/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.certificationservice.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.shr.base.syssetting.MSFConfigFactory;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.certificationservice.util.MoneyTransformUtil;
import com.kingdee.shr.shareservice.CmpItemType;
import com.kingdee.shr.shareservice.DataDot;
import com.kingdee.shr.shareservice.FieldValueRelationCollection;
import com.kingdee.shr.shareservice.FieldValueRelationFactory;
import com.kingdee.shr.shareservice.FieldValueRelationInfo;
import com.kingdee.shr.shareservice.IFieldValueRelation;
import com.kingdee.shr.shareservice.SSCFieldValueRelationException;
import com.kingdee.shr.shareservice.SelectedTime;
import com.kingdee.shr.shareservice.SummaryType;
import com.kingdee.shr.shareservice.TemplateCmpItemRefCollection;
import com.kingdee.shr.shareservice.TemplateCmpItemRefFactory;
import com.kingdee.shr.shareservice.TemplateCmpItemRefInfo;
import com.kingdee.shr.shareservice.TemplateFieldConfigFactory;
import com.kingdee.shr.shareservice.TemplateFieldConfigInfo;
import com.kingdee.util.StringUtils;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FieldValueRelationUtil {
    public static String CMP_OSF = "getCmpItemCalInfoService";
    public static String CMP_FIX_OSF = "getSalaryItemInfoService";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.shareservice.util.FieldValueRelationUtil");

    public static void fillValue(Context ctx, String configStr, String personId, String billId) throws EASBizException, BOSException {
        if (personId != null) {
            PersonInfo person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)personId)));
            JSONArray jsonArray = JSONArray.parseArray((String)configStr);
            int index = 1;
            FieldValueRelationCollection coll = new FieldValueRelationCollection();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject config = jsonArray.getJSONObject(i);
                String key = config.getString("key");
                String fieldConfigId = config.getString("fieldConfig");
                if (StringUtils.isEmpty((String)fieldConfigId)) continue;
                String osfValue = null;
                try {
                    osfValue = FieldValueRelationUtil.getConfigValue(ctx, personId, fieldConfigId);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new SSCFieldValueRelationException(SSCFieldValueRelationException.OSFEXCEPTION);
                }
                FieldValueRelationInfo relationInfo = new FieldValueRelationInfo();
                relationInfo.setField(key);
                relationInfo.setValue(osfValue);
                relationInfo.setOldValue(osfValue);
                relationInfo.setPerson(person);
                relationInfo.setBill(billId);
                relationInfo.setName(index + "", Locale.CHINA);
                ++index;
                coll.add(relationInfo);
            }
            IFieldValueRelation iFieldValue = FieldValueRelationFactory.getLocalInstance((Context)ctx);
            iFieldValue.delete("where bill = '" + billId + "'");
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            coreBaseCollection.addObjectCollection((IObjectCollection)coll);
            iFieldValue.addnew(coreBaseCollection);
        }
    }

    public static String getConfigValue(Context ctx, String personId, String fieldConfigId) throws EASBizException, BOSException {
        TemplateCmpItemRefCollection coll;
        String result = null;
        TemplateFieldConfigInfo templateFieldConfigInfo = TemplateFieldConfigFactory.getLocalInstance((Context)ctx).getTemplateFieldConfigInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)fieldConfigId)));
        String cmpItemIdStr = null;
        cmpItemIdStr = templateFieldConfigInfo.getCmpItemIdStr();
        if (StringUtils.isEmpty((String)cmpItemIdStr) && (coll = TemplateCmpItemRefFactory.getLocalInstance((Context)ctx).getTemplateCmpItemRefCollection("where parent = '" + fieldConfigId + "'")).size() != 0) {
            ArrayList<String> cmpItemIdList = new ArrayList<String>();
            for (int i = 0; i < coll.size(); ++i) {
                TemplateCmpItemRefInfo info = coll.get(i);
                cmpItemIdList.add(info.getCmpItemId().toString());
            }
            String cmpItemId = ((Object)cmpItemIdList).toString();
            cmpItemIdStr = cmpItemId.substring(1, cmpItemId.length() - 1).replaceAll(" ", "");
        }
        SelectedTime selectedTime = templateFieldConfigInfo.getSelectedTime();
        SummaryType summerType = templateFieldConfigInfo.getSummaryType();
        CmpItemType cmpItemType = templateFieldConfigInfo.getCmpItemType();
        if (StringUtils.isEmpty((String)cmpItemIdStr) && selectedTime == null && summerType == null && cmpItemType == null) {
            return null;
        }
        String[] cmpItemIdStrs = null;
        if (!StringUtils.isEmpty((String)cmpItemIdStr)) {
            cmpItemIdStrs = cmpItemIdStr.split(",");
        }
        String bizImplClass = templateFieldConfigInfo.getBizImplClass();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("personId", personId);
        double tempOsfValue = 0.0;
        if (!StringUtils.isEmpty((String)bizImplClass)) {
            result = (String)MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService(bizImplClass, paramMap);
            return result;
        }
        paramMap.put("items", cmpItemIdStr);
        if (cmpItemType == null) {
            return "0";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int endYear = cal.get(1);
        int endMonth = cal.get(2) + 1;
        int endDay = cal.get(5);
        if (cmpItemType.equals((Object)CmpItemType.FIX)) {
            String endDate = FieldValueRelationUtil.getFixValueDate();
            paramMap.put("endDate", endDate);
            StringBuffer oql = new StringBuffer();
            oql.append("where serviceName = '");
            oql.append(CMP_FIX_OSF);
            oql.append("' and state = '");
            oql.append("1'");
            CoreBaseCollection resultCol = MSFConfigFactory.getLocalInstance((Context)ctx).getCollection(oql.toString());
            if (resultCol.size() < 1) {
                return "0";
            }
            logger.info((Object)("====== com.kingdee.shr.shareservice.util.FieldValueRelationUtil.getConfigValue CmpItemType.FIX paramMap: " + paramMap));
            Map cmpOsfValue = (Map)MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService(CMP_FIX_OSF, paramMap);
            logger.info((Object)("====== com.kingdee.shr.shareservice.util.FieldValueRelationUtil.getConfigValue CmpItemType.FIX cmpOsfValue: " + cmpOsfValue));
            double realSalSum = 0.0;
            Iterator iterator = cmpOsfValue.values().iterator();
            while (iterator.hasNext()) {
                double itemValue = (Double)iterator.next();
                realSalSum += itemValue;
            }
            tempOsfValue = realSalSum;
        } else {
            FieldValueRelationUtil.fillTwoYearMap(paramMap);
            List<String> dateKeyList = FieldValueRelationUtil.getTwoYearList();
            Map<String, Object> begingMap = FieldValueRelationUtil.getBeginMap(selectedTime);
            StringBuffer oql = new StringBuffer();
            oql.append("where serviceName = '");
            oql.append(CMP_OSF);
            oql.append("' and state = '");
            oql.append("1'");
            CoreBaseCollection resultCol = MSFConfigFactory.getLocalInstance((Context)ctx).getCollection(oql.toString());
            if (resultCol.size() < 1) {
                return "0";
            }
            logger.info((Object)("====== com.kingdee.shr.shareservice.util.FieldValueRelationUtil.getConfigValue CmpItemType.NOTFIX paramMap: " + paramMap));
            Map cmpOsfValue = (Map)MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService(CMP_OSF, paramMap);
            logger.info((Object)("====== com.kingdee.shr.shareservice.util.FieldValueRelationUtil.getConfigValue CmpItemType.NOTFIX cmpOsfValue: " + cmpOsfValue));
            int realMonCount = 0;
            double realSalSum = 0.0;
            Map realValue = FieldValueRelationUtil.fillRealValue(cmpItemIdStrs, Integer.parseInt(begingMap.get("count").toString()), (String)begingMap.get("beginDataStr"), (String)begingMap.get("endDataStr"), dateKeyList, cmpOsfValue);
            realMonCount = Integer.parseInt(realValue.get("realMonCount").toString());
            realSalSum = Double.parseDouble(realValue.get("realSalSum").toString());
            int summaryTypeValue = templateFieldConfigInfo.getSummaryType().getValue();
            if (summaryTypeValue == 1) {
                tempOsfValue = realSalSum;
            } else if (summaryTypeValue == 2) {
                tempOsfValue = realMonCount == 0 ? 0.0 : realSalSum / (double)realMonCount;
            }
        }
        DataDot dataDot = templateFieldConfigInfo.getDataDot();
        templateFieldConfigInfo.getGetValueMtd();
        boolean isUpper = templateFieldConfigInfo.isIsUpper();
        double finalDoubleValue = 0.0;
        DecimalFormat df = new DecimalFormat("0.00");
        if (dataDot.equals((Object)DataDot.DOT_NONE)) {
            df = new DecimalFormat("#");
            finalDoubleValue = Math.round(tempOsfValue);
        } else if (dataDot.equals((Object)DataDot.DOT_ONE)) {
            df = new DecimalFormat("0.0");
            finalDoubleValue = (double)Math.round(tempOsfValue * 10.0) / 10.0;
        } else if (dataDot.equals((Object)DataDot.DOT_TWO)) {
            df = new DecimalFormat("0.00");
            finalDoubleValue = (double)Math.round(tempOsfValue * 100.0) / 100.0;
        }
        if (isUpper) {
            return MoneyTransformUtil.transform(finalDoubleValue);
        }
        return df.format(tempOsfValue);
    }

    private static Map fillRealValue(String[] cmpItemIdStrs, int count, String beginDataStr, String endDataStr, List<String> dateKeyList, Map<String, Map<String, Object>> cmpOsfValue) {
        logger.info((Object)("====== com.kingdee.shr.shareservice.util.FieldValueRelationUtil.fillRealValue params count: " + count + " == beginDataStr: " + beginDataStr + " == endDataStr: " + endDataStr + " == dateKeyList: " + dateKeyList + " == cmpOsfValue: " + cmpOsfValue));
        int realMonCount = 0;
        int monCount = 0;
        double realSalSum = 0.0;
        Map<Object, Object> cmpItemValueMap = new HashMap();
        int index = 0;
        boolean hasValue = false;
        boolean isBegin = false;
        boolean needCount = false;
        for (int i = 0; i < 24; ++i) {
            if (!isBegin) {
                if (dateKeyList.get(index).equals(beginDataStr)) {
                    isBegin = true;
                } else {
                    ++index;
                    continue;
                }
            }
            if (monCount == count) break;
            if (cmpOsfValue.get(dateKeyList.get(index)) != null) {
                cmpItemValueMap = cmpOsfValue.get(dateKeyList.get(index));
                needCount = false;
                for (int j = 0; j < cmpItemIdStrs.length; ++j) {
                    if (cmpItemValueMap.get(cmpItemIdStrs[j]) == null) continue;
                    hasValue = true;
                    realSalSum += Double.parseDouble(cmpItemValueMap.get(cmpItemIdStrs[j]).toString());
                    needCount = true;
                }
                if (needCount) {
                    ++realMonCount;
                }
            }
            if (!StringUtils.isEmpty((String)endDataStr) && dateKeyList.get(index).equals(endDataStr)) break;
            if (hasValue) {
                ++monCount;
            }
            logger.info((Object)("====== com.kingdee.shr.shareservice.util.FieldValueRelationUtil.fillRealValue i: " + i + " == index:" + ++index + " == monCount:" + monCount + " == realMonCount:" + realMonCount + " == realSalSum:" + realSalSum));
        }
        HashMap<String, Number> result = new HashMap<String, Number>();
        result.put("realMonCount", realMonCount);
        result.put("realSalSum", realSalSum);
        return result;
    }

    private static Map<String, Object> getBeginMap(SelectedTime selectedTime) {
        int realEndYear;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int endYear = cal.get(1);
        int endMonth = cal.get(2) + 1;
        int count = 0;
        String beginDataStr = null;
        String endDataStr = null;
        if (selectedTime.equals((Object)SelectedTime.NEAR_YEAR)) {
            count = 12;
            beginDataStr = endMonth > 9 ? endYear + "-" + endMonth : endYear + "-0" + endMonth;
        } else if (selectedTime.equals((Object)SelectedTime.NEAR_HALF)) {
            count = 6;
            beginDataStr = endMonth > 9 ? endYear + "-" + endMonth : endYear + "-0" + endMonth;
        } else if (selectedTime.equals((Object)SelectedTime.LAST_MONTH)) {
            count = 1;
            if (endMonth == 1) {
                realEndYear = endYear - 1;
                beginDataStr = realEndYear + "-12";
            } else {
                int realEndMonth = endMonth - 1;
                beginDataStr = realEndMonth > 9 ? endYear + "-" + realEndMonth : endYear + "-0" + realEndMonth;
            }
            endDataStr = beginDataStr;
        } else if (selectedTime.equals((Object)SelectedTime.LAST_YEAR)) {
            count = 12;
            realEndYear = endYear - 1;
            beginDataStr = realEndYear + "-12";
            endDataStr = realEndYear + "-01";
        } else if (selectedTime.equals((Object)SelectedTime.NEAR_QUARTER)) {
            count = 3;
            beginDataStr = endMonth > 9 ? endYear + "-" + endMonth : endYear + "-0" + endMonth;
        } else if (selectedTime.equals((Object)SelectedTime.NEAR_MONTH)) {
            count = 1;
            beginDataStr = endMonth > 9 ? endYear + "-" + endMonth : endYear + "-0" + endMonth;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("count", count);
        result.put("beginDataStr", beginDataStr);
        result.put("endDataStr", endDataStr);
        return result;
    }

    private static void fillTwoYearMap(Map<String, Object> paramMap) {
        int startYear = 0;
        int startMonth = 0;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int endYear = cal.get(1);
        int endMonth = cal.get(2) + 1;
        cal.add(2, -23);
        startYear = cal.get(1);
        startMonth = cal.get(2) + 1;
        if (startMonth > 9) {
            paramMap.put("beginDate", startYear + "-" + startMonth);
        } else {
            paramMap.put("beginDate", startYear + "-0" + startMonth);
        }
        if (endMonth > 9) {
            paramMap.put("endDate", endYear + "-" + endMonth);
        } else {
            paramMap.put("endDate", endYear + "-0" + endMonth);
        }
    }

    private static String getFixValueDate() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = format.format(cal.getTime());
        return strDate;
    }

    private static List<String> getTwoYearList() {
        ArrayList<String> result = new ArrayList<String>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int endYear = cal.get(1);
        int endMonth = cal.get(2) + 1;
        int realEndYear = 0;
        int realEndMonth = 0;
        for (int i = 0; i < 24; ++i) {
            if (endMonth > i) {
                realEndYear = endYear;
                realEndMonth = endMonth - i;
            } else if (endMonth + 12 > i) {
                realEndYear = endYear - 1;
                realEndMonth = endMonth + 12 - i;
            } else {
                realEndYear = endYear - 2;
                realEndMonth = endMonth + 24 - i;
            }
            if (realEndMonth > 9) {
                result.add(realEndYear + "-" + realEndMonth);
                continue;
            }
            result.add(realEndYear + "-0" + realEndMonth);
        }
        return result;
    }

    public static void assembleFieldValue(Context ctx, String certificationbillId, List<Map<String, String>> infoList) {
        try {
            IFieldValueRelation iFieldValue = FieldValueRelationFactory.getLocalInstance((Context)ctx);
            if (iFieldValue.exists("where bill = '" + certificationbillId + "'")) {
                FieldValueRelationCollection coll = iFieldValue.getFieldValueRelationCollection("where bill = '" + certificationbillId + "'");
                ArrayList<Integer> sortList = new ArrayList<Integer>();
                HashMap<Integer, Integer> sortMap = new HashMap<Integer, Integer>();
                for (int k = 0; k < coll.size(); ++k) {
                    Integer indexName = Integer.parseInt(coll.get(k).getName(Locale.CHINA));
                    sortList.add(indexName);
                    sortMap.put(indexName, k);
                }
                Collections.sort(sortList);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sortMap----" + sortMap));
                    logger.debug((Object)("sortList----" + sortList));
                }
                for (int i = 0; i < sortList.size(); ++i) {
                    int dataInd = (Integer)sortMap.get(sortList.get(i));
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("key", "");
                    map.put("value", coll.get(dataInd).getValue());
                    map.put("oldvalue", coll.get(dataInd).getOldValue());
                    map.put("name", coll.get(dataInd).getField());
                    map.put("number", coll.get(dataInd).getName(Locale.CHINA));
                    infoList.add(map);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

