/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cloudservice.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.CloudServiceURLConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceURLConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceConfig;
import com.kingdee.shr.cloudservice.ICloudServiceURLConfig;
import com.kingdee.shr.cloudservice.app.AbstractHRCloudServiceFacadeControllerBean;
import com.kingdee.shr.cloudservice.util.CloudServiceUtil;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRCloudServiceFacadeControllerBean
extends AbstractHRCloudServiceFacadeControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.cloudservice.app.HRCloudServiceFacadeControllerBean");

    @Override
    protected Map _refreshCloudServiceAccessToken(Context ctx) throws BOSException, EASBizException {
        HashMap map;
        block5: {
            map = new HashMap();
            try {
                ICloudServiceConfig iCloudServiceConfig = CloudServiceConfigFactory.getLocalInstance(ctx);
                CloudServiceConfigCollection cloudServiceConfigColl = iCloudServiceConfig.getCloudServiceConfigCollection();
                CloudServiceConfigInfo cloudServiceConfigInfo = null;
                if (cloudServiceConfigColl.size() <= 0) break block5;
                cloudServiceConfigInfo = cloudServiceConfigColl.get(0);
                Date stopTime = cloudServiceConfigInfo.getStopTime();
                Date currentTime = new Date();
                ICloudServiceURLConfig iCloudServiceURLConfig = CloudServiceURLConfigFactory.getLocalInstance(ctx);
                CloudServiceURLConfigInfo cloudServiceURLConfigInfo = iCloudServiceURLConfig.getCloudServiceURLConfigInfo(" where state = 1 and serviceType = 1");
                String serviceURL = cloudServiceURLConfigInfo.getServiceURL();
                StringBuffer param = new StringBuffer();
                param.append("redirect_url=");
                param.append(cloudServiceConfigInfo.getEnterPubNetwork());
                param.append("&service_id=");
                param.append(cloudServiceConfigInfo.getServiceID());
                param.append("&service_key=");
                param.append(cloudServiceConfigInfo.getServiceKey());
                param.append("&from=");
                param.append(1);
                String version = "";
                String logPrefix = "sync s-HR version,";
                try {
                    IRowSet rowset = null;
                    StringBuilder sql = new StringBuilder();
                    sql.append(" select FMajor,FMinor,FBuild,FBim from T_SYS_DatacenterSHR where FType = 'SHR' ");
                    rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    while (rowset.next()) {
                        version = rowset.getString("FMajor") + rowset.getString("FMinor") + rowset.getString("FBuild") + rowset.getString("FBim");
                    }
                    param.append("&version=");
                    param.append(version);
                    logger.error(String.format("%s...version:[%s]", logPrefix, version));
                }
                catch (Exception e) {
                    logger.error(logPrefix + "occur system exception...detail :" + e.getMessage(), (Throwable)e);
                }
                logger.error("Refresh s-HR Cloud Service Access Token Start: ");
                logger.error("Access Token Url: " + serviceURL);
                logger.error("Access Token Param: " + param.toString());
                String result = this.get(serviceURL, param.toString());
                map = JSONUtils.convertJsonToObject((Context)ctx, (String)result);
                logger.error("Refresh s-HR Cloud Service Access Token Result: " + result);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }

    @Override
    protected Map _validateWebServiceLoginUser(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            CloudServiceConfigInfo cloudServiceConfigInfo;
            map.put("code", "success");
            map.put("message", "success");
            ICloudServiceConfig iCloudServiceConfig = CloudServiceConfigFactory.getLocalInstance(ctx);
            CloudServiceConfigCollection cloudServiceConfigColl = iCloudServiceConfig.getCloudServiceConfigCollection();
            if (cloudServiceConfigColl.size() > 0 && !StringUtils.isEmpty((String)(cloudServiceConfigInfo = cloudServiceConfigColl.get(0)).getServiceUser()) && !StringUtils.isEmpty((String)cloudServiceConfigInfo.getServicePwd())) {
                logger.error("validateWebServiceLoginUser info:" + cloudServiceConfigInfo.getServiceID() + "," + cloudServiceConfigInfo.getServiceUser());
                CloudServiceUtil.doWSLogin(ctx, cloudServiceConfigInfo);
                map.put("message", "login success");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            map.put("code", "fail");
            map.put("message", e.getMessage());
        }
        logger.error("validateWebServiceLoginUser result:" + (String)map.get("code") + "," + (String)map.get("message"));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String get(String url, String queryString) {
        String response = null;
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url);
        try {
            method.setQueryString(URIUtil.encodeQuery((String)queryString));
            client.executeMethod((HttpMethod)method);
            if (method.getStatusCode() == 200) {
                response = method.getResponseBodyAsString();
            }
        }
        catch (URIException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
        return response;
    }
}

