/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CalSchemeCommonException;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpCalSchemeDataPermFactory;
import com.kingdee.shr.compensation.CmpCalSchemeDataPermInfo;
import com.kingdee.shr.compensation.CmpSalaryDataPermFactory;
import com.kingdee.shr.compensation.CmpSalaryDataPermInfo;
import com.kingdee.shr.compensation.app.AbstractCalSchemeDataPermFacadeControllerBean;
import com.kingdee.shr.compensation.permission.CalSchemePermAPI;
import com.kingdee.shr.compensation.permission.RecordPermAPI;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class CalSchemeDataPermFacadeControllerBean
extends AbstractCalSchemeDataPermFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CalSchemeDataPermFacadeControllerBean");

    @Override
    protected void _saveCalSchemeRange(Context ctx, Map param) throws BOSException, EASBizException {
        String personids = (String)param.get("personids");
        String itemInfo = (String)param.get("itemInfo");
        String hrOrgId = (String)param.get("hrOrgId");
        try {
            HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
            hrOrgUnitInfo.setId(BOSUuid.read((String)hrOrgId));
            String[] persons = personids.split(",");
            CoreBaseCollection coll = new CoreBaseCollection();
            CoreBaseCollection salaryPermColl = new CoreBaseCollection();
            for (int k = 0; k < persons.length; ++k) {
                String personid = persons[k].trim();
                if (StringUtils.isEmpty((String)personid)) continue;
                PersonInfo personInfo = RecordPermAPI.getPersonInfo(ctx, personid);
                CmpCalSchemeDataPermFactory.getLocalInstance(ctx).delete(" where person.id='" + personid + "' and hrOrgUnit.id='" + hrOrgId + "' ");
                CmpCalSchemeDataPermInfo item = null;
                JSONArray items = new JSONArray(itemInfo);
                for (int i = 0; i < items.length(); ++i) {
                    JSONObject t = items.getJSONObject(i);
                    String itemId = t.getString("itemId");
                    String isEdit = t.getString("isEdit");
                    item = new CmpCalSchemeDataPermInfo();
                    CalSchemeInfo calSchemeInfo = CalSchemePermAPI.getCalSchemeInfo(ctx, itemId);
                    item.setPerson(personInfo);
                    item.setHrOrgUnit(hrOrgUnitInfo);
                    item.setCalScheme(calSchemeInfo);
                    if ("true".equals(isEdit)) {
                        item.setIsEdit(1);
                    } else {
                        item.setIsEdit(0);
                    }
                    coll.add((CoreBaseInfo)item);
                }
                boolean bExist = CmpSalaryDataPermFactory.getLocalInstance(ctx).exists("where person.id='" + personid + "' and hrOrgUnit.id='" + hrOrgId + "' ");
                CmpSalaryDataPermInfo cmpSalaryPermInfo = null;
                if (bExist) {
                    cmpSalaryPermInfo = CmpSalaryDataPermFactory.getLocalInstance(ctx).getCmpSalaryDataPermInfo("where person.id='" + personid + "' and hrOrgUnit.id='" + hrOrgId + "' ");
                } else {
                    cmpSalaryPermInfo = new CmpSalaryDataPermInfo();
                    cmpSalaryPermInfo.setPerson(personInfo);
                    cmpSalaryPermInfo.setHrOrgUnit(hrOrgUnitInfo);
                }
                cmpSalaryPermInfo.setIsCalSchemePerm(true);
                salaryPermColl.add((CoreBaseInfo)cmpSalaryPermInfo);
                CmpCalSchemeDataPermFactory.getLocalInstance(ctx).saveBatchData(coll);
                coll.clear();
            }
            CmpSalaryDataPermFactory.getLocalInstance(ctx).saveBatchData(salaryPermColl);
            salaryPermColl.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalSchemeCommonException(CalSchemeCommonException.SAVE_DATAPERM_ERROR);
        }
    }

    @Override
    protected List _getAssignedScheme(Context ctx, Map param) throws BOSException, EASBizException {
        ArrayList<Map<Object, Object>> result = new ArrayList<Map<Object, Object>>();
        String personId = (String)param.get("personId");
        String hrOrgId = (String)param.get("hrOrgId");
        String personIds = "('" + personId.replace(",", "','") + "')";
        String l = LocaleUtils.getShortCode((Context)ctx);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        StringBuilder sb = new StringBuilder();
        sb.append(" select perm.fid id, FIsEdit isEdit, scheme.fnumber number, scheme.fname_" + l + " schemeName, perm.FCalSchemeId from T_HR_SCmpCalSchemeDataPerm perm ");
        sb.append(" left join t_hr_scalScheme scheme on perm.FCalSchemeId = scheme.fid ");
        sb.append(" where perm.FHrOrgUnitId='" + hrOrgId + "' and perm.fpersonid in " + personIds);
        sb.append(" order by scheme.fnumber, scheme.fname_" + l + "");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        Map<String, Object> editSameMap = this.isEditSame(ctx, personIds);
        int count = 0;
        LinkedHashMap map = Maps.newLinkedHashMap();
        ArrayList<Object> list = null;
        try {
            while (rs.next()) {
                String id = rs.getString("id");
                boolean isEdit = rs.getBoolean("isEdit");
                String calSchemeId = rs.getString("FCalSchemeId");
                String calNumber = rs.getString("number");
                String schemeName = rs.getString("schemeName");
                list = new ArrayList<Object>();
                list.add(isEdit);
                list.add(calSchemeId);
                list.add(calNumber);
                list.add(schemeName);
                map.put(id, list);
                if (countMap.get(calSchemeId) == null) {
                    count = 1;
                } else {
                    count = (Integer)countMap.get(calSchemeId);
                    ++count;
                }
                countMap.put(calSchemeId, count);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new CalSchemeCommonException(CalSchemeCommonException.ASSIGNED_SCHEME_ERROR);
        }
        result.add(map);
        result.add(countMap);
        result.add(editSameMap);
        return result;
    }

    private Map<String, Object> isEditSame(Context ctx, String personIds) throws BOSException, CalSchemeCommonException {
        HashMap<String, Object> editMap = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        sb.append(" select FCalSchemeId, count(distinct fisedit) num from T_HR_SCmpCalSchemeDataPerm ");
        sb.append(" where fpersonid in " + personIds);
        sb.append(" group by FCALSCHEMEID ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String calSchemeId = rs.getString("FCalSchemeId");
                int num = rs.getInt("num");
                editMap.put(calSchemeId, num == 1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new CalSchemeCommonException(CalSchemeCommonException.ASSIGNED_SCHEME_ERROR);
        }
        return editMap;
    }
}

