/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillCollection;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.IAgentPayBill;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.CmpAgentPayBillCollection;
import com.kingdee.shr.compensation.CmpAgentPayBillException;
import com.kingdee.shr.compensation.CmpAgentPayBillFactory;
import com.kingdee.shr.compensation.CmpAgentPayBillInfo;
import com.kingdee.shr.compensation.app.AbstractCmpAgentPayBillControllerBean;
import com.kingdee.shr.compensation.app.agentIntegrate.AbstractCmpAgentPayBillCreating;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpITPayEnum;
import com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil.CmpRemoteCallXKQJService;
import com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil.XKQJAgentPayBillInfo;
import com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil.XKQJCallBackDTO;
import com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil.XKQJCallBackDetailDTO;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmpAgentPayBillControllerBean
extends AbstractCmpAgentPayBillControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(CmpAgentPayBillControllerBean.class);
    private static final String LOCK_KEY_FLAG = "XKQJ_BILL_SUBMIT";
    private static final long serialVersionUID = 1L;

    @Override
    protected void _createAgentPayBill(Context ctx, Map param) throws BOSException, EASBizException {
        AbstractCmpAgentPayBillCreating instance = (AbstractCmpAgentPayBillCreating)param.get("cmpAgentPayBillCreatingInstance");
        logger.info("#########createAgentPayBill:" + param.toString());
        instance.create(ctx, param);
    }

    @Override
    public void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (null == arrayPK || arrayPK.length <= 0) {
            return;
        }
        IAgentPayBill agentPayBillInstance = AgentPayBillFactory.getLocalInstance((Context)ctx);
        Map<String, Object> map = this.getAllCmpAgentPayBill(ctx, arrayPK);
        Map allCmpAgentPayBill = (Map)map.get("cmpAgentPayBillMap");
        Set cashBillIdSet = (Set)map.get("cashBillIdSet");
        Map<IObjectPK, Integer> allAgentPayBill = this.getAllAgentPayBill(ctx, cashBillIdSet);
        ArrayList<IObjectPK> cashBillIdArray = new ArrayList<IObjectPK>();
        for (int i = 0; i < arrayPK.length; ++i) {
            IObjectPK billId = arrayPK[i];
            List list = (List)allCmpAgentPayBill.get(billId);
            int state = (Integer)list.get(1);
            if (state > 10) {
                throw new CmpAgentPayBillException(CmpAgentPayBillException.CMP_SUBMITED_ERROR);
            }
            IObjectPK cashBillId = (IObjectPK)list.get(0);
            if (!allAgentPayBill.containsKey(cashBillId)) continue;
            int billStatus = allAgentPayBill.get(cashBillId);
            if (billStatus > 10) {
                throw new CmpAgentPayBillException(CmpAgentPayBillException.CMP_SUBMITED_ERROR);
            }
            cashBillIdArray.add(cashBillId);
        }
        for (IObjectPK cashBillId : cashBillIdArray) {
            agentPayBillInstance.delete(cashBillId);
        }
        for (int i = 0; i < arrayPK.length; ++i) {
            this._delete(ctx, arrayPK[i]);
        }
    }

    protected Map<String, Object> getAllCmpAgentPayBill(Context ctx, IObjectPK[] arrayPK) throws BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (arrayPK.length <= 0) {
            return result;
        }
        HashMap cmpAgentPayBillMap = new HashMap();
        CmpAgentPayBillCollection collection = this.getCmpAgentPayBillCollection(ctx, " select id, cashBillId, state where id in (" + this.joinPKArrayToIds(arrayPK) + ")");
        ArrayList<Object> list = null;
        HashSet<String> cashBillIdSet = new HashSet<String>();
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                list = new ArrayList<Object>();
                CmpAgentPayBillInfo info = collection.get(i);
                ObjectUuidPK billId = new ObjectUuidPK(info.getId());
                ObjectUuidPK cashBillId = new ObjectUuidPK(info.getCashBillId());
                int state = info.getState().getValue();
                list.add(cashBillId);
                list.add(state);
                cashBillIdSet.add(cashBillId.toString());
                cmpAgentPayBillMap.put(billId, list);
            }
            result.put("cmpAgentPayBillMap", cmpAgentPayBillMap);
            result.put("cashBillIdSet", cashBillIdSet);
        }
        return result;
    }

    protected Map<IObjectPK, Integer> getCmpAgentPayBillOnly(Context ctx, IObjectPK[] arrayPK) throws BOSException {
        HashMap<IObjectPK, Integer> cmpAgentPayBillMap = new HashMap<IObjectPK, Integer>();
        if (arrayPK.length <= 0) {
            return cmpAgentPayBillMap;
        }
        CmpAgentPayBillCollection collection = this.getCmpAgentPayBillCollection(ctx, " select id, stateIT where id in (" + this.joinPKArrayToIds(arrayPK) + ")");
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                CmpAgentPayBillInfo info = collection.get(i);
                ObjectUuidPK billId = new ObjectUuidPK(info.getId());
                int state = info.getStateIT().getValue();
                cmpAgentPayBillMap.put((IObjectPK)billId, state);
            }
        }
        return cmpAgentPayBillMap;
    }

    protected Map<IObjectPK, Integer> getAllAgentPayBill(Context ctx, Set<String> cashBillIdSet) throws BOSException {
        HashMap<IObjectPK, Integer> map = new HashMap<IObjectPK, Integer>();
        if (null != cashBillIdSet && cashBillIdSet.size() <= 0) {
            return map;
        }
        IAgentPayBill agentPayBillInstance = AgentPayBillFactory.getLocalInstance((Context)ctx);
        AgentPayBillCollection collection = agentPayBillInstance.getAgentPayBillCollection("select id, billStatus where id in ('" + StringUtils.join(cashBillIdSet, (String)"','") + "')");
        for (int i = 0; i < collection.size(); ++i) {
            AgentPayBillInfo info = collection.get(i);
            ObjectUuidPK cashBillId = new ObjectUuidPK(info.getId());
            int state = info.getBillStatus().getValue();
            map.put((IObjectPK)cashBillId, state);
        }
        return map;
    }

    @Override
    protected void _checkCodingRule(Context ctx, Map param) throws BOSException, EASBizException {
        AgentPayBillInfo agentPayBillInfo;
        boolean isCashUseCodingRule;
        CmpAgentPayBillInfo cmpAgentPayBillInfo = new CmpAgentPayBillInfo();
        String currentCUID = HRFilterUtils.getCurrentCUID((Context)ctx);
        boolean isCmpUseCodingRule = this.isUseCodingRule(ctx, (IObjectValue)cmpAgentPayBillInfo, currentCUID);
        if (!isCmpUseCodingRule) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.CMP_RULE_ERROR);
        }
        String integrateType = (String)param.get("integrateType");
        if ("EAS".equals(integrateType) && !(isCashUseCodingRule = this.isUseCodingRule(ctx, (IObjectValue)(agentPayBillInfo = new AgentPayBillInfo()), currentCUID))) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.CASH_RULE_ERROR);
        }
    }

    protected boolean isUseCodingRule(Context ctx, IObjectValue model, String orgId) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (orgId != null && orgId.trim().length() > 0 && iCodingRuleManager.isExist(model, orgId)) {
                return true;
            }
            String companyId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            return iCodingRuleManager.isExist(model, companyId);
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    @Override
    protected void _deleteIT(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        int i;
        if (null == arrayPK || arrayPK.length <= 0) {
            return;
        }
        Map<IObjectPK, Integer> map = this.getCmpAgentPayBillOnly(ctx, arrayPK);
        for (i = 0; i < arrayPK.length; ++i) {
            IObjectPK billId = arrayPK[i];
            Integer state = map.get(billId);
            if (state == 6) {
                throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION20);
            }
            if (state != null && (state == 2 || state == 7)) continue;
            throw new CmpAgentPayBillException(CmpAgentPayBillException.CMP_SUBMITED_ERROR_CQ);
        }
        for (i = 0; i < arrayPK.length; ++i) {
            this.delete(ctx, arrayPK[i]);
        }
    }

    @Override
    protected void _deleteXKQJ(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (null == arrayPK || arrayPK.length == 0) {
            return;
        }
        String oql = " select id where id in (" + this.joinPKArrayToIds(arrayPK) + ") and stateXKQJ not in (" + 0 + "," + 2 + "," + 7 + ")";
        boolean exists = CmpAgentPayBillFactory.getLocalInstance(ctx).exists(oql);
        if (exists) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION23);
        }
        for (int i = 0; i < arrayPK.length; ++i) {
            this.delete(ctx, arrayPK[i]);
        }
    }

    protected String joinPKArrayToIds(IObjectPK[] arrayPK) {
        if (arrayPK == null || arrayPK.length == 0) {
            return "''";
        }
        StringBuilder sb = new StringBuilder();
        for (IObjectPK pk : arrayPK) {
            sb.append(",'").append(pk.toString()).append("'");
        }
        return sb.toString().replaceFirst(",", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _submitXKQJ(Context ctx, Map param) throws BOSException, EASBizException {
        XKQJAgentPayBillInfo dto = (XKQJAgentPayBillInfo)param.get("billInfo");
        String billId = dto.getSourcebillnumber();
        ArrayList successBillList = Lists.newArrayList();
        ArrayList successEntryList = Lists.newArrayList();
        ArrayList errorBillList = Lists.newArrayList();
        try {
            if (!CmpDistributedLockUtils.tryLock(ctx, LOCK_KEY_FLAG, billId)) {
                return;
            }
            String submitResult = CmpRemoteCallXKQJService.submitXKQJAgentBill(ctx, Lists.newArrayList((Object[])new XKQJAgentPayBillInfo[]{dto}));
            this.translateSubmitResult(submitResult, billId, successBillList, successEntryList, errorBillList);
        }
        catch (Exception e) {
            String message = e.getMessage() != null ? e.getMessage() : ExceptionUtils.getFullStackTrace((Throwable)e);
            message = message.replaceAll("\r|\n|\t", " ");
            errorBillList.add(new Object[]{message, 2, billId});
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, LOCK_KEY_FLAG, billId);
        }
        this.afterSubmitBill(ctx, successBillList, successEntryList, errorBillList);
    }

    protected void translateSubmitResult(String submitResult, String billId, List<Object[]> successList, List<Object[]> successEntryList, List<Object[]> errorList) {
        JSONObject result = JSONObject.parseObject((String)submitResult);
        JSONObject data = result.getJSONObject("data");
        JSONObject firstResult = data.getJSONArray("result").getJSONObject(0);
        boolean billStatus = firstResult.getBoolean("billStatus");
        if (billStatus) {
            String billNo = firstResult.getString("number");
            successList.add(new Object[]{billNo, null, 3, billId});
            successEntryList.add(new Object[]{5, billId});
        } else {
            JSONObject firstError = firstResult.getJSONArray("errors").getJSONObject(0);
            String rowMsg = firstError.getString("rowMsg");
            errorList.add(new Object[]{rowMsg, 2, billId});
        }
    }

    protected void afterSubmitBill(Context ctx, List<Object[]> successBillList, List<Object[]> successEntryList, List<Object[]> errorBillList) throws BOSException {
        String sql;
        if (!successBillList.isEmpty()) {
            sql = "update T_HR_SCmpAgentPayBill set FBillNumIT = ?, FApiLogIT = ?, FStateXKQJ = ? where fid = ?";
            CmpSQLUtil.executeBatch(ctx, sql, successBillList);
            sql = "update T_HR_SCmpAgentPayBillEntry set FITPayState = ? where FBillId = ?";
            CmpSQLUtil.executeBatch(ctx, sql, successEntryList);
        }
        if (!errorBillList.isEmpty()) {
            sql = "update T_HR_SCmpAgentPayBill set FApiLogIT = ?, FStateXKQJ = ? where fid = ?";
            CmpSQLUtil.executeBatch(ctx, sql, errorBillList);
        }
    }

    @Override
    protected String _updateFromXKQJ(Context ctx, String param) throws BOSException, EASBizException {
        XKQJCallBackDTO xkqjCallBackDTO = (XKQJCallBackDTO)JSONUtils.convertJsonToObject((Context)ctx, (String)param, XKQJCallBackDTO.class);
        if (xkqjCallBackDTO == null || xkqjCallBackDTO.getData() == null) {
            logger.error("\u661f\u7a7a\u65d7\u8230\u56de\u8c03shr\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        List<XKQJCallBackDetailDTO> data = xkqjCallBackDTO.getData();
        try {
            this.doUpdateBillState(ctx, data);
            data.forEach(d -> {
                HashMap result = Maps.newHashMap();
                result.put("dealStatus", "true");
                d.setResult(result);
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            data.forEach(d -> {
                HashMap result = Maps.newHashMap();
                result.put("dealStatus", "false");
                result.put("errorMsg", e.getMessage() == null ? "save error!" : e.getMessage());
                d.setResult(result);
            });
        }
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)xkqjCallBackDTO);
    }

    protected void doUpdateBillState(Context ctx, List<XKQJCallBackDetailDTO> data) throws BOSException, SQLException {
        Map<Boolean, List<XKQJCallBackDetailDTO>> partition = data.stream().collect(Collectors.partitioningBy(d -> StringUtils.isEmpty((CharSequence)d.getSourcebillnumber())));
        ArrayList billColl = partition.get(Boolean.FALSE) == null ? Lists.newArrayList() : partition.get(Boolean.FALSE);
        ArrayList entryColl = partition.get(Boolean.TRUE) == null ? Lists.newArrayList() : partition.get(Boolean.TRUE);
        ArrayList udpBillParam = Lists.newArrayList();
        ArrayList udpBillEntryParam = Lists.newArrayList();
        for (XKQJCallBackDetailDTO bill : billColl) {
            String sourceBillNumber = bill.getSourcebillnumber();
            String status = bill.getStatus();
            String description = bill.getDescription();
            udpBillParam.add(new Object[]{this.getXKQJEnumValue(ctx, status), description, sourceBillNumber});
            udpBillEntryParam.add(new Object[]{this.getITPayEnumValue(ctx, status), description, sourceBillNumber});
        }
        ArrayList udpEntryParam = Lists.newArrayList();
        ArrayList entryIdList = Lists.newArrayList();
        for (XKQJCallBackDetailDTO entry : entryColl) {
            Long sourceEntryId = Long.valueOf(entry.getSourceentryid());
            String status = entry.getStatus();
            String description = entry.getDescription();
            udpEntryParam.add(new Object[]{this.getITPayEnumValue(ctx, status), description, sourceEntryId});
            entryIdList.add(sourceEntryId);
        }
        this.updateBillInfo(ctx, udpBillParam, udpBillEntryParam);
        this.updateEntryInfo(ctx, udpEntryParam, entryIdList);
    }

    private int getXKQJEnumValue(Context ctx, String status) throws BOSException {
        if ("2".equals(status)) {
            return 4;
        }
        if ("3".equals(status)) {
            return 6;
        }
        if ("4".equals(status)) {
            return 7;
        }
        if ("5".equals(status)) {
            return 3;
        }
        throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.app.agentIntegrate.CmpXKQJBillResource", (String)"label5", (Locale)ctx.getLocale()));
    }

    private int getITPayEnumValue(Context ctx, String status) throws BOSException {
        CmpITPayEnum payEnum = CmpITPayEnum.getEnum(Integer.parseInt(status));
        if (payEnum != null) {
            return payEnum.getValue();
        }
        throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.app.agentIntegrate.CmpXKQJBillResource", (String)"label5", (Locale)ctx.getLocale()));
    }

    protected void updateBillInfo(Context ctx, List<Object[]> udpBillParam, List<Object[]> udpBillEntryParam) throws BOSException {
        if (udpBillParam.isEmpty()) {
            return;
        }
        String udpBillSql = "update T_HR_SCmpAgentPayBill set FStateXKQJ = ?, FApiLogIT = ? where fid = ?";
        DbUtil.executeBatch((Context)ctx, (String)udpBillSql, udpBillParam);
        String udpEntrySql = "update T_HR_SCmpAgentPayBillEntry set FITPayState = ?, FITPayMessage = ? where FBillId = ?";
        DbUtil.executeBatch((Context)ctx, (String)udpEntrySql, udpBillEntryParam);
    }

    protected void updateEntryInfo(Context ctx, List<Object[]> udpEntryParam, List<Long> entryIdList) throws BOSException, SQLException {
        if (udpEntryParam.isEmpty()) {
            return;
        }
        String updEntrySql = "update T_HR_SCmpAgentPayBillEntry set FITPayState = ?, FITPayMessage = ? where FITCode = ?";
        DbUtil.executeBatch((Context)ctx, (String)updEntrySql, udpEntryParam);
        this.updateBillStateByEntryState(ctx, entryIdList);
    }

    protected void updateBillStateByEntryState(Context ctx, List<Long> entryIdList) throws BOSException, SQLException {
        CmpInSql<Long> inSql = CmpInSqlFactory.getInstance();
        String inSqlStr = inSql.createInSqlNoQuotes(ctx, entryIdList, "T_HR_CMPITEM", "FID");
        String queryBill = "select b.fid billId, e.FITPayState from T_HR_SCmpAgentPayBill b  inner join T_HR_SCmpAgentPayBillEntry e on b.fid = e.FBillId  where b.fid in (select distinct FBillId from T_HR_SCmpAgentPayBillEntry where FITCode in " + inSqlStr + " )";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryBill);
        HashMap billStateMap = Maps.newHashMap();
        while (rs.next()) {
            String billId = rs.getString("billId");
            int payState = rs.getInt("FITPayState");
            billStateMap.putIfAbsent(billId, Lists.newArrayList());
            ((List)billStateMap.get(billId)).add(payState);
        }
        ArrayList udpBillParam = Lists.newArrayList();
        for (Map.Entry entry : billStateMap.entrySet()) {
            String billId = (String)entry.getKey();
            List entryStateList = (List)entry.getValue();
            boolean isPayed = entryStateList.stream().allMatch(state -> state == 2);
            if (isPayed) {
                udpBillParam.add(new Object[]{4, billId});
                continue;
            }
            boolean isCancelPay = entryStateList.stream().allMatch(state -> state == 3);
            if (isCancelPay) {
                udpBillParam.add(new Object[]{6, billId});
                continue;
            }
            boolean endPay = entryStateList.stream().allMatch(state -> state == 2 || state == 3);
            if (!endPay) continue;
            udpBillParam.add(new Object[]{5, billId});
        }
        if (!udpBillParam.isEmpty()) {
            String udpBillSql = "update T_HR_SCmpAgentPayBill set FStateXKQJ = ? where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)udpBillSql, (List)udpBillParam);
        }
    }
}

