/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.agentIntegrate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillEntryInfo;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.hr.emp.BankInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryCollection;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillException;
import com.kingdee.shr.compensation.CmpAgentPayBillInfo;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.agentIntegrate.AbstractCmpAgentPayBillCreating;
import com.kingdee.shr.compensation.app.agentIntegrate.AbstractCmpAgentPayBillEASCreating;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpAgentSource;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpITType;
import com.kingdee.shr.compensation.app.agentIntegrate.helper.CmpGiveBankHelper;
import com.kingdee.shr.compensation.exception.PersonCmpFacadeException;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CmpAgentPayBillSingleCurEASCreating
extends AbstractCmpAgentPayBillEASCreating {
    @Override
    public void create(Context ctx, Map param) throws BOSException, EASBizException {
        Map paramIn = param;
        CmpItemInfo cmpItemInfo = CmpGiveBankHelper.getCmpItemByName(ctx, (String)param.get("cmpItemName"));
        paramIn.put("cmpItemInfo", cmpItemInfo);
        this.initPayBillInfo(ctx, paramIn);
        AbstractCmpAgentPayBillEASCreating.EASEntryGroups entryGroups = (AbstractCmpAgentPayBillEASCreating.EASEntryGroups)this.buildPayBillEntry(ctx, paramIn);
        if (StringUtils.isNotEmpty((CharSequence)entryGroups.getErrorMsg())) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION12, new Object[]{entryGroups.getErrorMsg()});
        }
        if (entryGroups.getCmpEntrysGroup().isEmpty()) {
            throw new PersonCmpFacadeException(PersonCmpFacadeException.CREATEFAIL);
        }
        entryGroups.setOrgIdAndPayOrgMap(this.getOrgIdAndPayOrgMap(ctx, entryGroups.getCmpEntrysGroup()));
        for (String key : entryGroups.getCmpEntrysGroup().keySet()) {
            this.buildAndSavePayBill(ctx, paramIn, key, entryGroups);
        }
        String calSchemeId = ((CalSchemeInfo)paramIn.get("calSchemeInfo")).getId().toString();
        String deleteSql = this.generateDeleteSql();
        String insertSql = this.generateInsertSql();
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
        ArrayList<Object[]> deleteParams = new ArrayList<Object[]>();
        this.fillGiveAcountResultParams(entryGroups.getCmpEntrysGroup(), insertParams, deleteParams, calSchemeId, cmpItemInfo, (String)paramIn.get("currencyId"));
        DbUtil.executeBatch((Context)ctx, (String)deleteSql, deleteParams);
        DbUtil.executeBatch((Context)ctx, (String)insertSql, insertParams);
    }

    @Override
    protected AbstractCmpAgentPayBillCreating.EntryGroups buildPayBillEntry(Context ctx, Map param) throws BOSException, EASBizException {
        SingleEASEntryGroups entryGroups = new SingleEASEntryGroups();
        CmpItemInfo cmpItemInfo = (CmpItemInfo)param.get("cmpItemInfo");
        String currencyId = (String)param.get("currencyId");
        currencyId = currencyId == null ? CmpGiveBankHelper.getDefaultCurrencyId() : currencyId;
        entryGroups.setCmpItemInfo(cmpItemInfo);
        entryGroups.setCurrencyId(currencyId);
        entryGroups.setCurrencyName(CmpGiveBankHelper.getCurrencyNameById(ctx, currencyId));
        String calTableName = (String)param.get("calTableName");
        String itemKey = calTableName + ".s" + cmpItemInfo.getFieldSn();
        List listData = (List)param.get("listData");
        for (Map data : listData) {
            String beCity;
            String beProvince;
            CmpAgentPayBillEntryInfo cmpEntryInfo = new CmpAgentPayBillEntryInfo();
            AgentPayBillEntryInfo cashEntryInfo = new AgentPayBillEntryInfo();
            List<Object> calTableList = this.getCalTableMap().get(data.get(calTableName + ".id"));
            BigDecimal itemValue = new BigDecimal(data.get(itemKey) == null ? "0" : data.get(itemKey).toString());
            if (itemValue == null || itemValue.compareTo(BigDecimal.ZERO) <= 0) {
                throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION16);
            }
            PersonInfo personInfo = (PersonInfo)calTableList.get(0);
            String currentPersonId = personInfo.getId().toString();
            if (this.getExistPers().contains(currentPersonId + "~" + cmpItemInfo.getId().toString())) {
                throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION17);
            }
            String bankName = (String)data.get("fil_bank.name");
            if (Boolean.TRUE.equals(param.get("validBankName"))) {
                BEBankInfo beBankInfo = (BEBankInfo)this.recBankMap.get(bankName);
                beProvince = beBankInfo == null ? "" : beBankInfo.getBeProvince();
                beCity = beBankInfo == null ? "" : beBankInfo.getBeCity();
            } else {
                beProvince = (String)data.get("fil_account.province");
                beCity = (String)data.get("fil_account.city");
            }
            String accountNum = (String)data.get("fil_account.accountnum");
            BOSUuid cmpAgentPayBillEntryId = BOSUuid.create((BOSObjectType)cmpEntryInfo.getBOSType());
            cmpEntryInfo.setPerson(personInfo);
            cmpEntryInfo.setPersonNum(personInfo.getNumber());
            cmpEntryInfo.setPersonName(personInfo.getName());
            cmpEntryInfo.setAmount(itemValue);
            cmpEntryInfo.setAdminOrg((AdminOrgUnitInfo)calTableList.get(1));
            cmpEntryInfo.setCmpCalOrg((AdminOrgUnitInfo)calTableList.get(2));
            cmpEntryInfo.setHrOrgUnit((HROrgUnitInfo)calTableList.get(3));
            cmpEntryInfo.setIsSuccess(false);
            cmpEntryInfo.setUseDefault((Boolean)data.get(calTableName + ".usedefault"));
            cmpEntryInfo.setId(cmpAgentPayBillEntryId);
            cmpEntryInfo.setCmpItemName(cmpItemInfo.getName());
            cmpEntryInfo.setCmpItem(cmpItemInfo);
            cmpEntryInfo.setBankName(bankName);
            cmpEntryInfo.setAccountNum(accountNum);
            String accountName = (String)data.get("fil_account.accountname");
            accountName = CmpStrUtil.isEmpty(accountName) ? personInfo.getName() : accountName;
            cmpEntryInfo.setAccountName(accountName);
            cmpEntryInfo.setRecProvince(beProvince);
            cmpEntryInfo.setRecCity(beCity);
            String bankId = (String)data.get("fil_bank.id");
            BankInfo bankInfo = new BankInfo();
            bankInfo.setId(BOSUuid.read((String)bankId));
            cmpEntryInfo.setHrBank(bankInfo);
            cashEntryInfo.setRecName(accountName);
            cashEntryInfo.setAmount(itemValue);
            cashEntryInfo.setSourceBillId(cmpAgentPayBillEntryId.toString());
            cashEntryInfo.setRecBankAccount(accountNum);
            cashEntryInfo.setRecProvince(beProvince);
            cashEntryInfo.setRecCity(beCity);
            cashEntryInfo.setRecBankName(bankName);
            cashEntryInfo.setRecBank((BEBankInfo)this.recBankMap.get(bankName));
            String splitField = this.getSplitFieldKey(data, param, entryGroups);
            entryGroups.putCmpEntrysGroup(splitField, cmpEntryInfo);
            entryGroups.putCashEntrysGroup(splitField, cashEntryInfo);
        }
        return entryGroups;
    }

    @Override
    protected void buildBillMark(CmpAgentPayBillInfo info) {
        info.setITType(CmpITType.EAS);
        info.setAgentSource(CmpAgentSource.SingleCur);
    }

    protected String generateDeleteSql() {
        return "DELETE FROM T_HR_SCmpGiveAccountResult WHERE FCmpCalTableID = ? AND FCmpItemId = ?";
    }

    protected String generateInsertSql() {
        String insertSql = "INSERT INTO T_HR_SCmpGiveAccountResult (Fid, FCmpCalTableID, FPersonID, FCmpItemId, FCurrencyId, FAmount, FGiveAccount, FExchangeRate, FSourceType) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        return insertSql;
    }

    protected void fillGiveAcountResultParams(Map<String, CmpAgentPayBillEntryCollection> cmpEntrysGroup, List<Object[]> insertParams, List<Object[]> deleteParams, String cmpCalTableId, CmpItemInfo cmpItem, String currencyId) {
        for (Map.Entry<String, CmpAgentPayBillEntryCollection> entry : cmpEntrysGroup.entrySet()) {
            CmpAgentPayBillEntryCollection col = entry.getValue();
            for (int i = 0; i < col.size(); ++i) {
                CmpAgentPayBillEntryInfo info = col.get(i);
                Object[] insertParam = new Object[9];
                Object[] deleteParam = new Object[2];
                insertParam[0] = info.getId().toString();
                insertParam[1] = cmpCalTableId;
                insertParam[2] = info.getPerson().getId().toString();
                insertParam[3] = cmpItem.getId().toString();
                insertParam[4] = currencyId;
                insertParam[5] = info.getAmount();
                insertParam[6] = info.getAmount();
                insertParam[7] = 1;
                insertParam[8] = 1;
                deleteParam[0] = cmpCalTableId;
                deleteParam[1] = cmpItem.getId().toString();
            }
        }
    }

    @Override
    protected CmpAgentPayBillInfo buildEASCmpPayBill(Context ctx, String key, Map param, AbstractCmpAgentPayBillEASCreating.EASEntryGroups entryGroups) throws EASBizException, BOSException {
        SingleEASEntryGroups singleEASEntryGroups = (SingleEASEntryGroups)entryGroups;
        return this.buildCmpPayBill(ctx, param, singleEASEntryGroups.getCmpItemInfo(), this.getCurrencyId(key, entryGroups));
    }

    @Override
    protected String getCurrencyId(String key, AbstractCmpAgentPayBillEASCreating.EASEntryGroups entryGroups) {
        return ((SingleEASEntryGroups)entryGroups).getCurrencyId();
    }

    @Override
    protected String getCmpItemSplitInfo(Map<String, Object> data, AbstractCmpAgentPayBillCreating.EntryGroups entryGroups) throws EASBizException {
        SingleEASEntryGroups singleEASEntryGroups = (SingleEASEntryGroups)entryGroups;
        if (singleEASEntryGroups.getCmpItemInfo() != null) {
            return singleEASEntryGroups.getCmpItemInfo().getName();
        }
        return "";
    }

    @Override
    protected String getCurrencySplitInfo(Map<String, Object> data, AbstractCmpAgentPayBillCreating.EntryGroups entryGroups) throws EASBizException {
        SingleEASEntryGroups singleEASEntryGroups = (SingleEASEntryGroups)entryGroups;
        if (singleEASEntryGroups.getCurrencyName() != null) {
            return singleEASEntryGroups.getCurrencyName();
        }
        return CmpGiveBankHelper.getDefaultCurrencyId();
    }

    public static class SingleEASEntryGroups
    extends AbstractCmpAgentPayBillEASCreating.EASEntryGroups {
        private CmpItemInfo cmpItemInfo;
        private String currencyName;
        private String currencyId;

        public CmpItemInfo getCmpItemInfo() {
            return this.cmpItemInfo;
        }

        public void setCmpItemInfo(CmpItemInfo cmpItemInfo) {
            this.cmpItemInfo = cmpItemInfo;
        }

        public String getCurrencyName() {
            return this.currencyName;
        }

        public void setCurrencyName(String currencyName) {
            this.currencyName = currencyName;
        }

        public String getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(String currencyId) {
            this.currencyId = currencyId;
        }
    }
}

