/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class Consts
implements ServletContextListener {
    static Logger logger = Logger.getLogger(Consts.class);
    public static String ProjectStatus = "dev";

    private void setProjectStatus(String value) {
        ProjectStatus = value;
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent arg0) {
        FileInputStream fs = null;
        try {
            logger.info((Object)"contextInitialized......");
            String path = Consts.getPathFromClass(Consts.class);
            if (null == path) {
                return;
            }
            path = path.substring(0, path.indexOf("classes/com/hinge/eis"));
            Properties prop = new Properties();
            String filename = path + "application.properties";
            fs = new FileInputStream(filename);
            prop.load(fs);
            String status = prop.getProperty("application.status");
            if (status != null) {
                this.setProjectStatus(status);
            }
            logger.info((Object)("contextInitialized end ......" + ProjectStatus));
        }
        catch (Exception e) {
            logger.error((Object)"error \u3002");
            e.printStackTrace();
        }
        finally {
            if (null != fs) {
                try {
                    fs.close();
                }
                catch (Exception e2) {
                    logger.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
    }

    public static String getPathFromClass(Class cls) throws IOException {
        String path = null;
        if (cls == null) {
            throw new NullPointerException();
        }
        URL url = Consts.getClassLocationURL(cls);
        if (url != null) {
            path = url.getPath();
            if ("jar".equalsIgnoreCase(url.getProtocol())) {
                try {
                    path = new URL(path).getPath();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                int location = path.indexOf("!/");
                if (location != -1) {
                    path = path.substring(0, location);
                }
            }
            File file = new File(path);
            path = file.getCanonicalPath();
        }
        if (null == path) {
            return null;
        }
        path = path.replaceAll("\\\\", "/");
        path = path.substring(0, path.lastIndexOf("/"));
        return path;
    }

    private static URL getClassLocationURL(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("null input: cls");
        }
        URL result = null;
        String clsAsResource = cls.getName().replace('.', '/').concat(".class");
        ProtectionDomain pd = cls.getProtectionDomain();
        if (pd != null) {
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                result = cs.getLocation();
            }
            if (result != null && "file".equals(result.getProtocol())) {
                try {
                    if (result.toExternalForm().endsWith(".jar") || result.toExternalForm().endsWith(".zip")) {
                        result = new URL("jar:".concat(result.toExternalForm()).concat("!/").concat(clsAsResource));
                    } else if (new File(result.getFile()).isDirectory()) {
                        result = new URL(result, clsAsResource);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (result == null) {
            ClassLoader clsLoader = cls.getClassLoader();
            result = clsLoader != null ? clsLoader.getResource(clsAsResource) : ClassLoader.getSystemResource(clsAsResource);
        }
        return result;
    }
}

