/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.v2.base.impl;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpCalTableInfo;
import com.kingdee.shr.compensation.app.calculate.validate.CmpCalResultValidateParam;
import com.kingdee.shr.compensation.app.calculate.validate.CmpCalValidateResultFactory;
import com.kingdee.shr.compensation.app.calculate.validate.CmpCalValidateResultInfo;
import com.kingdee.shr.validaterule.ValidateState;
import com.kingdee.shr.validaterule.VerificationRuleInfo;
import com.kingdee.shr.validaterule.VerificationRuleNodeInfo;
import com.kingdee.shr.validaterule.exception.SalaryException;
import com.kingdee.shr.validaterule.formula.base.impl.SaveCalResultImplCommon;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import com.kingdee.shr.validaterule.formula.base.vo.VRCell;
import com.kingdee.shr.validaterule.formula.base.vo.VRRow;
import com.kingdee.shr.validaterule.util.EntityUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CalResultValidateSaveCalResultImplCommon
extends SaveCalResultImplCommon {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.formula.v2.base.impl.CalResultValidateSaveCalResultImplCommon");

    public void saveCalResult(InitCalData initCalData, Sheet result) throws SalaryException {
        String errMsg = result.getErrMsg();
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            throw new RuntimeException(errMsg);
        }
        Map outerData = (Map)initCalData.getOuterData();
        CmpCalResultValidateParam param = (CmpCalResultValidateParam)outerData.get("param");
        this.handleResult(initCalData.getCtx(), param, result);
    }

    protected void handleResult(Context ctx, CmpCalResultValidateParam param, Sheet result) {
        if (null == result) {
            return;
        }
        List vrResultList = result.getVrResultList();
        String nodeId = this.getNodeIdByNum(ctx, param.getValidateNodeNum());
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
        UserInfo currentUser = (UserInfo)EntityUtil.getNewObjectInfoWithId((Object)new UserInfo(), (String)currentUserId);
        CtrlUnitInfo cu = HRFilterUtils.getCurrentCU((Context)ctx);
        this.deleteBeforeData(ctx, param.getFilterSql(), nodeId);
        CalSchemeInfo calSchemeInfo = param.getCalSchemeInfo();
        CoreBaseCollection validateResultCollection = new CoreBaseCollection();
        ArrayList calTableStateParams = Lists.newArrayList();
        for (VRRow vrRow : vrResultList) {
            String calTableId = vrRow.getId();
            CmpCalTableInfo calTableInfo = (CmpCalTableInfo)EntityUtil.getNewObjectInfoWithId((Object)new CmpCalTableInfo(), (String)calTableId);
            List vrCells = vrRow.getVrCells();
            ValidateState rowState = ValidateState.PASS;
            boolean isError = false;
            for (VRCell vrCell : vrCells) {
                CmpCalValidateResultInfo resultInfo = this.assembleResultInfo(calSchemeInfo, calTableInfo, nodeId, vrCell);
                this.setUserAndCu(currentUser, cu, resultInfo);
                validateResultCollection.add((CoreBaseInfo)resultInfo);
                if (isError) continue;
                if (ValidateState.ERROR.equals((Object)resultInfo.getValidateState())) {
                    isError = true;
                }
                if (resultInfo.getValidateState().getValue() > rowState.getValue()) continue;
                rowState = resultInfo.getValidateState();
            }
            calTableStateParams.add(new Object[]{rowState.getValue(), calTableId});
        }
        this.saveResult(ctx, validateResultCollection);
        this.updateCalTableState(ctx, calTableStateParams);
    }

    protected CmpCalValidateResultInfo assembleResultInfo(CalSchemeInfo calSchemeInfo, CmpCalTableInfo calTableInfo, String nodeId, VRCell vrCell) {
        String vrId = vrCell.getVrId();
        String cellResult = vrCell.getResult();
        String warnType = vrCell.getWarnType();
        ValidateState cellState = this.assembleState(warnType, cellResult);
        CmpCalValidateResultInfo item = new CmpCalValidateResultInfo();
        item.setCmpCalTable(calTableInfo);
        item.setCalScheme(calSchemeInfo);
        item.setPeriodYear(calSchemeInfo.getPeriodYear());
        item.setPeriodMonth(calSchemeInfo.getPeriodMonth());
        item.setCalTime(calSchemeInfo.getCalTime());
        item.setValidateRule((VerificationRuleInfo)EntityUtil.getNewObjectInfoWithId((Object)new VerificationRuleInfo(), (String)vrId));
        item.setNode((VerificationRuleNodeInfo)EntityUtil.getNewObjectInfoWithId((Object)new VerificationRuleNodeInfo(), (String)nodeId));
        item.setValidateState(cellState);
        item.setMessage(cellResult);
        return item;
    }

    protected void saveResult(Context ctx, CoreBaseCollection collection) {
        try {
            CmpCalValidateResultFactory.getLocalInstance(ctx).saveBatchData(collection);
        }
        catch (BOSException | EASBizException e) {
            logger.error((Object)"Save CmpCal ValidateResult error", e);
        }
    }

    protected void deleteBeforeData(Context ctx, String filterSql, String nodeId) {
        try {
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_SCmpCalValidateResult where FCmpCalTableID in (" + filterSql + ") and FNodeID = ?"), (Object[])new Object[]{nodeId});
        }
        catch (BOSException e) {
            logger.error((Object)"delete validate result error", (Throwable)e);
        }
    }

    protected void updateCalTableState(Context ctx, List<Object[]> params) {
        try {
            DbUtil.executeBatch((Context)ctx, (String)"update T_HR_SCmpCalTable set FValidateState = ? where fid = ?", params);
        }
        catch (BOSException e) {
            logger.error((Object)"update T_HR_SCmpCalTable validate State error", (Throwable)e);
        }
    }

    protected String getNodeIdByNum(Context ctx, String nodeNum) {
        String nodeId = "";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select FID from T_HR_SVerificationRuleNode where fnumber = ?", (Object[])new Object[]{nodeNum});
            while (rowSet.next()) {
                nodeId = rowSet.getString("FID");
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"get VerificationRuleNode error", e);
        }
        return nodeId;
    }
}

