/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.v2.base.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.validaterule.CmpItemDataDot;
import com.kingdee.shr.validaterule.formula.base.impl.CalculatorBusinessDataCommon;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SubmitSchemeBillBusinessDataCommon
extends CalculatorBusinessDataCommon {
    private static Logger logger = Logger.getLogger(SubmitSchemeBillBusinessDataCommon.class);

    protected String buildDataSetSql(InitCalData initCalData) throws Exception {
        FilterInfo filter = new FilterInfo("CMP_SMT002.id in (" + initCalData.getCondition() + ")");
        SqlParam sqlParam = new SqlParam();
        Map selectMapping = this.buildSelector(initCalData);
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filter);
        sqlParam.setSortStr("CMP_SMT002.id");
        sqlParam.setScheme(initCalData.getConfigNum());
        sqlParam.setFilterDate(initCalData.getEndDate());
        sqlParam.setHistoryMode(true);
        sqlParam.setIgnoreNowDateFilter(true);
        String sql = FilterUtil.getSql((Context)initCalData.getCtx(), (SqlParam)sqlParam);
        sql = sql.replace("T_HR_SCHEMEBILLENTRY", initCalData.getMainTable().toUpperCase(Locale.ENGLISH));
        return sql;
    }

    public Map<String, Object> getAllCnSnMap(Context ctx, String schemeID) throws BOSException {
        String language = this.getCurrentLanguageBySchemeLocal(ctx, schemeID);
        String sql = "SELECT ITEM.FID ITEMID,ITEM.FNAME_" + language + " ITEMNAME,ITEM.FNUMBER ITEMNUMBER,  ITEM.FIELDSN,ITEM.FDATADOT,ITEM.FDATATYPE,ITEM.FDATALENGTH,F7.FTABLE  FROM  T_HR_SCalSubmitItem ITEM  LEFT JOIN T_HR_SCalSchemeItemForF7 F7 on ITEM.FFilterField = F7.FID  WHERE FSTATE = 1 ORDER BY FIELDSN";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> sn = new ArrayList<String>();
        ArrayList<String> cn = new ArrayList<String>();
        HashMap<String, CmpItemDataDot> dataDotMap = new HashMap<String, CmpItemDataDot>();
        HashMap<String, Integer> dataTypeMap = new HashMap<String, Integer>();
        HashMap<String, Map> f7TypeMap = new HashMap<String, Map>();
        HashMap<String, String> idItemMap = new HashMap<String, String>();
        HashMap<String, Integer> strItemLenMap = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                CmpItemDataDot dataDot = CmpItemDataDot.getEnum((int)rs.getInt("FDATADOT"));
                Integer dataType = rs.getInt("FDATATYPE");
                String name = rs.getString("ITEMNAME");
                int fieldSn = rs.getInt("FIELDSN");
                String f7TableName = rs.getString("FTABLE");
                if (fieldSn <= 0) continue;
                String fieldName = "s" + fieldSn;
                sn.add(fieldName);
                cn.add(name);
                dataDotMap.put(fieldName, dataDot);
                dataTypeMap.put(fieldName, dataType);
                if (dataType == 1) {
                    strItemLenMap.put(fieldName, rs.getInt("FDATALENGTH"));
                }
                if (dataType == 3 && !StringUtils.isEmpty((String)f7TableName)) {
                    f7TypeMap.put(fieldName, this.getF7TableValue(ctx, language, f7TableName));
                }
                idItemMap.put(fieldName.toUpperCase(Locale.ENGLISH), rs.getString("ITEMID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        sn.add("forwarncontent");
        cn.add(EASResource.getString((String)"com.kingdee.shr.validaterule.resource.BaseStrResource", (String)"warnContent", (Locale)ctx.getLocale()));
        dataTypeMap.put("forwarncontent", 1);
        res.put("sn", sn);
        res.put("cn", cn);
        res.put("dataDotMap", dataDotMap);
        res.put("dataTypeMap", dataTypeMap);
        res.put("fieldSnAndId", idItemMap);
        res.put("strLengthMap", strItemLenMap);
        res.put("f7TypeMap", f7TypeMap);
        return res;
    }
}

