/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.v2.base.impl;

import com.kingdee.bos.Context;
import com.kingdee.shr.validaterule.exception.SalaryException;
import com.kingdee.shr.validaterule.formula.base.impl.SaveCalResultImplCommon;
import com.kingdee.shr.validaterule.formula.base.vo.Cell;
import com.kingdee.shr.validaterule.formula.base.vo.ErrRow;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.shr.validaterule.formula.base.vo.Row;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import com.kingdee.shr.validaterule.util.FunUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class SubmitSchemeBillSaveCalResultImplCommon
extends SaveCalResultImplCommon {
    public void saveCalResult(InitCalData initCalData, Sheet result) throws SalaryException {
        String errMsg = result.getErrMsg();
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            throw new RuntimeException(errMsg);
        }
        if (result.getErrDataList() != null && result.getErrDataList().size() > 0) {
            throw new RuntimeException(((ErrRow)result.getErrDataList().get(0)).getErrMsg());
        }
        List changeDataList = result.getChangeDataList();
        if (null == changeDataList) {
            return;
        }
        ArrayList<String> updateSqlList = new ArrayList<String>();
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            String nowDate = FunUtils.toKSqlDate((Date)calendar.getTime());
            Map allCnSnMap = initCalData.getAllCnSnMap();
            String mainTableName = initCalData.getMainTableName();
            Context ctx = initCalData.getCtx();
            Map strItemLenMap = (Map)allCnSnMap.get("strLengthMap");
            Map f7TypeMap = (Map)allCnSnMap.get("f7TypeMap");
            int tempLength = 0;
            for (Row row : changeDataList) {
                StringBuilder setStr = new StringBuilder();
                StringBuilder updateSql = new StringBuilder();
                String fid = row.getFID();
                List cells = row.getCells();
                for (Cell cell : cells) {
                    String column = cell.getColumn();
                    String value = cell.getValue();
                    if ("FORWARNCONTENT".equals(column)) {
                        column = "F" + column;
                    }
                    if (value != null && strItemLenMap.containsKey(column.toLowerCase(Locale.ENGLISH))) {
                        tempLength = (Integer)strItemLenMap.get(column.toLowerCase(Locale.ENGLISH));
                        String string = value = value.length() > tempLength ? value.substring(0, tempLength - 1) : value;
                    }
                    if (value != null && f7TypeMap.get(column.toLowerCase()) != null) {
                        boolean inTable = false;
                        for (Map.Entry entry : ((Map)f7TypeMap.get(column.toLowerCase())).entrySet()) {
                            if (!value.equals(entry.getValue())) continue;
                            inTable = true;
                            value = String.valueOf(entry.getKey());
                            break;
                        }
                        if (!inTable) {
                            value = null;
                        }
                    }
                    if (StringUtils.isEmpty((CharSequence)(value = StringEscapeUtils.escapeSql((String)value)))) {
                        setStr.append(", ").append(column).append(" = null ");
                        continue;
                    }
                    setStr.append(", ").append(column).append(" = '").append(value).append("' ");
                }
                updateSql.append("update ").append(mainTableName).append(" set ");
                updateSql.append(setStr.toString().replaceFirst(",", ""));
                updateSql.append(" ,FLastUpdateTime = ").append(nowDate);
                updateSql.append(" where fid = '").append(fid).append("'");
                updateSqlList.add(updateSql.toString());
            }
            this.executeBatch(ctx, updateSqlList.toArray());
        }
        catch (Exception e) {
            throw new SalaryException(SalaryException.SAVEERROR);
        }
    }
}

