/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.SscTypeEnum;
import com.kingdee.shr.compensation.app.integrate.AbstractSubmitBillEntryFacadeControllerBean;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.helper.CmpCurrencyHelper;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateEntryHelper;
import com.kingdee.shr.compensation.util.integrate.IntegrateEntryTableAttrs;
import com.kingdee.util.LocaleUtils;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitBillEntryFacadeControllerBean
extends AbstractSubmitBillEntryFacadeControllerBean {
    private static final long serialVersionUID = -3822503672868646868L;
    private static final Logger logger = LoggerFactory.getLogger(SubmitBillEntryFacadeControllerBean.class);
    private static final String BASE_TABLE_NAME = "T_HR_SchemeBillEntry";
    private static final String ENTITY_TYPE = "7F647776";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private String userId;

    @Override
    protected void _dealSaveEnties(Context ctx, BatchSubmitShemeBillInfo billInfo) throws BOSException, EASBizException {
        String submitSchemeId = billInfo.getSubmitScheme().getId().toString();
        IntegrateEntryTableAttrs entryTableAttrs = CmpIntegrateEntryHelper.getIntegrateEntryTableAttrs(ctx, submitSchemeId);
        ArrayList baseParamArrayList = Lists.newArrayList();
        ArrayList paramArrayList = Lists.newArrayList();
        BatchSubmitShemeBillEntryCollection coll = billInfo.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            this.assembleSaveParamList(ctx, coll.get(i), billInfo, entryTableAttrs, baseParamArrayList, paramArrayList);
        }
        this.batchSaveEntries(ctx, billInfo, entryTableAttrs, baseParamArrayList, paramArrayList);
    }

    protected void assembleSaveParamList(Context ctx, BatchSubmitShemeBillEntryInfo entryInfo, BatchSubmitShemeBillInfo billInfo, IntegrateEntryTableAttrs entryTableAttrs, List<Object[]> baseParamArrayList, List<Object[]> paramArrayList) {
        ArrayList paramList = Lists.newArrayList();
        String id = BOSUuid.create((String)ENTITY_TYPE).toString();
        entryInfo.setId(BOSUuid.read((String)id));
        paramList.add(id);
        paramList.add(billInfo.getId().toString());
        paramList.add(this.getUserId(ctx));
        paramList.add(CmpDateUtil.genCreateTime4Entry());
        paramList.add(this.getEffectDate(entryInfo));
        paramList.add(entryInfo.getOrgUnit() == null ? null : entryInfo.getOrgUnit().getId().toString());
        paramList.add(entryInfo.getPerson() == null ? null : entryInfo.getPerson().getId().toString());
        paramList.add(entryInfo.getAdminOrgUnit() == null ? null : entryInfo.getAdminOrgUnit().getId().toString());
        paramList.add(entryInfo.getPosition() == null ? null : entryInfo.getPosition().getId().toString());
        paramList.add(entryInfo.getCmpEmpORelation() == null ? null : entryInfo.getCmpEmpORelation().getId().toString());
        paramList.add(entryInfo.getSubmitElement() == null ? null : entryInfo.getSubmitElement().getId().toString());
        paramList.add(entryInfo.getCurrency() == null ? CmpCurrencyHelper.getCNYCurrencyId() : entryInfo.getCurrency().getId().toString());
        paramList.add(entryInfo.getDescription(LocaleUtils.locale_l1));
        paramList.add(entryInfo.getDescription(LocaleUtils.locale_l2));
        paramList.add(entryInfo.getDescription(LocaleUtils.locale_l3));
        paramList.add(entryInfo.getLeffectDate() == null ? CmpDateUtil.toSqlDate(CmpDateUtil.getMaxEndDate()) : CmpDateUtil.toSqlDate(entryInfo.getLeffectDate()));
        paramList.add(billInfo.getHrOrgUnit().getId().toString());
        paramList.add("01");
        paramList.add(10);
        paramList.add(null == entryInfo.getBillState() ? 0 : entryInfo.getBillState().getValue());
        if (billInfo.getIsSsc() != SscTypeEnum.DISTRIBUTE) {
            paramList.add(1);
        } else {
            paramList.add(entryInfo.getDealStatus() == null ? 1 : entryInfo.getDealStatus().getValue());
        }
        this.afterAssembleInsertFixColumn(entryInfo, paramList);
        baseParamArrayList.add(paramList.toArray());
        this.assembleDynamicColumn(entryInfo, paramList, entryTableAttrs);
        paramArrayList.add(paramList.toArray());
    }

    private void assembleUpdateParamList(Context ctx, BatchSubmitShemeBillEntryInfo entryInfo, BatchSubmitShemeBillInfo billInfo, IntegrateEntryTableAttrs entryTableAttrs, List<Object[]> baseParamArrayList, List<Object[]> paramArrayList) {
        ArrayList updateParamList = Lists.newArrayList();
        updateParamList.add(this.getUserId(ctx));
        updateParamList.add(new Timestamp(System.currentTimeMillis()));
        updateParamList.add(this.getEffectDate(entryInfo));
        updateParamList.add(entryInfo.getOrgUnit() == null ? null : entryInfo.getOrgUnit().getId().toString());
        updateParamList.add(entryInfo.getPerson() == null ? null : entryInfo.getPerson().getId().toString());
        updateParamList.add(entryInfo.getAdminOrgUnit() == null ? null : entryInfo.getAdminOrgUnit().getId().toString());
        updateParamList.add(entryInfo.getPosition() == null ? null : entryInfo.getPosition().getId().toString());
        updateParamList.add(entryInfo.getCmpEmpORelation() == null ? null : entryInfo.getCmpEmpORelation().getId().toString());
        updateParamList.add(entryInfo.getSubmitElement() == null ? null : entryInfo.getSubmitElement().getId().toString());
        updateParamList.add(entryInfo.getCurrency() == null ? CmpCurrencyHelper.getCNYCurrencyId() : entryInfo.getCurrency().getId().toString());
        updateParamList.add(entryInfo.getDescription(LocaleUtils.locale_l1));
        updateParamList.add(entryInfo.getDescription(LocaleUtils.locale_l2));
        updateParamList.add(entryInfo.getDescription(LocaleUtils.locale_l3));
        updateParamList.add(entryInfo.getLeffectDate() == null ? CmpDateUtil.toSqlDate(CmpDateUtil.getMaxEndDate()) : entryInfo.getLeffectDate());
        if (billInfo.getIsSsc() != SscTypeEnum.DISTRIBUTE) {
            updateParamList.add(1);
        } else {
            updateParamList.add(entryInfo.getDealStatus() == null ? 1 : entryInfo.getDealStatus().getValue());
        }
        this.afterAssembleUpdateFixColumn(entryInfo, updateParamList);
        ArrayList updateBaseParamList = Lists.newArrayList((Iterable)updateParamList);
        updateBaseParamList.add(entryInfo.getId().toString());
        baseParamArrayList.add(updateBaseParamList.toArray());
        this.assembleDynamicColumn(entryInfo, updateParamList, entryTableAttrs);
        updateParamList.add(entryInfo.getId().toString());
        paramArrayList.add(updateParamList.toArray());
    }

    protected Date getEffectDate(BatchSubmitShemeBillEntryInfo entryInfo) {
        java.util.Date effectDate = entryInfo.getEffectDate();
        if (effectDate != null) {
            return CmpDateUtil.toSqlDate(effectDate);
        }
        return CmpDateUtil.toSqlDate(entryInfo.get("effectday"));
    }

    protected void assembleDynamicColumn(BatchSubmitShemeBillEntryInfo entryInfo, List<Object> paramList, IntegrateEntryTableAttrs entryTableAttrs) {
        int index = 0;
        for (String colName : entryTableAttrs.getColNames()) {
            String dataType = entryTableAttrs.getColTypes().get(index++);
            int dataLength = entryTableAttrs.getDataLength().get(colName);
            Object object = entryInfo.get(colName);
            if (object != null && object.toString().trim().length() > 0 && "2".equals(dataType)) {
                String datestr = object.toString();
                try {
                    java.util.Date date = this.dateFormat.parse(datestr);
                    paramList.add(new Date(date.getTime()));
                }
                catch (ParseException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    paramList.add(null);
                }
                continue;
            }
            if (object != null && object.toString().trim().length() > 0 && "1".equals(dataType) && object.toString().length() > dataLength) {
                paramList.add(object.toString().substring(0, dataLength));
                continue;
            }
            paramList.add("0E-10".equals(object) ? "0.00" : object);
        }
    }

    @Override
    protected void _saveOrUpdateEntries(Context ctx, BatchSubmitShemeBillInfo billInfo) throws BOSException, EASBizException {
        String submitSchemeId = billInfo.getSubmitScheme().getId().toString();
        IntegrateEntryTableAttrs entryTableAttrs = CmpIntegrateEntryHelper.getIntegrateEntryTableAttrs(ctx, submitSchemeId);
        BatchSubmitShemeBillEntryCollection coll = billInfo.getEntry();
        ArrayList updateBaseParamArrayList = Lists.newArrayList();
        ArrayList updateParamArrayList = Lists.newArrayList();
        ArrayList insertBaseParamArrayInsertList = Lists.newArrayList();
        ArrayList insertParamArrayList = Lists.newArrayList();
        for (int i = 0; i < coll.size(); ++i) {
            BatchSubmitShemeBillEntryInfo entryInfo = coll.get(i);
            if (entryInfo.getId() != null) {
                this.assembleUpdateParamList(ctx, entryInfo, billInfo, entryTableAttrs, updateBaseParamArrayList, updateParamArrayList);
                continue;
            }
            this.assembleSaveParamList(ctx, entryInfo, billInfo, entryTableAttrs, insertBaseParamArrayInsertList, insertParamArrayList);
        }
        this.batchUpdateEntries(ctx, billInfo, entryTableAttrs, updateBaseParamArrayList, updateParamArrayList);
        this.batchSaveEntries(ctx, billInfo, entryTableAttrs, insertBaseParamArrayInsertList, insertParamArrayList);
    }

    protected void batchSaveEntries(Context ctx, BatchSubmitShemeBillInfo billInfo, IntegrateEntryTableAttrs entryTableAttrs, List<Object[]> baseParamArrayList, List<Object[]> paramArrayList) throws BOSException {
        if (!paramArrayList.isEmpty()) {
            String insertBaseSql = this.getInsertBaseEntryPrepareSql();
            String insertSql = this.getInsertEntryPrepareSql(entryTableAttrs.getTableName(), entryTableAttrs.getColNames(), false);
            CmpSQLUtil.executeBatch(ctx, insertBaseSql, baseParamArrayList);
            CmpSQLUtil.executeBatch(ctx, insertSql, paramArrayList);
        }
    }

    protected void batchUpdateEntries(Context ctx, BatchSubmitShemeBillInfo billInfo, IntegrateEntryTableAttrs entryTableAttrs, List<Object[]> baseParamArrayList, List<Object[]> paramArrayList) throws BOSException, EASBizException {
        if (!paramArrayList.isEmpty()) {
            String updateBaseSql = this.getUpdateBaseSql();
            String updateSql = this.getUpdateSql(entryTableAttrs.getTableName(), entryTableAttrs.getColNames(), false);
            CmpSQLUtil.executeBatch(ctx, updateBaseSql, baseParamArrayList);
            CmpSQLUtil.executeBatch(ctx, updateSql, paramArrayList);
        }
    }

    protected List<String> getInsertFixColumnNames() {
        return Lists.newArrayList((Object[])new String[]{"FID", "FBillID", "FCreatorID", "FCreateTime", "FEffectDate", "FOrgUnitID", "FPersonID", "FAdminOrgUnitID", "FPositionID", "FCmpEmpORelationID", "FSubmitElementID", "FCurrencyID", "FDescription_l1", "FDescription_l2", "FDescription_l3", "FLeffectDate", "FHrOrgUnitID", "FCalState", "FIsCal", "FBillState", "FDealStatus"});
    }

    protected void afterAssembleInsertFixColumn(BatchSubmitShemeBillEntryInfo entryInfo, List<Object> paramList) {
    }

    protected List<String> getUpdateFixColumnNames() {
        return Lists.newArrayList((Object[])new String[]{"FLastUpdateUserID", "FLastUpdateTime", "FEffectDate", "FOrgUnitID", "FPersonID", "FAdminOrgUnitID", "FPositionID", "FCmpEmpORelationID", "FSubmitElementID", "FCurrencyID", "FDescription_l1", "FDescription_l2", "FDescription_l3", "FLeffectDate", "FDealStatus"});
    }

    protected void afterAssembleUpdateFixColumn(BatchSubmitShemeBillEntryInfo entryInfo, List<Object> paramList) {
    }

    protected String getInsertBaseEntryPrepareSql() {
        return this.getInsertEntryPrepareSql(null, null, true);
    }

    protected String getInsertEntryPrepareSql(String dynamicEntryTable, List<String> submitItemColumnNames, boolean isBase) {
        String entryTableName;
        String submitItemKeys = "";
        String submitItemvalues = "";
        if (isBase) {
            entryTableName = BASE_TABLE_NAME;
        } else {
            entryTableName = dynamicEntryTable;
            submitItemKeys = "," + StringUtils.join(submitItemColumnNames, (String)",");
            submitItemvalues = submitItemKeys.replaceAll("[Ss]{1}\\d{1,4}", "?");
        }
        List<String> fixColumnNames = this.getInsertFixColumnNames();
        String fixColumnKeys = StringUtils.join(fixColumnNames, (String)",");
        String fixColumnValues = fixColumnKeys.replaceAll("\\w+", "?");
        return "INSERT INTO " + entryTableName + " (" + fixColumnKeys + submitItemKeys + ") VALUES (" + fixColumnValues + submitItemvalues + ")";
    }

    protected String getUpdateBaseSql() {
        return this.getUpdateSql(null, null, true);
    }

    protected String getUpdateSql(String dynamicEntryTable, List<String> submitItemColumnNames, boolean isBase) {
        String entryTableName = isBase ? BASE_TABLE_NAME : dynamicEntryTable;
        StringBuilder updateSql = new StringBuilder("UPDATE %s SET ");
        List<String> updateColumnNames = this.getUpdateFixColumnNames();
        if (submitItemColumnNames != null) {
            updateColumnNames.addAll(submitItemColumnNames);
        }
        ArrayList setSqlColumnList = Lists.newArrayList();
        for (String columnName : updateColumnNames) {
            setSqlColumnList.add(columnName + "=?");
        }
        updateSql.append(StringUtils.join((Object[])setSqlColumnList.toArray(), (String)","));
        updateSql.append(" WHERE fid=?");
        return String.format(updateSql.toString(), entryTableName);
    }

    protected String getUserId(Context ctx) {
        if (this.userId == null) {
            this.userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        }
        return this.userId;
    }
}

