/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.tax.base.TaxIncomeItemFactory;
import com.kingdee.shr.compensation.app.tax.base.TaxIncomeItemInfo;
import com.kingdee.shr.compensation.app.tax.base.TaxItemCollection;
import com.kingdee.shr.compensation.app.taxCal.AbstractConfigResultFacadeControllerBean;
import com.kingdee.shr.compensation.taxCal.util.TaxItemUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ConfigResultFacadeControllerBean
extends AbstractConfigResultFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.taxCal.ConfigResultFacadeControllerBean");
    private List<String> itemList;
    private Set<String> sumItemSet;
    private Set<String> sumTaxIncomeItem;
    private Map<String, Map<String, BigDecimal>> sumMap;
    private List<Map<String, Object>> detailList;
    private Set<String> configDetailSet;
    private Map<String, Integer> personCountMap;
    private Map<String, Boolean> notNullMap;

    @Override
    protected Set _confirmData(Context ctx, String resultIds) throws BOSException {
        this.initTaxItem(ctx);
        this.insertConfigDetail(ctx, resultIds);
        this.combineSumAndResultData(ctx, resultIds);
        this.updateConfigDetailFromResult(ctx);
        DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_STAXCALCONFIGRESULT SET FSTATE = 20 WHERE FID IN (" + resultIds + ") AND FSTATE = 10"));
        return this.configDetailSet;
    }

    private void initTaxItem(Context ctx) {
        this.itemList = new ArrayList<String>();
        this.sumItemSet = new HashSet<String>();
        TaxItemCollection coll = TaxItemUtil.getAllTaxItem(ctx, true);
        for (int i = 0; i < coll.size(); ++i) {
            this.itemList.add("T" + coll.get(i).getFieldSn());
            if (!coll.get(i).isIsSplit()) continue;
            this.sumItemSet.add("T" + coll.get(i).getFieldSn());
        }
        this.sumTaxIncomeItem = new HashSet<String>();
        try {
            CoreBaseCollection taxIncomeItemCollection = TaxIncomeItemFactory.getLocalInstance(ctx).getCollection("select id,taxCalMethod where taxCalMethod = 10");
            if (null != taxIncomeItemCollection && taxIncomeItemCollection.size() > 0) {
                int size = taxIncomeItemCollection.size();
                for (int i = 0; i < size; ++i) {
                    TaxIncomeItemInfo taxIncomeItemInfo = (TaxIncomeItemInfo)taxIncomeItemCollection.get(i);
                    this.sumTaxIncomeItem.add(taxIncomeItemInfo.getId().toString());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateConfigDetailFromResult(Context ctx) throws BOSException {
        StringBuilder str = new StringBuilder();
        str.append(" UPDATE T_HR_STAXCALCONFIGDETAIL SET FSTATE = 20,");
        for (String itemStr : this.itemList) {
            str.append(itemStr).append(" = ?,");
        }
        String updateSql = str.substring(0, str.length() - 1) + " where fid = ? ";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Map<String, Object> stringObjectMap : this.detailList) {
            String item;
            int k;
            Object[] param = new Object[this.itemList.size() + 1];
            String personKey = stringObjectMap.get("personKey").toString();
            Map<String, BigDecimal> sumRowMap = this.sumMap.get(personKey);
            if (null == sumRowMap) continue;
            if (this.sumTaxIncomeItem.contains(stringObjectMap.get("incomeItem"))) {
                if (this.personCountMap.containsKey(personKey)) {
                    for (k = 0; k < this.itemList.size(); ++k) {
                        item = this.itemList.get(k);
                        if (!this.notNullMap.containsKey(personKey + item) && !this.isBigDecimalEmpty(sumRowMap.get(item))) {
                            if (this.sumItemSet.contains(item)) {
                                int count = this.personCountMap.get(personKey);
                                BigDecimal sumVal = sumRowMap.get(item);
                                BigDecimal[] divideAndRemainder = sumVal.divideAndRemainder(new BigDecimal(count));
                                BigDecimal divideVal = divideAndRemainder[0];
                                BigDecimal remainder = divideAndRemainder[1];
                                sumRowMap.put(item, sumVal.subtract(divideVal).subtract(remainder));
                                param[k] = divideVal.add(remainder);
                                continue;
                            }
                            param[k] = sumRowMap.get(item);
                            continue;
                        }
                        param[k] = stringObjectMap.get(item);
                    }
                    this.personCountMap.put(personKey, this.personCountMap.get(personKey) - 1);
                } else {
                    for (k = 0; k < this.itemList.size(); ++k) {
                        item = this.itemList.get(k);
                        param[k] = this.isBigDecimalEmpty(stringObjectMap.get(item)) ? sumRowMap.get(item) : stringObjectMap.get(item);
                    }
                }
            } else {
                for (k = 0; k < this.itemList.size(); ++k) {
                    item = this.itemList.get(k);
                    param[k] = this.isBigDecimalEmpty(stringObjectMap.get(item)) ? sumRowMap.get(item) : stringObjectMap.get(item);
                }
            }
            param[this.itemList.size()] = stringObjectMap.get("id");
            paramsList.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
    }

    private boolean isBigDecimalEmpty(Object obj) {
        if (!(obj instanceof BigDecimal)) {
            return true;
        }
        BigDecimal bigObj = (BigDecimal)obj;
        return bigObj.compareTo(BigDecimal.ZERO) == 0;
    }

    private void combineSumAndResultData(Context ctx, String resultIds) throws BOSException {
        this.sumMap = new HashMap<String, Map<String, BigDecimal>>();
        StringBuilder resStr = new StringBuilder();
        for (String item : this.itemList) {
            resStr.append(",").append(item);
        }
        String resColumns = resStr.toString();
        String str = " SELECT RES.FPERSONID, RES.FTAXUNITID,RES.FINCOMEITEMID,FRELATIONID " + resColumns + " FROM T_HR_STAXCALCONFIGRESULT RES  WHERE RES.FID IN (" + resultIds + ") AND FSTATE = 10 ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str);
        try {
            while (rowSet.next()) {
                this.combineRowInfo(rowSet);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
    }

    private void combineRowInfo(IRowSet rowSet) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        String key = null;
        try {
            for (String item : this.itemList) {
                map.put(item, rowSet.getBigDecimal(item));
            }
            key = rowSet.getString("FTAXUNITID") + rowSet.getString("FINCOMEITEMID") + rowSet.getString("FPERSONID") + rowSet.getString("FRELATIONID");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        this.sumMap.put(key, map);
    }

    private void insertConfigDetail(Context ctx, String resultIds) throws BOSException {
        this.detailList = new ArrayList<Map<String, Object>>();
        this.configDetailSet = new HashSet<String>();
        this.personCountMap = new HashMap<String, Integer>();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Date createTime = new Date(new java.util.Date().getTime());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        StringBuilder str = new StringBuilder();
        StringBuilder valStr = new StringBuilder();
        for (String item : this.itemList) {
            str.append(",").append(item);
            valStr.append(",?");
        }
        String itemCol = str.toString();
        str = new StringBuilder();
        str.append(" INSERT INTO T_HR_STAXCALCONFIGDETAIL(");
        str.append(" FCALSCHEMEID, FCMPCALTABLEID, FSTATE, FPERSONID, FTAXUNITID, ");
        str.append(" FPERIODBEGIN, FPERIODEND, FINCOMEITEMID, FCREATORID, FCREATETIME, ");
        str.append(" FLASTUPDATEUSERID, FLASTUPDATETIME, FID ").append(itemCol).append(") ");
        str.append(" VALUES(?, ?, ?, ?, ?, ");
        str.append(" ?, ?, ?, ?, ?,");
        str.append(" ?, ?, ? ").append(valStr.toString());
        str.append(") ");
        String sql = str.toString();
        Set<String> relationIdsSet = this.getRelationCmpCalSet(ctx, resultIds);
        str = new StringBuilder();
        str.append(" SELECT FCALSCHEMEID, FCMPCALTABLEID, FPERSONID, FTAXUNITID, FPERIODBEGIN, ");
        str.append(" FPERIODEND, FINCOMEITEMID ").append(itemCol);
        str.append(" FROM T_HR_STAXCALINITDETAIL INIT ");
        str.append(" WHERE EXISTS(");
        str.append(" SELECT 1 FROM T_HR_STAXCALCONFIGRESULT RES ");
        str.append(" WHERE INIT.FPERSONID = RES.FPERSONID AND INIT.FTAXUNITID = RES.FTAXUNITID ");
        str.append(" AND INIT.FINCOMEITEMID = RES.FINCOMEITEMID AND INIT.FPERIODBEGIN = RES.FPERIODBEGIN ");
        str.append(" AND RES.FID IN (").append(resultIds).append(") AND FSTATE = 10 )");
        str.append(" AND FSTATE = 40 AND FDATASTATE = 10");
        str.append(" ORDER BY FTAXUNITID, FINCOMEITEMID, FPERSONID, FCREATETIME ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                String personKey;
                String incomeItemId = rowSet.getString("FINCOMEITEMID");
                if (this.sumTaxIncomeItem.contains(incomeItemId)) {
                    personKey = rowSet.getString("FTAXUNITID") + rowSet.getString("FINCOMEITEMID") + rowSet.getString("FPERSONID") + rowSet.getString("FPERSONID");
                } else {
                    if (!relationIdsSet.contains(rowSet.getString("FCMPCALTABLEID"))) continue;
                    personKey = rowSet.getString("FTAXUNITID") + rowSet.getString("FINCOMEITEMID") + rowSet.getString("FPERSONID") + rowSet.getString("FCMPCALTABLEID");
                }
                String pkId = BOSUuid.create((String)"CF8A697F").toString();
                Object[] param = new Object[13 + this.itemList.size()];
                param[0] = rowSet.getString("FCALSCHEMEID");
                param[1] = rowSet.getString("FCMPCALTABLEID");
                param[2] = 10;
                param[3] = rowSet.getString("FPERSONID");
                param[4] = rowSet.getString("FTAXUNITID");
                param[5] = rowSet.getDate("FPERIODBEGIN");
                param[6] = rowSet.getDate("FPERIODEND");
                param[7] = incomeItemId;
                param[8] = userId;
                param[9] = createTime;
                param[10] = userId;
                param[11] = createTime;
                param[12] = pkId;
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < this.itemList.size(); ++i) {
                    param[13 + i] = rowSet.getBigDecimal(this.itemList.get(i));
                    map.put(this.itemList.get(i), rowSet.getBigDecimal(this.itemList.get(i)));
                }
                paramsList.add(param);
                map.put("id", pkId);
                map.put("personKey", personKey);
                map.put("incomeItem", rowSet.getString("FINCOMEITEMID"));
                this.detailList.add(map);
                this.configDetailSet.add(pkId);
                if (this.personCountMap.containsKey(personKey)) {
                    this.personCountMap.put(personKey, this.personCountMap.get(personKey) + 1);
                    continue;
                }
                this.personCountMap.put(personKey, 1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        Set<String> keySet = this.personCountMap.keySet();
        Iterator<String> iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (this.personCountMap.get(key) > 1) continue;
            iterator.remove();
            this.personCountMap.remove(key);
        }
        this.notNullMap = new HashMap<String, Boolean>();
        for (Map<String, Object> dataMap : this.detailList) {
            String personKey = dataMap.get("personKey").toString();
            if (!this.personCountMap.containsKey(personKey)) continue;
            for (String item : this.itemList) {
                BigDecimal val = null == dataMap.get(item) ? BigDecimal.ZERO : (BigDecimal)dataMap.get(item);
                if (val.compareTo(BigDecimal.ZERO) <= 0) continue;
                this.notNullMap.put(personKey + item, true);
            }
        }
    }

    private Set<String> getRelationCmpCalSet(Context ctx, String resultIds) {
        HashSet<String> result = new HashSet<String>();
        StringBuilder str = new StringBuilder();
        str.append(" SELECT DISTINCT FRELATIONID FROM T_HR_STAXCALCONFIGRESULT ");
        str.append(" WHERE FID IN (").append(resultIds).append(")");
        str.append(" AND FINCOMEITEMID NOT IN (").append(CmpStrUtil.convertSetToSqlString(this.sumTaxIncomeItem)).append(")");
        str.append(" AND FSTATE = 10 ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (rowSet.next()) {
                result.add(rowSet.getString("FRELATIONID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

