/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.app.taxCal.AbstractTaxCalTaskControllerBean;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TaxCalTaskControllerBean
extends AbstractTaxCalTaskControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.taxCal.TaxCalTaskControllerBean");

    @Override
    protected IObjectPK _getTaskIDByMsgID(Context ctx, String msg_id) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)msg_id)) {
            return null;
        }
        TaxCalTaskInfo taskInfo = this.getTaskByMsgID(ctx, msg_id);
        if (null == taskInfo) {
            return null;
        }
        return new ObjectUuidPK(taskInfo.getId());
    }

    @Override
    protected void _saveAcceptIDByMsgID(Context ctx, String accept_id, String msg_id) throws BOSException {
        TaxCalTaskInfo taskInfo = this.getTaskByMsgID(ctx, msg_id);
        if (null == taskInfo) {
            return;
        }
        taskInfo.setAccept_id(accept_id);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("accept_id");
        try {
            this.updatePartial(ctx, taskInfo, selector);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected IObjectValue _getTaskByMsgID(Context ctx, String msg_id) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)msg_id)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo msgIdFilter = new FilterItemInfo("message_id", (Object)msg_id, CompareType.EQUALS);
        filterInfo.getFilterItems().add(msgIdFilter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("message_id");
        selector.add("catalog");
        selector.add("state");
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(selector);
        TaxCalTaskCollection taxCalTaskCollection = this.getTaxCalTaskCollection(ctx, viewInfo);
        if (null != taxCalTaskCollection && taxCalTaskCollection.size() > 0) {
            TaxCalTaskInfo taxCalTaskInfo = taxCalTaskCollection.get(0);
            return taxCalTaskInfo;
        }
        return null;
    }

    @Override
    protected void _updateStateByAcceptID(Context ctx, TaxCalTaskStateEnum state, String accept_id) throws BOSException {
        TaxCalTaskInfo taskInfo = this.getTaskByAcceptID(ctx, accept_id);
        if (null == taskInfo) {
            return;
        }
        taskInfo.setState(state);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        try {
            this.updatePartial(ctx, taskInfo, selector);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _updateStateMsgByAcceptID(Context ctx, String accept_id, TaxCalTaskStateEnum state, String msg) throws BOSException {
        TaxCalTaskInfo taskInfo = this.getTaskByAcceptID(ctx, accept_id);
        if (null == taskInfo) {
            return;
        }
        taskInfo.setState(state);
        taskInfo.setMsg(msg);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        selector.add("msg");
        try {
            this.updatePartial(ctx, taskInfo, selector);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected IObjectValue _getTaskByAcceptID(Context ctx, String accept_id) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)accept_id)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo acceptIdFilter = new FilterItemInfo("accept_id", (Object)accept_id, CompareType.EQUALS);
        filterInfo.getFilterItems().add(acceptIdFilter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("accept_id");
        selector.add("message_id");
        selector.add("msg");
        selector.add("catalog");
        selector.add("taxUnit.id");
        selector.add("taxUnit.taxNumber");
        selector.add("taxUnit.name");
        selector.add("creator.id");
        selector.add("state");
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(selector);
        TaxCalTaskCollection taxCalTaskCollection = this.getTaxCalTaskCollection(ctx, viewInfo);
        if (null != taxCalTaskCollection && taxCalTaskCollection.size() > 0) {
            return taxCalTaskCollection.get(0);
        }
        return null;
    }

    protected void setNumberFromCodingRule(Context ctx, DataBaseInfo caller, String orgId) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = this.getCU(ctx, (ObjectBaseInfo)caller).getId().toString();
        }
        if (orgId == null || orgId.trim().length() == 0) {
            return;
        }
        if (iCodingRuleManager.isExist((IObjectValue)caller, orgId)) {
            caller.setNumber(iCodingRuleManager.getNumber((IObjectValue)caller, orgId));
        }
    }

    @Override
    protected void _updateStateMsgByMsgID(Context ctx, String msg_id, TaxCalTaskStateEnum state, String msg) throws BOSException {
        TaxCalTaskInfo taskInfo = this.getTaskByMsgID(ctx, msg_id);
        if (null == taskInfo) {
            return;
        }
        taskInfo.setState(state);
        taskInfo.setMsg(msg);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        selector.add("msg");
        try {
            this.updatePartial(ctx, taskInfo, selector);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected IObjectPK _getTaskIDBySecondMsgID(Context ctx, String secondMsg_id) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)secondMsg_id)) {
            return null;
        }
        TaxCalTaskInfo taskInfo = this.getTaskBySecordMsgID(ctx, secondMsg_id);
        if (null == taskInfo) {
            return null;
        }
        return new ObjectUuidPK(taskInfo.getId());
    }

    @Override
    protected IObjectValue _getTaskBySecordMsgID(Context ctx, String secondMsg_id) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)secondMsg_id)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo msgIdFilter = new FilterItemInfo("getResultMsgID", (Object)secondMsg_id, CompareType.EQUALS);
        filterInfo.getFilterItems().add(msgIdFilter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("getResultMsgID");
        selector.add("catalog");
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(selector);
        TaxCalTaskCollection taxCalTaskCollection = this.getTaxCalTaskCollection(ctx, viewInfo);
        if (null != taxCalTaskCollection && taxCalTaskCollection.size() > 0) {
            return taxCalTaskCollection.get(0);
        }
        return null;
    }

    @Override
    protected void _updateStateMsgBySecondMsgID(Context ctx, String secondMsg_id, TaxCalTaskStateEnum state, String msg) throws BOSException {
        TaxCalTaskInfo taskInfo = this.getTaskByMsgID(ctx, secondMsg_id);
        if (null == taskInfo) {
            return;
        }
        taskInfo.setState(state);
        taskInfo.setMsg(msg);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        selector.add("msg");
        try {
            this.updatePartial(ctx, taskInfo, selector);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected IObjectValue _getTaskById(Context ctx, String taskId) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo acceptIdFilter = new FilterItemInfo("id", (Object)BOSUuid.read((String)taskId), CompareType.EQUALS);
        filterInfo.getFilterItems().add(acceptIdFilter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("accept_id");
        selector.add("message_id");
        selector.add("msg");
        selector.add("period");
        selector.add("catalog");
        selector.add("taxUnit.id");
        selector.add("taxUnit.taxNumber");
        selector.add("taxUnit.name");
        selector.add("creator.id");
        selector.add("requestParam.paramContent");
        selector.add("state");
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(selector);
        TaxCalTaskCollection taxCalTaskCollection = this.getTaxCalTaskCollection(ctx, viewInfo);
        if (null != taxCalTaskCollection && taxCalTaskCollection.size() > 0) {
            return taxCalTaskCollection.get(0);
        }
        return null;
    }

    @Override
    protected void _updateStateMsgById(Context ctx, String taskId, TaxCalTaskStateEnum taskState, String msg) throws BOSException {
        TaxCalTaskInfo taskInfo = this.getTaskById(ctx, taskId);
        if (null == taskInfo) {
            return;
        }
        taskInfo.setState(taskState);
        taskInfo.setMsg(msg);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        selector.add("msg");
        try {
            this.updatePartial(ctx, taskInfo, selector);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _updateAcceptIdById(Context ctx, String acceptId, String taskId) throws BOSException {
        String sql = "update t_hr_sTaxCalTask set fAccept_id = ?, fState = ? where fid = ?";
        ArrayList<Object[]> list = new ArrayList<Object[]>(1);
        Object[] param = new Object[]{acceptId, 20, taskId};
        list.add(param);
        DbUtil.executeBatch((Context)ctx, (String)sql, list);
    }
}

