/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.tax.TaxUnitCollection;
import com.kingdee.shr.compensation.app.tax.TaxUnitFactory;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.taxCal.AbstractTaxDirectDeductionFacadeControllerBean;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxDirectDeductionCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxDirectDeductionFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxDirectDeductionInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxUnitDeductionFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxUnitDeductionInfo;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.TaxReportUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxDirectDeductionFacadeControllerBean
extends AbstractTaxDirectDeductionFacadeControllerBean {
    private static final Logger LOG = Logger.getLogger(TaxDirectDeductionFacadeControllerBean.class);

    @Override
    protected List _staffCollection(Context ctx, Map paramMap) throws BOSException {
        if (null == paramMap || null == paramMap.get("taxUnitIds") || null == paramMap.get("period")) {
            throw new BOSException("6\u4e07\u76f4\u63a5\u6263\u9664\u4eba\u5458\u5f52\u96c6\u63a5\u53e3\u670d\u52a1\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        String taxUnitIds = (String)paramMap.get("taxUnitIds");
        ArrayList<IObjectPK> arrayList = new ArrayList<IObjectPK>();
        String oql = "select id,name,number,taxNumber,areaCode,regNumber,declPassword,realPassword,isAutoDeduct where id in " + CmpStrUtil.buildInSql(taxUnitIds);
        TaxUnitCollection taxUnitCollection = TaxUnitFactory.getLocalInstance(ctx).getTaxUnitCollection(oql);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int i = 0; i < taxUnitCollection.size(); ++i) {
            TaxUnitInfo taxUnitInfo = taxUnitCollection.get(i);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nsrsbh", taxUnitInfo.getTaxNumber());
            map.put("areaid", taxUnitInfo.getAreaCode());
            map.put("smzh", "");
            map.put("smmm", Base64Utils.decode(taxUnitInfo.getRealPassword()));
            String yearMonth = TaxReportUtil.getCurrentYearMonth((String)paramMap.get("period"));
            map.put("sdyf", yearMonth);
            map.put("ver", "V2.0.000");
            map.put("djxhid", taxUnitInfo.getRegNumber());
            map.put("sbmm", Base64Utils.decode(taxUnitInfo.getDeclPassword()));
            map.put("TAXUNITID", taxUnitInfo.getId().toString());
            map.put("PERIOD", (String)paramMap.get("period"));
            IObjectPK pk = TaxServiceTaskFacadeFactory.getLocalInstance(ctx).addTask(TaxCalTaskCatalogEnum.PersonCollect, map);
            arrayList.add(pk);
            int year = Integer.parseInt(yearMonth.substring(0, 4)) - 1;
            String taxUnitDeductionId = this.saveTaxUnitDeduction(ctx, taxUnitInfo, year);
            Object[] param = new Object[]{pk.toString(), taxUnitDeductionId, BOSUuid.create((String)"46E337F4").toString()};
            params.add(param);
        }
        String sqlString = "insert into T_HR_STaskIncomeTaxRelation (FTaskId,FBizId,Fid) values (?, ?, ?)";
        DbUtil.executeBatch((Context)ctx, (String)sqlString, params);
        return arrayList;
    }

    @Override
    protected synchronized void _saveStaffCollection(Context ctx, String taskId, String result) throws BOSException {
    }

    private String saveTaxUnitDeduction(Context ctx, TaxUnitInfo taxUnit, int year) throws BOSException {
        IObjectPK pk;
        try {
            String taxUnitId = taxUnit.getId().toString();
            String deleteSQL = "delete from T_HR_STaxUnitDeduction where fTaxUnitId = '" + taxUnitId + "' and fYear = " + year;
            DbUtil.execute((Context)ctx, (String)deleteSQL);
            deleteSQL = "delete from t_hr_sTaxDirectDeduction where fTaxUnitDeductionId in (select fid from T_HR_STaxUnitDeduction where fTaxUnitId = '" + taxUnitId + "' and fYear = " + year + ")";
            DbUtil.execute((Context)ctx, (String)deleteSQL);
            TaxUnitDeductionInfo info = new TaxUnitDeductionInfo();
            info.setTaxUnit(taxUnit);
            info.setYear(year);
            info.setIsCollection(true);
            pk = TaxUnitDeductionFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        }
        catch (EASBizException e) {
            LOG.error((Object)"_saveStaffCollection error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        return pk.toString();
    }

    @Override
    protected List _confirm(Context ctx, Map paramMap) throws BOSException {
        List ids = (List)paramMap.get("ids");
        String oql = "select id, taxUnitDeduction.id, taxUnitDeduction.taxUnit.taxNumber, taxUnit.id, taxUnitDeduction.taxUnit.areaCode, taxUnitDeduction.taxUnit.regNumber, taxUnitDeduction.taxUnit.declPassword, taxUnitDeduction.taxUnit.realPassword, taxUnitDeduction.taxUnit.isAutoDeduct, isDecdut, taxPersonRecordEntry.bill.cardType, taxPersonRecordEntry.bill.cardNumber where id in " + CmpStrUtil.concatList(ids);
        TaxDirectDeductionCollection collection = TaxDirectDeductionFactory.getLocalInstance(ctx).getTaxDirectDeductionCollection(oql);
        if (null == collection || collection.size() == 0) {
            throw new BOSException("6\u4e07\u76f4\u63a5\u6263\u9664\u4eba\u5458\u786e\u8ba4\uff0c\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u4eba\u5458\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e\u662f\u5426\u88ab\u5220\u9664");
        }
        ArrayList<IObjectPK> arrayList = new ArrayList<IObjectPK>();
        Map<String, List<TaxDirectDeductionInfo>> groups = this.groupByTaxUnit(collection);
        Map<String, String> acceptIdMap = this.getAcceptIdMap(ctx, groups);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Map.Entry<String, List<TaxDirectDeductionInfo>> entry : groups.entrySet()) {
            TaxUnitDeductionInfo taxUnitDeductionInfo = entry.getValue().get(0).getTaxUnitDeduction();
            TaxUnitInfo taxUnitInfo = taxUnitDeductionInfo.getTaxUnit();
            StringBuilder confirmIds = new StringBuilder();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("nsrsbh", taxUnitInfo.getTaxNumber());
            map.put("areaid", taxUnitInfo.getAreaCode());
            map.put("smzh", "");
            map.put("smmm", Base64Utils.decode(taxUnitInfo.getRealPassword()));
            int lastYear = CmpDateUtil.getYear(new Date());
            String period = lastYear + "01";
            map.put("sdyf", period);
            map.put("bmbh", "");
            map.put("acceptId", acceptIdMap.get(taxUnitDeductionInfo.getId().toString()));
            map.put("ver", "V2.0.000");
            map.put("djxhid", taxUnitInfo.getRegNumber());
            map.put("sbmm", Base64Utils.decode(taxUnitInfo.getDeclPassword()));
            map.put("TAXUNITID", taxUnitInfo.getId().toString());
            ArrayList dataList = new ArrayList();
            for (TaxDirectDeductionInfo taxDirectDeductionInfo : entry.getValue()) {
                HashMap<String, String> detailMap = new HashMap<String, String>();
                Object[] param = new Object[2];
                detailMap.put("zzlx", taxDirectDeductionInfo.getTaxPersonRecordEntry().getBill().getCardType().getAlias());
                detailMap.put("zzhm", taxDirectDeductionInfo.getTaxPersonRecordEntry().getBill().getCardNumber());
                detailMap.put("sfkc", taxDirectDeductionInfo.isIsDecdut() ? "\u662f" : "\u5426");
                param[0] = 40;
                param[1] = taxDirectDeductionInfo.getId().toString();
                params.add(param);
                dataList.add(detailMap);
                if (confirmIds.length() > 0) {
                    confirmIds.append(",");
                }
                confirmIds.append(taxDirectDeductionInfo.getId().toString());
            }
            map.put("ids", confirmIds.toString());
            map.put("qrgjrylb", dataList);
            IObjectPK pk = TaxServiceTaskFacadeFactory.getLocalInstance(ctx).addTask(TaxCalTaskCatalogEnum.PersonCollectConfirm, map);
            String updateSQL = "update T_HR_STaxDirectDeduction set FSate = ? where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, params);
            TaxCalTaskInfo taxCalTaskInfo = new TaxCalTaskInfo();
            taxCalTaskInfo.setId(BOSUuid.read((String)pk.toString()));
            arrayList.add(pk);
        }
        return arrayList;
    }

    private Map<String, String> getAcceptIdMap(Context ctx, Map<String, List<TaxDirectDeductionInfo>> groups) throws BOSException {
        try {
            String sql = "select t3.fAccept_id acceptId, t1.fid fid from t_hr_sTaxUnitDeduction t1, T_HR_STaskIncomeTaxRelation t2, t_hr_sTaxCalTask t3 where t1.fid = t2.fBizId and t2.fTaskId = t3.fid and t1.fid in (" + CmpStrUtil.convertSetToSqlString(groups.keySet()) + ")";
            HashMap<String, String> acceptIdMap = new HashMap<String, String>();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String key = rs.getString("fid");
                String acceptId = rs.getString("acceptId");
                acceptIdMap.put(key, acceptId);
            }
            return acceptIdMap;
        }
        catch (Exception e) {
            LOG.error((Object)"getAcceptIdMap error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private Map<String, List<TaxDirectDeductionInfo>> groupByTaxUnit(TaxDirectDeductionCollection collection) {
        HashMap<String, List<TaxDirectDeductionInfo>> map = new HashMap<String, List<TaxDirectDeductionInfo>>();
        for (int i = 0; i < collection.size(); ++i) {
            TaxDirectDeductionInfo info = collection.get(i);
            String taxUnitDeductionId = info.getTaxUnitDeduction().getId().toString();
            ArrayList<TaxDirectDeductionInfo> list = (ArrayList<TaxDirectDeductionInfo>)map.get(taxUnitDeductionId);
            if (null == list) {
                list = new ArrayList<TaxDirectDeductionInfo>();
            }
            list.add(info);
            map.put(taxUnitDeductionId, list);
        }
        return map;
    }

    @Override
    protected void _saveConfirm(Context ctx, String taskId, String result) throws BOSException {
    }
}

