/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.budget.budgetadjust.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.budget.BudgetManageInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.SubBudgetAssignTypeEnum;
import com.kingdee.shr.compensation.app.budget.SubBudgetManageInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustBillInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustEntryInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.SubBudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.app.budget.budgetadjust.SubBudgetAdjustEntryInfo;
import com.kingdee.shr.compensation.app.integrate.multiinspire.CostTypeInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetAdjustEntryParam;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BudgetAdjustSqlUtils {
    public static String queryBudgetManageSql(List<String> colNameHisList, String whereSql) {
        StringBuilder queryManageSql = new StringBuilder();
        queryManageSql.append("select fid budgetManage, FAdminOrgUnitID adminOrgUnit, FCostTypeID costType, FDataVersion dataVersion, FRemark_l1 description_l1, FRemark_l2 description_l2, FRemark_l3 description_l3");
        for (String colNameHis : colNameHisList) {
            queryManageSql.append(", ").append(colNameHis);
        }
        queryManageSql.append(" from T_HR_SBudgetManage ").append(whereSql);
        return queryManageSql.toString();
    }

    public static String queryBudgetManageSqlWithoutApprovingBill(List<String> colNameHisList, String filterSql) {
        StringBuilder queryManageSql = new StringBuilder();
        queryManageSql.append("select fid budgetManage, FAdminOrgUnitID adminOrgUnit, FCostTypeID costType, FDataVersion dataVersion, FRemark_l1 description_l1, FRemark_l2 description_l2, FRemark_l3 description_l3");
        for (String colNameHis : colNameHisList) {
            queryManageSql.append(", ").append(colNameHis);
        }
        queryManageSql.append(" from T_HR_SBudgetManage where   fstate=1 and fid not in  (SELECT manage2.fid id FROM T_HR_SBudgetManage manage2 inner join t_hr_sbudgetadjustentry entry on entry.FBudgetManageID = manage2.fid  inner join t_hr_sbudgetadjustbill bill on entry.FBillID = bill.fid  where  bill.FBillState in (1,2) ) ").append(filterSql);
        return queryManageSql.toString();
    }

    public static String queryBudgetManageAndEntrySql(List<String> colNameHisList, String whereSql) {
        StringBuilder queryManageSql = new StringBuilder();
        queryManageSql.append("select entry.fid entryId, manage.fid budgetManage, entry.FBudgetManageID entryManageId, manage.FAdminOrgUnitID adminOrgUnit, manage.FCostTypeID costType, manage.FDataVersion dataVersion, manage.FRemark_l1 description_l1, manage.FRemark_l2 description_l2, manage.FRemark_l3 description_l3");
        for (String colNameHis : colNameHisList) {
            queryManageSql.append(", manage.").append(colNameHis);
        }
        queryManageSql.append(" FROM t_hr_SBudgetAdjustEntry entry  inner join t_hr_sbudgetadjustbill bill on entry.fbillid = bill.fid  left join  t_hr_sbudgetmanage manage  on manage.FAdminOrgUnitID = entry.FAdminOrgUnitID and manage.FCostTypeID=entry.FCostTypeID  and  manage.FBudgetSchemeID = bill.FBudgetSchemeID ").append(whereSql);
        return queryManageSql.toString();
    }

    public static String queryEntryAndBudgetManageSql(List<String> colNameHisList, String whereSql) {
        StringBuilder queryManageSql = new StringBuilder();
        queryManageSql.append("select fid budgetManage, FAdminOrgUnitID adminOrgUnit, FCostTypeID costType, FDataVersion dataVersion, FRemark_l1 description_l1, FRemark_l2 description_l2, FRemark_l3 description_l3");
        for (String colNameHis : colNameHisList) {
            queryManageSql.append(", ").append(colNameHis);
        }
        queryManageSql.append(" from T_HR_SBudgetManage ").append(whereSql);
        return queryManageSql.toString();
    }

    public static String querySubBudgetManageSqlToQuery(Context ctx, List<String> budgetPeriodColNames, List<String> budgetPeriodFields, String whereSql) {
        StringBuilder querySubManageSql = new StringBuilder();
        String lan = ctx.getLocale().getLanguage();
        querySubManageSql.append("select t.fid subBudgetManage, t.FBudgetMangeID budgetManage, item.fid budgetItem, item.fname_" + lan + " budgetItemName, item.FieldSn fieldSn");
        for (int i = 0; i < budgetPeriodFields.size(); ++i) {
            String field = budgetPeriodFields.get(i);
            String colName = budgetPeriodColNames.get(i);
            querySubManageSql.append(",t." + field + " " + colName);
        }
        querySubManageSql.append(" from T_HR_SSubBudgetManage t inner join t_hr_SCmpBudgetItem item on t.FCmpBudgetItemID = item.fid  ").append(whereSql);
        return querySubManageSql.toString();
    }

    public static String querySubBudgetManageSqlWithoutApprovingBill(Context ctx, Map<String, Object> subItemFieldSnMap, List<String> subItemIdList, List<String> budgetPeriodFields, List<String> budgetPeriodColNames, String whereSql) {
        StringBuilder querySubManageSql = new StringBuilder();
        String lan = ctx.getLocale().getLanguage();
        querySubManageSql.append("select t.fid subBudgetManage, t.FBudgetMangeID adjustYearBudget, manage.FAdminOrgUnitID adminOrgUnit, manage.FCostTypeID costType, entry.fid yearBudgetEntry, entry.FBillId billId, item.fid budgetItem, item.fname_" + lan + " budgetItemName, item.FieldSn fieldSn");
        for (String itemId : subItemIdList) {
            if (subItemFieldSnMap.get(itemId) == null || StringUtils.isEmpty((CharSequence)subItemFieldSnMap.get(itemId).toString())) continue;
            String fieldSn = subItemFieldSnMap.get(itemId).toString();
            querySubManageSql.append(",manage.T" + fieldSn + " T" + fieldSn);
        }
        for (int i = 0; i < budgetPeriodColNames.size(); ++i) {
            String field = budgetPeriodFields.get(i);
            String colName = budgetPeriodColNames.get(i);
            querySubManageSql.append(",t." + field + " " + colName);
        }
        querySubManageSql.append(" from T_HR_SSubBudgetManage t inner join T_HR_SBudgetManage manage on t.FBudgetMangeID = manage.fid inner join t_hr_SBudgetAdjustEntry entry on t.FBudgetMangeID = entry.FBudgetManageID  inner join t_hr_SCmpBudgetItem item on t.FCmpBudgetItemID = item.fid  where manage.fid not in (  SELECT manage2.fid id FROM T_HR_SBudgetManage manage2 inner join t_hr_sbudgetadjustentry entry on entry.FBudgetManageID = manage2.fid  inner join t_hr_sbudgetadjustbill bill on entry.FBillID = bill.fid  where bill.FBillState in (1,2)) ").append(whereSql);
        return querySubManageSql.toString();
    }

    public static String querySubManageSqlNotById(List<String> budgetPeriodFields, List<String> budgetPeriodColNames, String filterSql) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("SELECT submanage.fid subBudgetManage, subentry.fid entryId ");
        for (int i = 0; i < budgetPeriodFields.size(); ++i) {
            querySql.append(", submanage." + budgetPeriodFields.get(i)).append(" " + budgetPeriodColNames.get(i));
        }
        querySql.append(" FROM t_hr_SSubBudgetAdjustEntry subentry inner join t_hr_sbudgetadjustbill bill on subentry.fbillid = bill.fid inner join t_hr_sbudgetmanage manage on manage.FAdminOrgUnitID = subentry.FAdminOrgUnitID and manage.FCostTypeID=subentry.FCostTypeID and bill.FBudgetSchemeID=manage.FBudgetSchemeID inner join t_hr_ssubbudgetmanage submanage on manage.fid = submanage.FBudgetMangeID and subentry.FBudgetItemID = submanage.FCmpBudgetItemID  where 1=1 ").append(filterSql);
        return querySql.toString();
    }

    public static String querySubManageSql(List<String> budgetPeriodFields, List<String> budgetPeriodColNames, String filterSql) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select submanage.fid subBudgetManage, subentry.fid entryId ");
        for (int i = 0; i < budgetPeriodFields.size(); ++i) {
            querySql.append(", submanage." + budgetPeriodFields.get(i)).append(" " + budgetPeriodColNames.get(i));
        }
        querySql.append(" from t_hr_SSubBudgetAdjustEntry subentry inner join t_hr_SBudgetAdjustEntry entry on subentry.FYearBudgetEntryID = entry.fid inner join t_hr_ssubbudgetmanage submanage on submanage.fid = subentry.FSubBudgetManageID  where 1=1 ").append(filterSql);
        return querySql.toString();
    }

    public static String assembleInsertSubEntryHisSql(List<String> budgetPeriodFields) {
        StringBuilder insertSql = new StringBuilder();
        StringBuilder fieldsSql = new StringBuilder();
        StringBuilder valueSql = new StringBuilder();
        fieldsSql.append("FID,FSubBudgetManageID,FEntryID");
        valueSql.append("?, ?, ?");
        for (String field : budgetPeriodFields) {
            fieldsSql.append(", " + field);
            valueSql.append(", ?");
        }
        insertSql.append("insert t_hr_SSubBudgetAdjustEntryHis(").append((CharSequence)fieldsSql).append(") values(").append((CharSequence)valueSql).append(")");
        return insertSql.toString();
    }

    public static List<Object> assembleInsertSubEntryHisParams(IRowSet rs, List<String> budgetPeriodColNames) throws SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(BOSUuid.create((String)"258817C1").toString());
        params.add(rs.getString("subBudgetManage"));
        params.add(rs.getString("entryId"));
        for (String colName : budgetPeriodColNames) {
            params.add(BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal(colName)));
        }
        return params;
    }

    public static String queryBudgetAdjustEntrySql(Context ctx, List<String> fieldSnList, String whereSql) {
        StringBuilder queryFields = new StringBuilder();
        String lan = ctx.getLocale().getLanguage();
        queryFields.append("entry.FId id, entry.FBillId billId,entry.FBudgetManageId budgetManageId, entry.FAdminOrgUnitID adminOrgUnitId,entry.FCostTypeId costTypeId, entry.FbackupVersion backupVersion, entry.FSyncVersion syncVersion, entry.FDescription_L1 as description1, entry.FDescription_L2 description2, entry.FDescription_L3 description3");
        for (int i = 0; i < fieldSnList.size(); ++i) {
            queryFields.append(", entry.M" + fieldSnList.get(i));
            queryFields.append(", entry.T" + fieldSnList.get(i));
        }
        StringBuilder querySql = new StringBuilder();
        querySql.append("select ").append((CharSequence)queryFields).append(" FROM  t_hr_sbudgetadjustentry entry inner join T_ORG_Admin adminOrgUnit on adminOrgUnit.fid = entry.FAdminOrgUnitID inner join T_HR_CostType costType on costType.fid = entry.FCostTypeID ").append(whereSql);
        return querySql.toString();
    }

    public static String queryBudgetAdjustSubEntrySql(List<String> periodFields, List<String> periodColNames, String whereSql) {
        StringBuilder queryFields = new StringBuilder();
        queryFields.append("subentry.Fid id, subentry.FBillId billId, subentry.FAdminOrgUnitID adminOrgUnitId,subentry.FCostTypeId costTypeId, subentry.FBudgetItemID budgetItemId, subentry.FAdjustYearBudget adjustYearBudget,subentry.FSubBudgetManageId subBudgetManageId,subentry.FYearBudgetEntryID entryId, entry.FBudgetManageId budgetManageId");
        for (int i = 0; i < periodFields.size(); ++i) {
            queryFields.append(", subentry." + periodFields.get(i) + " " + periodColNames.get(i));
        }
        StringBuilder querySql = new StringBuilder();
        querySql.append("select ").append((CharSequence)queryFields).append(" from t_hr_SSubBudgetAdjustEntry subentry  inner join  t_hr_sbudgetadjustentry entry on subentry.FYearBudgetEntryId = entry.fid ");
        if (!StringUtils.isEmpty((CharSequence)whereSql)) {
            querySql.append(whereSql);
        }
        return querySql.toString();
    }

    public static String queryBudgetAdjustSubEntrySqlBySort(List<String> periodFields, List<String> periodColNames, String whereSql) {
        StringBuilder queryFields = new StringBuilder();
        queryFields.append("subentry.Fid id, subentry.FBillId billId, subentry.FAdminOrgUnitID adminOrgUnitId,subentry.FCostTypeId costTypeId, subentry.FBudgetItemID budgetItemId, subentry.FAdjustYearBudget adjustYearBudget,subentry.FSubBudgetManageId subBudgetManageId,subentry.FYearBudgetEntryID entryId, entry.FBudgetManageId budgetManageId");
        for (int i = 0; i < periodFields.size(); ++i) {
            queryFields.append(", subentry." + periodFields.get(i) + " " + periodColNames.get(i));
        }
        StringBuilder querySql = new StringBuilder();
        querySql.append("select ").append((CharSequence)queryFields).append(" from t_hr_SSubBudgetAdjustEntry subentry  inner join  t_hr_sbudgetadjustentry entry on subentry.FYearBudgetEntryId = entry.fid  inner join T_ORG_Admin adminOrgUnit on adminOrgUnit.fid = subentry.FAdminOrgUnitID  inner join T_HR_CostType costType on costType.fid = subentry.FCostTypeID  inner join T_HR_SBudgetTemplateItem itemset on subentry.FBudgetItemID=itemset.FBudgetItemID and itemset.FTemplateID in (select FTemplateID from T_HR_SCmpBudgetScheme where fid = ?) ");
        if (!StringUtils.isEmpty((CharSequence)whereSql)) {
            querySql.append(whereSql);
        }
        return querySql.toString();
    }

    public static String queryBudgetAdjustSubEntryHisSql(List<String> periodFields, List<String> periodColNames, String whereSql) {
        StringBuilder queryFields = new StringBuilder();
        queryFields.append("subentry.Fid id, subentry.FBillId billId, subentry.FAdminOrgUnitID adminOrgUnitId,subentry.FCostTypeId costTypeId, subentry.FBudgetItemID budgetItemId, subentry.FAdjustYearBudget adjustYearBudget,subentryhis.FSubBudgetManageId subBudgetManageId,subentry.FYearBudgetEntryID yearBudgetEntry, entry.FBudgetManageId budgetManageId");
        for (int i = 0; i < periodFields.size(); ++i) {
            queryFields.append(", subentryhis." + periodFields.get(i) + " " + periodColNames.get(i));
        }
        StringBuilder querySql = new StringBuilder();
        querySql.append("select ").append((CharSequence)queryFields).append(" from t_hr_SSubBudgetAdjustEntryHis subentryhis inner join t_hr_SSubBudgetAdjustEntry subentry on subentryhis.FEntryId = subentry.fid inner join  t_hr_sbudgetadjustentry entry on subentry.FYearBudgetEntryId = entry.fid  ").append(whereSql);
        return querySql.toString();
    }

    public static String assembleInsertEntrySql(List<String> budgetItemFields) {
        StringBuilder insertSql = new StringBuilder();
        StringBuilder fieldsSql = new StringBuilder();
        StringBuilder valueSql = new StringBuilder();
        fieldsSql.append("Fid, FBillId, ForwarnContent, FAdminOrgUnitId, FCostTypeId, FBackupVersion, FSyncVersion, FBudgetManageID, FDescription_l1, FDescription_l2,FDescription_l3");
        valueSql.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?");
        for (String field : budgetItemFields) {
            fieldsSql.append(", " + field);
            valueSql.append(", ?");
        }
        insertSql.append("insert T_HR_SBudgetAdjustEntry(").append((CharSequence)fieldsSql).append(") values(").append((CharSequence)valueSql).append(")");
        return insertSql.toString();
    }

    public static List<Object> assembleInsertEntryParam(String billId, BudgetAdjustEntryInfo entry, List<String> budgetItemFields) {
        ArrayList<Object> params = new ArrayList<Object>();
        BOSUuid entryId = BOSUuid.create((BOSObjectType)entry.getBOSType());
        entry.setId(entryId);
        params.add(entryId.toString());
        params.add(billId);
        params.add(entry.getForwarnContent());
        params.add(entry.getAdminOrgUnit() == null ? null : entry.getAdminOrgUnit().getId().toString());
        params.add(entry.getCostType() == null ? null : entry.getCostType().getId().toString());
        if (entry.get("backupVersion") == null) {
            params.add(-1);
            params.add(0);
        } else {
            params.add(entry.getBackupVersion());
            params.add(entry.getSyncVersion());
        }
        params.add(entry.getBudgetManage() == null ? BOSUuid.create((String)"84812771").toString() : entry.getBudgetManage().getId().toString());
        params.add(entry.getDescription(LocaleUtils.locale_l1));
        params.add(entry.getDescription(LocaleUtils.locale_l2));
        params.add(entry.getDescription(LocaleUtils.locale_l3));
        for (String field : budgetItemFields) {
            params.add(entry.get(field));
        }
        return params;
    }

    public static String assembleUpdateEntrySql(List<String> budgetItemFields) {
        StringBuilder updateSql = new StringBuilder();
        StringBuilder fieldsSql = new StringBuilder();
        fieldsSql.append("FAdminOrgUnitID=?, FCostTypeID=?, FBackupVersion=?, FSyncVersion=?, FBudgetManageId=?, FDescription_l1=?, FDescription_l2=?, FDescription_l3=?");
        for (String field : budgetItemFields) {
            fieldsSql.append(", " + field).append("=?");
        }
        updateSql.append("update T_HR_SBudgetAdjustEntry set ").append((CharSequence)fieldsSql).append(" where fid=?");
        return updateSql.toString();
    }

    public static String assembleUpdateEntrySqlFromManage(List<String> budgetItemFields) {
        StringBuilder updateSql = new StringBuilder();
        StringBuilder fieldsSql = new StringBuilder();
        fieldsSql.append("FBackupVersion=?, FSyncVersion=?, FBudgetManageId=?, FDescription_l1=?, FDescription_l2=?, FDescription_l3=?");
        for (String field : budgetItemFields) {
            fieldsSql.append(", " + field).append("=?");
        }
        updateSql.append("update T_HR_SBudgetAdjustEntry set ").append((CharSequence)fieldsSql).append(" where fid=?");
        return updateSql.toString();
    }

    public static List<Object> assembleUpdateEntryParam(String billId, BudgetAdjustEntryInfo entry, List<String> budgetItemFields) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(entry.getAdminOrgUnit() == null ? null : entry.getAdminOrgUnit().getId().toString());
        params.add(entry.getCostType() == null ? null : entry.getCostType().getId().toString());
        params.add(entry.getBackupVersion());
        params.add(entry.getSyncVersion());
        params.add(entry.getBudgetManage() == null ? BOSUuid.create((String)"84812771").toString() : entry.getBudgetManage().getId().toString());
        params.add(entry.getDescription(LocaleUtils.locale_l1));
        params.add(entry.getDescription(LocaleUtils.locale_l2));
        params.add(entry.getDescription(LocaleUtils.locale_l3));
        for (String field : budgetItemFields) {
            params.add(entry.get(field));
        }
        params.add(entry.getId().toString());
        return params;
    }

    public static List<Object> assembleUpdateEntryParamFromManage(String billId, BudgetAdjustEntryInfo entry, List<String> budgetItemFields) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(entry.getBackupVersion());
        params.add(entry.getSyncVersion());
        params.add(entry.getBudgetManage() == null ? null : entry.getBudgetManage().getId().toString());
        params.add(entry.getDescription(LocaleUtils.locale_l1));
        params.add(entry.getDescription(LocaleUtils.locale_l2));
        params.add(entry.getDescription(LocaleUtils.locale_l3));
        for (String field : budgetItemFields) {
            params.add(entry.get(field));
        }
        params.add(entry.getId().toString());
        return params;
    }

    public static List<Object> assembleUpdateSubEntryParam(SubBudgetAdjustEntryInfo entry, List<String> budgetPeriodColNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(entry.getAdminOrgUnit() == null ? null : entry.getAdminOrgUnit().getId().toString());
        params.add(entry.getCostType() == null ? null : entry.getCostType().getId().toString());
        params.add(entry.getAdjustYearBudget());
        params.add(entry.getSubBudgetManage() == null ? null : entry.getSubBudgetManage().getId().toString());
        for (String colNames : budgetPeriodColNames) {
            params.add(entry.get(colNames));
        }
        params.add(entry.getId().toString());
        return params;
    }

    public static List<Object> assembleUpdateSubEntryParamFromSubManage(SubBudgetAdjustEntryInfo entry, List<String> budgetPeriodColNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(entry.getSubBudgetManage() == null ? null : entry.getSubBudgetManage().getId().toString());
        for (String colNames : budgetPeriodColNames) {
            params.add(entry.get(colNames));
        }
        params.add(entry.getId().toString());
        return params;
    }

    public static String assembleInsertSubEntrySql(List<String> budgetPeriodFields) {
        StringBuilder insertSql = new StringBuilder();
        StringBuilder fieldsSql = new StringBuilder();
        StringBuilder valueSql = new StringBuilder();
        fieldsSql.append("Fid, FBillId, FAdminOrgUnitId, FCostTypeId, FBudgetItemID, FAdjustYearBudget, FSubBudgetManageID, FYearBudgetEntryID");
        valueSql.append("?,?,?,?,?,?,?,?");
        for (String field : budgetPeriodFields) {
            fieldsSql.append(", " + field);
            valueSql.append(", ?");
        }
        insertSql.append("insert T_HR_SSubBudgetAdjustEntry(").append((CharSequence)fieldsSql).append(") values (").append((CharSequence)valueSql).append(")");
        return insertSql.toString();
    }

    public static String assembleUpdateSubEntrySql(List<String> budgetPeriodFields) {
        StringBuilder updateSql = new StringBuilder();
        StringBuilder fieldsSql = new StringBuilder();
        fieldsSql.append("FAdminOrgUnitId=?,FCostTypeId=?,FAdjustYearBudget=?,FSubBudgetManageId=?");
        for (String field : budgetPeriodFields) {
            fieldsSql.append(", " + field).append("=?");
        }
        updateSql.append("update T_HR_SSubBudgetAdjustEntry set ").append((CharSequence)fieldsSql).append(" where fid=?");
        return updateSql.toString();
    }

    public static String assembleUpdateSubEntrySqlFromSubManage(List<String> budgetPeriodFields) {
        StringBuilder updateSql = new StringBuilder();
        StringBuilder fieldsSql = new StringBuilder();
        fieldsSql.append("FSubBudgetManageId=?");
        for (String field : budgetPeriodFields) {
            fieldsSql.append(", " + field).append("=?");
        }
        updateSql.append("update T_HR_SSubBudgetAdjustEntry set ").append((CharSequence)fieldsSql).append(" where fid=?");
        return updateSql.toString();
    }

    public static List<Object> assembleInsertSubEntryParam(String billId, SubBudgetAdjustEntryInfo entry, Map<String, Object> newEntryIdMap, List<String> budgetPeriodColNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(BOSUuid.create((BOSObjectType)entry.getBOSType()).toString());
        params.add(billId);
        params.add(entry.getAdminOrgUnit() == null ? null : entry.getAdminOrgUnit().getId().toString());
        params.add(entry.getCostType() == null ? null : entry.getCostType().getId().toString());
        params.add(entry.get("budgetItem.id") == null ? null : entry.get("budgetItem.id").toString());
        params.add(entry.getAdjustYearBudget());
        params.add(entry.getSubBudgetManage() == null ? BOSUuid.create((String)"82CD7FA3").toString() : entry.getSubBudgetManage().getId().toString());
        if (entry.getAdminOrgUnit() != null && entry.getCostType() != null) {
            Object entryIdObj = newEntryIdMap.get(entry.getAdminOrgUnit().getId().toString() + "_" + entry.getCostType().getId().toString());
            params.add(entryIdObj);
        } else {
            params.add(null);
        }
        for (String colName : budgetPeriodColNames) {
            params.add(entry.get(colName));
        }
        return params;
    }

    public static List<Object> assembleInsertSubEntryParam(String billId, SubBudgetAdjustEntryInfo entry, List<String> budgetPeriodColNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(BOSUuid.create((BOSObjectType)entry.getBOSType()).toString());
        params.add(billId);
        params.add(entry.getAdminOrgUnit() == null ? null : entry.getAdminOrgUnit().getId().toString());
        params.add(entry.getCostType() == null ? null : entry.getCostType().getId().toString());
        params.add(entry.getBudgetItem() == null ? null : entry.getBudgetItem().getId().toString());
        params.add(entry.getAdjustYearBudget());
        params.add(entry.getSubBudgetManage() == null ? null : entry.getSubBudgetManage().getId().toString());
        params.add(entry.getYearBudgetEntry() == null ? null : entry.getYearBudgetEntry().getId().toString());
        for (String colName : budgetPeriodColNames) {
            params.add(entry.get(colName));
        }
        return params;
    }

    public static BigDecimal handleZero(BigDecimal value) {
        if (value != null && BigDecimal.ZERO.compareTo(value) == 0) {
            value = BigDecimal.ZERO;
        }
        return value;
    }

    public static BudgetAdjustEntryCollection assembleEntryCol(List<String> budgetItemFields, IRowSet rs, Map<String, Integer> itemColDataTypeMap) throws SQLException {
        BudgetAdjustEntryCollection col = new BudgetAdjustEntryCollection();
        while (rs.next()) {
            BudgetManageInfo manageInfo;
            BudgetAdjustEntryInfo info = new BudgetAdjustEntryInfo();
            info.setId(BOSUuid.read((String)rs.getString("entryId")));
            int dataVersion = -1;
            if (rs.getObject("dataVersion") != null) {
                dataVersion = rs.getInt("dataVersion");
            }
            info.setBackupVersion(dataVersion);
            info.setSyncVersion(dataVersion + 1);
            String budgetManageId = rs.getString("budgetManage");
            if (!StringUtils.isEmpty((CharSequence)budgetManageId)) {
                manageInfo = new BudgetManageInfo();
                manageInfo.setId(BOSUuid.read((String)budgetManageId));
                info.setBudgetManage(manageInfo);
            } else {
                manageInfo = new BudgetManageInfo();
                manageInfo.setId(BOSUuid.create((String)"84812771"));
                info.setBudgetManage(manageInfo);
            }
            info.setDescription(rs.getString("description_l1"), LocaleUtils.locale_l1);
            info.setDescription(rs.getString("description_l2"), LocaleUtils.locale_l2);
            info.setDescription(rs.getString("description_l3"), LocaleUtils.locale_l3);
            for (String field : budgetItemFields) {
                if (0 == itemColDataTypeMap.get(field)) {
                    info.put(field, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal(field)));
                    continue;
                }
                info.put(field, rs.getString(field));
            }
            col.add(info);
        }
        return col;
    }

    public static SubBudgetAdjustEntryCollection assembleSubEntryCol(List<String> budgetPeriodColNames, IRowSet rs) throws SQLException {
        SubBudgetAdjustEntryCollection col = new SubBudgetAdjustEntryCollection();
        while (rs.next()) {
            SubBudgetAdjustEntryInfo info = new SubBudgetAdjustEntryInfo();
            info.setId(BOSUuid.read((String)rs.getString("entryId")));
            SubBudgetManageInfo manageInfo = new SubBudgetManageInfo();
            manageInfo.setId(BOSUuid.read((String)rs.getString("subBudgetManage")));
            info.setSubBudgetManage(manageInfo);
            for (String colName : budgetPeriodColNames) {
                info.put(colName, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal(colName)));
            }
            col.add(info);
        }
        return col;
    }

    public static SubBudgetAdjustEntryCollection assembleSubEntryColBySubManage(List<String> budgetPeriodColNames, Map<String, Object> subItemFieldSnMap, IRowSet rs) throws SQLException {
        SubBudgetAdjustEntryCollection col = new SubBudgetAdjustEntryCollection();
        while (rs.next()) {
            SubBudgetAdjustEntryInfo info = new SubBudgetAdjustEntryInfo();
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("adminOrgUnitId")));
            info.setAdminOrgUnit(adminOrgUnitInfo);
            CostTypeInfo costTypeInfo = new CostTypeInfo();
            costTypeInfo.setId(BOSUuid.read((String)rs.getString("costTypeId")));
            info.setCostType(costTypeInfo);
            CmpBudgetItemInfo itemInfo = new CmpBudgetItemInfo();
            String itemId = rs.getString("budgetItemId");
            itemInfo.setId(BOSUuid.read((String)itemId));
            info.setBudgetItem(itemInfo);
            if (subItemFieldSnMap.get(itemId) != null) {
                String colName = "T" + subItemFieldSnMap.get(itemId).toString();
                info.setAdjustYearBudget(rs.getBigDecimal(colName));
            }
            SubBudgetManageInfo manageInfo = new SubBudgetManageInfo();
            manageInfo.setId(BOSUuid.read((String)rs.getString("subBudgetManageId")));
            info.setSubBudgetManage(manageInfo);
            for (String colName : budgetPeriodColNames) {
                info.put(colName, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal(colName)));
            }
            col.add(info);
        }
        return col;
    }

    public static BudgetAdjustEntryCollection assembleNewEntryCol(List<String> budgetItemFieldSn, IRowSet rs, Map<String, Integer> itemDataTypeMap) throws SQLException {
        BudgetAdjustEntryCollection col = new BudgetAdjustEntryCollection();
        while (rs.next()) {
            BudgetAdjustEntryInfo info = new BudgetAdjustEntryInfo();
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("adminOrgUnit")));
            info.setAdminOrgUnit(adminOrgUnitInfo);
            CostTypeInfo costTypeInfo = new CostTypeInfo();
            costTypeInfo.setId(BOSUuid.read((String)rs.getString("costType")));
            info.setCostType(costTypeInfo);
            int dataVersion = rs.getInt("dataVersion");
            info.setBackupVersion(dataVersion);
            info.setSyncVersion(dataVersion + 1);
            BudgetManageInfo manageInfo = new BudgetManageInfo();
            manageInfo.setId(BOSUuid.read((String)rs.getString("budgetManage")));
            info.setBudgetManage(manageInfo);
            info.setDescription(rs.getString("description_l1"), LocaleUtils.locale_l1);
            info.setDescription(rs.getString("description_l2"), LocaleUtils.locale_l2);
            info.setDescription(rs.getString("description_l3"), LocaleUtils.locale_l3);
            for (String fieldSn : budgetItemFieldSn) {
                if (itemDataTypeMap.get(fieldSn) != null && 0 == itemDataTypeMap.get(fieldSn)) {
                    info.put("T" + fieldSn, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal("T" + fieldSn)));
                    info.put("M" + fieldSn, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal("T" + fieldSn)));
                    continue;
                }
                info.put("T" + fieldSn, rs.getString("T" + fieldSn));
                info.put("M" + fieldSn, rs.getString("T" + fieldSn));
            }
            col.add(info);
        }
        return col;
    }

    public static SubBudgetAdjustEntryCollection assembleNewSubEntryCol(List<String> budgetPeriodColNames, Map<String, Object> subItemFieldSnMap, IRowSet rs) throws SQLException {
        SubBudgetAdjustEntryCollection col = new SubBudgetAdjustEntryCollection();
        while (rs.next()) {
            SubBudgetAdjustEntryInfo info = new SubBudgetAdjustEntryInfo();
            BudgetAdjustBillInfo billInfo = new BudgetAdjustBillInfo();
            billInfo.setId(BOSUuid.read((String)rs.getString("billId")));
            info.setBill(billInfo);
            AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)rs.getString("adminOrgUnit")));
            info.setAdminOrgUnit(orgInfo);
            CostTypeInfo costTypeInfo = new CostTypeInfo();
            costTypeInfo.setId(BOSUuid.read((String)rs.getString("costType")));
            info.setCostType(costTypeInfo);
            CmpBudgetItemInfo itemInfo = new CmpBudgetItemInfo();
            String itemId = rs.getString("budgetItem");
            itemInfo.setId(BOSUuid.read((String)itemId));
            info.setBudgetItem(itemInfo);
            if (subItemFieldSnMap.get(itemId) != null) {
                String fieldSn = subItemFieldSnMap.get(itemId).toString();
                info.setAdjustYearBudget(BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal("T" + fieldSn)));
            }
            SubBudgetManageInfo manageInfo = new SubBudgetManageInfo();
            manageInfo.setId(BOSUuid.read((String)rs.getString("subBudgetManage")));
            info.setSubBudgetManage(manageInfo);
            BudgetAdjustEntryInfo entryInfo = new BudgetAdjustEntryInfo();
            entryInfo.setId(BOSUuid.read((String)rs.getString("yearBudgetEntry")));
            info.setYearBudgetEntry(entryInfo);
            for (String colName : budgetPeriodColNames) {
                info.put(colName, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal(colName)));
            }
            col.add(info);
        }
        return col;
    }

    public static BudgetAdjustEntryCollection assembleNewEntryColByBillId(Context ctx, List<String> budgetItemFieldSn, IRowSet rs, Map<String, Integer> itemDataTypeMap) throws SQLException {
        BudgetAdjustEntryCollection col = new BudgetAdjustEntryCollection();
        while (rs.next()) {
            BudgetAdjustEntryInfo info = new BudgetAdjustEntryInfo();
            info.setId(BOSUuid.read((String)rs.getString("id")));
            String adminOrgUnitId = rs.getString("adminOrgUnitId");
            String costTypeId = rs.getString("costTypeId");
            if (StringUtils.isEmpty((CharSequence)adminOrgUnitId) || StringUtils.isEmpty((CharSequence)costTypeId)) continue;
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)adminOrgUnitId));
            info.setAdminOrgUnit(adminOrgUnitInfo);
            CostTypeInfo costTypeInfo = new CostTypeInfo();
            costTypeInfo.setId(BOSUuid.read((String)costTypeId));
            info.setCostType(costTypeInfo);
            info.setBackupVersion(rs.getInt("backupVersion"));
            info.setSyncVersion(rs.getInt("syncVersion"));
            String budgetManageId = rs.getString("budgetManageId");
            if (!StringUtils.isEmpty((CharSequence)budgetManageId)) {
                BudgetManageInfo manageInfo = new BudgetManageInfo();
                manageInfo.setId(BOSUuid.read((String)budgetManageId));
                info.setBudgetManage(manageInfo);
            }
            info.setDescription(rs.getString("description1"), LocaleUtils.locale_l1);
            info.setDescription(rs.getString("description2"), LocaleUtils.locale_l2);
            info.setDescription(rs.getString("description3"), LocaleUtils.locale_l3);
            for (String fieldSn : budgetItemFieldSn) {
                if (itemDataTypeMap.get(fieldSn) != null && 0 == itemDataTypeMap.get(fieldSn)) {
                    info.put("T" + fieldSn, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal("T" + fieldSn)));
                    info.put("M" + fieldSn, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal("M" + fieldSn)));
                    continue;
                }
                info.put("T" + fieldSn, rs.getString("T" + fieldSn));
                info.put("M" + fieldSn, rs.getString("M" + fieldSn));
            }
            col.add(info);
        }
        return col;
    }

    public static SubBudgetAdjustEntryCollection assembleSubEntryColByBill(List<String> budgetPeriodColNames, IRowSet rs) throws SQLException {
        SubBudgetAdjustEntryCollection col = new SubBudgetAdjustEntryCollection();
        while (rs.next()) {
            SubBudgetAdjustEntryInfo info = new SubBudgetAdjustEntryInfo();
            info.setId(BOSUuid.read((String)rs.getString("id")));
            BudgetAdjustBillInfo billInfo = new BudgetAdjustBillInfo();
            billInfo.setId(BOSUuid.read((String)rs.getString("billId")));
            info.setBill(billInfo);
            AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)rs.getString("adminOrgUnitId")));
            info.setAdminOrgUnit(orgInfo);
            CostTypeInfo costTypeInfo = new CostTypeInfo();
            costTypeInfo.setId(BOSUuid.read((String)rs.getString("costTypeId")));
            info.setCostType(costTypeInfo);
            CmpBudgetItemInfo itemInfo = new CmpBudgetItemInfo();
            String itemId = rs.getString("budgetItemId");
            itemInfo.setId(BOSUuid.read((String)itemId));
            info.setBudgetItem(itemInfo);
            info.setAdjustYearBudget(BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal("adjustYearBudget")));
            String subBudgetManageId = rs.getString("subBudgetManageId");
            if (!StringUtils.isEmpty((CharSequence)subBudgetManageId)) {
                SubBudgetManageInfo manageInfo = new SubBudgetManageInfo();
                manageInfo.setId(BOSUuid.read((String)rs.getString("subBudgetManageId")));
                info.setSubBudgetManage(manageInfo);
            }
            BudgetAdjustEntryInfo entryInfo = new BudgetAdjustEntryInfo();
            entryInfo.setId(BOSUuid.read((String)rs.getString("entryId")));
            info.setYearBudgetEntry(entryInfo);
            info.put("budgetManageId", rs.getString("budgetManageId"));
            for (String colName : budgetPeriodColNames) {
                info.put(colName, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal(colName)));
            }
            col.add(info);
        }
        return col;
    }

    public static BudgetAdjustEntryCollection assembleEntryColByManage(Context ctx, List<String> budgetItemFieldSn, IRowSet rs, Map<String, Integer> itemDataTypeMap) throws SQLException {
        BudgetAdjustEntryCollection col = new BudgetAdjustEntryCollection();
        while (rs.next()) {
            BudgetAdjustEntryInfo info = new BudgetAdjustEntryInfo();
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("adminOrgUnitId")));
            info.setAdminOrgUnit(adminOrgUnitInfo);
            CostTypeInfo costTypeInfo = new CostTypeInfo();
            costTypeInfo.setId(BOSUuid.read((String)rs.getString("costTypeId")));
            info.setCostType(costTypeInfo);
            int dataVersion = rs.getInt("dataVersion");
            info.setBackupVersion(dataVersion);
            info.setSyncVersion(dataVersion + 1);
            BudgetManageInfo manageInfo = new BudgetManageInfo();
            manageInfo.setId(BOSUuid.read((String)rs.getString("budgetManageId")));
            info.setBudgetManage(manageInfo);
            Locale locale = ctx.getLocale();
            info.setDescription(rs.getString("description"), locale);
            info.put("state", rs.getInt("state"));
            for (String fieldSn : budgetItemFieldSn) {
                if (itemDataTypeMap.get(fieldSn) != null && 0 == itemDataTypeMap.get(fieldSn)) {
                    info.put("T" + fieldSn, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal("T" + fieldSn)));
                    info.put("M" + fieldSn, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal("T" + fieldSn)));
                    continue;
                }
                info.put("T" + fieldSn, rs.getString("T" + fieldSn));
                info.put("M" + fieldSn, rs.getString("T" + fieldSn));
            }
            col.add(info);
        }
        return col;
    }

    public static SubBudgetAdjustEntryCollection assembleNewSubEntryColByBillId(List<String> budgetPeriodColNames, IRowSet rs) throws SQLException {
        SubBudgetAdjustEntryCollection col = new SubBudgetAdjustEntryCollection();
        while (rs.next()) {
            String yearBudgetEntry;
            SubBudgetAdjustEntryInfo info = new SubBudgetAdjustEntryInfo();
            info.setId(BOSUuid.read((String)rs.getString("id")));
            BudgetAdjustBillInfo billInfo = new BudgetAdjustBillInfo();
            billInfo.setId(BOSUuid.read((String)rs.getString("billId")));
            info.setBill(billInfo);
            AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)rs.getString("adminOrgUnitId")));
            info.setAdminOrgUnit(orgInfo);
            CostTypeInfo costTypeInfo = new CostTypeInfo();
            costTypeInfo.setId(BOSUuid.read((String)rs.getString("costTypeId")));
            info.setCostType(costTypeInfo);
            CmpBudgetItemInfo itemInfo = new CmpBudgetItemInfo();
            String itemId = rs.getString("budgetItemId");
            itemInfo.setId(BOSUuid.read((String)itemId));
            info.setBudgetItem(itemInfo);
            String subBudgetManageId = rs.getString("subBudgetManageId");
            if (!StringUtils.isEmpty((CharSequence)subBudgetManageId)) {
                SubBudgetManageInfo manageInfo = new SubBudgetManageInfo();
                manageInfo.setId(BOSUuid.read((String)subBudgetManageId));
                info.setSubBudgetManage(manageInfo);
            }
            if (!StringUtils.isEmpty((CharSequence)(yearBudgetEntry = rs.getString("yearBudgetEntry")))) {
                BudgetAdjustEntryInfo entryInfo = new BudgetAdjustEntryInfo();
                entryInfo.setId(BOSUuid.read((String)rs.getString("yearBudgetEntry")));
                info.setYearBudgetEntry(entryInfo);
            }
            info.setAdjustYearBudget(rs.getBigDecimal("adjustYearBudget"));
            for (String colName : budgetPeriodColNames) {
                info.put(colName, BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal(colName)));
            }
            col.add(info);
        }
        return col;
    }

    public static BudgetAdjustEntryCollection queryAndAssembleEntryColByBill(Context ctx, String billId, List<String> budgetItemFieldSn, Map<String, Integer> itemDataTypeMap) throws BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)billId) || budgetItemFieldSn == null || budgetItemFieldSn.isEmpty() || itemDataTypeMap == null) {
            return null;
        }
        String queryEntrySql = BudgetAdjustSqlUtils.queryBudgetAdjustEntrySql(ctx, budgetItemFieldSn, "where entry.FBillId = ? order by adminOrgUnit.FNumber asc, costType.FNumber asc");
        IRowSet entryRs = DbUtil.executeQuery((Context)ctx, (String)queryEntrySql, (Object[])new Object[]{billId});
        BudgetAdjustEntryCollection entryCol = BudgetAdjustSqlUtils.assembleNewEntryColByBillId(ctx, budgetItemFieldSn, entryRs, itemDataTypeMap);
        return entryCol;
    }

    public static SubBudgetAdjustEntryCollection queryAndAssembleSubEntryColByBill(Context ctx, String billId, List<String> periodColNames, List<String> periodFields, String whereSql) throws BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)billId) || periodColNames == null || periodColNames.isEmpty() || periodFields == null || periodFields.isEmpty()) {
            return null;
        }
        String querySubEntrySql = BudgetAdjustSqlUtils.queryBudgetAdjustSubEntrySql(periodFields, periodColNames, whereSql);
        IRowSet entryRs = DbUtil.executeQuery((Context)ctx, (String)querySubEntrySql, (Object[])new Object[]{billId});
        SubBudgetAdjustEntryCollection subEntryCol = BudgetAdjustSqlUtils.assembleSubEntryColByBill(periodColNames, entryRs);
        return subEntryCol;
    }

    public static SubBudgetAdjustEntryCollection queryAndAssembleSubEntryColByBillSort(Context ctx, String billId, String budgetSchemeId, List<String> periodColNames, List<String> periodFields, String whereSql) throws BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)billId) || periodColNames == null || periodColNames.isEmpty() || periodFields == null || periodFields.isEmpty()) {
            return null;
        }
        String querySubEntrySql = BudgetAdjustSqlUtils.queryBudgetAdjustSubEntrySqlBySort(periodFields, periodColNames, whereSql);
        IRowSet entryRs = DbUtil.executeQuery((Context)ctx, (String)querySubEntrySql, (Object[])new Object[]{budgetSchemeId, billId});
        SubBudgetAdjustEntryCollection subEntryCol = BudgetAdjustSqlUtils.assembleSubEntryColByBill(periodColNames, entryRs);
        return subEntryCol;
    }

    public static SubBudgetAdjustEntryCollection assembleSubEntryColByManageContainTemp(Context ctx, String tempTable, String budgetSchemeId, List<String> periodColNames, List<String> periodFields, List<String> fieldSnList, Map<String, Object> subItemFieldSnMap) throws BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)tempTable) || StringUtils.isEmpty((CharSequence)budgetSchemeId) || periodColNames == null || periodColNames.isEmpty() || periodFields == null || periodFields.isEmpty() || fieldSnList == null || fieldSnList.isEmpty()) {
            return null;
        }
        String querySubEntrySql = BudgetAdjustSqlUtils.queryBudgetAdjustSubEntryByManageSqlContainTemp(ctx, periodColNames, periodFields, fieldSnList, tempTable, "where manage1.FBudgetSchemeID = ?");
        IRowSet entryRs = DbUtil.executeQuery((Context)ctx, (String)querySubEntrySql, (Object[])new Object[]{budgetSchemeId});
        SubBudgetAdjustEntryCollection subEntryCol = BudgetAdjustSqlUtils.assembleSubEntryColBySubManage(periodColNames, subItemFieldSnMap, entryRs);
        return subEntryCol;
    }

    public static String queryBudgetAdjustSubEntryByManageSqlContainTemp(Context ctx, List<String> periodColNames, List<String> periodFields, List<String> fieldSnList, String tempTable, String whereSql) {
        StringBuilder queryFields = new StringBuilder();
        queryFields.append("temp1.FAdminOrgUnitID adminOrgUnitId, temp1.FCostTypeID costTypeId, temp1.FBudgetItemID budgetItemId, submanage.FId subBudgetManageId");
        for (int i = 0; i < periodColNames.size(); ++i) {
            queryFields.append(", submanage." + periodFields.get(i) + " " + periodColNames.get(i) + " ");
        }
        for (String fieldSn : fieldSnList) {
            queryFields.append(", manage1.T" + fieldSn);
        }
        StringBuilder querySql = new StringBuilder();
        querySql.append("select ").append((CharSequence)queryFields).append(" FROM ").append(tempTable).append(" temp1  left join t_hr_sbudgetmanage manage1 on temp1.FAdminOrgUnitID = manage1.FAdminOrgUnitID and temp1.FCostTypeID=manage1.FCostTypeID  left join t_hr_ssubbudgetmanage submanage on submanage.FBudgetMangeID = manage1.fid and submanage.FCmpBudgetItemID=temp1.FBudgetItemID ").append(whereSql);
        return querySql.toString();
    }

    public static String queryBudgetAdjustSubEntrySqlContainTemp(Context ctx, List<String> periodColNames, List<String> periodFields, String tempTable, String whereSql) {
        StringBuilder queryFields = new StringBuilder();
        queryFields.append("temp1.FAdminOrgUnitID adminOrgUnitId, temp1.FCostTypeID costTypeId, temp1.FBudgetItemID budgetItemId, subentry.FSubBudgetManageID subBudgetManageId");
        for (int i = 0; i < periodColNames.size(); ++i) {
            queryFields.append(", subentry." + periodFields.get(i) + " " + periodColNames.get(i) + " ");
        }
        StringBuilder querySql = new StringBuilder();
        querySql.append("select ").append((CharSequence)queryFields).append(" FROM ").append(tempTable).append(" temp1  left join t_hr_ssubbudgetadjustentry subentry on subentry.FCostTypeID = temp1.FCostTypeID and subentry.FAdminOrgUnitID = temp1.FAdminOrgUnitID and subentry.FBudgetItemID=temp1.FBudgetItemID ").append(whereSql);
        return querySql.toString();
    }

    public static BudgetAdjustEntryCollection assembleEntryColByManageDataContainTemp(Context ctx, String tempTable, String budgetSchemeId, List<String> budgetItemFieldSn, Map<String, Integer> itemDataTypeMap) throws BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)tempTable) || budgetItemFieldSn == null || budgetItemFieldSn.isEmpty() || itemDataTypeMap == null) {
            return null;
        }
        String queryEntrySql = BudgetAdjustSqlUtils.queryBudgetManageSqlContainTemp(ctx, budgetItemFieldSn, tempTable, "where manage1.FBudgetSchemeID = ?  ");
        IRowSet entryRs = DbUtil.executeQuery((Context)ctx, (String)queryEntrySql, (Object[])new Object[]{budgetSchemeId});
        BudgetAdjustEntryCollection entryCol = BudgetAdjustSqlUtils.assembleEntryColByManage(ctx, budgetItemFieldSn, entryRs, itemDataTypeMap);
        return entryCol;
    }

    public static String queryBudgetAdjustEntrySqlContainTemp(Context ctx, List<String> fieldSnList, String tempTable, String whereSql) {
        StringBuilder queryFields = new StringBuilder();
        String lan = ctx.getLocale().getLanguage();
        queryFields.append("entry1.FId id, entry1.FBillId billId,entry1.FBudgetManageId budgetManageId, temp1.FAdminOrgUnitID adminOrgUnitId,temp1.FCostTypeID costTypeId, entry1.FbackupVersion backupVersion, entry1.FSyncVersion syncVersion, entry1.FDescription_" + lan + " description");
        for (int i = 0; i < fieldSnList.size(); ++i) {
            queryFields.append(", entry1.M" + fieldSnList.get(i));
            queryFields.append(", entry1.T" + fieldSnList.get(i));
        }
        StringBuilder querySql = new StringBuilder();
        querySql.append("select ").append((CharSequence)queryFields).append(" FROM ").append(tempTable).append(" temp1  left join t_hr_sbudgetadjustentry entry1  on entry1.FAdminOrgUnitID = temp1.FAdminOrgUnitID and entry1.FCostTypeID = temp1.FCostTypeID ").append(whereSql);
        return querySql.toString();
    }

    public static String queryBudgetManageSqlContainTemp(Context ctx, List<String> fieldSnList, String tempTable, String whereSql) {
        StringBuilder queryFields = new StringBuilder();
        String lan = ctx.getLocale().getLanguage();
        queryFields.append("temp1.FAdminOrgUnitID adminOrgUnitId,temp1.FCostTypeID costTypeId,manage1.FId budgetManageId, manage1.FDataVersion dataVersion, manage1.FState state,  manage1.FRemark_" + lan + " description");
        for (int i = 0; i < fieldSnList.size(); ++i) {
            queryFields.append(", manage1.T" + fieldSnList.get(i));
        }
        StringBuilder querySql = new StringBuilder();
        querySql.append("select ").append((CharSequence)queryFields).append(" FROM ").append(tempTable).append(" temp1   left join T_HR_SBudgetManage manage1 on temp1.FAdminOrgUnitID = manage1.FAdminOrgUnitID and temp1.FCostTypeID = manage1.FCostTypeID ").append(whereSql);
        return querySql.toString();
    }

    public static String createTempTable(Context ctx, String table, String fields, List<Object[]> batchInserTempParam) throws BOSException {
        String tempTable = SQLHandleUtil.createTempTableName(ctx);
        String createTempTableSql = "SELECT  " + fields + " into " + tempTable + " FROM " + table + " where 1<>1";
        DbUtil.execute((Context)ctx, (String)createTempTableSql);
        String[] fieldArr = fields.split(",");
        StringBuilder valueSql = new StringBuilder();
        for (int i = 0; i < fieldArr.length; ++i) {
            valueSql.append("?,");
        }
        valueSql = valueSql.deleteCharAt(valueSql.lastIndexOf(","));
        String insertSql = "INSERT INTO " + tempTable + "(" + fields + ") VALUES(" + valueSql + ")";
        DbUtil.executeBatch((Context)ctx, (String)insertSql, batchInserTempParam);
        return tempTable;
    }

    public static BudgetAdjustEntryInfo assembleEntryDataByManageMap(Context ctx, BudgetAdjustEntryInfo entryInfo, Map<String, BudgetAdjustEntryInfo> manageInfoMap, List<String> colNameHisList) {
        if (entryInfo == null || manageInfoMap == null || colNameHisList == null) {
            return entryInfo;
        }
        String entryKey = BudgetAdjustSqlUtils.assembleEntryKey(entryInfo);
        if (StringUtils.isEmpty((CharSequence)entryKey) || manageInfoMap.get(entryKey) == null) {
            return entryInfo;
        }
        BudgetAdjustEntryInfo manageInfo = manageInfoMap.get(entryKey);
        entryInfo.setBudgetManage(manageInfo.getBudgetManage());
        entryInfo.setBackupVersion(manageInfo.getBackupVersion());
        entryInfo.setSyncVersion(manageInfo.getSyncVersion());
        for (String colName : colNameHisList) {
            entryInfo.put(colName, manageInfo.get(colName));
        }
        return entryInfo;
    }

    public static String assembleEntryKey(SubBudgetAdjustEntryInfo entryInfo) {
        if (entryInfo.getAdminOrgUnit() == null || entryInfo.getAdminOrgUnit().getId() == null || entryInfo.getCostType() == null || entryInfo.getCostType().getId() == null) {
            return null;
        }
        String orgId = entryInfo.getAdminOrgUnit().getId().toString();
        String costTypeId = entryInfo.getCostType().getId().toString();
        return orgId + "_" + costTypeId;
    }

    public static String assembleEntryKey(BudgetAdjustEntryInfo entryInfo) {
        if (entryInfo.getAdminOrgUnit() == null || entryInfo.getAdminOrgUnit().getId() == null || entryInfo.getCostType() == null || entryInfo.getCostType().getId() == null) {
            return null;
        }
        String orgId = entryInfo.getAdminOrgUnit().getId().toString();
        String costTypeId = entryInfo.getCostType().getId().toString();
        return orgId + "_" + costTypeId;
    }

    public static String assembleSubEntryKey(SubBudgetAdjustEntryInfo entryInfo) {
        if (entryInfo.getAdminOrgUnit() == null || entryInfo.getAdminOrgUnit().getId() == null || entryInfo.getCostType() == null || entryInfo.getCostType().getId() == null || entryInfo.getBudgetItem() == null || entryInfo.getBudgetItem().getId() == null) {
            return null;
        }
        String itemId = entryInfo.getBudgetItem().getId().toString();
        return BudgetAdjustSqlUtils.assembleEntryKey(entryInfo) + "_" + itemId;
    }

    public static List<BudgetAdjustEntryParam> assembleBudgetAdjustEntryParam(BudgetAdjustEntryCollection entryCol) {
        if (entryCol == null || entryCol.isEmpty()) {
            return null;
        }
        ArrayList<BudgetAdjustEntryParam> entryParams = new ArrayList<BudgetAdjustEntryParam>();
        for (int i = 0; i < entryCol.size(); ++i) {
            BudgetAdjustEntryInfo entryInfo = entryCol.get(i);
            if (entryInfo.getAdminOrgUnit() == null || entryInfo.getAdminOrgUnit().getId() == null || entryInfo.getCostType() == null || entryInfo.getCostType().getId() == null) continue;
            BudgetAdjustEntryParam entryParam = new BudgetAdjustEntryParam();
            entryParam.setAdminOrgUnitId(entryInfo.getAdminOrgUnit().getId().toString());
            entryParam.setCostTypeID(entryInfo.getCostType().getId().toString());
            entryParams.add(entryParam);
        }
        return entryParams;
    }

    public static SubBudgetAdjustEntryInfo subEntryAssignDefault(SubBudgetAdjustEntryInfo subEntryInfo, CmpBudgetSchemeInfo schemeInfo, List<String> periodColNames, Map<String, Object> subBudgetAssignMap) {
        BigDecimal adjustYearBudget = subEntryInfo.getAdjustYearBudget();
        if (adjustYearBudget == null) {
            return subEntryInfo;
        }
        SubBudgetAssignTypeEnum assignType = schemeInfo.getSubBudgetAssignType();
        int len = periodColNames.size();
        BigDecimal sumValue = BigDecimal.ZERO;
        BigDecimal averageValue = adjustYearBudget.divide(new BigDecimal(len), 2, 4);
        BigDecimal bigValue100 = new BigDecimal(100);
        for (int i = 0; i < len - 1; ++i) {
            BigDecimal periodValue;
            String colName = periodColNames.get(i);
            if (assignType == SubBudgetAssignTypeEnum.PERCENT && subBudgetAssignMap != null && subBudgetAssignMap.get(colName) != null) {
                BigDecimal percentValue = new BigDecimal(subBudgetAssignMap.get(colName).toString());
                periodValue = adjustYearBudget.multiply(percentValue).divide(bigValue100, 2, 4);
            } else {
                periodValue = assignType == SubBudgetAssignTypeEnum.AVERAGE ? averageValue : BigDecimal.ZERO;
            }
            sumValue = sumValue.add(periodValue);
            subEntryInfo.put(colName, periodValue);
        }
        BigDecimal subtractValue = adjustYearBudget.subtract(sumValue).setScale(2, RoundingMode.HALF_UP);
        String lastColName = periodColNames.get(len - 1);
        subEntryInfo.put(lastColName, subtractValue);
        return subEntryInfo;
    }
}

