/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.calculate.CmpCalculateFacadeFactory;
import com.kingdee.shr.compensation.app.calculate.SalaryCalProcessEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class SalaryCalProcess {
    private int totalCount;
    private int noCalCount;
    private int calCount;
    private int waitCount;
    private int exceptionCount;
    private String percent;
    private SalaryCalProcessEnum processEnum;
    private int cell;
    private long waitTime;
    private long calTime;
    private long beginTime;
    private String desc;
    private String calTaskId;
    private int calculatorTime;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.calculate.cache.SalaryCalProcess");

    public SalaryCalProcess(int totalCount, int noCalCount) {
        this.totalCount = totalCount;
        this.noCalCount = noCalCount;
        this.setCalCountForCal(0);
        this.setPercent("0%");
        this.setProcessEnumForCal(SalaryCalProcessEnum.WAITTING);
        this.cell = this.getTotalCount() / 60;
        this.waitTime = System.currentTimeMillis();
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getCalCount() {
        return this.calCount;
    }

    public static SalaryCalProcess getProcess(Context ctx, String calSchemeId) throws BOSException {
        try {
            CmpCalculateFacadeFactory.getLocalInstance(ctx).calIsRunning(calSchemeId);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            CmpCalculateFacadeFactory.getLocalInstance(ctx).calIsRunning(calSchemeId);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        SalaryCalProcess calProcess = null;
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        StringBuilder str = new StringBuilder();
        str.append(" SELECT TOP 1 CALTASK.FID, CALTASK.FSERVER, CALTASK.FDATACENTER, CALTASK.FPROCESS, CALTASK.FBEGINTIME, CALTASK.FENDTIME, ");
        str.append(" CALTASK.FSUCCESS, CALTASK.FAIL, CALTASK.FSUM, CALTASK.FNOCAL, CALTASK.FWAIT, CALTASK.FENDTIME, BASE.FCOUNT ");
        str.append(" FROM T_HR_SCMPCALTASK CALTASK ");
        str.append(" INNER JOIN T_HR_SCMPCALTASKBASE BASE ON CALTASK.FTASKBASEID = BASE.FID ");
        str.append(" INNER JOIN T_HR_SCALSCHEME SCHEME ON BASE.FCALSCHEMEID = SCHEME.FID AND BASE.FPERIODYEAR = SCHEME.FPERIODYEAR ");
        str.append(" AND BASE.FPERIODMONTH = SCHEME.FPERIODMONTH AND BASE.FCALTIME = SCHEME.FCALTIME ");
        str.append(" WHERE BASE.FCALSCHEMEID = '").append(calSchemeId).append("' ");
        str.append(" AND BASE.FCREATORID = '").append(userId).append("' ");
        str.append(" ORDER BY FCOUNT DESC ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            if (rowSet.next()) {
                SalaryCalProcessEnum processEnum = SalaryCalProcessEnum.getEnum(rowSet.getInt("FProcess"));
                calProcess = new SalaryCalProcess(rowSet.getInt("FSUM"), rowSet.getInt("FNOCAL"));
                calProcess.setCalCount(rowSet.getInt("FSUCCESS"));
                calProcess.setCalculatorTime(rowSet.getInt("FCOUNT"));
                calProcess.setWaitCount(rowSet.getInt("FSUM") - rowSet.getInt("FSUCCESS") - rowSet.getInt("FNOCAL") - rowSet.getInt("FAIL"));
                calProcess.setExceptionCount(rowSet.getInt("FAIL"));
                calProcess.setPercent(userId);
                calProcess.setProcessEnum(SalaryCalProcessEnum.getEnum(rowSet.getInt("FProcess")));
                calProcess.setPercent(processEnum.equals((Object)SalaryCalProcessEnum.FINISH) || processEnum.equals((Object)SalaryCalProcessEnum.NO_CHANGE) ? "100%" : "0%");
                calProcess.setCalTaskId(rowSet.getString("FID"));
                if (null != rowSet.getDate("FWAIT")) {
                    calProcess.setWaitTime(rowSet.getDate("FWAIT").getTime());
                    calProcess.setCalTime(rowSet.getDate("FWAIT").getTime());
                }
                if (null != rowSet.getDate("FENDTIME")) {
                    calProcess.setCalTime(rowSet.getDate("FENDTIME").getTime());
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return calProcess;
    }

    public void setCalCountForCal(int calCount) {
        this.calCount = calCount;
        this.waitCount = this.totalCount - calCount - this.noCalCount - this.exceptionCount;
        if (this.cell == 0) {
            BigDecimal limit = new BigDecimal(60);
            if (this.totalCount - this.noCalCount - this.exceptionCount == 0) {
                this.setPercent("80%");
            } else {
                int avg = limit.divide(new BigDecimal(this.totalCount - this.noCalCount), 0, 3).intValue();
                this.setPercent(avg * (calCount + this.exceptionCount) + 20 + "%");
            }
        } else if (calCount % this.cell == 0) {
            BigDecimal bp = new BigDecimal(calCount);
            int tempCount = this.totalCount - this.noCalCount - this.exceptionCount;
            bp = tempCount == 0 ? new BigDecimal(60) : bp.divide(new BigDecimal(this.totalCount - this.noCalCount - this.exceptionCount), 2, 1).multiply(new BigDecimal(60));
            this.setPercent(bp.intValue() + 20 + "%");
        }
    }

    public void setProcessEnumForCal(SalaryCalProcessEnum processEnum) {
        this.processEnum = processEnum;
        switch (processEnum.getValue()) {
            case 15: {
                this.beginTime = System.currentTimeMillis();
                break;
            }
            case 70: {
                this.calTime = System.currentTimeMillis();
                break;
            }
            case 75: {
                this.calTime = System.currentTimeMillis();
                break;
            }
            case 65: {
                this.calTime = System.currentTimeMillis();
            }
        }
    }

    public void setCalCount(int calCount) {
        this.calCount = calCount;
    }

    public String getPercent() {
        return this.percent;
    }

    public void setPercent(String percent) {
        this.percent = percent;
    }

    public int getWaitCount() {
        return this.waitCount;
    }

    public void setWaitCount(int waitCount) {
        this.waitCount = waitCount;
    }

    public SalaryCalProcessEnum getProcessEnum() {
        return this.processEnum;
    }

    public void setProcessEnum(SalaryCalProcessEnum processEnum) {
        this.processEnum = processEnum;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public void setCalTime(long calTime) {
        this.calTime = calTime;
    }

    public long getCalTime() {
        return this.calTime;
    }

    public int getNoCalCount() {
        return this.noCalCount;
    }

    public int getExceptionCount() {
        return this.exceptionCount;
    }

    public void setExceptionCount(int exceptionCount) {
        this.exceptionCount = exceptionCount;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getCalTaskId() {
        return this.calTaskId;
    }

    public void setCalTaskId(String calTaskId) {
        this.calTaskId = calTaskId;
    }

    public int getCalculatorTime() {
        return this.calculatorTime;
    }

    public void setCalculatorTime(int calculatorTime) {
        this.calculatorTime = calculatorTime;
    }
}

