/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.BizManageState;
import com.kingdee.shr.base.bizmanage.DataSource;
import com.kingdee.shr.base.bizmanage.IPersonBURelation;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmInfo;
import com.kingdee.shr.base.bizmanage.PersonBURelationCollection;
import com.kingdee.shr.base.bizmanage.PersonBURelationFactory;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpEmpORelationInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatEntityCollection;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatEntityFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatEntityInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatalogCollection;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatalogFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatalogInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryCollection;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelFilterCollection;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelFilterDataFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelFilterFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelFilterInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelRuleCollection;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelRuleFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelRuleInfo;
import com.kingdee.shr.compensation.app.intelligent.ICmpIntelCatEntity;
import com.kingdee.shr.compensation.app.intelligent.ICmpIntelCatalog;
import com.kingdee.shr.compensation.app.intelligent.ICmpIntelEntry;
import com.kingdee.shr.compensation.app.intelligent.ICmpIntelFilter;
import com.kingdee.shr.compensation.app.intelligent.ICmpIntelFilterData;
import com.kingdee.shr.compensation.app.intelligent.ICmpIntelRule;
import com.kingdee.shr.compensation.app.intelligent.optimization.CmpIntelEntryAdminOrgCollection;
import com.kingdee.shr.compensation.app.intelligent.optimization.CmpIntelEntryAdminOrgInfo;
import com.kingdee.shr.compensation.intelligent.constant.CmpIntelConstant;
import com.kingdee.shr.compensation.intelligent.dto.json.AdminOrg;
import com.kingdee.shr.compensation.intelligent.dto.json.CmpItelJsonBean;
import com.kingdee.shr.compensation.intelligent.dto.json.Data;
import com.kingdee.shr.compensation.intelligent.dto.json.Entry;
import com.kingdee.shr.compensation.intelligent.dto.json.Scheme;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CmpIntelligentUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.intelligent.util.CmpIntelligentUtil");
    private static String id;

    private CmpIntelligentUtil() {
    }

    public static Map<String, Object> getIntelFilterMap(Context ctx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String oql = "select *";
        try {
            ICmpIntelFilter cmpIntelFilter = CmpIntelFilterFactory.getLocalInstance(ctx);
            CmpIntelFilterCollection coll = cmpIntelFilter.getCmpIntelFilterCollection(oql);
            if (coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    CmpIntelFilterInfo cmpIntelFilterInfo = coll.get(i);
                    String keyword = cmpIntelFilterInfo.getKeyword();
                    String sourceEntity = cmpIntelFilterInfo.getSourceEntity();
                    String key = sourceEntity + "_" + keyword;
                    map.put(key, cmpIntelFilterInfo);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static <T> T getJsonObj(String jsonStr, T type) {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping();
        Gson gson = builder.create();
        Object result = gson.fromJson(jsonStr, type.getClass());
        return (T)result;
    }

    public static Map<String, String> getCatalogEntityMap(Context ctx) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        ICmpIntelCatEntity cmpIntelCatEntity = CmpIntelCatEntityFactory.getLocalInstance(ctx);
        String oql = "select cmpIntelCatalog.id, entity";
        CmpIntelCatEntityCollection coll = cmpIntelCatEntity.getCmpIntelCatEntityCollection(oql);
        String sourceEntity = "";
        String catalogId = "";
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            CmpIntelCatEntityInfo cmpIntelCatEntityInfo = coll.get(i);
            catalogId = cmpIntelCatEntityInfo.getCmpIntelCatalog().getId().toString();
            sourceEntity = cmpIntelCatEntityInfo.getEntity();
            map.put(catalogId, sourceEntity);
        }
        return map;
    }

    public static Map<String, String> getOrgLongNumberMap(Context ctx) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            String oql = "select id,longNumber";
            AdminOrgUnitCollection coll = adminOrgUnit.getAdminOrgUnitCollection(oql);
            if (coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    AdminOrgUnitInfo adminOrgUnitInfo = coll.get(i);
                    String orgId = adminOrgUnitInfo.getId().toString();
                    String longNumber = adminOrgUnitInfo.getLongNumber();
                    map.put(orgId, longNumber);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, String> getCmpIntelCatalogMap(Context ctx) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ICmpIntelCatalog cmpIntelCatalog = CmpIntelCatalogFactory.getLocalInstance(ctx);
            String oql = "select id, number";
            CmpIntelCatalogCollection coll = cmpIntelCatalog.getCmpIntelCatalogCollection(oql);
            if (coll.size() > 0) {
                CmpIntelCatalogInfo cmpIntelCatalogInfo = null;
                String id = "";
                String number = "";
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    cmpIntelCatalogInfo = coll.get(i);
                    id = cmpIntelCatalogInfo.getId().toString();
                    number = cmpIntelCatalogInfo.getNumber();
                    map.put(number, id);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static CmpIntelRuleInfo getRuleInfoByRuleId(Context ctx, String ruleId) throws BOSException {
        CmpIntelRuleInfo cmpIntelRuleInfo = null;
        String ruleFilter = "select id, effectDate, hrOrgUnit.id where id='" + ruleId + "'";
        ICmpIntelRule cmpIntelRule = CmpIntelRuleFactory.getLocalInstance(ctx);
        CmpIntelRuleCollection ruleColl = cmpIntelRule.getCmpIntelRuleCollection(ruleFilter);
        if (ruleColl.size() > 0) {
            cmpIntelRuleInfo = ruleColl.get(0);
        }
        return cmpIntelRuleInfo;
    }

    public static PersonBURelationInfo assemblePersonBuInfo(Context ctx, PersonBURelaConfirmInfo confirmInfo, Map<String, EmpPosOrgRelationInfo> EmpOrgReMap, HROrgUnitInfo hrOrgUnit) {
        PersonBURelationInfo buInfo = new PersonBURelationInfo();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        java.util.Date now = new java.util.Date();
        String confirmId = confirmInfo.getId().toString();
        EmpPosOrgRelationInfo newEmpOrgRelationInfo = confirmInfo.getNewEmpOrgRelation();
        String empOrgReId = newEmpOrgRelationInfo.getId().toString();
        if ((newEmpOrgRelationInfo = EmpOrgReMap.get(empOrgReId)) == null) {
            try {
                newEmpOrgRelationInfo = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationInfo("where id = '" + empOrgReId + "'");
            }
            catch (Exception e) {
                logger.error((Object)("\u85aa\u916c\u7ec4\u88c5\u4e1a\u52a1\u5173\u7cfb\u62a5\u9519:" + confirmInfo.getId()));
                e.printStackTrace();
            }
        }
        Timestamp ts = new Timestamp(now.getTime());
        buInfo.setId(BOSUuid.create((BOSObjectType)buInfo.getBOSType()));
        buInfo.setPerson(confirmInfo.getPerson());
        buInfo.setEmpOrgRelation(newEmpOrgRelationInfo);
        buInfo.setEmpPostExpHis(confirmInfo.getNewEmpPostExpHis());
        buInfo.setBizManageType(confirmInfo.getBizManageType());
        if (hrOrgUnit == null) {
            hrOrgUnit = confirmInfo.getNewHrOrgUnit();
            hrOrgUnit = hrOrgUnit == null ? confirmInfo.getDefaultHrOrgUnit() : hrOrgUnit;
        }
        buInfo.setHrOrgUnit(hrOrgUnit);
        buInfo.setState(BizManageState.New);
        buInfo.setUseDefault(false);
        buInfo.setComfirmMsgId(confirmId);
        buInfo.setCreator(user);
        buInfo.setLastUpdateUser(user);
        buInfo.setLastUpdateTime(ts);
        buInfo.setCreateTime(ts);
        buInfo.setDataSource(DataSource.ChangeOperation);
        buInfo.setEFFDT(null == newEmpOrgRelationInfo ? null : newEmpOrgRelationInfo.getEFFDT());
        return buInfo;
    }

    public static PersonBURelationInfo assemblePersonBuInfo(Context ctx, PersonBURelaConfirmInfo confirmInfo, Map<String, EmpPosOrgRelationInfo> EmpOrgReMap) {
        PersonBURelationInfo buInfo = new PersonBURelationInfo();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        java.util.Date now = new java.util.Date();
        String confirmId = confirmInfo.getId().toString();
        EmpPosOrgRelationInfo newEmpOrgRelationInfo = confirmInfo.getNewEmpOrgRelation();
        String empOrgReId = newEmpOrgRelationInfo.getId().toString();
        if ((newEmpOrgRelationInfo = EmpOrgReMap.get(empOrgReId)) == null) {
            try {
                newEmpOrgRelationInfo = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationInfo("where id = '" + empOrgReId + "'");
            }
            catch (Exception e) {
                logger.error((Object)("\u85aa\u916c\u7ec4\u88c5\u4e1a\u52a1\u5173\u7cfb\u62a5\u9519:" + confirmInfo.getId()));
                e.printStackTrace();
            }
        }
        Timestamp ts = new Timestamp(now.getTime());
        buInfo.setId(BOSUuid.create((BOSObjectType)buInfo.getBOSType()));
        buInfo.setPerson(confirmInfo.getPerson());
        buInfo.setEmpOrgRelation(newEmpOrgRelationInfo);
        buInfo.setEmpPostExpHis(confirmInfo.getNewEmpPostExpHis());
        buInfo.setBizManageType(confirmInfo.getBizManageType());
        HROrgUnitInfo hrOrgUnit = confirmInfo.getNewHrOrgUnit();
        hrOrgUnit = hrOrgUnit == null ? confirmInfo.getDefaultHrOrgUnit() : hrOrgUnit;
        buInfo.setHrOrgUnit(hrOrgUnit);
        buInfo.setState(BizManageState.New);
        buInfo.setUseDefault(false);
        buInfo.setComfirmMsgId(confirmId);
        buInfo.setCreator(user);
        buInfo.setLastUpdateUser(user);
        buInfo.setLastUpdateTime(ts);
        buInfo.setCreateTime(ts);
        buInfo.setDataSource(DataSource.ChangeOperation);
        buInfo.setEFFDT(null == newEmpOrgRelationInfo ? null : newEmpOrgRelationInfo.getEFFDT());
        return buInfo;
    }

    public static Map<String, EmpPosOrgRelationInfo> getEmpPosOrgReMap(Context ctx, String hrOrgId) throws BOSException {
        return CmpIntelligentUtil.getEmpPosOrgReMapNew(ctx, hrOrgId);
    }

    public static Map<String, EmpPosOrgRelationInfo> getEmpPosOrgReMap(Context ctx) throws BOSException {
        return CmpIntelligentUtil.getEmpPosOrgReMapNew(ctx, null);
    }

    private static Map<String, EmpPosOrgRelationInfo> getEmpPosOrgReMapNew(Context ctx, String hrOrgId) throws BOSException {
        HashMap<String, EmpPosOrgRelationInfo> map = new HashMap<String, EmpPosOrgRelationInfo>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT FID,FPOSITIONID ,FADMINORGID ,FPERSONID ,FEFFDT ");
        builder.append(" FROM T_HR_EmpOrgRelation where FID in (SELECT distinct FNEWEMPORGRELATIONID FROM T_HR_PersonBURelaConfirm ");
        builder.append(" where fdealstate=0 ");
        if (!StringUtils.isEmpty((String)hrOrgId)) {
            builder.append(" and FHrOrgUnitID = '").append(hrOrgId).append("'");
        }
        builder.append(" and FBizManageTypeID in ('").append("UEVgqLoZwEWW4Kq+2LWYL2WJ1dE=").append("','").append("eCE4/SnC20yjAOZ5CU5iymWJ1dE=").append("','").append("cEzQ1pHpEE+h9QzcFAj//2WJ1dE=").append("'))");
        EmpPosOrgRelationInfo empPosOrgRelationInfo = null;
        PositionInfo position = null;
        AdminOrgUnitInfo adminOrgInfo = null;
        PersonInfo person = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.toString());
            String fid = "";
            String positionId = "";
            String adminOrgId = "";
            String personId = "";
            Date effdt = null;
            while (rs.next()) {
                fid = rs.getString("FID");
                positionId = rs.getString("FPOSITIONID");
                adminOrgId = rs.getString("FADMINORGID");
                personId = rs.getString("FPERSONID");
                effdt = rs.getDate("FEFFDT");
                empPosOrgRelationInfo = new EmpPosOrgRelationInfo();
                empPosOrgRelationInfo.setId(BOSUuid.read((String)fid));
                position = new PositionInfo();
                position.setId(BOSUuid.read((String)positionId));
                empPosOrgRelationInfo.setPosition(position);
                adminOrgInfo = new AdminOrgUnitInfo();
                adminOrgInfo.setId(BOSUuid.read((String)adminOrgId));
                empPosOrgRelationInfo.setAdminOrg(adminOrgInfo);
                person = new PersonInfo();
                person.setId(BOSUuid.read((String)personId));
                empPosOrgRelationInfo.setPerson(person);
                empPosOrgRelationInfo.setEFFDT((java.util.Date)effdt);
                map.put(fid, empPosOrgRelationInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static List<String> getFlowOutAffairReasons(Context ctx) {
        ArrayList<String> list = new ArrayList<String>();
        String sql = "select fid from T_HR_AffairActionReason where flongnumber like '02!%'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            String id = "";
            while (rs.next()) {
                id = rs.getString("fid");
                list.add(id);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Map<String, CmpEmpORelationInfo> getCmpEmpPosMap(Context ctx) throws BOSException {
        HashMap<String, CmpEmpORelationInfo> map = new HashMap<String, CmpEmpORelationInfo>();
        CmpEmpORelationInfo info = null;
        String hrOrgId = "";
        String empPosId = "";
        String cmpEmpId = "";
        int useDefault = 0;
        Date leffectDate = null;
        StringBuilder sb = new StringBuilder();
        sb.append(" select cmpEmp.femporgrelationid empPosId,cmpEmp.fid cmpEmpId, ");
        sb.append(" cmpEmp.fusedefault,cmpEmp.fleffectdate,personCmp.fhrorgunitid ");
        sb.append(" from T_HR_SCmpEmpORelation cmpEmp ");
        sb.append(" left join t_hr_spersoncmp personCmp on cmpEmp.FPERSONCMPID=personCmp.fid ");
        sb.append(" left join T_HR_PersonBURelaConfirm confirm on confirm.FNEWEMPORGRELATIONID=cmpEmp.FEMPORGRELATIONID ");
        sb.append(" left join T_HR_SCmpIntelMatchData matchData on matchData.FPBUCONFIRMID=confirm.fid ");
        sb.append(" where matchData.fstate='10' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                info = new CmpEmpORelationInfo();
                hrOrgId = rs.getString("fhrorgunitid");
                empPosId = rs.getString("empPosId");
                cmpEmpId = rs.getString("cmpEmpId");
                useDefault = rs.getInt("fusedefault");
                leffectDate = rs.getDate("fleffectdate");
                info.setId(BOSUuid.read((String)cmpEmpId));
                info.setUseDefault(useDefault == 1);
                info.setLeffectDate(leffectDate);
                map.put(hrOrgId + "_" + empPosId, info);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static void delOldData(Context ctx, String ruleId, String catalogId) throws BOSException, EASBizException {
        String delEntryOql = "where cmpIntelRule.id='" + ruleId + "' and cmpIntelCatalog.id='" + catalogId + "'";
        String delFilterDataOql = "where cmpIntelEntry.cmpIntelRule.id='" + ruleId + "' and cmpIntelEntry.cmpIntelCatalog.id='" + catalogId + "'";
        ICmpIntelFilterData cmpIntelFilterData = CmpIntelFilterDataFactory.getLocalInstance(ctx);
        ICmpIntelEntry cmpIntelEntry = CmpIntelEntryFactory.getLocalInstance(ctx);
        cmpIntelFilterData.delete(delFilterDataOql);
        try {
            cmpIntelEntry.delete(delEntryOql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean hasEnableRule(Context ctx, String hrOrgId) {
        try {
            ICmpIntelRule cmpIntelRule = CmpIntelRuleFactory.getLocalInstance(ctx);
            String oql = "where hrOrgUnit.id='" + hrOrgId + "' and state=1";
            return cmpIntelRule.exists(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static List<String> getEnableRuleHrOrgs(Context ctx) {
        ArrayList<String> list = new ArrayList<String>();
        String sql = "select distinct fhrorgunitid hrOrgId from T_HR_SCmpIntelRule where fstate=1 and FIfUseDefault = 1 ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            String hrOrgId = "";
            while (rs.next()) {
                hrOrgId = rs.getString("hrOrgId");
                list.add(hrOrgId);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<String> getSocEnableRuleHrOrgs(Context ctx) {
        ArrayList<String> list = new ArrayList<String>();
        String sql = "select distinct r.FHrOrgUnitID as hrOrgId  from t_hr_scmpintelrule r inner join t_hr_scmpintelentry e on r.fid=e.FCmpIntelRuleID where e.FCmpIntelCatalogID='ecnRgrVrakexjc9fhpQpwwB4WXA=' and r.FSTATE = 1";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            String hrOrgId = "";
            while (rs.next()) {
                hrOrgId = rs.getString("hrOrgId");
                list.add(hrOrgId);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public static Map<String, String> buildSchemeMap(Context ctx, List<Scheme> schemeList, Map<String, CalSchemeInfo> calSchemeMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        Scheme cmpF7FilterData = null;
        StringBuilder idSB = new StringBuilder();
        StringBuilder nameSB = new StringBuilder();
        String idStr = "";
        String nameStr = "";
        int size = schemeList.size();
        for (int i = 0; i < size; ++i) {
            cmpF7FilterData = schemeList.get(i);
            idStr = cmpF7FilterData.getId();
            idStr = CmpIntelligentUtil.uriDecode(idStr);
            nameStr = calSchemeMap.get(idStr).getName();
            idSB.append(idStr).append("-");
            nameSB.append(nameStr).append("\u3001");
        }
        String schemeIds = idSB.substring(0, idSB.length() - 1);
        String schemeNames = nameSB.substring(0, nameSB.length() - 1);
        map.put("schemeIds", schemeIds);
        map.put("schemeNames", schemeNames);
        return map;
    }

    public static boolean isAutoSendCmp(Context ctx, String hrOrgId) {
        boolean value = CmpIntelligentUtil.getParamValueByOrgId(ctx, "shr_cmp_022", hrOrgId);
        return value;
    }

    public static boolean isAutoHandleSoc(Context ctx, String hrOrgId) {
        boolean value = CmpIntelligentUtil.getParamValueByOrgId(ctx, "shr_cmp_023", hrOrgId);
        return value;
    }

    public static boolean isAutoHandleAdj(Context ctx, String hrOrgId) {
        boolean value = CmpIntelligentUtil.getParamValueByOrgId(ctx, "shr_adj_002", hrOrgId);
        return value;
    }

    public static boolean getParamValueByOrgId(Context ctx, String number, String orgId) {
        String lan = ctx.getLocale().getLanguage();
        String sql = "select FValue_" + lan + " as paramVal from T_BAS_ParamItem item where fkeyid=(select fid from T_BAS_Param where fnumber=?) and FOrgUnitID=?";
        String value = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{number, orgId});
            while (rs.next()) {
                value = rs.getString("paramVal");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "true".equals(value);
    }

    public static Map<String, PersonBURelationInfo> personConfirmWithBuMap(Context ctx, String hrOrgId) {
        HashMap<String, PersonBURelationInfo> map = new HashMap<String, PersonBURelationInfo>();
        String bizTypeFilter = "('CMP02','CMP03')";
        try {
            IPersonBURelation personBURelation = PersonBURelationFactory.getLocalInstance((Context)ctx);
            String oql = "where bizManageType.number in" + bizTypeFilter + " and hrOrgUnit.id='" + hrOrgId + "' and comfirmMsgId is not null and comfirmMsgId in(select fid from T_HR_PersonBURelaConfirm  where fdealstate=0 and FBizManageTypeID in('" + "UEVgqLoZwEWW4Kq+2LWYL2WJ1dE=" + "','" + "eCE4/SnC20yjAOZ5CU5iymWJ1dE=" + "','" + "cEzQ1pHpEE+h9QzcFAj//2WJ1dE=" + "'))";
            PersonBURelationCollection coll = personBURelation.getPersonBURelationCollection(oql);
            String confirmId = "";
            PersonBURelationInfo personBURelationInfo = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                personBURelationInfo = coll.get(i);
                confirmId = personBURelationInfo.getComfirmMsgId();
                map.put(confirmId, personBURelationInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static List<String> getNoMatchCalData(Context ctx) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append(" select fcalschemeid,fpersonid,fperiodyear,fperiodmonth,fcaltime ").append("\r\n");
        sb.append(" from t_hr_scmpcaltable where fcalschemeid In( ").append("\r\n");
        sb.append(" select distinct substring(fcustomparam, 1,charindex(';', fcustomparam) - 1) schemeId ").append("\r\n");
        sb.append(" from T_HR_SCmpIntelMatchData ").append("\r\n");
        sb.append(" where fcmpintelcatalogid ='").append("zAOYO3uW+E+4twZ3xNBPrgB4WXA=").append("' ").append("\r\n");
        sb.append(" and fstate='10' ").append("\r\n");
        sb.append(" )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            String key = "";
            String calSchemeId = "";
            String personId = "";
            while (rs.next()) {
                calSchemeId = rs.getString("fcalschemeid");
                personId = rs.getString("fpersonid");
                int periodYear = rs.getInt("fperiodyear");
                int periodMonth = rs.getInt("fperiodmonth");
                int calTime = rs.getInt("fcaltime");
                key = calSchemeId + ";" + periodYear + ";" + periodMonth + ";" + calTime + ";" + personId;
                list.add(key);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String getInitPersonInsertSql(Context ctx, String bizManageTypeId, String idSet) throws BOSException, EASBizException {
        String insertSql = "insert into T_HR_PersonBURelation(FPersonID, FEmpOrgRelationID, FEmpPostExpHisID, FBizManageTypeID, FHrOrgUnitID, FBeginDate, FEndDate, FState, FItemState, FVersion, FUseDefault, FEFFDT, FComfirmMsgId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FID, FIsEmpInit, FDataSource) SELECT FPersonID,FNewEmpOrgRelationID,FNewEmpPostExpHisID,'" + bizManageTypeId + "',FNewHrOrgUnitID,FCreateTime,null,1,2,null,1,FChangeDate,FID,null,FCreateTime,null,null,null,newbosid('9F35F085'),1,1 FROM T_HR_PersonBURelaConfirm WHERE FID IN (" + idSet + ")";
        return insertSql;
    }

    public static List<Integer> getNoHandleBizTypes() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(4);
        list.add(6);
        list.add(8);
        return list;
    }

    public static CmpItelJsonBean buildSchemeFilter(String jsonStr) {
        CmpItelJsonBean bean = CmpIntelligentUtil.getJsonObj(jsonStr, new CmpItelJsonBean());
        return bean;
    }

    public static String changeObjToJson(Object javeBean) {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping();
        Gson gson = builder.create();
        String str = gson.toJson(javeBean);
        return str;
    }

    public static List<AdminOrg> getAdminOrgByRemoveSubInclude(Context ctx, List<AdminOrg> adminOrg) {
        String numbersub = null;
        String longNumber = null;
        HashSet<String> set = new HashSet<String>();
        ArrayList<AdminOrg> list = new ArrayList<AdminOrg>();
        for (AdminOrg org : adminOrg) {
            if (!"1".equals(org.getIfInclude())) continue;
            numbersub = numbersub == null ? "'" + org.getId() + "'" : numbersub + ",'" + org.getId() + "'";
        }
        StringBuilder temp = new StringBuilder(" select flongnumber ,fnumber from t_org_admin where fid in (" + numbersub + ")");
        StringBuilder tempsub = new StringBuilder(" select flongnumber ,fnumber from t_org_admin where ");
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)temp.toString());
            while (executeQuery.next()) {
                if (longNumber == null) {
                    longNumber = " flongnumber LIKE '" + executeQuery.getString("flongnumber") + "!%'";
                    continue;
                }
                longNumber = longNumber + " or flongnumber LIKE '" + executeQuery.getString("flongnumber") + "!%'";
            }
            tempsub.append(longNumber);
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)tempsub.toString());
            while (executeQuery.next()) {
                String fnumber = executeQuery.getString("fnumber");
                set.add(fnumber);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (AdminOrg org : adminOrg) {
            if (set.contains(org.getAdminOrgNumber())) continue;
            list.add(org);
        }
        return list;
    }

    public static CmpIntelEntryAdminOrgCollection getCmpIntelEntryAdminOrgCollection(List<AdminOrg> adminOrg) {
        CmpIntelEntryAdminOrgCollection orgColl = new CmpIntelEntryAdminOrgCollection();
        for (AdminOrg org : adminOrg) {
            CmpIntelEntryAdminOrgInfo infoOrg = new CmpIntelEntryAdminOrgInfo();
            AdminOrgUnitInfo info = new AdminOrgUnitInfo();
            info.setId(BOSUuid.read((String)org.getId()));
            infoOrg.setAdminOrg(info);
            infoOrg.setIfInclude("1".equals(org.getIfInclude()));
            infoOrg.setIfcontainBefore("1".equals(org.getIfcontainBefore()));
            orgColl.add(infoOrg);
        }
        return orgColl;
    }

    public static String getAdminOrgId(Context ctx, CmpIntelEntryAdminOrgCollection org) {
        String numbersub = null;
        String longNumber = null;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < org.size(); ++i) {
            CmpIntelEntryAdminOrgInfo info = org.get(i);
            list.add(info.getAdminOrg().getId().toString());
            if (!info.isIfInclude()) continue;
            numbersub = numbersub == null ? "'" + info.getAdminOrg().getId().toString() + "'" : numbersub + ",'" + info.getAdminOrg().getId().toString() + "'";
        }
        if (StringUtils.isEmpty(numbersub)) {
            return CmpStrUtil.convertListToString(list);
        }
        StringBuilder temp = new StringBuilder(" select flongnumber ,fnumber from t_org_admin where fid in (" + numbersub + ")");
        StringBuilder tempsub = new StringBuilder(" select fid from t_org_admin where ");
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)temp.toString());
            while (executeQuery.next()) {
                if (longNumber == null) {
                    longNumber = " flongnumber LIKE '" + executeQuery.getString("flongnumber") + "!%'";
                    continue;
                }
                longNumber = longNumber + " or flongnumber LIKE '" + executeQuery.getString("flongnumber") + "!%'";
            }
            tempsub.append(longNumber);
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)tempsub.toString());
            while (executeQuery.next()) {
                list.add(executeQuery.getString("fid"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CmpStrUtil.convertListToString(list);
    }

    public static Map<String, List<String>> getParamHrOrgUnitListByBizManage(Context ctx) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String paramID = "";
        try {
            String lan = ctx.getLocale().getLanguage();
            String bizSQl = "select fid  from T_HR_BizManageType where FNumber in  ('CMP02','CMP01','CMP03') and FState =1 ";
            IRowSet eQuery = DbUtil.executeQuery((Context)ctx, (String)bizSQl);
            while (eQuery.next()) {
                String bizManageTypeId = eQuery.getString("fid");
                if (bizManageTypeId.equals("cEzQ1pHpEE+h9QzcFAj//2WJ1dE=")) {
                    paramID = CmpIntelConstant.CMP01_PARAM_ID;
                } else if (bizManageTypeId.equals("UEVgqLoZwEWW4Kq+2LWYL2WJ1dE=")) {
                    paramID = CmpIntelConstant.CMP02_PARAM_ID;
                } else if (bizManageTypeId.equals("eCE4/SnC20yjAOZ5CU5iymWJ1dE=")) {
                    paramID = CmpIntelConstant.CMP03_PARAM_ID;
                }
                ArrayList<String> resultList = new ArrayList<String>();
                String sql = "select FOrgUnitID from T_BAS_PARAMitem where FKeyID = '" + paramID + "' AND FValue_" + lan + " = 'true'";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery.next()) {
                    resultList.add(executeQuery.getString("FOrgUnitID"));
                }
                StringBuilder sb = new StringBuilder();
                sb.append("select org.flongnumber longNumber from T_BAS_ParamManagerControl paramCon");
                sb.append("  left join t_org_hro org on paramCon.FSUPERIORCONTROLID=org.fid ");
                sb.append(" where FPARAMITEMID in( ");
                sb.append("select fid from t_bas_paramitem where fkeyid='").append(paramID).append("' ");
                sb.append("   and FVALUE_").append(lan).append("='true' ");
                sb.append("   ) and  FISINCLUDESUB=1 ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                String longNumber = "";
                IRowSet subRs = null;
                while (rs.next()) {
                    longNumber = rs.getString("longNumber");
                    sql = "select fid from t_org_hro where flongnumber like '" + longNumber + "!%' and fid not in(select FOrgUnitID from T_BAS_PARAMitem where FKeyID ='" + paramID + "')";
                    subRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (subRs.next()) {
                        resultList.add(subRs.getString("fid"));
                    }
                }
                map.put(bizManageTypeId, resultList);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Set<String> getPersonIdSchemeId(Context ctx, String schemeId) {
        HashSet<String> resultSet = new HashSet<String>();
        String sql = "select  fpersonId  from t_hr_scmpcaltable where FCalSchemeID = '" + schemeId + "'  ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                resultSet.add(rs.getString("fpersonId"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultSet;
    }

    public static boolean checkCmpItelEntrysIfUseDefault(Context ctx, String ruleId, String catalogId) throws BOSException {
        boolean flag = false;
        ICmpIntelEntry cmpIntelEntry = CmpIntelEntryFactory.getLocalInstance(ctx);
        String oql = "select data ,orgEntry.* where cmpIntelRule.id='" + ruleId + "' and cmpIntelCatalog.id='" + catalogId + "' order by index";
        String entryJsonData = "";
        CmpIntelEntryInfo cmpIntelEntryInfo = null;
        CmpIntelEntryCollection coll = cmpIntelEntry.getCmpIntelEntryCollection(oql);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            cmpIntelEntryInfo = coll.get(i);
            CmpIntelEntryAdminOrgCollection orgColl = cmpIntelEntryInfo.getOrgEntry();
            entryJsonData = cmpIntelEntryInfo.getData();
            Entry bean = CmpIntelligentUtil.getJsonObj(entryJsonData, new Entry());
            String dimension = bean.getDimension();
            if ("2".equals(dimension)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static String getDataId(List<Data> data) {
        ArrayList<String> reasonList = new ArrayList<String>();
        for (int i = 0; i < data.size(); ++i) {
            reasonList.add(data.get(i).getId().toString());
        }
        return CmpStrUtil.convertListToString(reasonList);
    }

    public static String uriDecode(String idStr) {
        if (!StringUtils.isEmpty((String)idStr) && idStr.indexOf("%") > -1) {
            try {
                idStr = URLDecoder.decode(idStr, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return idStr;
    }

    public static String replaceJsonStrFields(String jsonStr, String replaceKeysStr, Map<String, String> replaceMap) {
        String keyJsonStr;
        if (StringUtils.isEmpty((String)replaceKeysStr) || StringUtils.isEmpty((String)jsonStr)) {
            return jsonStr;
        }
        JSONObject rootJsonObject = JSONObject.parseObject((String)jsonStr);
        String parentKey = "";
        if (replaceKeysStr.contains(".")) {
            parentKey = replaceKeysStr.substring(0, replaceKeysStr.lastIndexOf("."));
        }
        String targetKeyName = replaceKeysStr.substring(replaceKeysStr.lastIndexOf(".") + 1, replaceKeysStr.length());
        JSONObject parentJsonObect = CmpIntelligentUtil.getJsonObjectByKey(rootJsonObject, parentKey);
        if (parentJsonObect != null && !StringUtils.isEmpty((String)targetKeyName) && !StringUtils.isEmpty((String)(keyJsonStr = parentJsonObect.getString(targetKeyName)))) {
            for (Map.Entry<String, String> replaceContent : replaceMap.entrySet()) {
                keyJsonStr = keyJsonStr.replaceAll(replaceContent.getKey(), replaceContent.getValue());
            }
            parentJsonObect.put(targetKeyName, JSONObject.parse((String)keyJsonStr));
        }
        return rootJsonObject.toJSONString();
    }

    public static JSONObject getJsonObjectByKey(JSONObject jsonObject, String jsonKeyStr) {
        int i;
        if (StringUtils.isEmpty((String)jsonKeyStr) || jsonObject == null) {
            return jsonObject;
        }
        String[] jsonKeyArr = jsonKeyStr.split("\\.");
        int keyArrLen = jsonKeyArr.length;
        JSONObject targetJsonObect = jsonObject;
        for (i = 0; i < keyArrLen && targetJsonObect != null; targetJsonObect = targetJsonObect.getJSONObject(jsonKeyArr[i]), ++i) {
        }
        if (i == keyArrLen && targetJsonObect != null) {
            return targetJsonObect;
        }
        return null;
    }

    public static Object getObjectByKey(JSONObject jsonObject, String jsonKeyStr) {
        if (StringUtils.isEmpty((String)jsonKeyStr) || jsonObject == null) {
            return null;
        }
        String parentKey = "";
        if (jsonKeyStr.contains(".")) {
            parentKey = jsonKeyStr.substring(0, jsonKeyStr.lastIndexOf("."));
        }
        String targetKeyName = jsonKeyStr.substring(jsonKeyStr.lastIndexOf(".") + 1, jsonKeyStr.length());
        JSONObject parentJsonObect = CmpIntelligentUtil.getJsonObjectByKey(jsonObject, parentKey);
        if (parentJsonObect != null && !StringUtils.isEmpty((String)targetKeyName)) {
            return parentJsonObect.get((Object)targetKeyName);
        }
        return null;
    }

    public static String parseEntryArr(String jsonStr, String replaceKeyStr, Map<String, String> replaceContent) {
        if (StringUtils.isEmpty((String)jsonStr)) {
            return "";
        }
        JSONObject rootJsonObject = JSONObject.parseObject((String)jsonStr);
        JSONArray entryArr = rootJsonObject.getJSONArray("entry");
        if (entryArr == null) {
            return "";
        }
        JSONArray newEntryArr = new JSONArray();
        for (int i = 0; i < entryArr.size(); ++i) {
            String entryObjStr = entryArr.getString(i);
            String newEntryObjectStr = CmpIntelligentUtil.replaceJsonStrFields(entryObjStr, replaceKeyStr, replaceContent);
            newEntryArr.add((Object)JSONObject.parseObject((String)newEntryObjectStr));
        }
        rootJsonObject.put("entry", (Object)newEntryArr);
        return rootJsonObject.toJSONString();
    }

    public static String getJsonArrayFieldFromStr(String jsonArrStr, String fieldName) {
        if (StringUtils.isEmpty((String)jsonArrStr) || StringUtils.isEmpty((String)fieldName)) {
            return "";
        }
        JSONArray parseArray = JSONArray.parseArray((String)jsonArrStr);
        ArrayList<String> idList = new ArrayList<String>();
        if (parseArray != null && parseArray.size() > 0) {
            for (int i = 0; i < parseArray.size(); ++i) {
                if (parseArray.getJSONObject(i) == null) continue;
                idList.add(parseArray.getJSONObject(i).getString(fieldName));
            }
        }
        return StringUtils.join((Object[])idList.toArray(), (String)",");
    }

    public static Set<String> getCmpIntelAdjEnableHrOrgSet(Context ctx) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        String sql = " select distinct intelRule.fhrorgunitid FDefaultHrOrgUnitID  from T_HR_SCmpIntelRule intelRule  left join t_hr_scmpintelentry entry on entry.FCMPINTELRULEID = intelRule.Fid  where intelRule.fstate = 1 and entry.FCMPINTELCATALOGID = 'zICC5+gl8kG0Opqki7xwlQB4WXA=' and entry.FDATA LIKE '%dimension\": \"1%'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String hrOrgId = rs.getString("FDefaultHrOrgUnitID");
                set.add(hrOrgId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getCmpIntelEnableHrOrgSet :", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return set;
    }
}

