/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.service;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.TaxExceptionEnum;
import com.kingdee.shr.compensation.app.tax.CountryCollection;
import com.kingdee.shr.compensation.app.tax.CountryFactory;
import com.kingdee.shr.compensation.app.tax.CountryInfo;
import com.kingdee.shr.compensation.app.tax.SupportCollection;
import com.kingdee.shr.compensation.app.tax.SupportFactory;
import com.kingdee.shr.compensation.app.tax.TaxBaseCollection;
import com.kingdee.shr.compensation.app.tax.TaxBaseFactory;
import com.kingdee.shr.compensation.app.tax.TaxBaseInfo;
import com.kingdee.shr.compensation.app.tax.TaxConfigCollection;
import com.kingdee.shr.compensation.app.tax.TaxConfigFactory;
import com.kingdee.shr.compensation.app.tax.TaxConfigInfo;
import com.kingdee.shr.compensation.app.tax.TaxPersonBaseCollection;
import com.kingdee.shr.compensation.app.tax.TaxPersonBaseFactory;
import com.kingdee.shr.compensation.app.tax.TaxStateEnum;
import com.kingdee.shr.compensation.app.tax.TaxTypeEnum;
import com.kingdee.shr.compensation.tax.TaxUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TaxHomeService {
    public static Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();

    public String getAreaTree(Context ctx) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        LinkedHashMap<String, Object> proMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> cityMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> areaMap = new LinkedHashMap<String, String>();
        ArrayList<LinkedHashMap<String, Object>> list = new ArrayList<LinkedHashMap<String, Object>>();
        ArrayList<LinkedHashMap<String, Object>> citylist = new ArrayList<LinkedHashMap<String, Object>>();
        ArrayList<LinkedHashMap<String, String>> arealist = new ArrayList<LinkedHashMap<String, String>>();
        if (dataMap.containsKey("areaTree_v1.0")) {
            return TaxUtil.success(ctx, dataMap.get("areaTree_v1.0"));
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        map.put("version", "v1.0");
        String sql = " select fid id, FName_" + l + " name, FNumber number, FLevel FLevel from T_HR_SPrefecture order by FNumber ";
        IRowSet r = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (r.next()) {
            String id = r.getString("id");
            String name = r.getString("name");
            int level = r.getInt("FLevel");
            if (1 == level) {
                proMap = new LinkedHashMap();
                citylist = new ArrayList();
                proMap.put("value", id);
                proMap.put("text", name);
                proMap.put("children", citylist);
                list.add(proMap);
                continue;
            }
            if (2 == level) {
                cityMap = new LinkedHashMap();
                arealist = new ArrayList();
                cityMap.put("value", id);
                cityMap.put("text", name);
                cityMap.put("children", arealist);
                citylist.add(cityMap);
                continue;
            }
            if (3 != level) continue;
            areaMap = new LinkedHashMap();
            areaMap.put("value", id);
            areaMap.put("text", name);
            arealist.add(areaMap);
        }
        map.put("tree", list);
        dataMap.put("areaTree_v1.0", map);
        return TaxUtil.success(ctx, map);
    }

    public String getCityDeduct(Context ctx) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        LinkedHashMap<String, Object> proMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> cityMap = new LinkedHashMap<String, Object>();
        ArrayList<LinkedHashMap<String, Object>> list = new ArrayList<LinkedHashMap<String, Object>>();
        ArrayList<LinkedHashMap<String, Object>> citylist = new ArrayList<LinkedHashMap<String, Object>>();
        if (dataMap.containsKey("cityDeduct_v1.0")) {
            return TaxUtil.success(ctx, dataMap.get("cityDeduct_v1.0"));
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        map.put("version", "v1.0");
        StringBuilder str = new StringBuilder();
        str.append(" select fec.fid id, fec.FName_" + l + " name, fec.FNumber number, fec.FLevel FLevel, deduct.FMoney money ");
        str.append(" from T_HR_SPrefecture fec ");
        str.append(" inner join T_HR_SCityDeduct deduct on fec.fid = deduct.FCityId ");
        str.append(" order by fec.FNumber ");
        IRowSet r = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        while (r.next()) {
            String id = r.getString("id");
            String name = r.getString("name");
            int level = r.getInt("FLevel");
            double money = r.getDouble("money");
            if (1 == level) {
                proMap = new LinkedHashMap();
                citylist = new ArrayList();
                proMap.put("value", id);
                proMap.put("text", name);
                proMap.put("money", money);
                proMap.put("children", citylist);
                list.add(proMap);
                continue;
            }
            if (2 != level) continue;
            cityMap = new LinkedHashMap();
            cityMap.put("value", id);
            cityMap.put("text", name);
            cityMap.put("money", money);
            citylist.add(cityMap);
        }
        map.put("tree", list);
        dataMap.put("cityDeduct_v1.0", map);
        return TaxUtil.success(ctx, map);
    }

    public String getTaxHomeInfo(Context ctx) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, TaxBaseInfo> stateMap = new HashMap<String, TaxBaseInfo>();
        HashMap<String, Double> totalMap = new HashMap<String, Double>();
        HashMap<String, Object> dataMap = null;
        HashMap<String, Object> enumMap = null;
        double total = 0.0;
        double itemTol = 0.0;
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        String ksql = "select id, state, effdtYear, effdtMonth, total, type where dataState = 1 and person.id = '" + personId + "' order by type, state asc ";
        TaxBaseCollection coll = TaxBaseFactory.getLocalInstance(ctx).getTaxBaseCollection(ksql);
        for (int i = 0; i < coll.size(); ++i) {
            TaxBaseInfo info = coll.get(i);
            itemTol = info.getTotal();
            if (info.getState().equals((Object)TaxStateEnum.VALID)) {
                total += itemTol;
                switch (info.getType().getValue()) {
                    case 10: {
                        totalMap.put("housing", itemTol);
                        break;
                    }
                    case 20: {
                        totalMap.put("rent", itemTol);
                        break;
                    }
                    case 40: {
                        totalMap.put("adult", itemTol);
                        break;
                    }
                    case 30: {
                        totalMap.put("education", itemTol);
                        break;
                    }
                    case 50: {
                        totalMap.put("support", itemTol);
                    }
                }
            }
            if (map.containsKey(info.getType().getName().toLowerCase(Locale.ENGLISH))) continue;
            enumMap = new HashMap<String, Object>();
            dataMap = new HashMap<String, Object>();
            enumMap.put("value", info.getState().getValue());
            enumMap.put("text", info.getState().getAlias());
            dataMap.put("billId", info.getId().toString());
            dataMap.put("total", info.getTotal());
            dataMap.put("state", enumMap);
            if (info.getType().getName().toLowerCase(Locale.ENGLISH).equals("support")) {
                int isOnly = 0;
                SupportCollection supColl = SupportFactory.getLocalInstance(ctx).getSupportCollection(" where bill.id = '" + info.getId().toString() + "' ");
                if (null != supColl && supColl.size() > 0) {
                    isOnly = supColl.get(0).isIsOnly() ? 1 : 0;
                }
                dataMap.put("isOnly", isOnly);
            }
            map.put(info.getType().getName().toLowerCase(Locale.ENGLISH), dataMap);
            stateMap.put(info.getType().getName().toLowerCase(Locale.ENGLISH), info);
        }
        if (stateMap.containsKey(TaxTypeEnum.HOUSING.getName().toLowerCase(Locale.ENGLISH)) && stateMap.containsKey(TaxTypeEnum.RENT.getName().toLowerCase(Locale.ENGLISH))) {
            TaxBaseInfo houInfo = (TaxBaseInfo)stateMap.get(TaxTypeEnum.HOUSING.getName().toLowerCase(Locale.ENGLISH));
            TaxBaseInfo teneInfo = (TaxBaseInfo)stateMap.get(TaxTypeEnum.RENT.getName().toLowerCase(Locale.ENGLISH));
            if (houInfo.getState().getValue() < teneInfo.getState().getValue()) {
                map.remove(TaxTypeEnum.RENT.getName().toLowerCase(Locale.ENGLISH));
            } else {
                map.remove(TaxTypeEnum.HOUSING.getName().toLowerCase(Locale.ENGLISH));
            }
        }
        int isBase = 0;
        TaxPersonBaseCollection perColl = TaxPersonBaseFactory.getLocalInstance(ctx).getTaxPersonBaseCollection(" where person.id = '" + TaxUtil.getPersonId(ctx) + "' ");
        if (null != perColl && perColl.size() > 0) {
            isBase = 1;
        }
        map.put("isBase", isBase);
        map.put("total", total);
        map.put("headlines", totalMap);
        this.extendForDetail(map);
        String notice = null;
        TaxConfigCollection configColl = TaxConfigFactory.getLocalInstance(ctx).getTaxConfigCollection();
        if (null != configColl && configColl.size() > 0) {
            notice = configColl.get(0).getNotice();
        }
        map.put("notice", notice);
        return TaxUtil.success(ctx, map);
    }

    private void extendForDetail(Map<String, Object> map) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("billId", null);
        dataMap.put("total", null);
        dataMap.put("state", null);
        if (!map.containsKey("housing")) {
            map.put("housing", dataMap);
        }
        if (!map.containsKey("rent")) {
            map.put("rent", dataMap);
        }
        if (!map.containsKey("adult")) {
            map.put("adult", dataMap);
        }
        if (!map.containsKey("education")) {
            map.put("education", dataMap);
        }
        if (!map.containsKey("support")) {
            map.put("support", dataMap);
        }
    }

    public String loseTaxInfo(Context ctx, String jsonParam) throws Exception {
        Map map = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonParam, Map.class);
        int type = TaxUtil.getMapInt(map, "taxType");
        String personId = TaxUtil.getPersonId(ctx);
        int addMonth = TaxUtil.getEffdtMonth(ctx);
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, addMonth);
        String sql = " select fid from T_HR_STaxBase where FPersonId = '" + personId + "' and FType = " + type + " and FState = " + 30;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() < 1) {
            return TaxUtil.error(ctx, TaxExceptionEnum.LOSE_FAILED.getValue(), TaxExceptionEnum.LOSE_FAILED.getName());
        }
        String billId = null;
        while (rowSet.next()) {
            billId = rowSet.getString(1);
        }
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)("select fid from T_HR_STaxBase where FPersonId = '" + personId + "' and FState = " + 20));
        if (rowSet1.size() > 0) {
            String delBillId = null;
            String table = TaxUtil.getTableByTaxType(type);
            if (rowSet1.next()) {
                delBillId = rowSet1.getString(1);
            }
            DbUtil.execute((Context)ctx, (String)("delete from " + table + " where FBillId = '" + delBillId + "' "));
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_STaxBase where fid = '" + delBillId + "'"));
        }
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        sql = "update T_HR_STaxBase set FLeffdtYear = " + year + ", FLeffdtMonth = " + month + ", FState = " + 40 + " where fid = '" + billId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        return TaxUtil.success(ctx, null);
    }

    public String getNotice(Context ctx) throws Exception {
        TaxConfigCollection coll = TaxConfigFactory.getLocalInstance(ctx).getTaxConfigCollection();
        if (null == coll || coll.size() < 1) {
            return TaxUtil.success(ctx, null);
        }
        TaxConfigInfo taxConfigInfo = coll.get(0);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("notice", taxConfigInfo.getNotice());
        return TaxUtil.success(ctx, map);
    }

    public String getCountry(Context ctx) throws Exception {
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = null;
        CountryInfo info = null;
        CountryCollection coll = CountryFactory.getLocalInstance(ctx).getCountryCollection("order by index");
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            map = new HashMap<String, Object>();
            map.put("value", info.getId().toString());
            map.put("text", info.getName());
            map.put("index", info.getIndex());
            list.add(map);
        }
        return TaxUtil.success(ctx, list);
    }

    public String deleteBill(Context ctx, String jsonParam) throws Exception {
        HashMap map = JSONUtils.convertJsonToObject((Context)ctx, (String)jsonParam);
        int type = TaxUtil.getMapInt(map, "taxType");
        int state = TaxUtil.getMapInt(map, "state");
        if (10 != state && 20 != state) {
            return TaxUtil.error(ctx, TaxExceptionEnum.DELETE_STATE.getValue(), TaxExceptionEnum.DELETE_STATE.getName());
        }
        String personId = TaxUtil.getPersonId(ctx);
        String sql = "select fid from T_HR_STaxBase where FPersonid = '" + personId + "' and FType = " + type + " and FState = " + state;
        IRowSet r = DbUtil.executeQuery((Context)ctx, (String)sql);
        String billId = null;
        while (r.next()) {
            billId = r.getString(1);
        }
        if (StringUtils.isEmpty(billId)) {
            return TaxUtil.success(ctx, "");
        }
        switch (type) {
            case 40: {
                DbUtil.execute((Context)ctx, (String)("delete from T_HR_SAdultEdu where FBillId = '" + billId + "'"));
                break;
            }
            case 30: {
                DbUtil.execute((Context)ctx, (String)("delete from T_HR_SEducation where FBillId = '" + billId + "'"));
                break;
            }
            case 10: {
                DbUtil.execute((Context)ctx, (String)("delete from T_HR_SHousing where FBillId = '" + billId + "'"));
                break;
            }
            case 20: {
                DbUtil.execute((Context)ctx, (String)("delete from T_HR_STenement where FBillId = '" + billId + "'"));
                break;
            }
            case 50: {
                String supportId = null;
                IRowSet r2 = DbUtil.executeQuery((Context)ctx, (String)("select fid from T_HR_SSupport where FBillId = '" + billId + "'"));
                while (r2.next()) {
                    supportId = r2.getString(1);
                }
                DbUtil.execute((Context)ctx, (String)("delete from T_HR_SSupportEntry where FSupportID = '" + supportId + "'"));
                DbUtil.execute((Context)ctx, (String)("delete from T_HR_SSupport where FBillId = '" + billId + "'"));
            }
        }
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_STaxBase where fid = '" + billId + "'"));
        return TaxUtil.success(ctx, "");
    }
}

