/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.exception.SQLHandleException;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class SQLHandleUtil {
    public static String getCurrentUserId(Context ctx) {
        return ContextUtil.getCurrentUserInfo((Context)ctx) == null ? "00000000-0000-0000-0000-00000000000013B7DE7F" : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
    }

    public static String getInsertSql(Context ctx, String tableName, String columns) {
        StringBuilder str = new StringBuilder();
        Date createTime = new Date(System.currentTimeMillis());
        String[] colArray = columns.split(",");
        int size = colArray.length;
        for (int i = 0; i < size; ++i) {
            str.append("?,");
        }
        String charStr = str.toString();
        str = new StringBuilder();
        str.append("insert into ");
        str.append(tableName);
        str.append(" (");
        str.append(columns);
        str.append(",FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime ) ");
        str.append("values(");
        str.append(charStr);
        str.append("'").append(SQLHandleUtil.getCurrentUserId(ctx)).append("',");
        str.append("{ts '").append(createTime).append("'}");
        str.append(",'").append(SQLHandleUtil.getCurrentUserId(ctx)).append("',");
        str.append("{ts '").append(createTime).append("'}");
        str.append(")");
        return str.toString();
    }

    public static String getUpdateSql(String tableName, String updateCol, String whereCol, String whereFilter) {
        int i;
        StringBuilder str = new StringBuilder();
        StringBuilder updateStrBu = new StringBuilder();
        StringBuilder whereStrBu = new StringBuilder();
        String[] updateArray = updateCol.split(",");
        String[] whereArray = whereCol.split(",");
        int size = updateArray.length;
        for (i = 0; i < size; ++i) {
            updateStrBu.append(updateArray[i]).append(" = ?, ");
        }
        String upStr = updateStrBu.substring(0, updateStrBu.lastIndexOf(","));
        size = whereArray.length;
        for (i = 0; i < size; ++i) {
            whereStrBu.append(whereArray[i]).append(" = ? and ");
        }
        String whereStr = whereStrBu.substring(0, whereStrBu.lastIndexOf("and"));
        str.append(" update ");
        str.append(tableName);
        str.append(" set ");
        str.append(upStr);
        str.append(" where ");
        str.append(whereStr);
        if (CmpStrUtil.isNotEmpty(whereFilter)) {
            str.append(" and " + whereFilter);
        }
        return str.toString();
    }

    public static String getTempTable(Context ctx, String sql) {
        if (!sql.contains("select") && !sql.contains("SELECT")) {
            return sql;
        }
        String createTempTableName = null;
        String createTempTableSql = null;
        if (sql.indexOf("null AS") >= 0) {
            createTempTableSql = sql;
            createTempTableName = "(" + sql + ") tempTab";
        } else {
            createTempTableName = SQLHandleUtil.createTempTableName(ctx);
            createTempTableSql = "select tempTab.* into " + createTempTableName + " from (" + sql + ") tempTab ";
        }
        try {
            CmpSQLUtil.execute(ctx, createTempTableSql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        String temp = "select * from " + createTempTableName;
        return temp;
    }

    public static String getTempTableForName(Context ctx, String sql) {
        if (!sql.contains("select") && !sql.contains("SELECT")) {
            return sql;
        }
        String createTempTableName = null;
        String createTempTableSql = null;
        if (sql.indexOf("null AS") >= 0) {
            createTempTableSql = sql;
            createTempTableName = "(" + sql + ") tempTab";
        } else {
            createTempTableName = SQLHandleUtil.createTempTableName(ctx);
            createTempTableSql = "select tempTab.* into " + createTempTableName + " from (" + sql + ") tempTab ";
        }
        try {
            CmpSQLUtil.execute(ctx, createTempTableSql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return createTempTableName;
    }

    public static String createTempTableName(Context ctx) {
        String createTempTableName = "TempTableName";
        try {
            createTempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return createTempTableName;
    }

    public static Map<String, Set<String>> getTableCloumnSetMap(Context ctx, String tableName) throws BOSException {
        if (StringUtils.isEmpty((String)tableName)) {
            throw new BOSException(new SQLHandleException(SQLHandleException.NULLPARAMETER).getMessage());
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        HashSet<String> numberSet = new HashSet<String>();
        HashSet<String> intSet = new HashSet<String>();
        HashSet<String> dateSet = new HashSet<String>();
        HashSet<String> strSet = new HashSet<String>();
        HashSet<String> nclobSet = new HashSet<String>();
        HashSet<String> uidSet = new HashSet<String>();
        String sql = "select top 1 * from " + tableName;
        if (tableName.contains(" ")) {
            sql = "select top 0 * from (" + tableName + ") ONESQL";
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            int columnCount = rowSet.getMetaData().getColumnCount();
            ResultSetMetaData metaData = rowSet.getMetaData();
            for (int i = 1; i <= columnCount; ++i) {
                String columnTypeName = metaData.getColumnTypeName(i);
                int scale = metaData.getScale(i);
                int precision = metaData.getPrecision(i);
                String columnName = metaData.getColumnName(i);
                if (("number".equalsIgnoreCase(columnTypeName) || "decimal".equalsIgnoreCase(columnTypeName)) && (scale >= 8 || precision == 0)) {
                    numberSet.add(columnName);
                    continue;
                }
                if ("float".equalsIgnoreCase(columnTypeName) || "numeric".equalsIgnoreCase(columnTypeName)) {
                    numberSet.add(columnName);
                    continue;
                }
                if ("number".equalsIgnoreCase(columnTypeName) || "decimal".equalsIgnoreCase(columnTypeName)) {
                    intSet.add(columnName);
                    continue;
                }
                if ("int".equalsIgnoreCase(columnTypeName) || "int4".equalsIgnoreCase(columnTypeName)) {
                    intSet.add(columnName);
                    continue;
                }
                if ("datetime".equalsIgnoreCase(columnTypeName) || "timestamp".equalsIgnoreCase(columnTypeName) || "date".equalsIgnoreCase(columnTypeName)) {
                    dateSet.add(columnName);
                    continue;
                }
                if ("clob".equalsIgnoreCase(columnTypeName) || "nclob".equalsIgnoreCase(columnTypeName)) {
                    nclobSet.add(columnName);
                    continue;
                }
                if ("varchar".equalsIgnoreCase(columnTypeName) && precision == 44) {
                    uidSet.add(columnName);
                    continue;
                }
                strSet.add(columnName);
            }
            map.put("numberSet", numberSet);
            map.put("intSet", intSet);
            map.put("dateSet", dateSet);
            map.put("strSet", strSet);
            map.put("nclobSet", nclobSet);
            map.put("uidSet", uidSet);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }
}

