/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpSalaryDataPermCollection;
import com.kingdee.shr.compensation.CmpSalaryDataPermFactory;
import com.kingdee.shr.compensation.CmpSalaryDataPermInfo;
import com.kingdee.shr.compensation.helper.CmpBizHelper;
import com.kingdee.shr.compensation.helper.CmpConstants;
import com.kingdee.shr.compensation.helper.CmpInitFactory;
import com.kingdee.shr.compensation.permission.CalSchemePermAPI;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import com.kingdee.util.StringUtils;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

public abstract class CmpSchemeFilter {
    private static final int CREATE_TEMP_INDEX_LIMIT = 5000;

    public static String getAdminOrgUnitRangeSQL(Context ctx, String permItemId) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String userAdminRangeSQL = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
        String tempTable = SQLHandleUtil.getTempTable(ctx, userAdminRangeSQL);
        String temptableName = CmpSchemeFilter.getTempTableName(tempTable);
        String adminOrgID = "FAdminOrgID";
        CmpSchemeFilter.createTempTableIndex(ctx, temptableName, "FAdminOrgID");
        return "select FAdminOrgID from (" + tempTable + ") as tempTable ";
    }

    public static void createTempTableIndex(Context ctx, String temptableName, String columnName) {
        try {
            int tempCount = CmpSchemeFilter.getTempCount(ctx, temptableName);
            if (tempCount < 5000) {
                return;
            }
            String index = "T_HR_AdTemp";
            SecureRandom random = new SecureRandom();
            int bound = 9999998;
            int randomNum = random.nextInt(bound);
            index = index + randomNum;
            String sql = "if not exists (select 1 from KSQL_INDEXES where KSQL_INDNAME ='%s' )  create index %s on %s(%s) ";
            String createIntexSql = String.format(sql, index, index, temptableName, columnName);
            DbUtil.execute((Context)ctx, (String)createIntexSql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static String getTempTableName(String tempTable) {
        String tableName = "";
        String from = " FROM ";
        if (!(tempTable = tempTable.toUpperCase()).contains(from)) {
            return tableName;
        }
        int index = tempTable.indexOf(from);
        tableName = tempTable.substring(index + from.length()).replace(" ", "");
        return tableName;
    }

    private static int getTempCount(Context ctx, String tableName) {
        int count = 0;
        String sql = " select count(1) num from " + tableName;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                count = rs.getInt("num");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }

    public static String getStraightAdminOrgUnitRangeSql(Context ctx, String permItemId) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        return SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
    }

    public static String getHrOrgUnitRangeSQL(Context ctx, String permItemId) {
        String ids;
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Set idSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)userId, (String)permItemId);
        if (idSet.size() >= 10) {
            String tempTable = SQLHandleUtil.createTempTableName(ctx);
            String creatTable = "SELECT FID TEMPCOLUMN INTO " + tempTable + " FROM T_HR_SCMPITEM WHERE 1<>1";
            String insertSql = "INSERT INTO " + tempTable + "(TEMPCOLUMN) VALUES(?)";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (String id : idSet) {
                Object[] params = new Object[]{id};
                paramList.add(params);
            }
            try {
                DbUtil.execute((Context)ctx, (String)creatTable);
                CmpSQLUtil.executeBatch(ctx, insertSql, paramList);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            ids = "  select tempColumn from " + tempTable + " ";
        } else {
            ids = CmpStrUtil.convertSetToSqlString(idSet);
        }
        return ids;
    }

    public static FilterInfo getPersonWebFilter(Context ctx, String calSchemeId, String permItemId, String adminOrgRange) {
        FilterInfo filterInfo = new FilterInfo();
        CalSchemeInfo calSchemeInfo = CalSchemePermAPI.getCalSchemeInfo(ctx, calSchemeId);
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        int calTime = calSchemeInfo.getCalTime();
        StringBuffer str = new StringBuffer();
        str.append(" SELECT 1 from  T_HR_SCmpCalTable where FCalSchemeID = '" + calSchemeId);
        str.append("' and FperiodYear = " + periodYear);
        str.append(" and FperiodMonth= " + periodMonth);
        str.append(" and FcalTime = " + calTime);
        str.append(" and person.FhistoryRelateID = FPersonId ");
        try {
            FilterItemInfo itemInfo = new FilterItemInfo("person.id", (Object)str.toString(), CompareType.NOTEXISTS);
            filterInfo.getFilterItems().add(itemInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            filterInfo.mergeFilter(new FilterInfo(" personCmp.isSendSalary = 1 "), "AND");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String schemeHrSql = "select FHrOrgUnitID from T_HR_SCalScheme where fid = '" + calSchemeId + "'";
            filterInfo.mergeFilter(new FilterInfo("cmpHROrgUnit.id in (" + schemeHrSql + ")"), "AND");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String adminOrgRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String adminKey = "adminOrgUnit.id";
        String useDefault = "cmpEmpORelation.useDefault";
        if (CmpConstants.ADMIN_ORG_INNER.equalsIgnoreCase(adminOrgRange)) {
            str = new StringBuffer();
            str.append(" ( " + adminKey + " in (").append(adminOrgRangeSql).append(") ");
            str.append(" and " + useDefault + " =1 )");
        } else if (CmpConstants.ADMIN_ORG_OUTER.equalsIgnoreCase(adminOrgRange)) {
            str = new StringBuffer(useDefault + " = 0 or (" + useDefault + " IS NULL)");
        } else {
            str = new StringBuffer();
            str.append(" (( " + adminKey + " in (").append(adminOrgRangeSql).append(") ");
            str.append(" and " + useDefault + " = 1 )");
            str.append(" or " + useDefault + " = 0 or " + useDefault + " IS NULL) ");
        }
        try {
            FilterInfo rangeFilter = new FilterInfo(str.toString());
            filterInfo.mergeFilter(rangeFilter, "AND");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getPersonHasFilter(Context ctx, String calSchemeId, String permItemId, String adminOrgRange) {
        CalSchemeInfo calSchemeInfo = CalSchemePermAPI.getCalSchemeInfo(ctx, calSchemeId);
        String colScheme = "cmp_CTB.calScheme";
        String colYear = "cmp_CTB.periodYear";
        String colMonth = "cmp_CTB.periodMonth";
        String colTime = "cmp_CTB.calTime";
        StringBuffer filterSql = new StringBuffer();
        filterSql.append(colScheme).append(" = '").append(calSchemeInfo.getId().toString()).append("'");
        filterSql.append(" and ").append(colYear).append(" = ").append(calSchemeInfo.getPeriodYear());
        filterSql.append(" and ").append(colMonth).append(" = ").append(calSchemeInfo.getPeriodMonth());
        filterSql.append(" and ").append(colTime).append(" = ").append(calSchemeInfo.getCalTime());
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(filterSql.toString());
            FilterInfo rangeFilter = CmpSchemeFilter.getReportPersonFilterFor002(ctx, permItemId, adminOrgRange);
            filterInfo.mergeFilter(rangeFilter, "AND");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getReportPersonFilterFor002(Context ctx, String permItemId, String adminOrgRange) {
        FilterInfo filterInfo = null;
        if (CmpStrUtil.isEmpty(adminOrgRange)) {
            return null;
        }
        try {
            if (adminOrgRange.equalsIgnoreCase(CmpConstants.ADMIN_ORG_INNER)) {
                filterInfo = CmpSchemeFilter.getAdminInnerFiler(ctx, permItemId, "002");
            } else if (adminOrgRange.equalsIgnoreCase(CmpConstants.ADMIN_ORG_OUTER)) {
                filterInfo = CmpSchemeFilter.getAdminOuterFilter(ctx, permItemId, "002");
            } else {
                filterInfo = CmpSchemeFilter.getAdminInnerFiler(ctx, permItemId, "002");
                filterInfo.mergeFilter(CmpSchemeFilter.getAdminOuterFilter(ctx, permItemId, "002"), "or");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getAdminInnerFiler(Context ctx, String permItemId, String scheme) {
        String adminOrgRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String adminKey = "cal_adminOrg.id";
        String hrKey = "cal_hrOrgUnit.id";
        String useDefault = "cmp_CTB.useDefault";
        if ("006".equals(scheme)) {
            adminKey = "adminOrgUnit.id";
            hrKey = "cmpHROrgUnit.id";
            useDefault = "cmpEmpORelation.useDefault";
        } else if ("008".equals(scheme)) {
            adminKey = "soc_adminOrg.id";
            hrKey = "soc_hrOrg.id";
            useDefault = "soc_record.useDefault";
        }
        String db = ctx.getAIS();
        boolean isUpdate = (Boolean)CmpInitFactory.getInstance(ctx).getCmpInitMap().get(db + "||" + CmpConstants.IS_UPDATE);
        StringBuilder str = new StringBuilder();
        if ("002".equals(scheme)) {
            str.append("(").append(adminKey).append(" in (").append(adminOrgRangeSql).append(") or cal_cmpCalOrg.id in ( ").append(adminOrgRangeSql).append(")) ");
        } else if ("006".equals(scheme) && isUpdate) {
            str.append("(").append(adminKey).append(" in (").append(adminOrgRangeSql).append(") or (cmpCalOrg.cluOrg is not null and cmpCalOrgUnit.id in ( ").append(adminOrgRangeSql).append("))) ");
        } else {
            str.append(adminKey).append(" in (").append(adminOrgRangeSql).append(") ");
        }
        str.append(" and ").append(hrKey).append(" in (").append(hrOrgRangeSQL).append(") and ").append(useDefault).append(" = 1 ");
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(str.toString());
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getAdminOuterFilter(Context ctx, String permItemId, String scheme) {
        String hrOrgRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String hrKey = "cal_hrOrgUnit.id";
        String defaultKey = "cmp_CTB.useDefault";
        if ("006".equals(scheme)) {
            hrKey = "cmpHROrgUnit.id";
            defaultKey = "cmpEmpORelation.useDefault";
        } else if ("008".equals(scheme)) {
            hrKey = "soc_hrOrg.id";
            defaultKey = "soc_record.useDefault";
        }
        StringBuilder str = new StringBuilder();
        str.append(" ").append(hrKey).append(" in (").append(hrOrgRangeSQL).append(") and (").append(defaultKey).append(" = 0 or ").append(defaultKey).append(" is null)");
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(str.toString());
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getPersonFilterFor006(Context ctx, String permItemId, String adminOrgRange) {
        FilterInfo filterInfo = null;
        try {
            filterInfo = CmpConstants.ADMIN_ORG_INNER.equalsIgnoreCase(adminOrgRange) ? CmpSchemeFilter.getAdminInnerFiler(ctx, permItemId, "006") : (CmpConstants.ADMIN_ORG_OUTER.equalsIgnoreCase(adminOrgRange) ? CmpSchemeFilter.getAdminOuterFilter(ctx, permItemId, "006") : CmpSchemeFilter.getAdminAllFilerFor008And006(ctx, permItemId, "006"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getPersonFilterFor008(Context ctx, String permItemId, String adminOrgRange) {
        FilterInfo filterInfo = null;
        try {
            filterInfo = adminOrgRange.equalsIgnoreCase(CmpConstants.ADMIN_ORG_INNER) ? CmpSchemeFilter.getAdminInnerFiler(ctx, permItemId, "008") : (adminOrgRange.equalsIgnoreCase(CmpConstants.ADMIN_ORG_OUTER) ? CmpSchemeFilter.getAdminOuterFilter(ctx, permItemId, "008") : CmpSchemeFilter.getAdminAllFilerFor008And006(ctx, permItemId, "008"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getAdminAllFilerFor008And006(Context ctx, String permItemId, String scheme) {
        String adminOrgRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String adminKey = "soc_adminOrg.id";
        String hrKey = "soc_hrOrg.id";
        String useDefault = "soc_record.useDefault";
        if (scheme.equals("006")) {
            adminKey = "adminOrgUnit.id";
            hrKey = "cmpHROrgUnit.id";
            useDefault = "cmpEmpORelation.useDefault";
        }
        StringBuilder str = new StringBuilder();
        str.append(hrKey).append(" in (").append(hrOrgRangeSQL).append(") ");
        str.append(" and ( ").append(adminKey).append(" in (").append(adminOrgRangeSql).append(") ");
        str.append(" or (").append(useDefault).append(" = 0 or ").append(useDefault).append(" is null))");
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(str.toString());
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getFastFilterInner(Context ctx, String permItemId, String adminOrgKey, String hrOrgKey) {
        String adminOrgRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        StringBuilder str = new StringBuilder();
        str.append(adminOrgKey).append(" in (").append(adminOrgRangeSql).append(") ");
        str.append(" and ").append(hrOrgKey).append(" in (").append(hrOrgRangeSQL).append(")");
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(str.toString());
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static String getUserHeadOfDepartmentAdminRangeSQL(Context ctx, String userId, String permItemId) {
        return SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
    }

    public static String getUserHeadOfDepartmentAdminRangeSQL(Context ctx, String permItemId) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        return SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
    }

    public static Set<String> getUserHeadOfDepartmentAdminRangeSet(Context ctx, String permItemId) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        return SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSet((Context)ctx, (String)userId, (String)permItemId);
    }

    public static FilterInfo getFastFilterInnerByUseId(Context ctx, String permItemId, String userId, String adminOrgKey, String hrOrgKey) {
        String adminOrgRangeSql = SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
        String hrOrgRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        StringBuilder str = new StringBuilder();
        str.append(adminOrgKey).append(" in (").append(adminOrgRangeSql).append(") ");
        str.append(" and ").append(hrOrgKey).append(" in (").append(hrOrgRangeSQL).append(")");
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(str.toString());
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getFastFilterInner(Context ctx, String permItemId, String adminOrgKey, String adminOrgRangeSql, String hrOrgKey) {
        String hrOrgRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        StringBuilder str = new StringBuilder();
        str.append(adminOrgKey).append(" in (").append(adminOrgRangeSql).append(") ");
        str.append(" and ").append(hrOrgKey).append(" in (").append(hrOrgRangeSQL).append(")");
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(str.toString());
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getFastFilterOuter(Context ctx, String permItemId, String hrOrgKey, String useDefault) {
        String hrOrgRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        StringBuilder str = new StringBuilder();
        str.append(" ").append(hrOrgKey).append(" in (").append(hrOrgRangeSQL).append(") and (").append(useDefault).append(" = 0 or ").append(useDefault).append(" is null)");
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(str.toString());
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getPersonFilterForList(Context ctx, String permItemId, String adminOrgRange, String adminOrgKey, String hrOrgKey, String useDefault) {
        String adminOrgRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        FilterInfo filterInfo = null;
        StringBuffer str = new StringBuffer();
        str.append(adminOrgKey + " in (").append(adminOrgRangeSql).append(") ");
        str.append(" and " + hrOrgKey + " in (" + hrOrgRangeSQL + ") and " + useDefault + " = 1 ");
        String inner = str.toString();
        str = new StringBuffer();
        str.append(" " + hrOrgKey + " in (" + hrOrgRangeSQL + ") and " + useDefault + " = 0 ");
        String outer = str.toString();
        try {
            if (adminOrgRange.equalsIgnoreCase(CmpConstants.ADMIN_ORG_INNER)) {
                filterInfo = new FilterInfo(inner);
            } else if (adminOrgRange.equalsIgnoreCase(CmpConstants.ADMIN_ORG_OUTER)) {
                filterInfo = new FilterInfo(outer);
            } else {
                filterInfo = new FilterInfo(inner);
                filterInfo.mergeFilter(new FilterInfo(outer), "or");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getPersonFilterForList(Context ctx, String permItemId, String adminOrgRange, String adminOrgKey, String hrOrgKey, String useDefault, boolean adminIsNull) {
        String adminOrgRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        FilterInfo filterInfo = null;
        StringBuffer str = new StringBuffer();
        if (adminIsNull) {
            str.append("(" + adminOrgKey + " in (").append(adminOrgRangeSql).append(") ");
            str.append(" or " + adminOrgKey + " is null) ");
        } else {
            str.append(adminOrgKey + " in (").append(adminOrgRangeSql).append(") ");
        }
        str.append(" and " + hrOrgKey + " in (" + hrOrgRangeSQL + ") and " + useDefault + " = 1 ");
        String inner = str.toString();
        str = new StringBuffer();
        str.append(" " + hrOrgKey + " in (" + hrOrgRangeSQL + ") and " + useDefault + " = 0 ");
        String outer = str.toString();
        try {
            if (adminOrgRange.equalsIgnoreCase(CmpConstants.ADMIN_ORG_INNER)) {
                filterInfo = new FilterInfo(inner);
            } else if (adminOrgRange.equalsIgnoreCase(CmpConstants.ADMIN_ORG_OUTER)) {
                filterInfo = new FilterInfo(outer);
            } else {
                filterInfo = new FilterInfo(inner);
                filterInfo.mergeFilter(new FilterInfo(outer), "or");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static String getPersonCalSchemePerm(Context ctx, String permItemId, boolean isEdit) throws EASBizException {
        return CmpSchemeFilter.getPersonCalSchemePerm(ctx, permItemId, isEdit, false);
    }

    public static String getReportPersonCalSchemePerm(Context ctx, String permItemId, boolean isEdit) throws EASBizException {
        return CmpSchemeFilter.getPersonCalSchemePerm(ctx, permItemId, isEdit, true);
    }

    public static String getPersonCalSchemePerm(Context ctx, String permItemId, boolean isEdit, boolean isReport) throws EASBizException {
        StringBuilder calSchemePerm = new StringBuilder();
        String adminOrgRangeSql = null;
        adminOrgRangeSql = isReport ? CmpSchemeFilter.getStraightAdminOrgUnitRangeSql(ctx, permItemId) : CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgUnitRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String userID = HRFilterUtils.getCurrentUserId((Context)ctx);
        String personid = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (StringUtils.isEmpty((String)personid)) {
            calSchemePerm.append("select FID from T_HR_SCalScheme ");
            calSchemePerm.append("where FAdminOrgUnitID in (" + adminOrgRangeSql + ") ");
            calSchemePerm.append(" and FHrOrgUnitID in (");
            calSchemePerm.append(hrOrgUnitRangeSQL).append(") ");
            return calSchemePerm.toString();
        }
        try {
            String permOql = "select hrOrgUnit.id where person.id='" + personid + "' and hrOrgUnit.id in(" + hrOrgUnitRangeSQL + ") and isCalSchemePerm = 1";
            boolean isDataPerm = CmpSalaryDataPermFactory.getLocalInstance(ctx).exists(permOql);
            if (isDataPerm) {
                StringBuilder hrBuf = new StringBuilder();
                CmpSalaryDataPermCollection salaryPermColletion = CmpSalaryDataPermFactory.getLocalInstance(ctx).getCmpSalaryDataPermCollection(permOql);
                if (salaryPermColletion != null && salaryPermColletion.size() > 0) {
                    for (int i = 0; i < salaryPermColletion.size(); ++i) {
                        CmpSalaryDataPermInfo salaryDataPermInfo = salaryPermColletion.get(i);
                        hrBuf.append(",'").append(salaryDataPermInfo.getHrOrgUnit().getId().toString()).append("'");
                    }
                }
                String permHrOrg = hrBuf.substring(1);
                calSchemePerm.append("select FID from T_HR_SCalScheme ");
                calSchemePerm.append("where FAdminOrgUnitID in (" + adminOrgRangeSql + ") ");
                calSchemePerm.append(" and FHrOrgUnitID in (");
                calSchemePerm.append(hrOrgUnitRangeSQL).append(") and FHrOrgUnitID not in(");
                calSchemePerm.append(permHrOrg).append(")");
                calSchemePerm.append(" union ");
                calSchemePerm.append("select FCalSchemeId from T_HR_SCmpCalSchemeDataPerm where FPersonId = '");
                calSchemePerm.append(personid);
                calSchemePerm.append("' and FHrOrgUnitId in (");
                calSchemePerm.append(permHrOrg);
                calSchemePerm.append(")");
                if (isEdit) {
                    calSchemePerm.append(" and FIsEdit = 1");
                }
                calSchemePerm.append(" union ");
                calSchemePerm.append("select FID from T_HR_SCalScheme where  FCreatorid='");
                calSchemePerm.append(userID).append("' and FAdminOrgUnitID in (");
                calSchemePerm.append(adminOrgRangeSql);
                calSchemePerm.append(") and FHrOrgUnitID in (");
                calSchemePerm.append(permHrOrg);
                calSchemePerm.append(")");
            } else {
                calSchemePerm.append("select FID from T_HR_SCalScheme ");
                calSchemePerm.append("where FAdminOrgUnitID in (" + adminOrgRangeSql + ") ");
                calSchemePerm.append(" and FHrOrgUnitID in (");
                calSchemePerm.append(hrOrgUnitRangeSQL).append(") ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return calSchemePerm.toString();
    }

    public static String getSchemePermByHRO(Context ctx, String permItemId, String hrOrgId, boolean isEdit) throws EASBizException {
        return CmpSchemeFilter.getSchemePermByHRO(ctx, permItemId, hrOrgId, isEdit, false);
    }

    public static String getReportSchemePermByHRO(Context ctx, String permItemId, String hrOrgId, boolean isEdit) throws EASBizException {
        return CmpSchemeFilter.getSchemePermByHRO(ctx, permItemId, hrOrgId, isEdit, true);
    }

    public static String getSchemePermByHRO(Context ctx, String permItemId, String hrOrgId, boolean isEdit, boolean isReport) throws EASBizException {
        StringBuffer calSchemePerm = new StringBuffer();
        String adminOrgRangeSql = null;
        adminOrgRangeSql = isReport ? CmpSchemeFilter.getStraightAdminOrgUnitRangeSql(ctx, permItemId) : CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String userID = HRFilterUtils.getCurrentUserId((Context)ctx);
        String personid = HRFilterUtils.getCurrentPersonId((Context)ctx);
        calSchemePerm.append("select FID from T_HR_SCalScheme ");
        calSchemePerm.append("where FHrOrgUnitID in ('" + hrOrgId + "') ");
        if (!CmpBizHelper.isSysAdminOperate(ctx)) {
            calSchemePerm.append(" and FAdminOrgUnitID in (");
            calSchemePerm.append(adminOrgRangeSql).append(")");
        }
        if (StringUtils.isEmpty((String)personid)) {
            return calSchemePerm.toString();
        }
        try {
            String permOql = "select hrOrgUnit.id where person.id='" + personid + "' and hrOrgUnit.id in('" + hrOrgId + "') and isCalSchemePerm = 1";
            boolean isDataPerm = CmpSalaryDataPermFactory.getLocalInstance(ctx).exists(permOql);
            if (isDataPerm) {
                calSchemePerm.append(" and FCreatorid='").append(userID).append("'");
                calSchemePerm.append(" union ");
                calSchemePerm.append("select FCalSchemeId from T_HR_SCmpCalSchemeDataPerm where FPersonId = '");
                calSchemePerm.append(personid);
                calSchemePerm.append("' and FHrOrgUnitId in ('");
                calSchemePerm.append(hrOrgId);
                calSchemePerm.append("')");
                if (isEdit) {
                    calSchemePerm.append(" and FIsEdit = 1");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return calSchemePerm.toString();
    }

    public static String getSchemePerm(Context ctx, String permItemId) {
        StringBuilder calSchemePerm = new StringBuilder();
        String adminOrgRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String userID = HRFilterUtils.getCurrentUserId((Context)ctx);
        String personid = HRFilterUtils.getCurrentPersonId((Context)ctx);
        String hrOrgId = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        calSchemePerm.append("select FID from T_HR_SCalScheme ");
        calSchemePerm.append("where FHrOrgUnitID in (" + hrOrgId + ") ");
        if (!CmpBizHelper.isSysAdminOperate(ctx)) {
            calSchemePerm.append(" and FAdminOrgUnitID in (");
            calSchemePerm.append(adminOrgRangeSql).append(")");
        }
        if (StringUtils.isEmpty((String)personid)) {
            return calSchemePerm.toString();
        }
        try {
            String permOql = "select hrOrgUnit.id where person.id='" + personid + "' and hrOrgUnit.id in (" + hrOrgId + ") and isCalSchemePerm = 1";
            boolean isDataPerm = CmpSalaryDataPermFactory.getLocalInstance(ctx).exists(permOql);
            if (isDataPerm) {
                calSchemePerm.append(" and FCreatorid='").append(userID).append("'");
                calSchemePerm.append(" union ");
                calSchemePerm.append("select FCalSchemeId from T_HR_SCmpCalSchemeDataPerm where FPersonId = '");
                calSchemePerm.append(personid);
                calSchemePerm.append("' and FHrOrgUnitId in (");
                calSchemePerm.append(hrOrgId);
                calSchemePerm.append(")");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return calSchemePerm.toString();
    }

    public static FilterInfo getFilterFor016(Context ctx, String permItemId, CalSchemeInfo calSchemeInfo) {
        String adminOrgRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        StringBuilder str = new StringBuilder();
        str.append("adminOrgUnit.id").append(" in (").append(adminOrgRangeSql).append(")  ");
        str.append(" and ").append("cmpHROrgUnit.id").append(" in (").append(hrOrgRangeSQL).append(")  ");
        FilterInfo filterInfo = null;
        Date endDate = calSchemeInfo.getEndDate();
        String oqlEndDate = CmpDateUtil.toKSqlDate(endDate);
        try {
            filterInfo = new FilterInfo(str.toString());
            filterInfo.mergeFilter(new FilterInfo("newEmpPos.effdt<=" + oqlEndDate), "AND");
            filterInfo.mergeFilter(new FilterInfo("personburelaconfirm.bizManageType='UEVgqLoZwEWW4Kq+2LWYL2WJ1dE='"), "AND");
            filterInfo.mergeFilter(new FilterInfo("personburelaconfirm.bizDefineType !=43  "), "AND");
            filterInfo.mergeFilter(new FilterInfo("personburelaconfirm.affairActionOperate NOT IN (20,70)  "), "AND");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return filterInfo;
    }

    public static FilterInfo getFilterFor001(Context ctx, String permItemId) {
        String adminOrgRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        StringBuilder str = new StringBuilder();
        str.append("adminOrgUnit.id").append(" in (").append(adminOrgRangeSql).append(")  ");
        str.append(" and ").append("personcmp.hrorgunit").append(" in (").append(hrOrgRangeSQL).append(")  ");
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(str.toString());
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
        return filterInfo;
    }
}

