/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.db.query;

import com.kingdee.shr.common.util.CloseUtil;
import com.kingdee.shr.data.domain.util.SQLHelperUtils;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;

public abstract class AbstractQueryRunner {
    private volatile boolean pmdKnownBroken = false;

    public AbstractQueryRunner(boolean pmdKnownBroken) {
        this.pmdKnownBroken = pmdKnownBroken;
    }

    public boolean isPmdKnownBroken() {
        return this.pmdKnownBroken;
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql, int returnedKeys) throws SQLException {
        return conn.prepareStatement(sql, returnedKeys);
    }

    protected abstract Connection prepareConnection() throws SQLException;

    public void fillStatement(PreparedStatement stmt, Object ... params) throws SQLException {
        int i;
        ParameterMetaData pmd = null;
        if (!this.pmdKnownBroken) {
            int sqlType;
            pmd = stmt.getParameterMetaData();
            i = pmd.getParameterCount();
            int n = sqlType = params == null ? 0 : params.length;
            if (i != sqlType) {
                throw new SQLException("Wrong number of parameters: expected " + i + ", was given " + sqlType);
            }
        }
        if (params != null) {
            for (i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                SQLHelperUtils.setParams(stmt, i + 1, params[i]);
            }
        }
    }

    protected void rethrow(SQLException cause, String sql, Object ... params) throws SQLException {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuilder msg = new StringBuilder(causeMessage);
        msg.append(" Sql3 execute exception: ");
        msg.append(sql);
        msg.append(" Parameters: ");
        if (params == null) {
            msg.append("[]");
        } else {
            msg.append(Arrays.deepToString(params));
        }
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }

    protected ResultSet wrap(ResultSet rs) {
        return rs;
    }

    protected void close(Connection conn) {
        CloseUtil.close(conn);
    }

    protected void close(Statement stmt) {
        CloseUtil.close(stmt);
    }

    protected void close(ResultSet rs) {
        CloseUtil.close(rs);
    }
}

