/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataplatform.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.common.util.SQLVerifyUtils;
import com.kingdee.shr.dataplatform.CustomSQLInfo;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.app.AbstractCustomSQLControllerBean;
import com.kingdee.shr.dataplatform.cache.DataplatformCacheHelper;
import com.kingdee.shr.dataset.model.CustomSQLItem;
import com.kingdee.shr.dataset.util.DataSetUtils;
import org.apache.log4j.Logger;

public class CustomSQLControllerBean
extends AbstractCustomSQLControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.dataplatform.app.CustomSQLControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CustomSQLInfo info = (CustomSQLInfo)model;
        CustomSQLItem customSQLItem = (CustomSQLItem)JSONUtils.convertJsonToObject((Context)ctx, (String)info.getContent(), CustomSQLItem.class);
        if (null != customSQLItem && !customSQLItem.isUseSourceSQLQuery() && SQLVerifyUtils.isOrderBy(customSQLItem.getSql().getText(), ctx)) {
            throw new DataSetException(DataSetException.ORDER_EXIST);
        }
        DataSetUtils.checkNumberRule(info.getNumber());
        info.setIsKSQL(true);
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        DataplatformCacheHelper.remove(ctx, 5, DataplatformCacheHelper.getRealKey(ctx, "DATAPLATFORM_DATASET_CUSTOMSQL_TREE"));
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isPreset", (Object)1));
        if (this._exists(ctx, filter)) {
            throw new DataSetException(DataSetException.PRESET_CUSTOM_NOT_DELETE);
        }
        super._delete(ctx, pk);
        DataplatformCacheHelper.remove(ctx, 5, DataplatformCacheHelper.getRealKey(ctx, "DATAPLATFORM_DATASET_CUSTOMSQL_TREE"));
    }
}

