/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataplatform.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.dataplatform.DataSetConfigExtFactory;
import com.kingdee.shr.dataplatform.DataSetConfigFactory;
import com.kingdee.shr.dataplatform.DataSetConfigInfo;
import com.kingdee.shr.dataplatform.DataSetConfigRoleFactory;
import com.kingdee.shr.dataplatform.DataSetConfigRoleInfo;
import com.kingdee.shr.dataplatform.DataSetConfigUserFactory;
import com.kingdee.shr.dataplatform.DataSetConfigUserInfo;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.IDataSetConfig;
import com.kingdee.shr.dataplatform.IDataSetConfigExt;
import com.kingdee.shr.dataplatform.IDataSetConfigRole;
import com.kingdee.shr.dataplatform.IDataSetConfigUser;
import com.kingdee.shr.dataplatform.app.AbstractDataSetConfigFacadeControllerBean;
import com.kingdee.shr.dataset.util.DataSetUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DataSetConfigFacadeControllerBean
extends AbstractDataSetConfigFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.dataplatform.app.DataSetConfigFacadeControllerBean");
    private static final int COUNT = 500;

    @Override
    protected void _distributeUserDataSet(Context ctx, String dataSetIds, String userIds) throws BOSException, EASBizException {
        String[] uIds;
        String[] dIds = dataSetIds.split(",");
        if (dIds.length * (uIds = userIds.split(",")).length > 500) {
            this.distributeUserDataSetByTempTable(ctx, dIds, uIds);
        } else {
            this.distributeUserDataSetByExists(ctx, dIds, uIds);
        }
    }

    @Override
    protected void _distributeRoleDataSet(Context ctx, String dataSetIds, String roleIds) throws BOSException, EASBizException {
        String[] rIds;
        String[] dIds = dataSetIds.split(",");
        if (dIds.length * (rIds = roleIds.split(",")).length > 500) {
            this.distributeRoleDataSetByTempTable(ctx, dIds, rIds);
        } else {
            this.distributeRoleDataSetByExists(ctx, dIds, rIds);
        }
    }

    @Override
    protected void _cancelDistribute(Context ctx, String billIds, int type) throws BOSException, EASBizException {
        String[] ids = billIds.split(",");
        IObjectPK[] objectPKArr = this.getIObjectPkArr(ids);
        if (1 == type) {
            DataSetConfigUserFactory.getLocalInstance(ctx).deleteBatchData(objectPKArr);
        } else if (2 == type) {
            DataSetConfigRoleFactory.getLocalInstance(ctx).deleteBatchData(objectPKArr);
        }
    }

    @Override
    public String resetConfig(Context ctx, String dataSetId) throws BOSException, EASBizException {
        IDataSetConfig iDataSetConfig = DataSetConfigFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)dataSetId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isPreset", (Object)true));
        if (!iDataSetConfig.exists(filterInfo)) {
            throw new DataSetException(DataSetException.EXTEND_EXIST_NON);
        }
        IDataSetConfigExt iDataSetConfigExt = DataSetConfigExtFactory.getLocalInstance(ctx);
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)dataSetId));
        if (!iDataSetConfigExt.exists(filterInfo)) {
            throw new DataSetException(DataSetException.EXTEND_EXIST_NON);
        }
        IObjectPK[] pk = iDataSetConfigExt.delete(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("content"));
        selector.add(new SelectorItemInfo("datasource"));
        selector.add(new SelectorItemInfo("setType"));
        ObjectUuidPK dataSetPk = new ObjectUuidPK(dataSetId);
        DataSetConfigInfo info = DataSetConfigFactory.getLocalInstance(ctx).getDataSetConfigInfo((IObjectPK)dataSetPk, selector);
        DataSetUtils.saveSQLResultInfo(ctx, (IObjectPK)dataSetPk, info.getContent(), info.getDatasource().getId().toString(), info.getSetType());
        return String.valueOf(pk[0]);
    }

    private void distributeUserDataSetByTempTable(Context ctx, String[] dataSetIds, String[] userIds) throws BOSException {
        String tempTableName = null;
        StringBuffer insertSql = new StringBuffer(200);
        try {
            List<Object> params = this.createParams(dataSetIds, userIds);
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            String createTableSql = "Create Table " + tempTableName + " (FUserID VARCHAR(44),FDataSetID VARCHAR(44))";
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
            DbUtil.executeBatch((Context)ctx, (String)("insert into " + tempTableName + "(FUserID,FDataSetID) values(?,?)"), params);
            insertSql.append("INSERT INTO T_SHR_DataSetConfigUser (FID,FUserID,FDataSetID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID)").append(" SELECT newbosid('FC2287C6'),FUserID,FDataSetID,now(),now()").append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("','").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("','").append(HRFilterUtils.getCurrentCU((Context)ctx).getId().toString()).append("' FROM ").append(tempTableName).append(" t1 where not exists (select 1 from T_SHR_DataSetConfigUser t2 where t1.FUserID = t2.FUserID and t1.FDataSetID = t2.FDataSetID)");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            if (!StringUtils.isEmpty((String)tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                tempTableName = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)insertSql);
            throw new BOSException(e.getMessage());
        }
        finally {
            if (!StringUtils.isEmpty(tempTableName)) {
                this.dropTable(ctx, tempTableName);
            }
        }
    }

    private void distributeUserDataSetByExists(Context ctx, String[] dataSetIds, String[] userIds) throws BOSException, EASBizException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        CoreBaseCollection dataSetUserCollection = new CoreBaseCollection();
        IDataSetConfigUser iDataSetConfigUser = DataSetConfigUserFactory.getLocalInstance(ctx);
        for (int i = 0; i < dataSetIds.length; ++i) {
            String dataSetId = dataSetIds[i];
            DataSetConfigInfo dataSetConfigInfoInfo = new DataSetConfigInfo();
            dataSetConfigInfoInfo.setId(BOSUuid.read((String)dataSetId));
            for (int j = 0; j < userIds.length; ++j) {
                String userId = userIds[j];
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)userId));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("dataset.id", (Object)dataSetId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId, CompareType.EQUALS));
                if (iDataSetConfigUser.exists(filterInfo)) continue;
                DataSetConfigUserInfo dataSetConfigUserInfo = new DataSetConfigUserInfo();
                dataSetConfigUserInfo.setDataset(dataSetConfigInfoInfo);
                dataSetConfigUserInfo.setUser(userInfo);
                dataSetConfigUserInfo.setCreateTime(timestamp);
                dataSetConfigUserInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                dataSetConfigUserInfo.setLastUpdateTime(timestamp);
                dataSetConfigUserInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                dataSetConfigUserInfo.setCU(HRFilterUtils.getCurrentCU((Context)ctx));
                dataSetUserCollection.add((CoreBaseInfo)dataSetConfigUserInfo);
            }
        }
        iDataSetConfigUser.saveBatchData(dataSetUserCollection);
    }

    private void distributeRoleDataSetByTempTable(Context ctx, String[] dataSetIds, String[] roleIds) throws BOSException {
        String tempTableName = null;
        StringBuffer insertSql = new StringBuffer(200);
        try {
            List<Object> params = this.createParams(dataSetIds, roleIds);
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            String createTableSql = "Create Table " + tempTableName + " (FRoleID VARCHAR(44),FDataSetID VARCHAR(44))";
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
            DbUtil.executeBatch((Context)ctx, (String)("insert into " + tempTableName + "(FRoleID,FDataSetID) values(?,?)"), params);
            insertSql.append("INSERT INTO T_SHR_DataSetConfigRole (FID,FRoleID,FDataSetID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID)").append(" SELECT newbosid('FC211C71'),FRoleID,FDataSetID,now(),now()").append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("','").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("','").append(HRFilterUtils.getCurrentCU((Context)ctx).getId().toString()).append("' FROM ").append(tempTableName).append(" t1 where not exists (select 1 from T_SHR_DataSetConfigRole t2 where t1.FRoleID = t2.FRoleID and t1.FDataSetID = t2.FDataSetID)");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            if (!StringUtils.isEmpty((String)tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                tempTableName = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)insertSql);
            throw new BOSException(e.getMessage());
        }
        finally {
            if (!StringUtils.isEmpty(tempTableName)) {
                this.dropTable(ctx, tempTableName);
            }
        }
    }

    private void distributeRoleDataSetByExists(Context ctx, String[] dataSetIds, String[] roleIds) throws BOSException, EASBizException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        CoreBaseCollection dataSetConfigRoleCollection = new CoreBaseCollection();
        IDataSetConfigRole iDataSetConfigRole = DataSetConfigRoleFactory.getLocalInstance(ctx);
        for (int i = 0; i < dataSetIds.length; ++i) {
            String dataSetId = dataSetIds[i];
            DataSetConfigInfo dataSetConfigInfo = new DataSetConfigInfo();
            dataSetConfigInfo.setId(BOSUuid.read((String)dataSetId));
            for (int j = 0; j < roleIds.length; ++j) {
                String roleId = roleIds[j];
                RoleInfo roleInfo = new RoleInfo();
                roleInfo.setId(BOSUuid.read((String)roleId));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("dataset.id", (Object)dataSetId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("role.id", (Object)roleId, CompareType.EQUALS));
                if (iDataSetConfigRole.exists(filterInfo)) continue;
                DataSetConfigRoleInfo dataSetConfigRoleInfo = new DataSetConfigRoleInfo();
                dataSetConfigRoleInfo.setDataset(dataSetConfigInfo);
                dataSetConfigRoleInfo.setRole(roleInfo);
                dataSetConfigRoleInfo.setCreateTime(timestamp);
                dataSetConfigRoleInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                dataSetConfigRoleInfo.setLastUpdateTime(timestamp);
                dataSetConfigRoleInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                dataSetConfigRoleInfo.setCU(HRFilterUtils.getCurrentCU((Context)ctx));
                dataSetConfigRoleCollection.add((CoreBaseInfo)dataSetConfigRoleInfo);
            }
        }
        iDataSetConfigRole.saveBatchData(dataSetConfigRoleCollection);
    }

    private List<Object> createParams(String[] dataSetIds, String[] ids) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < dataSetIds.length; ++i) {
            for (int j = 0; j < ids.length; ++j) {
                Object[] objArr = new Object[]{ids[j], dataSetIds[i]};
                params.add(objArr);
            }
        }
        return params;
    }

    private IObjectPK[] getIObjectPkArr(String[] billIds) {
        IObjectPK[] objectPKArr = new IObjectPK[billIds.length];
        for (int i = 0; i < billIds.length; ++i) {
            objectPKArr[i] = new ObjectUuidPK(BOSUuid.read((String)billIds[i]));
        }
        return objectPKArr;
    }

    private void dropTable(Context ctx, String tempTableName) throws BOSException {
        if (!StringUtils.isEmpty((String)tempTableName)) {
            DbUtil.execute((Context)ctx, (String)("TRUNCATE TABLE " + tempTableName));
            DbUtil.execute((Context)ctx, (String)("DROP TABLE " + tempTableName));
        }
    }
}

