/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataplatform.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemURLCollection;
import com.kingdee.eas.base.permission.PermItemURLFactory;
import com.kingdee.eas.base.permission.PermItemURLInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.IUIView;
import com.kingdee.shr.base.syssetting.ListQuerySchemeTypeEnum;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.UIViewTreeInfo;
import com.kingdee.shr.base.syssetting.util.FreemarkerUtils;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.dataplatform.CardConfigFactory;
import com.kingdee.shr.dataplatform.DataSetConfigExtFactory;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.IPageConfigExt;
import com.kingdee.shr.dataplatform.IWorkPFSolution;
import com.kingdee.shr.dataplatform.PageConfigCollection;
import com.kingdee.shr.dataplatform.PageConfigException;
import com.kingdee.shr.dataplatform.PageConfigExtCollection;
import com.kingdee.shr.dataplatform.PageConfigExtFactory;
import com.kingdee.shr.dataplatform.PageConfigExtInfo;
import com.kingdee.shr.dataplatform.PageConfigInfo;
import com.kingdee.shr.dataplatform.WorkPFSolutionCollection;
import com.kingdee.shr.dataplatform.WorkPFSolutionFactory;
import com.kingdee.shr.dataplatform.WorkPFSolutionInfo;
import com.kingdee.shr.dataplatform.app.AbstractPageConfigControllerBean;
import com.kingdee.shr.pageset.util.PageSetUtils;
import com.kingdee.util.StringUtils;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PageConfigControllerBean
extends AbstractPageConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.dataplatform.app.PageConfigControllerBean");
    private static final String DESIGN_PAGE_UIPK = "shr.workplatform.homepage";
    private static final String DEFAULT_FILE_TEMPLATE = "uiViewTemplateForWorkPlatform.ftl";
    private static final String DEFAULT_INNER_UIPK_RULE = "com.kingdee.shr.{0}.inner.work";
    private static final String DEFAULT_OUTER_UIPK_RULE = "com.kingdee.shr.{0}.outer.work";
    private static final String DEFAULT_OUTER_TREE_TYPE_UIVIEW = "4hUAAAAat+h3Uzxx";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isExtend = false;
        PageConfigInfo info = (PageConfigInfo)model;
        String extend = info.getExtend();
        String content = info.getContent();
        if (StringUtils.isEmpty((String)extend) && StringUtils.isEmpty((String)content)) {
            throw new PageConfigException(DataSetException.CONTENT_OR_EXTEND_NON);
        }
        if (info.isIsPreSet() && StringUtils.isEmpty((String)info.getContent())) {
            throw new PageConfigException(DataSetException.CONTEND_PRESET_NON);
        }
        String uipk = info.getUipk();
        if (StringUtils.isEmpty((String)uipk)) {
            uipk = this.generateUIviewAndPerm(ctx, info);
            info.setUipk(uipk);
        }
        if (!StringUtils.isEmpty((String)extend)) {
            isExtend = true;
            info.setExtend(null);
        }
        ObjectUuidPK pk = null;
        boolean isProductionMode = (Boolean)info.get("isProductionMode");
        if (null != info.getId() && info.isIsPreSet() && isProductionMode) {
            pk = new ObjectUuidPK(info.getId());
        } else {
            CoreBaseCollection coll = this.getCardCollection(ctx, info, content, false);
            pk = super._save(ctx, (IObjectValue)info);
            info.setId(BOSUuid.read((String)pk.toString()));
            CardConfigFactory.getLocalInstance(ctx).saveBatchDataByPage((IObjectCollection)coll, (IObjectValue)info);
        }
        if (isProductionMode || !info.isIsPreSet()) {
            this.saveExtend(ctx, info, extend, isExtend);
            this.saveExtendUiview(ctx, uipk);
        }
        return pk;
    }

    private void saveExtendUiview(Context ctx, String uipk) throws BOSException, EASBizException {
        IUIView iUIview = UIViewFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("uipk", (Object)uipk));
        if (iUIview.exists(filter)) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            UIViewInfo viewInfo = iUIview.getValueByUipk(uipk, selector);
            if (StringUtils.isEmpty((String)viewInfo.getExtend())) {
                viewInfo.setExtend(viewInfo.getContent());
                iUIview.extendSave(viewInfo);
            }
        }
    }

    private void saveExtend(Context ctx, PageConfigInfo pModel, String extend, boolean isExtend) throws BOSException, EASBizException {
        IPageConfigExt iPageConfigExt = PageConfigExtFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pModel.getId().toString()));
        PageConfigExtInfo model = null;
        if (iPageConfigExt.exists(filter)) {
            if (!isExtend) {
                iPageConfigExt.delete(filter);
                return;
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            PageConfigExtCollection coll = iPageConfigExt.getPageConfigExtCollection(viewInfo);
            if (null != coll && !coll.isEmpty()) {
                model = coll.get(0);
                if (coll.size() > 1) {
                    iPageConfigExt.delete(filter);
                }
            }
        } else {
            if (!isExtend) {
                return;
            }
            model = new PageConfigExtInfo();
            model.setParent(pModel);
        }
        CoreBaseCollection coll = this.getCardCollection(ctx, pModel, extend, true);
        if (null != model) {
            if (!StringUtils.isEmpty((String)pModel.getExtend())) {
                model.setContent(pModel.getExtend());
            } else {
                model.setContent(extend);
            }
        }
        iPageConfigExt.save((CoreBaseInfo)model);
        pModel.setExtend(extend);
        CardConfigFactory.getLocalInstance(ctx).saveBatchDataByPage((IObjectCollection)coll, (IObjectValue)pModel);
    }

    private CoreBaseCollection getCardCollection(Context ctx, PageConfigInfo info, String content, boolean isExtend) throws BOSException, EASBizException {
        CoreBaseCollection coll = new CoreBaseCollection();
        PageSetUtils.getCards(ctx, null, info, content, coll, isExtend);
        return coll;
    }

    private String generateUIviewAndPerm(Context ctx, PageConfigInfo pageInfo) throws EASBizException, BOSException {
        String uipk = this.generateWorkPlatformUiVew(ctx, pageInfo);
        return uipk;
    }

    private String generateWorkPlatformUiVew(Context ctx, PageConfigInfo page) throws EASBizException, BOSException {
        String templateStr = this.generateWorkPlatformTemplate();
        boolean isProductionMode = (Boolean)page.get("isProductionMode");
        String uipk = MessageFormat.format(DEFAULT_OUTER_UIPK_RULE, page.getNumber());
        IUIView iUIView = UIViewFactory.getLocalInstance((Context)ctx);
        UIViewInfo uIViewInfo = new UIViewInfo();
        uIViewInfo.setName(page.getName());
        uIViewInfo.setType(UIType.getEnum((String)"core"));
        UIViewTreeInfo tree = new UIViewTreeInfo();
        tree.setId(BOSUuid.read((String)DEFAULT_OUTER_TREE_TYPE_UIVIEW));
        uIViewInfo.setTree(tree);
        uIViewInfo.setInner(false);
        if (isProductionMode) {
            uIViewInfo.setUri(uipk);
            uIViewInfo.setUipk(uipk);
            uIViewInfo.setExtend(templateStr);
            iUIView.extendSave(uIViewInfo);
        } else {
            uipk = MessageFormat.format(DEFAULT_INNER_UIPK_RULE, page.getNumber());
            uIViewInfo.setUri(uipk);
            uIViewInfo.setUipk(uipk);
            uIViewInfo.setContent(templateStr);
            iUIView.save((CoreBaseInfo)uIViewInfo);
        }
        return uipk;
    }

    private String generateWorkPlatformTemplate() throws BOSException {
        String templatePath = SHRSyssettingUtil.getShrUIviewTemplatePath();
        StringWriter swriter = new StringWriter();
        HashMap dataModel = new HashMap();
        String str = "";
        try {
            Template template = new FreemarkerUtils(templatePath).getTemplate(DEFAULT_FILE_TEMPLATE);
            template.process(dataModel, (Writer)swriter);
            str = swriter.toString();
        }
        catch (IOException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (TemplateException e1) {
            throw new BOSException(e1.getMessage(), (Throwable)e1);
        }
        finally {
            try {
                swriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PageConfigInfo model = (PageConfigInfo)super._getValue(ctx, pk);
        this.mergeInfo(ctx, model);
        return model;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        PageConfigInfo model = (PageConfigInfo)super._getValue(ctx, pk, selector);
        this.mergeInfo(ctx, model);
        return model;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        PageConfigInfo model = (PageConfigInfo)super._getValue(ctx, pk, selector, sorter);
        this.mergeInfo(ctx, model);
        return model;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        PageConfigInfo model = (PageConfigInfo)super._getValue(ctx, pk, sorter);
        this.mergeInfo(ctx, model);
        return model;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        PageConfigInfo model = (PageConfigInfo)super._getValue(ctx, oql);
        this.mergeInfo(ctx, model);
        return model;
    }

    @Override
    protected IObjectValue _getValueBySolution(Context ctx, IObjectPK pk, String solutionId, String uipk) throws BOSException, EASBizException {
        PageConfigInfo model = (PageConfigInfo)super._getValue(ctx, pk);
        model.put("solutionId", solutionId);
        model.put("pageUipk", uipk);
        this.mergeInfo(ctx, model);
        return model;
    }

    @Override
    public PageConfigCollection getPageConfigCollection(Context ctx, EntityViewInfo view) throws BOSException {
        PageConfigCollection coll = super.getPageConfigCollection(ctx, view);
        return this.doGetCollection(ctx, coll);
    }

    @Override
    public PageConfigCollection getPageConfigCollection(Context ctx) throws BOSException {
        PageConfigCollection coll = super.getPageConfigCollection(ctx);
        return this.doGetCollection(ctx, coll);
    }

    @Override
    public PageConfigCollection getPageConfigCollection(Context ctx, String oql) throws BOSException {
        PageConfigCollection coll = super.getPageConfigCollection(ctx, oql);
        return this.doGetCollection(ctx, coll);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isPreSet", (Object)true));
        if (this._exists(ctx, filter)) {
            throw new PageConfigException(PageConfigException.PRESET_VIEW_NOT_DELETE);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("uipk");
        selector.add("number");
        PageConfigInfo model = (PageConfigInfo)this._getValue(ctx, pk, selector);
        String uipk = model.getUipk();
        this.deleteExtInfo(ctx, pk);
        this.deleteReferCard(ctx, pk);
        this.deleteUIview(ctx, uipk);
        String parentPk = this.deletePermItemURL(ctx, uipk);
        if (!StringUtils.isEmpty((String)parentPk)) {
            this.deletePermItem(ctx, parentPk);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _deleteDev(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("uipk");
        selector.add("number");
        PageConfigInfo model = (PageConfigInfo)this._getValue(ctx, pk, selector);
        String uipk = model.getUipk();
        this.deleteExtInfo(ctx, pk);
        this.deleteReferCard(ctx, pk);
        this.deleteUIview(ctx, uipk);
        String parentPk = this.deletePermItemURL(ctx, uipk);
        if (!StringUtils.isEmpty((String)parentPk)) {
            this.deletePermItem(ctx, parentPk);
        }
        super._delete(ctx, pk);
    }

    private void deleteReferCard(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("page.id", (Object)pk.toString()));
        CardConfigFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    private String deletePermItemURL(Context ctx, String uipk) throws EASBizException, BOSException {
        String pk = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("parent.id");
        viewInfo.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("uipk", (Object)uipk));
        viewInfo.setFilter(filter);
        PermItemURLCollection coll = PermItemURLFactory.getLocalInstance((Context)ctx).getPermItemURLCollection(viewInfo);
        for (int i = 0; i < coll.size(); ++i) {
            PermItemURLInfo permItemURLInfo = coll.get(0);
            pk = permItemURLInfo.getId().toString();
        }
        PermItemURLFactory.getLocalInstance((Context)ctx).delete(filter);
        return pk;
    }

    private void deletePermItem(Context ctx, String pk) throws EASBizException, BOSException {
        PermItemFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(pk));
    }

    private void deleteUIview(Context ctx, String uipk) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("uipk", (Object)uipk));
        UIViewFactory.getLocalInstance((Context)ctx).delete(filterInfo);
    }

    private void deleteExtInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pk.toString()));
        DataSetConfigExtFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    private PageConfigCollection doGetCollection(Context ctx, PageConfigCollection coll) throws BOSException {
        if (coll != null && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                PageConfigInfo info = coll.get(i);
                this.mergeInfo(ctx, info);
            }
        }
        return coll;
    }

    private void mergeInfo(Context ctx, PageConfigInfo pageConfigInfo) throws BOSException {
        if (null == pageConfigInfo) {
            return;
        }
        String worklatfromId = PageSetUtils.getWorklatfromIdByUipk(ctx, pageConfigInfo.getUipk());
        if ("TU2Kv85SFkWPOStTPKPa/ERLkh4=".equals(worklatfromId) && !DESIGN_PAGE_UIPK.equals(pageConfigInfo.get("pageUipk"))) {
            this.mergeSolutionInfo(ctx, worklatfromId, pageConfigInfo);
            if (!StringUtils.isEmpty((String)pageConfigInfo.getExtend())) {
                return;
            }
        }
        IPageConfigExt iPageConfigExt = PageConfigExtFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pageConfigInfo.getId().toString()));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("content"));
        PageConfigExtCollection coll = iPageConfigExt.getPageConfigExtCollection(viewInfo);
        if (null != coll && !coll.isEmpty()) {
            PageConfigExtInfo info = coll.get(0);
            pageConfigInfo.setExtend(info.getContent());
        }
    }

    private void mergeSolutionInfo(Context ctx, String worklatfromId, PageConfigInfo pageConfigInfo) throws BOSException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        IWorkPFSolution iWorkPFSolution = WorkPFSolutionFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (null != pageConfigInfo.get("solutionId") && !StringUtils.isEmpty((String)pageConfigInfo.get("solutionId").toString())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pageConfigInfo.get("solutionId").toString()));
            viewInfo.setFilter(filterInfo);
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)user.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("user.id", null));
            filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
            filterInfo.getFilterItems().add(new FilterItemInfo("workplatform.id", (Object)worklatfromId));
            filterInfo.setMaskString("(#0 or #1) and #2 and #3");
            viewInfo.setFilter(filterInfo);
        }
        WorkPFSolutionCollection coll = iWorkPFSolution.getWorkPFSolutionCollection(viewInfo);
        if (null != coll && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                WorkPFSolutionInfo info = coll.get(i);
                if (ListQuerySchemeTypeEnum.USER.equals((Object)info.getType())) {
                    this.mergeSolutionField(pageConfigInfo, info);
                    return;
                }
                if (!ListQuerySchemeTypeEnum.SYSTEM.equals((Object)info.getType())) continue;
                this.mergeSolutionField(pageConfigInfo, info);
            }
        }
    }

    private void mergeSolutionField(PageConfigInfo pageConfigInfo, WorkPFSolutionInfo info) {
        pageConfigInfo.setExtend(info.getContent());
        info.setContent(null);
        pageConfigInfo.put("solution", info);
    }
}

