/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.dataplatform.SQLParseLevel;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.model.JavaResult;
import com.kingdee.shr.dataset.service.IDataQueryService;
import com.kingdee.shr.dataset.service.IJavaDataQueryService;
import com.kingdee.shr.dataset.service.util.SelectorHelper;
import java.util.List;
import java.util.Map;

public class JavaDataQueryService
implements IDataQueryService {
    @Override
    public DataResult getAllData(Context ctx, Map<String, Object> param) throws BOSException, EASBizException {
        JavaResult javaResult = (JavaResult)param.get("sqlResult");
        IJavaDataQueryService service = this.getIJavaDataQueryService(javaResult);
        return service.getAllData(ctx, this.getParams(param));
    }

    private IJavaDataQueryService getIJavaDataQueryService(JavaResult javaResult) throws BOSException {
        String clz = javaResult.getClz();
        try {
            return (IJavaDataQueryService)Class.forName(clz).newInstance();
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private JavaAPIParam getParams(Map<String, Object> param) {
        JavaAPIParam p = new JavaAPIParam();
        JavaResult javaResult = (JavaResult)param.get("sqlResult");
        p.setDesignDataSetJava(javaResult.getDesignDataSetJava());
        SelectorHelper helper = new SelectorHelper(javaResult.getDesignDataSetJava());
        List runParam = (List)param.get("runParam");
        p.setRunParam(runParam);
        String permItemId = (String)param.get("permItemId");
        p.setPermItemId(permItemId);
        p.setSqlParseLevel(javaResult.getSqlParseLevel());
        if (!SQLParseLevel.DATASET.toString().equals(javaResult.getSqlParseLevel()) && null != javaResult.getDesignDataSetJava().getInitConfig()) {
            p.setCardDimension(helper.getDimensionSelector(javaResult.getDesignDataSetJava().getSelector().getDimension(), javaResult.getDesignDataSetJava().getInitConfig()));
            p.setCardMeasure(helper.getMeasureSelector(javaResult.getDesignDataSetJava().getSelector().getMeasure(), javaResult.getDesignDataSetJava().getInitConfig()));
            javaResult.getDesignDataSetJava().getInitConfig().remove("dimension");
            javaResult.getDesignDataSetJava().getInitConfig().remove("measure");
        }
        return p;
    }

    @Override
    public DataResult getPageData(Context ctx, Map<String, Object> param) throws BOSException, EASBizException {
        JavaResult javaResult = (JavaResult)param.get("sqlResult");
        boolean isPreview = (Boolean)param.get("isPreview");
        int page = 1;
        int rows = 50;
        JavaAPIParam jp = this.getParams(param);
        if (!isPreview) {
            if (param.get("page") instanceof Integer) {
                page = (Integer)param.get("page");
            }
            if (param.get("rows") instanceof Integer) {
                rows = (Integer)param.get("rows");
            }
        }
        jp.setPage(page);
        jp.setRows(rows);
        IJavaDataQueryService service = this.getIJavaDataQueryService(javaResult);
        return service.getPageData(ctx, jp);
    }
}

