/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pageset.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.api.service.SHRCodingRuleApi;
import com.kingdee.shr.common.util.StringUtils;
import com.kingdee.shr.dataplatform.IPageConfig;
import com.kingdee.shr.dataplatform.PageConfigException;
import com.kingdee.shr.dataplatform.PageConfigFactory;
import com.kingdee.shr.dataplatform.PageConfigInfo;
import com.kingdee.shr.dataplatform.WorkPFSolutionInfo;
import com.kingdee.shr.pageset.model.Solution;
import com.kingdee.shr.pageset.util.PageSetUtils;
import java.io.Serializable;
import java.util.Map;

public class Page
implements Serializable {
    private static final long serialVersionUID = -7413811945308355299L;
    private String pageId;
    private Map<String, String> pageName;
    private String uipk;
    private boolean isPreSet;
    private boolean isProductionMode;
    private boolean isExt;
    private String schema;
    private Solution solution;
    private boolean isUserState;
    private boolean isPermission;

    public String getId() {
        return this.pageId;
    }

    public void setId(String id) {
        this.pageId = id;
    }

    public Map<String, String> getPageName() {
        return this.pageName;
    }

    public void setPageName(Map<String, String> pageName) {
        this.pageName = pageName;
    }

    public boolean isPreSet() {
        return this.isPreSet;
    }

    public void setPreSet(boolean isPreSet) {
        this.isPreSet = isPreSet;
    }

    public boolean isProductionMode() {
        return this.isProductionMode;
    }

    public void setProductionMode(boolean isProductionMode) {
        this.isProductionMode = isProductionMode;
    }

    public boolean isExt() {
        return this.isExt;
    }

    public void setExt(boolean isExt) {
        this.isExt = isExt;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getUipk() {
        return this.uipk;
    }

    public void setUipk(String uipk) {
        this.uipk = uipk;
    }

    public boolean isUserState() {
        return this.isUserState;
    }

    public void setUserState(boolean isUserState) {
        this.isUserState = isUserState;
    }

    public Solution getSolution() {
        return this.solution;
    }

    public void setSolution(Solution solution) {
        this.solution = solution;
    }

    public boolean isPermission() {
        return this.isPermission;
    }

    public void setPermission(boolean isPermission) {
        this.isPermission = isPermission;
    }

    public CoreBaseInfo toPageInfo(Context ctx) throws BOSException, EASBizException {
        IPageConfig iPageConfig = PageConfigFactory.getLocalInstance(ctx);
        PageConfigInfo pageInfo = null;
        if (!StringUtils.isEmpty((CharSequence)this.pageId) && iPageConfig.exists((IObjectPK)new ObjectUuidPK(this.pageId))) {
            pageInfo = iPageConfig.getPageConfigInfo((IObjectPK)new ObjectUuidPK(this.pageId));
        } else {
            pageInfo = new PageConfigInfo();
            pageInfo.setId(BOSUuid.read((String)this.pageId));
            pageInfo.setIsPreSet(this.isPreSet());
            SHRCodingRuleApi.setNumberFromCodingRule((Context)ctx, (IObjectValue)pageInfo, (String)ContextUtil.getCurrentOrgUnit((Context)ctx).toString());
        }
        PageSetUtils.setMutiLanField(ctx, this.pageName, (IObjectValue)pageInfo);
        if (this.isProductionMode()) {
            pageInfo.setContent(pageInfo.getContent());
            pageInfo.setExtend(this.getSchema());
        } else {
            pageInfo.setContent(this.getSchema());
            pageInfo.setExtend(pageInfo.getExtend());
        }
        return pageInfo;
    }

    public Page toPage(Context ctx, String pageId, String solutionId, String uipk) throws BOSException, EASBizException {
        IPageConfig iPageConfig = PageConfigFactory.getLocalInstance(ctx);
        if (!BOSUuid.isValid((String)pageId, (boolean)false) || !iPageConfig.exists((IObjectPK)new ObjectUuidPK(pageId))) {
            throw new PageConfigException(PageConfigException.PARAMS_EXCEPTION, new Object[]{"pageId is Valid !"});
        }
        PageConfigInfo pageConfigInfo = iPageConfig.getValueBySolution((IObjectPK)new ObjectUuidPK(pageId), solutionId, uipk);
        this.setId(pageId);
        String realUipk = pageConfigInfo.getUipk();
        String content = pageConfigInfo.getContent();
        if (this.isProductionMode && !StringUtils.isEmpty((CharSequence)pageConfigInfo.getExtend())) {
            content = pageConfigInfo.getExtend();
            this.isExt = true;
        }
        this.setSchema(StringUtils.isEmpty((CharSequence)content) ? "" : content);
        this.setPageName(PageSetUtils.initMutiLanField((IObjectValue)pageConfigInfo));
        this.setPreSet(pageConfigInfo.isIsPreSet());
        this.setExt(this.isExt);
        this.setUipk(realUipk);
        if (this.isUserState) {
            this.setUserState(this.isUserState);
            if (!PageSetUtils.checkPagePermission(ctx, realUipk)) {
                this.setPermission(false);
                return this;
            }
            PageSetUtils.permissionVerification(ctx, content, this);
            this.setPermission(true);
        }
        if (null != pageConfigInfo.get("solution")) {
            WorkPFSolutionInfo solutionInfo = (WorkPFSolutionInfo)pageConfigInfo.get("solution");
            Solution solutionTemp = new Solution();
            this.solution = solutionTemp.toSolution(solutionInfo);
        }
        return this;
    }
}

