/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.econtractservice.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillInfo;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.hr.emp.SignTypeEnum;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.shr.base.syssetting.CloudHubMessageFacadeFactory;
import com.kingdee.shr.base.syssetting.cloud.http.HttpResultVo;
import com.kingdee.shr.base.syssetting.util.CloudHubUtil;
import com.kingdee.shr.cloudservice.util.TSPServerInstance;
import com.kingdee.shr.econtractservice.ISSCEContractRecord;
import com.kingdee.shr.econtractservice.SSCEContractRecordFactory;
import com.kingdee.shr.econtractservice.SSCEContractRecordInfo;
import com.kingdee.shr.econtractservice.app.AbstractEContractSendMessageFacadeControllerBean;
import com.kingdee.shr.econtractservice.app.EContractMessageException;
import com.kingdee.shr.econtractservice.app.EContractServiceException;
import com.kingdee.shr.econtractservice.service.EContractService;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.util.CloudHubPropertiesUtilsV2;
import com.kingdee.shr.elecontract.util.CloudHubPropertyConstant;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.elecontract.util.ElectronicTaskAppUtils;
import com.kingdee.shr.elecontract.weixin.WXMessagePusher;
import com.kingdee.shr.elecontract.weixin.message.adapter.SSCWxLinkMessageAdapter;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.shr.shareservice.SSCMessageType;
import com.kingdee.shr.shareservice.TaskMessageLogFactory;
import com.kingdee.shr.shareservice.TaskMessageLogInfo;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EContractSendMessageFacadeControllerBean
extends AbstractEContractSendMessageFacadeControllerBean {
    private static final long serialVersionUID = -6130815965606306789L;
    private ElectronicTaskAppUtils electronicTaskAppUtils = new ElectronicTaskAppUtils();
    public static final Logger logger = LoggerFactory.getLogger(EContractSendMessageFacadeControllerBean.class);

    @Override
    protected Object _sendPersonSignCompleteMessage(Context ctx, Map param) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Object _sendPersonSignMessage(Context ctx, String billId, String entryId, String jobId, String personId) throws BOSException, EASBizException {
        TaskMessageLogInfo messageLog = new TaskMessageLogInfo();
        try {
            String lcfpName;
            BOSUuid bosBillId = BOSUuid.read((String)billId);
            messageLog.setBusinessId(bosBillId);
            messageLog.setTaskId(jobId);
            messageLog.setBusinessType("PERSON_SIGN");
            messageLog.setSendResult(false);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("entrys.*"));
            HRBillBaseInfo billBaseInfo = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosBillId.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(bosBillId), selector);
            HRBillBaseEntryInfo billBaseEntryInfo = null;
            IObjectCollection entryColls = (IObjectCollection)billBaseInfo.get("entrys");
            if (entryColls.size() > 0) {
                billBaseEntryInfo = (HRBillBaseEntryInfo)entryColls.getObject(0);
            }
            Map processInfo = this.electronicTaskAppUtils.getProcessInfo(ctx, billBaseInfo);
            LabContractFirstPartyInfo firstPartyInfo = this.electronicTaskAppUtils.getLabContractFirstPartyByBillId(ctx, billBaseInfo);
            if (firstPartyInfo == null) {
                firstPartyInfo = EContractService.getLabContractFirstParty(ctx, billBaseInfo, billBaseEntryInfo);
            }
            if (firstPartyInfo != null && StringUtils.isEmpty((String)firstPartyInfo.getName())) {
                firstPartyInfo = LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(firstPartyInfo.getId().toString()));
            }
            if (!StringUtils.isEmpty((String)(lcfpName = EContractService.getLCFPNameByBillId(billBaseInfo))) && !lcfpName.equals(firstPartyInfo.getName())) {
                throw new EContractServiceException(EContractServiceException.LCFPNAME_NOT_SAME_BILL);
            }
            KDContractConfigInfo contractInfo = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigInfo("where labContractFirstParty.id='" + firstPartyInfo.getId().toString() + "'");
            if (contractInfo == null) {
                throw new EContractServiceException(EContractServiceException.CONTRACT_CONFIG_IS_NOT_OPEN);
            }
            if (!contractInfo.getEnterpriseName().equals(firstPartyInfo.getName())) {
                throw new EContractServiceException(EContractServiceException.LCFPNAME_NOT_SAME_CONFIG);
            }
            boolean isOtherContractPreEntry = false;
            if (billBaseInfo instanceof OtherContractSignBizBillInfo && ((OtherContractSignBizBillInfo)billBaseInfo).isIsPreEntry()) {
                isOtherContractPreEntry = true;
            }
            if ("9F4ECBD6".equals(bosBillId.getType().toString()) || isOtherContractPreEntry) {
                this.sendPhoneMessage(ctx, billId, processInfo, firstPartyInfo, messageLog);
            } else {
                this.sendSignMessage(ctx, billId, processInfo, firstPartyInfo, messageLog);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            messageLog.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            messageLog.setReason(e.getMessage(ctx.getLocale()).length() > 512 ? e.getMessage(ctx.getLocale()).substring(0, 512) : e.getMessage(ctx.getLocale()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            messageLog.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        if (messageLog.isIsSend()) {
            IObjectPK save = TaskMessageLogFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)messageLog);
            messageLog.setId(BOSUuid.read((String)save.toString()));
        }
        return messageLog;
    }

    @Override
    protected Object _autoSendPersonSignMessage(Context ctx, String billId, String entryId, String jobId, String personId, String creatorId) throws BOSException, EASBizException {
        TaskMessageLogInfo messageLog = (TaskMessageLogInfo)this._sendPersonSignMessage(ctx, billId, entryId, jobId, personId);
        if (messageLog.isIsSend()) {
            if (!StringUtils.isEmpty((String)creatorId)) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)creatorId));
                messageLog.setCreator(userInfo);
            }
            IObjectPK save = TaskMessageLogFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)messageLog);
            messageLog.setId(BOSUuid.read((String)save.toString()));
        }
        return messageLog;
    }

    @Override
    protected Object _sandSignCompleteMessage(Context ctx, IObjectValue billBaseInfo, IObjectValue billEntryInfo) throws BOSException, EASBizException {
        TaskMessageLogInfo messageLog = new TaskMessageLogInfo();
        try {
            HRBillBaseInfo billInfo = (HRBillBaseInfo)billBaseInfo;
            HRBillBaseEntryInfo billBaseEntryInfo = (HRBillBaseEntryInfo)billEntryInfo;
            BOSUuid bosBillId = billInfo.getId();
            messageLog.setBusinessId(bosBillId);
            messageLog.setTaskId(bosBillId.toString());
            messageLog.setBusinessType("SIGN_COMPLETE");
            messageLog.setSendResult(false);
            Map processInfo = this.electronicTaskAppUtils.getProcessInfo(ctx, billInfo);
            LabContractFirstPartyInfo firstPartyInfo = this.electronicTaskAppUtils.getLabContractFirstPartyByBillId(ctx, billInfo);
            if (firstPartyInfo == null) {
                firstPartyInfo = EContractService.getLabContractFirstParty(ctx, billInfo, billBaseEntryInfo);
            }
            boolean isOtherContractPreEntry = false;
            if (billBaseInfo instanceof OtherContractSignBizBillInfo && ((OtherContractSignBizBillInfo)billBaseInfo).isIsPreEntry()) {
                isOtherContractPreEntry = true;
            }
            if ("9F4ECBD6".equals(bosBillId.getType().toString()) || isOtherContractPreEntry) {
                this.sendPhoneSignedMessage(ctx, bosBillId.toString(), processInfo, firstPartyInfo, messageLog);
            } else {
                this.sendViewContractMessage(ctx, bosBillId.toString(), processInfo, firstPartyInfo, messageLog);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            messageLog.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            messageLog.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            messageLog.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        if (messageLog.isIsSend()) {
            IObjectPK save = TaskMessageLogFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)messageLog);
            messageLog.setId(BOSUuid.read((String)save.toString()));
        }
        return messageLog;
    }

    @Override
    protected Object _sandSignCompleteMessage(Context ctx, String billId, String entryId, String jobId, String personId) throws BOSException, EASBizException {
        TaskMessageLogInfo messageLog = new TaskMessageLogInfo();
        try {
            BOSUuid bosBillId = BOSUuid.read((String)billId);
            messageLog.setBusinessId(bosBillId);
            messageLog.setTaskId(jobId);
            messageLog.setBusinessType("SIGN_COMPLETE");
            messageLog.setSendResult(false);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("entrys.*"));
            HRBillBaseInfo billBaseInfo = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosBillId.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(bosBillId), selector);
            HRBillBaseEntryInfo billBaseEntryInfo = null;
            IObjectCollection entryColls = (IObjectCollection)billBaseInfo.get("entrys");
            if (entryColls.size() > 0) {
                billBaseEntryInfo = (HRBillBaseEntryInfo)entryColls.getObject(0);
            }
            Map processInfo = this.electronicTaskAppUtils.getProcessInfo(ctx, billBaseInfo);
            LabContractFirstPartyInfo firstPartyInfo = this.electronicTaskAppUtils.getLabContractFirstPartyByBillId(ctx, billBaseInfo);
            if (firstPartyInfo == null) {
                firstPartyInfo = EContractService.getLabContractFirstParty(ctx, billBaseInfo, billBaseEntryInfo);
            }
            if ("9F4ECBD6".equals(bosBillId.getType().toString())) {
                this.sendPhoneSignedMessage(ctx, billId, processInfo, firstPartyInfo, messageLog);
            } else {
                this.sendViewContractMessage(ctx, billId, processInfo, firstPartyInfo, messageLog);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            messageLog.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            messageLog.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            messageLog.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        if (messageLog.isIsSend()) {
            IObjectPK save = TaskMessageLogFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)messageLog);
            messageLog.setId(BOSUuid.read((String)save.toString()));
        }
        return messageLog;
    }

    protected void sendPhoneMessage(Context ctx, String billId, Map<String, String> processInfo, LabContractFirstPartyInfo firstPartyInfo, TaskMessageLogInfo messageLog) throws BOSException, EASBizException {
        String preEntryPersonId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String entryId = processInfo.get("entryId");
        logger.error("sendPhoneMessage : " + preEntryPersonId + " : " + contractNo + " : " + entryId);
        if (!(StringUtils.isEmpty((String)preEntryPersonId) || StringUtils.isEmpty((String)contractNo) || StringUtils.isEmpty((String)entryId))) {
            PreEntryInfo preEntryInfo = this.electronicTaskAppUtils.getPreEntryInfo(ctx, preEntryPersonId);
            String phone = preEntryInfo.getCellPhone();
            if (StringUtils.isEmpty((String)phone)) {
                throw new EContractMessageException(EContractMessageException.PRE_PERSON_NO_PHONE);
            }
            String pageBaseUrl = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"newContract.page.url");
            if (StringUtils.isEmpty((String)pageBaseUrl)) {
                String label25 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label25", (Context)ctx);
                throw new EContractMessageException(EContractMessageException.CUSTOM_ERROR, new Object[]{label25});
            }
            Map serverMap = null;
            try {
                serverMap = TSPServerInstance.getServerInfo((Context)ctx);
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            String tspServerUrl = (String)serverMap.get("SERVERURL");
            String serviceId = (String)serverMap.get("service_id");
            if (StringUtils.isEmpty((String)tspServerUrl) || StringUtils.isEmpty((String)serviceId)) {
                throw new EContractMessageException(EContractMessageException.TSPSERVER_INFO_ERROR);
            }
            SSCEContractRecordInfo recordInfo = EContractService.getSSCEContractRecordByContractNo(ctx, contractNo, billId);
            String longUrl = this.processPhoneSignMessageUrl(ctx, pageBaseUrl, serviceId, preEntryPersonId, phone, recordInfo);
            Map<String, Object> urlDataMap = this.processGetShortUrlParam(ctx, recordInfo, serviceId, longUrl, preEntryPersonId, phone);
            String shortUrl = ElectronicContractUtils.getShortUrl((Context)ctx, (String)tspServerUrl, urlDataMap);
            Map<String, Object> params = this.processPhoneSignMessageParam(ctx, recordInfo, serviceId, shortUrl, preEntryInfo);
            params.put("contractNum", urlDataMap.get("contractNum"));
            params.put("billId", urlDataMap.get("billId"));
            params.put("entryId", urlDataMap.get("entryId"));
            params.put("presetContractNo", recordInfo.getContractNO());
            messageLog.setCellphone(phone);
            messageLog.setToPrePerson(preEntryInfo.getTalent());
            messageLog.setParam(JSONObject.toJSONString(params));
            messageLog.setUrl(shortUrl);
            messageLog.setContent("HRSSC_Contract_Pre_Sign_PACKAGE");
            messageLog.setIsSend(true);
            messageLog.setType(SSCMessageType.SMS);
            String messageServiceId = "HRSSC_Contract_Pre_Sign_PACKAGE";
            boolean success = ElectronicContractUtils.sengPhoneMessage((Context)ctx, (String)tspServerUrl, (String)serviceId, (String)phone, (String)messageServiceId, params);
            messageLog.setSendResult(success);
            if (!success) {
                throw new EContractMessageException(EContractMessageException.SEND_ERROR);
            }
        } else {
            throw new EContractMessageException(EContractMessageException.PARAM_ERROR);
        }
    }

    protected Map<String, Object> processPhoneSignMessageParam(Context ctx, SSCEContractRecordInfo recordInfo, String serviceId, String shortUrl, PreEntryInfo preEntryInfo) {
        Map<String, Object> params = new HashMap<String, Object>();
        String companyName = "";
        if (preEntryInfo != null && preEntryInfo.getAdminOrg() != null && preEntryInfo.getAdminOrg().getCompany() != null) {
            companyName = preEntryInfo.getAdminOrg().getCompany().getName();
        }
        params.put("3", companyName);
        params.put("2", shortUrl);
        int counts = 1;
        try {
            counts = this.getSignEContractCount(ctx, recordInfo.getBillId().toString(), null, recordInfo, recordInfo.getEContractNO());
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        params.put("1", counts);
        params.put("0", preEntryInfo.getName());
        params.put("hrOrgUnitId", preEntryInfo.getHrOrgUnit().getId().toString());
        params.put("presetCompanyFullName", preEntryInfo.getAdminOrg().getCompany().getName());
        params.put("shorturl", shortUrl);
        params = this.afterProcessPhoneSignMessageParam(ctx, params, recordInfo, serviceId, shortUrl, preEntryInfo);
        return params;
    }

    protected Map<String, Object> afterProcessPhoneSignMessageParam(Context ctx, Map<String, Object> params, SSCEContractRecordInfo recordInfo, String serviceId, String shortUrl, PreEntryInfo preEntryInfo) {
        return params;
    }

    protected Map<String, Object> processGetShortUrlParam(Context ctx, SSCEContractRecordInfo recordInfo, String serviceId, String longUrl, String preEntryPersonId, String phone) {
        Map<String, Object> dataMap = new HashMap<String, Object>();
        String scheme = "HRSSC_Contract";
        BOSUuid billId = recordInfo.getBillId();
        if ("CB88E0A5".equals(billId.getType().toString())) {
            scheme = "HRSSC_Contract_Other";
        }
        int counts = 1;
        try {
            counts = this.getSignEContractCount(ctx, recordInfo.getBillId().toString(), null, recordInfo, recordInfo.getEContractNO());
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        dataMap.put("preEntryId", preEntryPersonId + ";" + billId.toString() + ";" + phone + ";" + recordInfo.getEntryId() + ";" + counts);
        dataMap.put("companyId", serviceId);
        dataMap.put("longUrl", longUrl);
        dataMap.put("scheme", scheme);
        dataMap.put("contractNum", counts);
        dataMap.put("billId", billId.toString());
        dataMap.put("entryId", recordInfo.getEntryId().toString());
        dataMap = this.afterProcessGetShortUrlParam(ctx, recordInfo, serviceId, longUrl, preEntryPersonId, phone, dataMap);
        return dataMap;
    }

    protected Map<String, Object> afterProcessGetShortUrlParam(Context ctx, SSCEContractRecordInfo recordInfo, String serviceId, String longUrl, String preEntryPersonId, String phone, Map<String, Object> dataMap) {
        return dataMap;
    }

    protected String processPhoneSignMessageUrl(Context ctx, String pageBaseUrl, String serviceId, String preEntryPersonId, String phone, SSCEContractRecordInfo recordInfo) throws EASBizException, BOSException {
        StringBuffer longUrl = new StringBuffer();
        longUrl.append(pageBaseUrl);
        longUrl.append("?mobile=");
        try {
            longUrl.append(URLEncoder.encode(phone, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            longUrl.append(phone);
            logger.error(e.getMessage(), (Throwable)e);
        }
        longUrl.append("&kdAppId=");
        longUrl.append(serviceId);
        longUrl.append("&contractNo=");
        longUrl.append(recordInfo.getEContractNO());
        longUrl.append("&serviceId=");
        longUrl.append(serviceId);
        String longUrlStr = longUrl.toString();
        longUrlStr = this.addSHRVerTOUrl(ctx, longUrlStr, recordInfo.getEContractNO(), recordInfo);
        longUrlStr = this.addPackageParam(ctx, longUrlStr, recordInfo.getEContractNO(), recordInfo);
        longUrlStr = this.addIsSingleSignTOUrl(ctx, longUrlStr, recordInfo.getEContractNO(), recordInfo);
        longUrlStr = this.afterProcessPhoneSignMessageUrl(ctx, longUrlStr, serviceId, preEntryPersonId, phone, recordInfo);
        return longUrlStr;
    }

    protected String afterProcessPhoneSignMessageUrl(Context ctx, String longUrl, String serviceId, String preEntryPersonId, String phone, SSCEContractRecordInfo recordInfo) throws EASBizException, BOSException {
        return longUrl;
    }

    protected String processPhoneSignedMessageUrl(Context ctx, String pageBaseUrl, String serviceId, String preEntryPersonId, String phone, SSCEContractRecordInfo recordInfo) throws EASBizException, BOSException {
        String longUrlStr = this.processPhoneSignMessageUrl(ctx, pageBaseUrl, serviceId, preEntryPersonId, phone, recordInfo);
        longUrlStr = this.afterProcessPhoneSignedMessageUrl(ctx, longUrlStr, serviceId, preEntryPersonId, phone, recordInfo);
        return longUrlStr;
    }

    protected String afterProcessPhoneSignedMessageUrl(Context ctx, String longUrl, String serviceId, String preEntryPersonId, String phone, SSCEContractRecordInfo recordInfo) throws EASBizException, BOSException {
        return longUrl;
    }

    protected void sendPhoneSignedMessage(Context ctx, String billId, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, TaskMessageLogInfo messageLog) throws BOSException, EASBizException {
        String preEntryPersonId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String entryId = processInfo.get("entryId");
        logger.error("sendPhoneMessage : " + preEntryPersonId + " : " + contractNo + " : " + entryId);
        if (!(StringUtils.isEmpty((String)preEntryPersonId) || StringUtils.isEmpty((String)contractNo) || StringUtils.isEmpty((String)entryId))) {
            PreEntryInfo preEntryInfo = this.electronicTaskAppUtils.getPreEntryInfo(ctx, preEntryPersonId);
            String phone = preEntryInfo.getCellPhone();
            if (StringUtils.isEmpty((String)phone)) {
                throw new EContractMessageException(EContractMessageException.PRE_PERSON_NO_PHONE);
            }
            String pageBaseUrl = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"newContract.page.url");
            if (StringUtils.isEmpty((String)pageBaseUrl)) {
                String label25 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label25", (Context)ctx);
                throw new EContractMessageException(EContractMessageException.CUSTOM_ERROR, new Object[]{label25});
            }
            Map serverMap = null;
            try {
                serverMap = TSPServerInstance.getServerInfo((Context)ctx);
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            String tspServerUrl = (String)serverMap.get("SERVERURL");
            String serviceId = (String)serverMap.get("service_id");
            if (StringUtils.isEmpty((String)tspServerUrl) || StringUtils.isEmpty((String)serviceId)) {
                throw new EContractMessageException(EContractMessageException.TSPSERVER_INFO_ERROR);
            }
            SSCEContractRecordInfo recordInfo = EContractService.getSSCEContractRecordByContractNo(ctx, contractNo, billId);
            String longUrl = this.processPhoneSignedMessageUrl(ctx, pageBaseUrl, serviceId, preEntryPersonId, phone, recordInfo);
            Map<String, Object> urlDataMap = this.processGetShortUrlParam(ctx, recordInfo, serviceId, longUrl, preEntryPersonId, phone);
            String shortUrl = ElectronicContractUtils.getShortUrl((Context)ctx, (String)tspServerUrl, urlDataMap);
            Map<String, Object> params = this.processPhoneSignedMessageParam(ctx, recordInfo, serviceId, shortUrl, preEntryInfo);
            params.put("contractNum", urlDataMap.get("contractNum"));
            params.put("billId", urlDataMap.get("billId"));
            params.put("entryId", urlDataMap.get("entryId"));
            params.put("presetContractNo", recordInfo.getContractNO());
            messageLog.setCellphone(phone);
            messageLog.setParam(JSONObject.toJSONString(params));
            messageLog.setUrl(shortUrl);
            messageLog.setContent("HRSSC_Contract_Pre_Sign_PACKAGE_OVER");
            messageLog.setIsSend(true);
            messageLog.setToPrePerson(preEntryInfo.getTalent());
            messageLog.setType(SSCMessageType.SMS);
            String messageServiceId = "HRSSC_Contract_Pre_Sign_PACKAGE_OVER";
            boolean success = ElectronicContractUtils.sengPhoneMessage((Context)ctx, (String)tspServerUrl, (String)serviceId, (String)phone, (String)messageServiceId, params);
            if (!success) {
                throw new EContractMessageException(EContractMessageException.SEND_ERROR);
            }
        } else {
            throw new EContractMessageException(EContractMessageException.PARAM_ERROR);
        }
    }

    protected Map<String, Object> processPhoneSignedMessageParam(Context ctx, SSCEContractRecordInfo recordInfo, String serviceId, String shortUrl, PreEntryInfo preEntryInfo) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("hrOrgUnitId", preEntryInfo.getHrOrgUnit().getId().toString());
        params.put("presetCompanyFullName", preEntryInfo.getAdminOrg().getCompany().getName());
        params.put("shorturl", shortUrl);
        params.put("2", preEntryInfo.getAdminOrg().getCompany().getName());
        params.put("1", shortUrl);
        params.put("0", preEntryInfo.getName());
        params = this.afterProcessPhoneSignedMessageParam(ctx, params, recordInfo, serviceId, shortUrl, preEntryInfo);
        return params;
    }

    protected Map<String, Object> afterProcessPhoneSignedMessageParam(Context ctx, Map<String, Object> params, SSCEContractRecordInfo recordInfo, String serviceId, String shortUrl, PreEntryInfo preEntryInfo) {
        return params;
    }

    protected void sendSignMessage(Context ctx, String billId, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, TaskMessageLogInfo messageLog) throws BOSException, EASBizException {
        String personId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String entryId = processInfo.get("entryId");
        logger.error("EContractServiceFacadeControllerBean sendSignMessageToCloudHub : " + personId + " : " + contractNo + " : " + entryId);
        if (!(StringUtils.isEmpty((String)personId) || StringUtils.isEmpty((String)contractNo) || StringUtils.isEmpty((String)entryId))) {
            SSCEContractRecordInfo recordInfo = EContractService.getSSCEContractRecordByContractNo(ctx, contractNo, billId);
            String eContractNo = recordInfo.getEContractNO();
            String url = this.processSignMessageUrl(ctx, billId, processInfo, recordInfo, eContractNo);
            String messageText = this.processSignMessageText(ctx, billId, processInfo, recordInfo, eContractNo);
            logger.error("url : " + url + " \n messageText : " + messageText);
            messageLog.setParam(eContractNo);
            messageLog.setUrl(url);
            messageLog.setContent(messageText);
            if (this.electronicTaskAppUtils.isSendToWeixin(ctx)) {
                messageLog.setType(SSCMessageType.WX);
                this.sendMessageToWeiXin(ctx, personId, url, messageText, messageLog);
            } else {
                messageLog.setType(SSCMessageType.CLOUDHUB_PUBS);
                this.sendMessageToCloudHub(ctx, personId, url, messageText, messageLog);
            }
        } else {
            throw new EContractMessageException(EContractMessageException.PARAM_ERROR);
        }
    }

    protected String processSignMessageUrl(Context ctx, String billId, Map<String, String> processInfo, SSCEContractRecordInfo recordInfo, String eContractNo) throws BOSException, EASBizException {
        String longUrl = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.handSign.lightApp.url.new").replace("@{contractNo}", eContractNo);
        longUrl = this.addSHRVerTOUrl(ctx, longUrl, eContractNo, recordInfo);
        longUrl = this.addPackageParam(ctx, longUrl, eContractNo, recordInfo);
        longUrl = this.addIsSingleSignTOUrl(ctx, longUrl, eContractNo, recordInfo);
        longUrl = this.afterProcessSignMessageUrl(ctx, longUrl, billId, processInfo, recordInfo, eContractNo);
        return longUrl;
    }

    protected String afterProcessSignMessageUrl(Context ctx, String longUrl, String billId, Map<String, String> processInfo, SSCEContractRecordInfo recordInfo, String eContractNo) throws BOSException, EASBizException {
        return longUrl;
    }

    protected String processSignMessageText(Context ctx, String billId, Map<String, String> processInfo, SSCEContractRecordInfo recordInfo, String eContractNo) throws BOSException, EASBizException {
        int totalNumber = this.getSignEContractCount(ctx, billId, processInfo, recordInfo, eContractNo);
        logger.info("CloudHubPropertiesUtilsV2.REPLACE_PreFix is {}, totalNumber is {}", (Object)CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)CloudHubPropertyConstant.DEFAULT_CONTRACT_KEY[0]), (Object)String.valueOf(totalNumber));
        String messageText = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.hignSign.message").replace(CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)CloudHubPropertyConstant.DEFAULT_CONTRACT_KEY[0]), String.valueOf(totalNumber));
        if (messageText.contains("@{contractNo}")) {
            messageText = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.hignSign.message").replace("@{contractNo}", recordInfo.getContractNO());
        }
        messageText = this.afterProcessSignMessageText(ctx, messageText, billId, processInfo, recordInfo, eContractNo);
        return messageText;
    }

    protected int getSignEContractCount(Context ctx, String billId, Map<String, String> processInfo, SSCEContractRecordInfo recordInfo, String eContractNo) throws BOSException, EASBizException {
        int counts = 1;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
            view.setFilter(filter);
            ISSCEContractRecord iSSCEContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
            counts = iSSCEContractRecord.getCount(view);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return counts;
    }

    protected String afterProcessSignMessageText(Context ctx, String messageText, String billId, Map<String, String> processInfo, SSCEContractRecordInfo recordInfo, String eContractNo) throws BOSException, EASBizException {
        return messageText;
    }

    protected String processSignedMessageUrl(Context ctx, String billId, Map<String, String> processInfo, SSCEContractRecordInfo recordInfo, String eContractNo) throws BOSException, EASBizException {
        String longUrl = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.viewContract.lightApp.url").replace("@{contractNo}", eContractNo);
        longUrl = this.addSHRVerTOUrl(ctx, longUrl, eContractNo, recordInfo);
        longUrl = this.addPackageParam(ctx, longUrl, eContractNo, recordInfo);
        longUrl = this.addIsSingleSignTOUrl(ctx, longUrl, eContractNo, recordInfo);
        longUrl = this.afterProcessSignedMessageUrl(ctx, longUrl, billId, processInfo, recordInfo, eContractNo);
        return longUrl;
    }

    protected String afterProcessSignedMessageUrl(Context ctx, String longUrl, String billId, Map<String, String> processInfo, SSCEContractRecordInfo recordInfo, String eContractNo) throws BOSException, EASBizException {
        return longUrl;
    }

    protected String processSignedMessageText(Context ctx, String billId, Map<String, String> processInfo, SSCEContractRecordInfo recordInfo, String eContractNo) throws BOSException, EASBizException {
        String messageText = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.viewContract.message").replace("@{contractNo}", recordInfo.getContractNO());
        messageText = this.afterProcessSignedMessageText(ctx, messageText, billId, processInfo, recordInfo, eContractNo);
        return messageText;
    }

    protected String afterProcessSignedMessageText(Context ctx, String messageText, String billId, Map<String, String> processInfo, SSCEContractRecordInfo recordInfo, String eContractNo) throws BOSException, EASBizException {
        return messageText;
    }

    protected void sendViewContractMessage(Context ctx, String billId, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, TaskMessageLogInfo messageLog) throws BOSException, EASBizException {
        String personId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String entryId = processInfo.get("entryId");
        if (!(StringUtils.isEmpty((String)personId) || StringUtils.isEmpty((String)contractNo) || StringUtils.isEmpty((String)entryId))) {
            SSCEContractRecordInfo recordInfo = EContractService.getSSCEContractRecordByContractNo(ctx, contractNo, billId);
            String eContractNo = recordInfo.getEContractNO();
            String url = this.processSignedMessageUrl(ctx, billId, processInfo, recordInfo, eContractNo);
            String messageText = this.processSignedMessageText(ctx, billId, processInfo, recordInfo, eContractNo);
            messageLog.setParam(eContractNo);
            messageLog.setUrl(url);
            messageLog.setContent(messageText);
            if (this.electronicTaskAppUtils.isSendToWeixin(ctx)) {
                messageLog.setType(SSCMessageType.WX);
                this.sendMessageToWeiXin(ctx, personId, url, messageText, messageLog);
            } else {
                messageLog.setType(SSCMessageType.CLOUDHUB_PUBS);
                this.sendMessageToCloudHub(ctx, personId, url, messageText, messageLog);
            }
        } else {
            throw new EContractMessageException(EContractMessageException.PARAM_ERROR);
        }
    }

    protected void sendMessageToWeiXin(Context ctx, String personId, String url, String messageText, TaskMessageLogInfo messageLog) throws BOSException, EASBizException {
        logger.error("EContractSendMessageFacadeControllerBean sendMessageToWeiXin");
        UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person.id = '" + personId + "' and isDelete = 0 AND isForbidden = 0");
        if (userColl.size() == 1) {
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)personId));
            messageLog.setToUser(userColl.get(0));
            messageLog.setToPerson(person);
            url = this.electronicTaskAppUtils.processWeiXinMessageURL(ctx, url);
            ArrayList<String> personIDs = new ArrayList<String>();
            personIDs.add(userColl.get(0).getId().toString());
            ArrayList<SSCWxLinkMessageAdapter> adapters = new ArrayList<SSCWxLinkMessageAdapter>();
            String label2 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label2", (Context)ctx);
            SSCWxLinkMessageAdapter sscWxLinkMessageAdapter = new SSCWxLinkMessageAdapter(ctx, label2, messageText, url, personIDs);
            adapters.add(sscWxLinkMessageAdapter);
            messageLog.setIsSend(true);
            Map pushMessage = new WXMessagePusher("").pushMessage(ctx, adapters);
            boolean success = false;
            String successStr = "";
            if (pushMessage.get("success") != null) {
                successStr = String.valueOf(pushMessage.get("success"));
            }
            if ("true".equalsIgnoreCase(successStr)) {
                success = true;
            }
            messageLog.setSendResult(success);
            if (!success) {
                throw new EContractMessageException(EContractMessageException.PUSH_ERROR);
            }
        } else {
            throw new EContractMessageException(EContractMessageException.PERSON_INFO_ERROR);
        }
    }

    protected void sendMessageToCloudHub(Context ctx, String personId, String url, String messageText, TaskMessageLogInfo messageLog) throws BOSException, EASBizException {
        logger.error("EContractSendMessageFacadeControllerBean sendMessageToCloudHub");
        boolean isPrivate = Boolean.parseBoolean(CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"isPrivate"));
        String pubaccName = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"pubaccName");
        String appId = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"appId");
        UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person.id = '" + personId + "' AND isDelete = 0 AND isForbidden = 0");
        if (userColl.size() == 1) {
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)personId));
            messageLog.setToUser(userColl.get(0));
            messageLog.setToPerson(person);
            messageLog.setIsSend(true);
            HttpResultVo result = null;
            try {
                String eid = CloudHubUtil.getIntegrationEid((Context)ctx);
                XTServiceConfig xtServiceConfig = XTServiceConfig.getInstance();
                xtServiceConfig.getPubEnabled(eid, pubaccName);
            }
            catch (BOSException e) {
                throw e;
            }
            catch (NullPointerException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new EContractMessageException(EContractMessageException.XTSERVICECONFIG_ERROR);
            }
            try {
                result = (HttpResultVo)CloudHubMessageFacadeFactory.getLocalInstance((Context)ctx).sendTextLinkMessageToUser(messageText, appId, url, userColl, pubaccName, isPrivate);
            }
            catch (BOSException e) {
                throw e;
            }
            catch (EASBizException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) {
                    throw new EContractMessageException(EContractMessageException.XTSERVICECONFIG_ERROR);
                }
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            logger.error("EContractSendMessageFacadeControllerBean OSFresult : " + JSON.toJSONString((Object)result));
            int status = result.getStatus();
            messageLog.setSendResult(true);
            if (status != 200) {
                messageLog.setSendResult(false);
                throw new EContractMessageException(EContractMessageException.PUSH_ERROR);
            }
        } else {
            throw new EContractMessageException(EContractMessageException.PERSON_INFO_ERROR);
        }
    }

    protected String addSHRVerTOUrl(Context ctx, String longUrl, String eContractNo, SSCEContractRecordInfo recordInfo) {
        longUrl = longUrl + "&sHRVer=8612";
        return longUrl;
    }

    protected String addIsSingleSignTOUrl(Context ctx, String longUrl, String eContractNo, SSCEContractRecordInfo recordInfo) {
        SignTypeEnum signType = recordInfo.getSignType();
        if (SignTypeEnum.SINGLESIGN.equals((Object)signType) || SignTypeEnum.TRIPARTITESIGN.equals((Object)signType)) {
            longUrl = longUrl + "&isSingleSign=true";
        }
        return longUrl;
    }

    protected String addPackageParam(Context ctx, String longUrl, String eContractNo, SSCEContractRecordInfo recordInfo) {
        longUrl = longUrl + "&contractP=true";
        return longUrl;
    }
}

