/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.econtractservice.service;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.econtractservice.service.IEContractTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EContractTaskHelper {
    private Map<String, IEContractTask> syncPoll = new ConcurrentHashMap<String, IEContractTask>();
    private static EContractTaskHelper instance = new EContractTaskHelper();
    public static final String PERSON_TASK_SUFFIX = "_PERSON_TASK";
    public static final String COMPANY_TASK_SUFFIX = "_COMPANY_TASK";

    private EContractTaskHelper() {
    }

    public static EContractTaskHelper getInstance() {
        return instance;
    }

    public String toString() {
        return "EContractTaskHelper [syncPoll=" + this.syncPoll + "]";
    }

    public void processTaskSuccess(String key) throws EASBizException, BOSException {
        if (this.syncPoll.containsKey(key)) {
            this.syncPoll.get(key).processSuccess();
        }
    }

    public void processTaskFail(String key) throws EASBizException, BOSException {
        if (this.syncPoll.containsKey(key)) {
            this.syncPoll.get(key).processFail();
        }
    }

    public void removeSync(String key) {
        this.syncPoll.remove(key);
    }

    public IEContractTask getSync(String key) {
        return this.syncPoll.get(key);
    }

    public void addSync(String key, IEContractTask sync) {
        this.syncPoll.put(key, sync);
    }

    public boolean isProcessing(String key) {
        return this.getSync(key) != null && !this.getSync(key).isHasNotice() && !this.getSync(key).isSuccess();
    }

    public boolean isFail(String key) {
        return this.getSync(key) != null && this.getSync(key).isHasNotice() && !this.getSync(key).isSuccess();
    }

    public boolean isSyncPollExistKey(String key) {
        return this.syncPoll.containsKey(key) && this.syncPoll.get(key) != null;
    }
}

