/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceConfig;
import com.kingdee.shr.cloudservice.util.HttpClientUtil;
import com.kingdee.shr.elecontract.IKDContractConfig;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordHISFactory;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordInfo;
import com.kingdee.shr.elecontract.KDContractConfigCollection;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigHISFactory;
import com.kingdee.shr.elecontract.KDContractConfigHISInfo;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.KDState;
import com.kingdee.shr.elecontract.app.AbstractKDContractConfigControllerBean;
import com.kingdee.shr.elecontract.app.KDContractServiceStatus;
import com.kingdee.shr.elecontract.app.KDContractSysVersion;
import com.kingdee.shr.elecontract.util.CloudHubPropertiesUtilsV2;
import com.kingdee.shr.elecontract.util.KdContractConfigAuthRecordUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.CloudServiceException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDContractConfigControllerBean
extends AbstractKDContractConfigControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(KDContractConfigControllerBean.class);

    @Override
    protected IObjectValue _getDefaultConfigInfo(Context ctx) throws BOSException {
        KDContractConfigInfo config = null;
        try {
            config = new KDContractConfigInfo();
            config.setCloudSysVersion(KDContractSysVersion.getEnum(CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.server.apiver")));
            config.setCloudServerUrl(CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.server.url"));
            config.setClientKDAppId(CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.server.kdAppId"));
            config.setClientSecret(CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.server.uuid"));
            config.setServiceStatus(KDContractServiceStatus.REGISTSUCC);
        }
        catch (Exception e) {
            String label15 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label15", (Context)ctx);
            logger.error(label15, (Throwable)e);
            return null;
        }
        return config;
    }

    protected void beforeSave(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this.verify(ctx, model);
    }

    protected void verify(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        KDContractConfigInfo info = (KDContractConfigInfo)model;
        LabContractFirstPartyInfo partyInfo = info.getLabContractFirstParty();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("labContractFirstParty.id", (Object)partyInfo.getId().toString()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            String label16;
            String errorMsg = label16 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label16", (Context)ctx);
            NumericExceptionSubItem validException = new NumericExceptionSubItem("00", errorMsg);
            throw new EASBizException(validException);
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        KDContractConfigInfo info = (KDContractConfigInfo)model;
        info.setState(KDState.NOAUTH);
        info.setSyncToCloudService(false);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        info.setId(BOSUuid.read((String)pk.toString()));
        this._afterAddnew(ctx, (IObjectValue)info);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        KDContractConfigInfo info = (KDContractConfigInfo)model;
        info.setState(KDState.NOAUTH);
        info.setAuthUrl("");
        info.setServiceStatus(KDContractServiceStatus.UNREGIST);
        info.setSyncToCloudService(false);
        super._update(ctx, pk, model);
        this._afterUpdate(ctx, model);
    }

    protected void _afterAddnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._addHisModelInfo(ctx, model);
        this._processAuthRecord(ctx, model);
    }

    protected void _afterUpdate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._addHisModelInfo(ctx, model);
        this._processAuthRecord(ctx, model);
    }

    protected void _processAuthRecord(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        KDContractConfigAuthRecordInfo authRecordInfo;
        KDContractConfigInfo info = (KDContractConfigInfo)model;
        String configId = info.getId().toString();
        if (KDContractConfigAuthRecordFactory.getLocalInstance(ctx).exists("where config = '" + configId + "'") && null != (authRecordInfo = KDContractConfigAuthRecordFactory.getLocalInstance(ctx).getKDContractConfigAuthRecordInfo("where config = '" + configId + "'"))) {
            logger.info("reset autoAuthSign\uff0cconfig is\uff1a " + configId);
            authRecordInfo.setCancelAuthTime(new Timestamp(System.currentTimeMillis()));
            KDContractConfigAuthRecordHISFactory.getLocalInstance(ctx).addnew(KdContractConfigAuthRecordUtils.copyAuthRecordToHis(authRecordInfo));
        }
        KDContractConfigAuthRecordFactory.getLocalInstance(ctx).delete("where config.id = '" + configId + "'");
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSave(ctx, model);
        KDContractConfigInfo info = (KDContractConfigInfo)model;
        boolean needAuth = true;
        Object oldInfo = null;
        if (needAuth) {
            String serverURL = CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.server.url");
            if (StringUtils.isEmpty((String)serverURL)) {
                serverURL = "https://pay.kingdee.com/kdcontract/api/contract";
            }
            info.setCloudServerUrl(serverURL);
            this.getKDAppIdAndSecret(ctx, info);
            if (info.getId() == null) {
                this.processClientInfo(ctx, info);
            }
        }
        return super._save(ctx, (IObjectValue)info);
    }

    private void processClientInfo(Context ctx, KDContractConfigInfo info) throws EASBizException, BOSException {
        JSONObject result;
        JSONObject jsonObject = this.getKDAppInfoFromCloud(ctx, info);
        int returnCode = jsonObject.getInt("status");
        if (returnCode == 200) {
            result = new JSONObject();
            result = jsonObject.get("result") instanceof JSONObject ? jsonObject.getJSONObject("result") : JSONObject.fromObject((Object)jsonObject.get("result"));
            if (result.get("code") != null && result.getInt("code") != 0) {
                throw new CloudServiceException(CloudServiceException.GETDATAFAILRESULT_EXCEPTION, new Object[]{result.getString("msg")});
            }
        } else {
            String label17 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label17", (Context)ctx);
            String realObj = MessageFormat.format(label17, returnCode, jsonObject.getString("msg"));
            logger.error(realObj);
            throw new CloudServiceException(CloudServiceException.GETDATAFAIL_EXCEPTION);
        }
        JSONObject data = new JSONObject();
        data = result.get("data") instanceof JSONObject ? result.getJSONObject("data") : JSONObject.fromObject((Object)result.get("data"));
        String clientKDAppId = data.getString("kdAppId");
        String clientSecret = data.getString("uuid");
        info.setClientKDAppId(clientKDAppId);
        info.setClientSecret(clientSecret);
    }

    private JSONObject getKDAppInfoFromCloud(Context ctx, KDContractConfigInfo info) throws BOSException {
        String productName;
        String client_secret;
        String client_id;
        String serverBaseUrl;
        String serverUrl = CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.interface.server");
        if (StringUtils.isEmpty((String)serverUrl)) {
            serverUrl = "https://api.kingdee.com/";
        }
        if (StringUtils.isEmpty((String)(serverBaseUrl = CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.interface.base.url")))) {
            serverBaseUrl = "emerchant/merchant/add";
        }
        if (StringUtils.isEmpty((String)(client_id = CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.client.id")))) {
            client_id = "200234";
        }
        if (StringUtils.isEmpty((String)(client_secret = CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.client.secret")))) {
            client_secret = "fde99eee9d188df7636b34de3fe3d6ce";
        }
        if (StringUtils.isEmpty((String)(productName = CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.client.product")))) {
            productName = "sHR";
        }
        String kdAppDesc = info.getEnterpriseName();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String companyName = "";
        ICloudServiceConfig irecConfig = CloudServiceConfigFactory.getLocalInstance((Context)ctx);
        CloudServiceConfigCollection cloudServiceConfigCollection = irecConfig.getCloudServiceConfigCollection();
        if (cloudServiceConfigCollection == null || cloudServiceConfigCollection.size() == 0) {
            String label36 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label36", (Context)ctx);
            throw new BOSException(label36);
        }
        CloudServiceConfigInfo serviceConfigInfo = cloudServiceConfigCollection.get(0);
        companyName = serviceConfigInfo.getEnterFullName();
        dataMap.put("companyName", companyName);
        dataMap.put("product", productName);
        dataMap.put("kdAppDesc", kdAppDesc);
        String reallyUrl = serverUrl + serverBaseUrl + "?client_id=" + client_id + "&client_secret=" + client_secret;
        logger.error(SHRCheck.vaildLog((String)("KDContractConfigControllerBean getKDAppInfoFromCloud : reallyUrl " + reallyUrl + " dataMap " + dataMap)));
        JSONObject jsonObject = HttpClientUtil.postForm((Context)ctx, (String)reallyUrl, dataMap);
        logger.error(SHRCheck.vaildLog((String)("KDContractConfigControllerBean getKDAppInfoFromCloud : jsonObject " + jsonObject)));
        return jsonObject;
    }

    private void getKDAppIdAndSecret(Context ctx, KDContractConfigInfo info) throws BOSException {
        BOSUuid id = info.getId();
        KDContractConfigCollection coll = null;
        KDContractConfigInfo configInfo = null;
        IKDContractConfig iKDContractConfig = KDContractConfigFactory.getLocalInstance(ctx);
        if (id != null && !StringUtils.isEmpty((String)id.toString())) {
            coll = iKDContractConfig.getKDContractConfigCollection("where id = '" + id.toString() + "'");
            if (coll != null && coll.size() > 0) {
                configInfo = coll.get(0);
                info.setClientKDAppId(configInfo.getClientKDAppId());
                info.setClientSecret(configInfo.getClientSecret());
            } else {
                configInfo = iKDContractConfig.getDefaultConfigInfo();
                info.setClientKDAppId(configInfo.getClientKDAppId());
                info.setClientSecret(configInfo.getClientSecret());
            }
        } else {
            configInfo = iKDContractConfig.getDefaultConfigInfo();
            info.setClientKDAppId(configInfo.getClientKDAppId());
            info.setClientSecret(configInfo.getClientSecret());
        }
    }

    protected void _addHisModelInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            KDContractConfigInfo info = (KDContractConfigInfo)model;
            KDContractConfigHISInfo hisInfo = new KDContractConfigHISInfo();
            hisInfo = (KDContractConfigHISInfo)this.copyProperty(ctx, (CoreBaseInfo)info, (CoreBaseInfo)hisInfo);
            if (info.getId() != null) {
                hisInfo.setHistoryId(info.getId().toString());
            }
            KDContractConfigHISFactory.getLocalInstance(ctx).save((CoreBaseInfo)hisInfo);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected CoreBaseInfo copyProperty(Context ctx, CoreBaseInfo source, CoreBaseInfo target) throws BOSException, EASBizException {
        Enumeration keys = source.keys();
        while (keys.hasMoreElements()) {
            String propertyKey = (String)keys.nextElement();
            if (this.isDonotNeedCopyProperty(propertyKey)) continue;
            target.put(propertyKey, source.get(propertyKey));
        }
        return target;
    }

    protected boolean isDonotNeedCopyProperty(String key) {
        return "creator".equalsIgnoreCase(String.valueOf(key)) || "createTime".equalsIgnoreCase(String.valueOf(key)) || "lastUpdateUser".equalsIgnoreCase(String.valueOf(key)) || "lastUpdateTime".equalsIgnoreCase(String.valueOf(key)) || "CU".equalsIgnoreCase(String.valueOf(key)) || "id".equalsIgnoreCase(String.valueOf(key));
    }
}

