/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.elecontract.IKDContractConfig;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.app.AbstractKDContractConfigFacadeControllerBean;
import com.kingdee.shr.elecontract.util.KDConfigUtils;
import com.kingdee.util.NumericExceptionSubItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDContractConfigFacadeControllerBean
extends AbstractKDContractConfigFacadeControllerBean {
    private static Logger logger = LoggerFactory.getLogger(KDContractConfigFacadeControllerBean.class);
    private KDConfigUtils kDConfigUtils = new KDConfigUtils();

    @Override
    protected IObjectPK _saveKDContractConfigInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        KDContractConfigInfo info = (KDContractConfigInfo)model;
        IObjectPK pk = null;
        try {
            pk = this.processKDContractConfig(ctx, info);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            NumericExceptionSubItem exceptionSubItem = new NumericExceptionSubItem("00", e.getMessage());
            throw new EASBizException(exceptionSubItem);
        }
        return pk;
    }

    @Override
    protected IObjectCollection _saveKDContractConfigCollection(Context ctx, IObjectCollection collection) throws BOSException, EASBizException {
        if (collection == null || collection.size() <= 0) {
            return collection;
        }
        int size = collection.size();
        for (int dex = 0; dex < size; ++dex) {
            IObjectValue object = collection.getObject(dex);
            KDContractConfigInfo info = (KDContractConfigInfo)object;
            try {
                IObjectPK pk = this._saveKDContractConfigInfo(ctx, (IObjectValue)info);
                info.setId(BOSUuid.read((String)pk.toString()));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return collection;
    }

    protected IObjectPK processKDContractConfig(Context ctx, KDContractConfigInfo info) throws BOSException, EASBizException {
        this.beforeSave(ctx, (CoreBaseInfo)info);
        IObjectPK save = this.save(ctx, (CoreBaseInfo)info);
        this.afterSave(ctx, (CoreBaseInfo)info);
        return save;
    }

    protected IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        IKDContractConfig iKDContractConfig = KDContractConfigFactory.getLocalInstance(ctx);
        IObjectPK save = iKDContractConfig.save(model);
        return save;
    }

    protected void beforeSave(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
    }

    protected void afterSave(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        KDContractConfigInfo info = (KDContractConfigInfo)model;
        if (info.getServiceStatus() != null && info.getServiceStatus().getValue() == 2) {
            this.kDConfigUtils.sendInfoToTsp(ctx, info);
        }
    }
}

