/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.service;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.elecontract.IKDContractConfig;
import com.kingdee.shr.elecontract.IKDContractConfigAuthRecord;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordInfo;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.KDState;
import com.kingdee.shr.elecontract.app.KDContractServiceStatus;
import com.kingdee.shr.elecontract.util.KdContractConfigAuthRecordUtils;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDContractConfigListRefreshDataThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(KDContractConfigListRefreshDataThread.class);
    private String threadName = "";
    private Context ctx;
    private CountDownLatch latch;
    private IMSFServiceFacade osfServiceFacade;
    private IKDContractConfig ikdContractConfig;
    private JSONObject object;

    public KDContractConfigListRefreshDataThread(Context ctx, CountDownLatch latch, IMSFServiceFacade osfServiceFacade, IKDContractConfig ikdContractConfig, JSONObject object) {
        this.ctx = ctx;
        this.latch = latch;
        this.osfServiceFacade = osfServiceFacade;
        this.ikdContractConfig = ikdContractConfig;
        this.object = object;
    }

    @Override
    public void run() {
        try {
            if (this.object.containsKey((Object)"isAuthState") && this.object.getBooleanValue("isAuthState")) {
                this.processAuthState();
            } else {
                this.processState();
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            this.latch.countDown();
        }
    }

    protected void processState() throws EASBizException, BOSException {
        JSONObject data;
        int resultCode;
        int stateValue;
        JSONObject objectJson;
        KDContractConfigInfo info = null;
        HashMap<String, String> dataMap = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        String userId = this.object.getString("userId");
        String billId = this.object.getString("billId");
        logger.error("refreshStateAction billId : " + billId);
        info = this.ikdContractConfig.getKDContractConfigInfo((IObjectPK)new ObjectUuidPK(billId));
        dataMap = new HashMap<String, String>();
        dataMap.put("userId", userId);
        dataMap.put("kdAppId", info.getClientKDAppId());
        dataMap.put("secret", info.getClientSecret());
        dataMap.put("version", info.getCloudSysVersion().getValue());
        dataMap.put("serverURL", info.getCloudServerUrl());
        Object result = this.osfServiceFacade.processService("electronicLaborGetAuthResultService", dataMap);
        if (result != null && 0 == (objectJson = result instanceof JSONObject ? (JSONObject)result : JSONObject.parseObject((String)result.toString())).getIntValue("code") && (stateValue = info.getState().getValue()) != (resultCode = (data = objectJson.getJSONObject("data")).getIntValue("resultCode"))) {
            selector.clear();
            KDContractConfigInfo newInfo = new KDContractConfigInfo();
            newInfo.setId(BOSUuid.read((String)billId));
            selector.add(new SelectorItemInfo("state"));
            if (1 == resultCode) {
                newInfo.setState(KDState.PASS);
                newInfo.setServiceStatus(KDContractServiceStatus.REGISTSUCC);
                selector.add(new SelectorItemInfo("serviceStatus"));
            } else if (0 == resultCode) {
                newInfo.setState(KDState.NOPASS);
                newInfo.setServiceStatus(KDContractServiceStatus.REGISTFAILED);
                selector.add(new SelectorItemInfo("serviceStatus"));
            } else if (2 == resultCode) {
                newInfo.setState(KDState.AUTHING);
            } else if (3 == resultCode) {
                newInfo.setState(KDState.TOAUDIT);
            }
            this.ikdContractConfig.updatePartial(newInfo, selector);
        }
    }

    protected void processAuthState() throws EASBizException, BOSException {
        String authFileId = this.object.getString("authId");
        IKDContractConfigAuthRecord ikdContractConfigAuthRecord = KDContractConfigAuthRecordFactory.getLocalInstance(this.ctx);
        if (!StringUtils.isEmpty((String)authFileId) && ikdContractConfigAuthRecord.exists("where id = '" + authFileId + "'")) {
            logger.info("authFileId_ is : " + authFileId);
            KDContractConfigAuthRecordInfo authRecordInfo = ikdContractConfigAuthRecord.getKDContractConfigAuthRecordInfo("where id = '" + authFileId + "'");
            KdContractConfigAuthRecordUtils.refreshAuthRecordState(this.ctx, authRecordInfo, new HashMap());
        }
    }
}

