/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.elecontract.util.ContactBillMiddleUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectronicTemplateSqlUtils {
    private static final Logger logger = LoggerFactory.getLogger(ElectronicTemplateSqlUtils.class);
    public static final String scheme = "009SSC";
    public static final String BillID_Identifier_Replacement = "@{CONTRACTRENEWBIZBILL.ID}";
    public static String Filter_String_Pre = "RenewBill";
    public static String Filter_String_Back = ".id";
    public static final int CUT_OUT_30 = 30;
    public static final String FIELDS_MPPING = "fieldsMpping";
    public static final String FIELDS_MPPING_BUSINESS = "fieldsMppingBusiness";
    public static final String GDPR_MAPINF = "GDPR_MAPINF";
    public static final String DEFAULT_QUERY_METANAME = "com.kingdee.shr.econtractservice.app.ElectronicContractBizBillQuery";

    public static String generateSQLFromString(Context ctx, String config, SHRElectronicTemplateInfo electronicTemplateInfo) throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        logger.error("ElectronicTemplateSqlUtils generateSQLFromString : " + config);
        JSONArray selector = JSONArray.parseArray((String)config);
        params.put("selectorFields", selector);
        return ElectronicTemplateSqlUtils.generateSQL(ctx, params, electronicTemplateInfo);
    }

    public static String generateSQL(Context ctx, Map<String, Object> params, SHRElectronicTemplateInfo electronicTemplateInfo) throws EASBizException, BOSException {
        String querySql = "";
        String schemeNum = electronicTemplateInfo.getStructureNumber();
        SqlParam sqlParam = new SqlParam();
        JSONArray selector = (JSONArray)params.get("selectorFields");
        sqlParam.setSelectMapping(ElectronicTemplateSqlUtils.assembleSelector(selector));
        if (StringUtils.isEmpty((String)schemeNum)) {
            schemeNum = scheme;
        }
        sqlParam.setScheme(schemeNum);
        sqlParam.setNeedDistinct(false);
        sqlParam.setHistoryMode(false);
        sqlParam.setNewSearch(true);
        FilterInfo filterInfo = new FilterInfo();
        String filterStr = electronicTemplateInfo.getFilterCondition();
        FilterItemInfo item = new FilterItemInfo(filterStr, (Object)BillID_Identifier_Replacement);
        filterInfo.getFilterItems().add(item);
        sqlParam.setFilterInfo(filterInfo);
        querySql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
        return querySql;
    }

    protected static Map<String, String> assembleSelector(String selector) {
        String[] columnModel = selector.split(",");
        String columnName2 = null;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String columnName2 : columnModel) {
            map.put(columnName2, columnName2);
        }
        return map;
    }

    protected static Map<String, String> assembleSelector(JSONArray selector) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (selector == null || selector.size() <= 0) {
            return map;
        }
        int length = selector.size();
        for (int i = 0; i < length; ++i) {
            JSONObject config = selector.getJSONObject(i);
            map.put(config.getString("metafield"), config.getString("metafield"));
        }
        return map;
    }

    public static String getFilterString(Context ctx, String scheme) {
        String str = ElectronicTemplateSqlUtils.getSSCStructureNoParentConfigNumber(ctx, scheme);
        str = StringUtils.isEmpty((String)str) ? Filter_String_Pre + Filter_String_Back : str + Filter_String_Back;
        return str;
    }

    private static String getSSCStructureNoParentConfigNumber(Context ctx, String scheme) {
        String returnStr = null;
        try {
            StructureConfigCollection structureColl = StructureConfigConvertHelper.getStructureConfigCollection((Context)ctx, (String)scheme);
            if (structureColl != null && structureColl.size() > 0) {
                int size = structureColl.size();
                for (int index = 0; index < size; ++index) {
                    StructureConfigInfo info = structureColl.get(index);
                    if (info.getParent() != null) continue;
                    returnStr = info.getClientNumber();
                }
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return returnStr;
    }

    public static Map<String, Object> getBizQueryParam(Context ctx, Map<String, Object> params, SHRElectronicTemplateInfo electronicTemplateInfo, FilterInfo filterItems) throws EASBizException, BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        try {
            String queryId = electronicTemplateInfo.getStructureNumber();
            String queryName = ContactBillMiddleUtils.getQueryMeta(queryId);
            MetaDataPK queryPK = MetaDataPK.create((String)queryName);
            JSONArray selector = (JSONArray)params.get("selectorFields");
            SelectorInfo selectorRec = null;
            IQueryExecutor exec = ElectronicTemplateSqlUtils.getQueryExecutor(ctx, queryName);
            EntityViewInfo entityViewInfo = ElectronicTemplateSqlUtils.getEntityViewInfo(selector, filterItems);
            exec.setObjectView(entityViewInfo);
            boolean isSQLServerDB = "MS SQL Server".equalsIgnoreCase(ContextUtil.getDbType((Context)ctx));
            selectorRec = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getQuery((IMetaDataPK)queryPK).getSelector();
            Map<String, Map<String, String>> result = ElectronicTemplateSqlUtils.initFieldsMpping((List)selector, isSQLServerDB);
            param.put("cloumnCount", selector.size());
            param.put("selector", selectorRec);
            String pro_sql = ElectronicTemplateSqlUtils.processGDPRFunc(ctx, exec.getSQL(), param);
            param.put("sql", pro_sql);
            logger.error("getBizQueryParam exec.getSQL() " + pro_sql);
            param.put(FIELDS_MPPING, result.get(FIELDS_MPPING));
            param.put(FIELDS_MPPING_BUSINESS, result.get(FIELDS_MPPING_BUSINESS));
            param.put("option", exec.option());
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return param;
    }

    public static String processGDPRFunc(Context ctx, String oldSQL, Map<String, Object> param) {
        HashMap GDPR_KEY_MAP = new HashMap();
        String SELECT_SQL = oldSQL.substring(0, oldSQL.indexOf("FROM"));
        String FORM_SQL = oldSQL.substring(oldSQL.indexOf("FROM"), oldSQL.indexOf("WHERE"));
        String WHERE_SQL = oldSQL.substring(oldSQL.indexOf("WHERE"));
        String temp = SELECT_SQL + ",";
        if (temp.contains("ISNULL")) {
            int ISNULL_INDEX = temp.indexOf("ISNULL");
            while (ISNULL_INDEX > -1) {
                String process_Str;
                int indexOf_RIGHT_brackets = temp.indexOf(")", ISNULL_INDEX);
                String pre = temp.substring(indexOf_RIGHT_brackets + 1, temp.indexOf(",", indexOf_RIGHT_brackets));
                pre = pre.trim().replaceAll("AS \"", "").replaceAll("\"", "").trim();
                String new_SELECT_SQL = process_Str = temp.substring(ISNULL_INDEX, indexOf_RIGHT_brackets + 1);
                new_SELECT_SQL = new_SELECT_SQL.replaceAll("ISNULL", "").replaceAll("\\(", "").replaceAll("\\)", "");
                String[] split = new_SELECT_SQL.split(",");
                StringBuffer new_rel = new StringBuffer();
                String pre_1 = split[0];
                String tempAlias = pre_1.replaceAll("\"", "");
                if (tempAlias.length() > 29) {
                    tempAlias = tempAlias.substring(0, 29);
                }
                String new_alias = tempAlias + "1";
                new_rel.append(pre_1).append(" AS \"").append(new_alias).append("\", ").append(split[1]);
                temp = temp.replace(process_Str, new_rel);
                ArrayList<String> pre_list = new ArrayList<String>();
                pre_list.add(pre.toLowerCase());
                pre_list.add(new_alias.toLowerCase());
                GDPR_KEY_MAP.put(pre.toLowerCase(), pre_list);
                ISNULL_INDEX = temp.indexOf("ISNULL");
            }
        }
        temp = temp.substring(0, temp.length() - 1);
        param.put(GDPR_MAPINF, GDPR_KEY_MAP);
        return temp + FORM_SQL + WHERE_SQL;
    }

    public static IQueryExecutor getQueryExecutor(Context ctx, String query) throws EASBizException, BOSException, ParserException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)query));
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        exec.option().isMultiLanguage = true;
        exec.option().pageCount = 1;
        return exec;
    }

    public static EntityViewInfo getEntityViewInfo(List<Map<String, Object>> selector, FilterInfo filterItems) throws BOSException, ParserException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterItems);
        if (selector != null && selector.size() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            for (int dex = 0; dex < selector.size(); ++dex) {
                Map<String, Object> str = selector.get(dex);
                logger.error("ElectronicTemplateSqlUtils getEntityViewInfo " + dex + " : " + str.get("metafield").toString());
                sic.add(new SelectorItemInfo(str.get("metafield").toString()));
            }
            entityViewInfo.setSelector(sic);
        }
        return entityViewInfo;
    }

    public static EntityViewInfo getEntityViewInfo(JSONArray selector, FilterInfo filterItems) throws BOSException, ParserException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterItems);
        if (selector != null && selector.size() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            for (int dex = 0; dex < selector.size(); ++dex) {
                JSONObject jsonObject = selector.getJSONObject(dex);
                sic.add(new SelectorItemInfo(jsonObject.getString("metafield")));
            }
            entityViewInfo.setSelector(sic);
        }
        return entityViewInfo;
    }

    public static EntityViewInfo getEntityViewInfo(FilterInfo filterItems) throws BOSException, ParserException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterItems);
        return entityViewInfo;
    }

    public static Map<String, Map<String, String>> initFieldsMpping(EntityViewInfo entityViewInfo, ArrayList<QueryFieldInfo> flds, boolean isSQLServerDB) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        HashMap<String, String> fieldsMpping = null;
        HashMap<String, String> fieldsMppingBusiness = null;
        if (isSQLServerDB) {
            int total = flds.size();
            fieldsMpping = new HashMap<String, String>(total);
            fieldsMppingBusiness = new HashMap<String, String>(total);
            ArrayList<String> alreadyAddList = new ArrayList<String>();
            int addIndex = 0;
            for (int i = 0; i < total; ++i) {
                QueryFieldInfo info = flds.get(i);
                String alais = info.getName();
                if (alreadyAddList.contains(alais)) continue;
                if (alais.length() >= 30) {
                    alais = alais.substring(0, 30 - String.valueOf(addIndex).length()) + String.valueOf(addIndex);
                }
                fieldsMpping.put(alais.toUpperCase(), info.getName());
                fieldsMppingBusiness.put(info.getName(), alais.toUpperCase());
                alreadyAddList.add(info.getName());
                ++addIndex;
            }
        } else {
            SelectorItemCollection coll = entityViewInfo.getSelector();
            int total = coll.size();
            fieldsMpping = new HashMap(total);
            fieldsMppingBusiness = new HashMap(total);
            ArrayList<String> alreadyAddList = new ArrayList<String>();
            int addIndex = 0;
            for (int i = 0; i < total; ++i) {
                SelectorItemInfo info = coll.get(i);
                String alais = info.getPropertyName();
                if (alreadyAddList.contains(alais)) continue;
                if (alais.length() >= 30) {
                    alais = alais.substring(0, 30 - String.valueOf(addIndex).length()) + String.valueOf(addIndex);
                }
                fieldsMpping.put(alais.toUpperCase(), info.getPropertyName());
                fieldsMppingBusiness.put(info.getPropertyName(), alais.toUpperCase());
                alreadyAddList.add(info.getPropertyName());
                ++addIndex;
            }
        }
        result.put(FIELDS_MPPING, fieldsMpping);
        result.put(FIELDS_MPPING_BUSINESS, fieldsMppingBusiness);
        return result;
    }

    public static Map<String, Map<String, String>> initFieldsMpping(List colls, ArrayList<QueryFieldInfo> flds, boolean isSQLServerDB) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        HashMap<String, String> fieldsMpping = null;
        HashMap<String, String> fieldsMppingBusiness = null;
        if (isSQLServerDB) {
            int total = flds.size();
            fieldsMpping = new HashMap<String, String>(total);
            fieldsMppingBusiness = new HashMap<String, String>(total);
            ArrayList<String> alreadyAddList = new ArrayList<String>();
            int addIndex = 0;
            for (int i = 0; i < total; ++i) {
                QueryFieldInfo info = flds.get(i);
                String alais = info.getName();
                if (alreadyAddList.contains(alais)) continue;
                if (alais.length() >= 30) {
                    alais = alais.substring(0, 30 - String.valueOf(addIndex).length()) + String.valueOf(addIndex);
                }
                fieldsMpping.put(alais.toUpperCase(), info.getName());
                fieldsMppingBusiness.put(info.getName(), alais.toUpperCase());
                alreadyAddList.add(info.getName());
                ++addIndex;
            }
        } else {
            int total = colls.size();
            fieldsMpping = new HashMap(total);
            fieldsMppingBusiness = new HashMap(total);
            ArrayList<String> alreadyAddList = new ArrayList<String>();
            int addIndex = 0;
            for (int i = 0; i < total; ++i) {
                Map str = (Map)colls.get(i);
                String alais = str.get("metafield").toString();
                if (alreadyAddList.contains(alais)) continue;
                if (alais.length() >= 30) {
                    alais = alais.substring(0, 30 - String.valueOf(addIndex).length()) + String.valueOf(addIndex);
                }
                fieldsMpping.put(alais.toUpperCase(), str.get("metafield").toString());
                fieldsMppingBusiness.put(str.get("metafield").toString(), alais.toUpperCase());
                alreadyAddList.add(str.get("metafield").toString());
                ++addIndex;
            }
        }
        result.put(FIELDS_MPPING, fieldsMpping);
        result.put(FIELDS_MPPING_BUSINESS, fieldsMppingBusiness);
        return result;
    }

    public static Map<String, Map<String, String>> initFieldsMpping(List colls, boolean isSQLServerDB) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        HashMap<String, String> fieldsMpping = null;
        HashMap<String, String> fieldsMppingBusiness = null;
        int total = colls.size();
        fieldsMpping = new HashMap<String, String>(total);
        fieldsMppingBusiness = new HashMap<String, String>(total);
        ArrayList<String> alreadyAddList = new ArrayList<String>();
        int addIndex = 0;
        for (int i = 0; i < total; ++i) {
            Map str = (Map)colls.get(i);
            String alais = str.get("metafield").toString();
            if (alreadyAddList.contains(alais)) continue;
            String realAlais = "";
            realAlais = alais.length() >= 30 ? alais.substring(0, 30 - String.valueOf(addIndex).length()) + String.valueOf(addIndex) : alais;
            fieldsMpping.put(realAlais.toUpperCase(), alais);
            fieldsMppingBusiness.put(alais, realAlais.toUpperCase());
            alreadyAddList.add(alais);
            ++addIndex;
        }
        result.put(FIELDS_MPPING, fieldsMpping);
        result.put(FIELDS_MPPING_BUSINESS, fieldsMppingBusiness);
        return result;
    }
}

