/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.emplightapp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.emplightapp.app.AbstractBriefEmpFacadeControllerBean;
import com.kingdee.shr.emplightapp.util.BriefUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BriefEmpFacadeControllerBean
extends AbstractBriefEmpFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.emplightapp.app.BriefEmpFacadeControllerBean");

    @Override
    protected Map _getEmpStructure(Context ctx, String orgId, int category, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List list = null;
        String configIdString = null;
        Map<String, Object> map = null;
        switch (category) {
            case 1: {
                map = this.getEmpAgeStructure(ctx, orgId, permItemId);
                break;
            }
            case 2: {
                map = this.getEmpWorkTimeStructure(ctx, orgId, permItemId);
                break;
            }
            case 3: {
                map = this.getEmpGenderStructure(ctx, orgId, permItemId);
                break;
            }
            case 4: {
                map = this.getEmpDiplomaStructure(ctx, orgId, permItemId);
                break;
            }
            case 5: {
                map = this.getEmpJobGradeStructure(ctx, orgId, permItemId);
                break;
            }
            case 6: {
                map = this.getEmpJobFamilyStructure(ctx, orgId, permItemId);
                break;
            }
            case 7: {
                map = this.getEmpCompanyYearStructure(ctx, orgId, permItemId);
            }
        }
        if (map != null) {
            list = (List)map.get("list");
            configIdString = (String)map.get("configId");
        }
        if (list != null && list.size() > 0) {
            resultMap.put("personList", list);
        }
        if (configIdString != null) {
            resultMap.put("configId", configIdString);
        }
        return resultMap;
    }

    @Override
    protected Map _getEmpDetail(Context ctx, String orgId, int category, String number, String permItemId) throws BOSException, EASBizException {
        return this._getEmpDetailByConfig(ctx, orgId, category, number, permItemId, null);
    }

    @Override
    protected Map _getSubHeadcountByStructure(Context ctx, String orgId, int category, String number, String permItemId) throws BOSException, EASBizException {
        return this._getSubHeadcountByStruConfig(ctx, orgId, category, number, permItemId, null);
    }

    @Override
    protected Map _getActualStaffingByStructure(Context ctx, String orgId, int category, String number, String permItemId) throws BOSException, EASBizException {
        return this._getActualStaffingByStruConfig(ctx, orgId, category, number, permItemId, null);
    }

    @Override
    protected Map _getDirectStaffingByStructure(Context ctx, String orgId, int category, String number) throws BOSException, EASBizException {
        return this._getDirectStaffingByStruConfig(ctx, orgId, category, number, null);
    }

    @Override
    protected Map _getEmpStructureCompare(Context ctx, String orgId, int category) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getEmpTopicStructure(Context ctx, String orgId, String filterParams, int dimension) throws BOSException, EASBizException {
        return null;
    }

    private String getPersonDetailByAgeSql(Context ctx, String orgId, String number, String configId) throws BOSException, EASBizException {
        String local = BriefUtil.getLocal(ctx);
        StringBuffer filter = new StringBuffer("");
        if (!StringUtils.isEmpty((String)number)) {
            filter.append(" and field.fnumber = '").append(number).append("'");
        }
        StringBuffer sql = new StringBuffer();
        String configIdString = null;
        try {
            configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_AgeStruConfig") : configId;
            sql.append("select person.fid personId,person.fname_" + local + " personName,").append(" adminOrg.fname_" + local + " as orgName,position.fname_" + local + " as positionName,photo.fimagedata").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_ORG_Admin adminOrg on emprelation.fadminorgid = adminOrg.fid").append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" left join T_HR_PersonPhoto photo on person.fid = photo.fpersonid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_PersonOtherInfo personother on personother.fpersonid = emprelation.fpersonid").append(" inner join T_MGR_AgeStruConfigField field on field.fstartAge < personother.fage and field.fendAge >= personother.fage").append(" inner join T_MGR_AgeStruConfig config on field.fparentid = config.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emptype.fisonthestrength = 1").append(" and emprelation.FIsLatestInAday = 1").append(" and config.fid = '").append(configIdString + "'").append(filter).append(" order by position.findex,position.fnumber,person.findex,person.fnumber asc");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return sql.toString();
    }

    private String getPersonDetailByCompanyYearSql(Context ctx, String orgId, String number, String configId) throws BOSException {
        String local = BriefUtil.getLocal(ctx);
        String cmpareType = this.getCompareTypeByCompanyYear(ctx, number, orgId);
        StringBuffer filter = new StringBuffer("");
        if (!StringUtils.isEmpty((String)number)) {
            filter.append(" and field.fnumber = '").append(number).append("'");
        }
        StringBuffer sql = new StringBuffer();
        String configIdString = null;
        try {
            configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_CompanyYearStruConfig") : configId;
            sql.append("select person.fid personId,person.fname_" + local + " personName,").append(" adminOrg.fname_" + local + " as orgName,position.fname_" + local + " as positionName,photo.fimagedata").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_ORG_Admin adminOrg on emprelation.fadminorgid = adminOrg.fid").append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" left join T_HR_PersonPhoto photo on person.fid = photo.fpersonid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_PersonPosition pp on pp.fpersonid = emprelation.fpersonid").append(" inner join T_MGR_CompanyYearConfigField field on field.fstartCompanyYear ").append(cmpareType).append(" pp.FJoinCompanyYears and field.fendCompanyYear >= pp.FJoinCompanyYears").append(" inner join T_MGR_CompanyYearStruConfig config on field.fparentid = config.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" and config.fid = '").append(configIdString + "'").append(filter).append(" order by position.findex,position.fnumber,person.findex,person.fnumber asc");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return sql.toString();
    }

    private String getCompareTypeByCompanyYear(Context ctx, String number, String orgId) throws BOSException {
        String fieldNumber = this.getCompanyYearConfigFieldNumber(ctx, orgId);
        String cmpareType = "<";
        if (!StringUtils.isEmpty((String)number) && !StringUtils.isEmpty((String)fieldNumber) && fieldNumber.equals(number)) {
            cmpareType = "<=";
        }
        return cmpareType;
    }

    private String getPersonDetailByWorkTimeSql(Context ctx, String orgId, String number, String configId) throws BOSException {
        String local = BriefUtil.getLocal(ctx);
        String cmpareType = this.getCompareTypeByWorkTime(ctx, number, orgId);
        StringBuffer filter = new StringBuffer("");
        if (!StringUtils.isEmpty((String)number)) {
            filter.append(" and field.fnumber = '").append(number).append("'");
        }
        StringBuffer sql = new StringBuffer();
        String configIdString = null;
        try {
            configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_WorkTimeStruConfig") : configId;
            sql.append("select person.fid personId,person.fname_" + local + " personName,").append(" adminOrg.fname_" + local + " as orgName,position.fname_" + local + " as positionName,photo.fimagedata").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_ORG_Admin adminOrg on emprelation.fadminorgid = adminOrg.fid").append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" left join T_HR_PersonPhoto photo on person.fid = photo.fpersonid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_PersonOtherInfo personother on personother.fpersonid = emprelation.fpersonid").append(" inner join T_MGR_WorkTimeStruConfigField field on field.fstartworktime ").append(cmpareType).append(" personother.FSocialServiceYears and field.fendworktime >= personother.FSocialServiceYears").append(" inner join T_MGR_WorkTimeStruConfig config on field.fparentid = config.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" and config.fid = '").append(configIdString + "'").append(filter).append(" order by position.findex,position.fnumber,person.findex,person.fnumber asc");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return sql.toString();
    }

    private String getCompareTypeByWorkTime(Context ctx, String number, String orgId) throws BOSException {
        String fieldNumber = this.getWorkTimeConfigFieldNumber(ctx, orgId);
        String cmpareType = "<";
        if (!StringUtils.isEmpty((String)number) && !StringUtils.isEmpty((String)fieldNumber) && fieldNumber.equals(number)) {
            cmpareType = "<=";
        }
        return cmpareType;
    }

    private String getWorkTimeConfigFieldNumber(Context ctx, String orgId) throws BOSException {
        String fieldNumber = "";
        try {
            String configIdString = BriefUtil.getConfigId(ctx, orgId, "T_MGR_WorkTimeStruConfig");
            StringBuffer sql = new StringBuffer("select field.fnumber from T_MGR_WorkTimeStruConfigField field").append(" inner join T_MGR_WorkTimeStruConfig config on field.fparentid = config.fid").append(" where field.fstartworktime = 0").append(" and config.fid = '").append(configIdString + "'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                fieldNumber = rowSet.getString("fnumber");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return fieldNumber;
    }

    private String getPersonDetailByGenderSql(Context ctx, String orgId, String number, String configId) {
        String local = BriefUtil.getLocal(ctx);
        StringBuffer filter = new StringBuffer("");
        if (!StringUtils.isEmpty((String)number)) {
            int gender = Integer.parseInt(number);
            filter.append(" and person.fgender = ").append(gender);
        }
        StringBuffer sql = new StringBuffer("select person.fid personId,person.fname_" + local + " personName,").append(" adminOrg.fname_" + local + " as orgName,position.fname_" + local + " as positionName,photo.fimagedata").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_ORG_Admin adminOrg on emprelation.fadminorgid = adminOrg.fid").append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" left join T_HR_PersonPhoto photo on person.fid = photo.fpersonid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(filter).append(" order by position.findex,position.fnumber,person.findex,person.fnumber asc");
        return sql.toString();
    }

    private String getPersonDetailByDiplomaSql(Context ctx, String orgId, String number, String configId) throws BOSException {
        String local = BriefUtil.getLocal(ctx);
        StringBuffer filter = new StringBuffer("");
        StringBuffer sql = new StringBuffer("");
        if (!StringUtils.isEmpty((String)number)) {
            filter.append(" and diplomafield.fnumber = '").append(number).append("'");
        }
        String configIdString = null;
        try {
            configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_DiplomaStruConfig") : configId;
            sql.append("select person.fid personId,person.fname_" + local + " personName,").append(" adminOrg.fname_" + local + " as orgName,position.fname_" + local + " as positionName,photo.fimagedata").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_ORG_Admin adminOrg on emprelation.fadminorgid = adminOrg.fid").append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" left join T_HR_PersonPhoto photo on person.fid = photo.fpersonid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_PersonDegree degree on degree.fpersonid = emprelation.fpersonid").append(" inner join T_BD_HRDiploma diploma on degree.fdiploma = diploma.fid").append(" inner join T_MGR_DiplomaStruConfigField diplomafield on diplomafield.fstartLevel < diploma.flevelcode and diplomafield.fendLevel >= diploma.flevelcode").append(" inner join T_MGR_DiplomaStruConfig diplomaconfig on diplomafield.fparentid = diplomaconfig.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" and degree.fishighest = 1").append(" and diplomaconfig.fid = '").append(configIdString + "'").append(filter).append(" order by position.findex,position.fnumber,person.findex,person.fnumber asc");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return sql.toString();
    }

    private String getPersonDetailByJobGradeSql(Context ctx, String orgId, String number, String configId) {
        String local = BriefUtil.getLocal(ctx);
        StringBuffer filter = new StringBuffer("");
        if (!StringUtils.isEmpty((String)number)) {
            filter.append(" and jobgrade.fnumber = '").append(number).append("'");
        }
        StringBuffer sql = new StringBuffer("select person.fid personId,person.fname_" + local + " personName,").append(" adminOrg.fname_" + local + " as orgName,position.fname_" + local + " as positionName,photo.fimagedata").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_ORG_Admin adminOrg on emprelation.fadminorgid = adminOrg.fid").append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" left join T_HR_PersonPhoto photo on person.fid = photo.fpersonid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_EmpPostRank emppostrank on emppostrank.fpersonid = emprelation.fpersonid").append(" inner join T_HR_JobGrade jobgrade on emppostrank.fjobgradeid = jobgrade.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(filter).append(" order by position.findex,position.fnumber,person.findex,person.fnumber asc");
        return sql.toString();
    }

    private String getPersonDetailByJobFamilySql(Context ctx, String orgId, String number, String configId) {
        String local = BriefUtil.getLocal(ctx);
        StringBuffer filter = new StringBuffer("");
        if (!StringUtils.isEmpty((String)number)) {
            filter.append(" and jobfamily.fnumber = '").append(number).append("'");
        }
        StringBuffer sql = new StringBuffer("select person.fid personId,person.fname_" + local + " personName,").append(" adminOrg.fname_" + local + " as orgName,position.fname_" + local + " as positionName,photo.fimagedata").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_ORG_Admin adminOrg on emprelation.fadminorgid = adminOrg.fid").append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" left join T_HR_PersonPhoto photo on person.fid = photo.fpersonid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_ORG_Job jobT on jobT.fid = position.fjobid").append(" inner join T_HR_HRJob hrjob on hrjob.FJobID = jobT.fid").append(" inner join T_HR_HRJobFamily jobfamily on jobfamily.fid = hrjob.FHRJobFamilyID").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(filter).append(" order by position.findex,position.fnumber,person.findex,person.fnumber asc");
        return sql.toString();
    }

    private String getPersonDetailSql(Context ctx, String orgId) {
        String local = BriefUtil.getLocal(ctx);
        StringBuffer sql = new StringBuffer("select person.fid personId,person.fname_" + local + " personName,").append(" adminOrg.fname_" + local + " as orgName,position.fname_" + local + " as positionName,photo.fimagedata").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_ORG_Admin adminOrg on emprelation.fadminorgid = adminOrg.fid").append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" left join T_HR_PersonPhoto photo on person.fid = photo.fpersonid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" order by position.findex,position.fnumber,person.findex,person.fnumber asc");
        return sql.toString();
    }

    private Map<String, Object> getEmpAgeStructure(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        ArrayList<Map> list = new ArrayList<Map>();
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        int headcount = 0;
        String configIdString = null;
        try {
            configIdString = BriefUtil.getConfigId(ctx, orgId, "T_MGR_AgeStruConfig");
            StringBuffer sql = new StringBuffer("select field.fstartAge,field.flabel,field.fnumber,count(ageTable.fage) as count, field.fstdvalue as standard").append(" from T_MGR_AgeStruConfigField field").append(" inner join T_MGR_AgeStruConfig config on field.fparentid = config.fid").append(" left join (").append(" select emprelation.fpersonid,personother.fage from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_PersonOtherInfo personother on personother.fpersonid = emprelation.fpersonid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" and personother.fage is not null").append(" ) ageTable on field.fstartAge < ageTable.fage and field.fendAge >= ageTable.fage").append(" where config.fid = '").append(configIdString + "'").append(" group by field.fstartAge,field.flabel,field.fnumber,field.fstdvalue").append(" order by field.fstartAge asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String label = rowSet.getString("flabel");
                int count = rowSet.getInt("count");
                String number = rowSet.getString("fnumber");
                String standard = String.valueOf(BriefUtil.round(rowSet.getDouble("standard"), 2));
                headcount += count;
                map.put("label", label);
                map.put("count", count);
                map.put("number", number);
                map.put("standard", standard);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        BriefUtil.getPercent(list, headcount);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("configId", configIdString);
        return map;
    }

    private Map<String, Object> getEmpCompanyYearStructure(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        String filedNumber = this.getCompanyYearConfigFieldNumber(ctx, orgId);
        ArrayList<Map> list = new ArrayList<Map>();
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        int headcount = 0;
        String configIdString = null;
        try {
            configIdString = BriefUtil.getConfigId(ctx, orgId, "T_MGR_CompanyYearStruConfig");
            String local = BriefUtil.getLocal(ctx);
            StringBuffer sql = new StringBuffer("select field.fstartCompanyYear,field.flabel_").append(local).append(" as flabel,").append(" field.fnumber,count(companyYearTable.FJoinCompanyYears) as count, field.fstdvalue as standard").append(" from T_MGR_CompanyYearConfigField field").append(" inner join T_MGR_CompanyYearStruConfig config on field.fparentid = config.fid").append(" left join (").append(" select emprelation.fpersonid,pp.FJoinCompanyYears from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_PersonPosition pp on pp.fpersonid = emprelation.fpersonid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" and pp.FJoinCompanyYears is not null").append(" ) companyYearTable on field.fstartCompanyYear < companyYearTable.FJoinCompanyYears and field.fendCompanyYear >= companyYearTable.FJoinCompanyYears").append(" where config.fid = '").append(configIdString + "'").append(" group by field.fstartCompanyYear,field.flabel_").append(local).append(",").append(" field.fnumber,field.fstdvalue").append(" order by field.fstartCompanyYear asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String label = rowSet.getString("flabel");
                int count = rowSet.getInt("count");
                String number = rowSet.getString("fnumber");
                String standard = String.valueOf(BriefUtil.round(rowSet.getDouble("standard"), 2));
                if (!StringUtils.isEmpty((String)filedNumber) && !StringUtils.isEmpty((String)filedNumber) && filedNumber.equals(number)) {
                    int otherHeadCount = this.getOtherHeadcountByCompanyYear(ctx, orgId, userId, permItemId);
                    count += otherHeadCount;
                }
                headcount += count;
                map.put("label", label);
                map.put("count", count);
                map.put("number", number);
                map.put("standard", standard);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        BriefUtil.getPercent(list, headcount);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("configId", configIdString);
        return map;
    }

    private String getCompanyYearConfigFieldNumber(Context ctx, String orgId) throws BOSException {
        String fieldNumber = "";
        try {
            String configIdString = BriefUtil.getConfigId(ctx, orgId, "T_MGR_CompanyYearStruConfig");
            StringBuffer sql = new StringBuffer("select field.fnumber from T_MGR_CompanyYearConfigField field").append(" inner join T_MGR_CompanyYearStruConfig config on field.fparentid = config.fid").append(" where field.fstartcompanyYear = 0").append(" and config.fid = '").append(configIdString + "'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                fieldNumber = rowSet.getString("fnumber");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return fieldNumber;
    }

    private int getOtherHeadcountByCompanyYear(Context ctx, String orgId, String userId, String permItemId) throws BOSException, EASBizException {
        int otherHeadcount = 0;
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        try {
            StringBuffer sql = new StringBuffer("select count(emprelation.fpersonid) otherHeadcount from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_PersonPosition pp on pp.fpersonid = emprelation.fpersonid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" and pp.FJoinCompanyYears = 0");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                otherHeadcount = rowSet.getInt("otherHeadcount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return otherHeadcount;
    }

    private Map<String, Object> getEmpWorkTimeStructure(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        String filedNumber = this.getWorkTimeConfigFieldNumber(ctx, orgId);
        ArrayList<Map> list = new ArrayList<Map>();
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        int headcount = 0;
        String configIdString = null;
        try {
            configIdString = BriefUtil.getConfigId(ctx, orgId, "T_MGR_WorkTimeStruConfig");
            StringBuffer sql = new StringBuffer("select field.fstartworktime,field.flabel,field.fnumber,count(workTimeTable.FSocialServiceYears) as count, field.fstdvalue as standard").append(" from T_MGR_WorkTimeStruConfigField field").append(" inner join T_MGR_WorkTimeStruConfig config on field.fparentid = config.fid").append(" left join (").append(" select emprelation.fpersonid,personother.FSocialServiceYears from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_PersonOtherInfo personother on personother.fpersonid = emprelation.fpersonid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" and personother.FSocialServiceYears is not null").append(" ) workTimeTable on field.fstartworktime < workTimeTable.FSocialServiceYears and field.fendworktime >= workTimeTable.FSocialServiceYears").append(" where config.fid = '").append(configIdString + "'").append(" group by field.fstartworktime,field.flabel,field.fnumber,field.fstdvalue").append(" order by field.fstartworktime asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String label = rowSet.getString("flabel");
                int count = rowSet.getInt("count");
                String number = rowSet.getString("fnumber");
                String standard = String.valueOf(BriefUtil.round(rowSet.getDouble("standard"), 2));
                if (!StringUtils.isEmpty((String)filedNumber) && !StringUtils.isEmpty((String)filedNumber) && filedNumber.equals(number)) {
                    int otherHeadCount = this.getOtherHeadcountByWorkTime(ctx, orgId, userId, permItemId);
                    count += otherHeadCount;
                }
                headcount += count;
                map.put("label", label);
                map.put("count", count);
                map.put("number", number);
                map.put("standard", standard);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        BriefUtil.getPercent(list, headcount);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("configId", configIdString);
        return map;
    }

    private int getOtherHeadcountByWorkTime(Context ctx, String orgId, String userId, String permItemId) throws BOSException, EASBizException {
        int otherHeadcount = 0;
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        try {
            StringBuffer sql = new StringBuffer("select count(emprelation.fpersonid) otherHeadcount from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_PersonOtherInfo personother on personother.fpersonid = emprelation.fpersonid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" and personother.FSocialServiceYears = 0");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                otherHeadcount = rowSet.getInt("otherHeadcount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return otherHeadcount;
    }

    private Map<String, Object> getEmpGenderStructure(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        ArrayList<Map> list = new ArrayList<Map>();
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        int headcount = 0;
        String configIdString = null;
        try {
            configIdString = BriefUtil.getConfigId(ctx, orgId, "T_MGR_GenderStructureConfig");
            StringBuffer sql = new StringBuffer("select field.fgender,field.FStdValue standard,count(genderTable.fpersonid) count").append(" from T_MGR_GenderStruConfigField field").append(" inner join T_MGR_GenderStructureConfig config on field.fparentid = config.fid").append(" left join (").append("select person.fgender,emprelation.fpersonid from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_BD_Person person on person.fid = emprelation.fpersonid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" and person.fgender in (1, 2)").append(" ) genderTable on field.fgender = genderTable.fgender").append(" where config.fid ='").append(configIdString + "'").append(" group by field.fgender,field.FStdValue").append(" order by field.fgender asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String alias = "";
                HashMap<String, Object> map = new HashMap<String, Object>();
                int gender = rowSet.getInt("fgender");
                int count = rowSet.getInt("count");
                String standard = String.valueOf(BriefUtil.round(rowSet.getDouble("standard"), 2));
                switch (gender) {
                    case 1: {
                        alias = Genders.Male.getAlias();
                        break;
                    }
                    case 2: {
                        alias = Genders.Female.getAlias();
                    }
                }
                headcount += count;
                map.put("number", gender);
                map.put("label", alias);
                map.put("count", count);
                map.put("standard", standard);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        BriefUtil.getPercent(list, headcount);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("configId", configIdString);
        return map;
    }

    private Map<String, Object> getEmpDiplomaStructure(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        ArrayList<Map> list = new ArrayList<Map>();
        String local = BriefUtil.getLocal(ctx);
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        int headcount = 0;
        String configIdString = null;
        try {
            configIdString = BriefUtil.getConfigId(ctx, orgId, "T_MGR_DiplomaStruConfig");
            StringBuffer sql = new StringBuffer("select field.FStartLevel,field.flabel,field.fnumber,field.FStdValue standard,count(diplomaTable.fpersonid) count").append(" from T_MGR_DiplomaStruConfigField field").append(" inner join T_MGR_DiplomaStruConfig config on field.fparentid = config.fid").append(" left join (").append("select diploma.fname_").append(local).append(",diploma.flevelcode fnumber,emprelation.fpersonid from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_PersonDegree degree on degree.fpersonid = emprelation.fpersonid").append(" inner join T_BD_HRDiploma diploma on degree.fdiploma = diploma.fid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" and degree.fishighest = 1").append(" ) diplomaTable on field.FStartLevel<diplomaTable.fnumber and field.FEndLevel>=diplomaTable.fnumber").append(" where config.fid = '").append(configIdString + "'").append(" group by field.FStartLevel,field.flabel,field.fnumber,field.FStdValue").append(" order by field.FStartLevel asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String diploma = rowSet.getString("flabel");
                int count = rowSet.getInt("count");
                String number = rowSet.getString("fnumber");
                String standard = String.valueOf(BriefUtil.round(rowSet.getDouble("standard"), 2));
                headcount += count;
                map.put("label", diploma);
                map.put("count", count);
                map.put("number", number);
                map.put("standard", standard);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        BriefUtil.getPercent(list, headcount);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("configId", configIdString);
        return map;
    }

    private Map<String, Object> getEmpJobGradeStructure(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        ArrayList<Map> list = new ArrayList<Map>();
        String local = BriefUtil.getLocal(ctx);
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        int headcount = 0;
        String configIdString = null;
        try {
            configIdString = BriefUtil.getConfigId(ctx, orgId, "T_MGR_JobGradeStruStd");
            StringBuffer sql = new StringBuffer("select jobgrade.fname_").append(local).append(",jobgrade.fnumber,field.FStdValue standard,count(jobGradeTable.fpersonid) count").append(" from T_HR_JobGrade jobgrade").append(" left join T_MGR_JobGradeStruStdEntry field on field.fjobGradeid = jobgrade.fid").append(" left join T_MGR_JobGradeStruStd config on field.fparentid = config.fid").append(" left join (").append("select jobgrade.fname_").append(local).append(",jobgrade.fid,emprelation.fpersonid from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_EmpPostRank emppostrank on emppostrank.fpersonid = emprelation.fpersonid").append(" inner join T_HR_JobGrade jobgrade on emppostrank.fjobgradeid = jobgrade.fid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" and emppostrank.fislatest = 1").append(" ) jobGradeTable on field.FJobGradeID = jobGradeTable.fid").append(" where config.fid = '").append(configIdString + "'").append(" group by jobgrade.fname_").append(local).append(",jobgrade.fnumber,field.FStdValue").append(" order by jobgrade.fnumber asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String jobgrade = rowSet.getString("fname_" + local);
                int count = rowSet.getInt("count");
                String number = rowSet.getString("fnumber");
                String standard = String.valueOf(BriefUtil.round(rowSet.getDouble("standard"), 2));
                headcount += count;
                map.put("label", jobgrade);
                map.put("count", count);
                map.put("number", number);
                map.put("standard", standard);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        BriefUtil.getPercent(list, headcount);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("configId", configIdString);
        return map;
    }

    private Map<String, Object> getEmpJobFamilyStructure(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        ArrayList<Map> list = new ArrayList<Map>();
        String local = BriefUtil.getLocal(ctx);
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        int headcount = 0;
        String configIdString = null;
        try {
            configIdString = BriefUtil.getConfigId(ctx, orgId, "T_MGR_JobFamilyStruStd");
            StringBuffer sql = new StringBuffer("select jobfamily.fname_" + local + " as flabel,jobfamily.fnumber,field.FStdValue standard,count(jobFamilyTable.fpersonid) as count").append(" from T_HR_HrJobFamily jobfamily ").append(" left join T_MGR_JobFamilyStruStdEntry field on field.fhrjobfamilyid = jobfamily.fid").append(" left join T_MGR_JobFamilyStruStd config on field.fparentid = config.fid").append(" and config.fid = '").append(configIdString + "'").append(" left join (").append("select jobfamily.fid,emprelation.fpersonid from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_ORG_Position position on position.fid = emprelation.fpositionid").append(" inner join T_ORG_Job jobT on jobT.fid = position.fjobid").append(" inner join T_HR_HRJob hrjob on hrjob.FJobID = jobT.fid").append(" inner join T_HR_HRJobFamily jobfamily on jobfamily.fid = hrjob.FHRJobFamilyID").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" ) jobFamilyTable on jobfamily.fid = jobFamilyTable.fid").append(" where jobfamily.fstate = 1").append(" group by jobfamily.fname_").append(local).append(",jobfamily.fnumber,field.FStdValue").append(" order by jobfamily.fnumber asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String job = rowSet.getString("flabel");
                int count = rowSet.getInt("count");
                String number = rowSet.getString("fnumber");
                String standard = String.valueOf(BriefUtil.round(rowSet.getDouble("standard"), 2));
                headcount += count;
                map.put("label", job);
                map.put("count", count);
                map.put("number", number);
                map.put("standard", standard);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        BriefUtil.getPercent(list, headcount);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("configId", configIdString);
        return map;
    }

    private StringBuffer getActualStaffingSql(Context ctx, String permItemId) {
        String userId = BriefUtil.getUserId(ctx);
        StringBuffer sql = new StringBuffer("select count(emprelation.fpersonid) actualStaffing").append(" from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid ").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid");
        return sql;
    }

    private StringBuffer getActualStaffingFilter(Context ctx, String orgId, String permItemId) throws BOSException {
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        StringBuffer sql = new StringBuffer(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1");
        return sql;
    }

    private StringBuffer getNumberFilter(int category, String number) {
        StringBuffer filter = new StringBuffer("");
        if (!StringUtils.isEmpty((String)number)) {
            switch (category) {
                case 1: {
                    filter.append(" and field.fnumber = '").append(number).append("'");
                    break;
                }
                case 2: {
                    filter.append(" and field.fnumber = '").append(number).append("'");
                    break;
                }
                case 3: {
                    int gender = Integer.parseInt(number);
                    filter.append(" and person.fgender = ").append(gender);
                    break;
                }
                case 4: {
                    filter.append(" and diplomafield.fnumber = '").append(number).append("'");
                    break;
                }
                case 5: {
                    filter.append(" and jobgrade.fnumber = '").append(number).append("'");
                    break;
                }
                case 6: {
                    filter.append(" and jobfamily.fnumber = '").append(number).append("'");
                    break;
                }
                case 7: {
                    filter.append(" and field.fnumber = '").append(number).append("'");
                }
            }
        }
        return filter;
    }

    private StringBuffer getDirectStaffingSql(Context ctx) {
        StringBuffer sql = new StringBuffer("select count(emprelation.fpersonid) actualStaffing").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid");
        return sql;
    }

    private StringBuffer getDirectStaffingFilter(String orgId) {
        StringBuffer sql = new StringBuffer(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1");
        return sql;
    }

    private Map getSubStaffingByEmpStructure(Context ctx, String orgId, int category, String number, String tempTableName, String permItemId) throws BOSException, EASBizException {
        return this.getSubStaffingByEmpStruConfig(ctx, orgId, category, number, tempTableName, permItemId, null);
    }

    private Map getSubStaffingByEmpStruConfig(Context ctx, String orgId, int category, String number, String tempTableName, String permItemId, String configId) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        StringBuffer subStaffingSql = this.getSubStaffingSql(ctx, tempTableName, permItemId);
        StringBuffer subStaffingFilter = this.getSubStaffingFilter(orgId);
        StringBuffer numberFilter = this.getNumberFilter(category, number);
        String configIdString = null;
        switch (category) {
            case 1: {
                configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_AgeStruConfig") : configId;
                subStaffingSql.append(" inner join T_HR_PersonOtherInfo personother on personother.fpersonid = emprelation.fpersonid").append(" inner join T_MGR_AgeStruConfigField field on field.fstartAge < personother.fage and field.fendAge >= personother.fage").append(" inner join T_MGR_AgeStruConfig config on field.fparentid = config.fid").append(subStaffingFilter).append(" and config.fid = '").append(configIdString + "'").append(numberFilter).append(" group by adcount.fid").append(" ) actualStaffing on adminOrg.fid = actualStaffing.adcountid");
                break;
            }
            case 2: {
                configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_WorkTimeStruConfig") : configId;
                String cmpareType = this.getCompareTypeByWorkTime(ctx, number, orgId);
                subStaffingSql.append(" inner join T_HR_PersonOtherInfo personother on personother.fpersonid = emprelation.fpersonid").append(" inner join T_MGR_WorkTimeStruConfigField field on field.fstartworktime ").append(cmpareType).append(" personother.FSocialServiceYears and field.fendworktime >= personother.FSocialServiceYears").append(" inner join T_MGR_WorkTimeStruConfig config on field.fparentid = config.fid").append(subStaffingFilter).append(" and config.fid = '").append(configIdString + "'").append(numberFilter).append(" group by adcount.fid").append(" ) actualStaffing on adminOrg.fid = actualStaffing.adcountid");
                break;
            }
            case 3: {
                subStaffingSql.append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(subStaffingFilter).append(numberFilter).append(" group by adcount.fid").append(" ) actualStaffing on adminOrg.fid = actualStaffing.adcountid");
                break;
            }
            case 4: {
                configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_DiplomaStruConfig") : configId;
                subStaffingSql.append(" inner join T_HR_PersonDegree degree on degree.fpersonid = emprelation.fpersonid").append(" inner join T_BD_HRDiploma diploma on degree.fdiploma = diploma.fid").append(" inner join T_MGR_DiplomaStruConfigField diplomafield on diplomafield.fstartLevel < diploma.flevelcode and diplomafield.fendLevel >= diploma.flevelcode").append(" inner join T_MGR_DiplomaStruConfig diplomaconfig on diplomafield.fparentid = diplomaconfig.fid").append(subStaffingFilter).append(" and diplomaconfig.fid = '").append(configIdString + "'").append(" and degree.fishighest = 1").append(numberFilter).append(" group by adcount.fid").append(" ) actualStaffing on adminOrg.fid = actualStaffing.adcountid");
                break;
            }
            case 5: {
                subStaffingSql.append(" inner join T_HR_EmpPostRank emppostrank on emppostrank.fpersonid = emprelation.fpersonid").append(" inner join T_HR_JobGrade jobgrade on emppostrank.fjobgradeid = jobgrade.fid").append(subStaffingFilter).append(numberFilter).append(" group by adcount.fid").append(" ) actualStaffing on adminOrg.fid = actualStaffing.adcountid");
                break;
            }
            case 6: {
                subStaffingSql.append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_ORG_Job jobT on jobT.fid = position.fjobid").append(" inner join T_HR_HRJob hrjob on hrjob.FJobID = jobT.fid").append(" inner join T_HR_HRJobFamily jobfamily on jobfamily.fid = hrjob.FHRJobFamilyID").append(subStaffingFilter).append(numberFilter).append(" group by adcount.fid").append(" ) actualStaffing on adminOrg.fid = actualStaffing.adcountid");
                break;
            }
            case 7: {
                configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_CompanyYearStruConfig") : configId;
                String compareType = this.getCompareTypeByCompanyYear(ctx, number, orgId);
                subStaffingSql.append(" inner join T_HR_PersonPosition pp on pp.fpersonid = emprelation.fpersonid").append(" inner join T_MGR_CompanyYearConfigField field on field.fstartCompanyYear ").append(compareType).append(" pp.FJoinCompanyYears and field.fendCompanyYear >= pp.FJoinCompanyYears").append(" inner join T_MGR_CompanyYearStruConfig config on field.fparentid = config.fid").append(subStaffingFilter).append(" and config.fid = '").append(configIdString + "'").append(numberFilter).append(" group by adcount.fid").append(" ) actualStaffing on adminOrg.fid = actualStaffing.adcountid");
                break;
            }
            default: {
                subStaffingSql.append(subStaffingFilter).append(" group by adcount.fid").append(" ) actualStaffing on adminOrg.fid = actualStaffing.adcountid");
            }
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)subStaffingSql.toString());
            while (rowSet.next()) {
                String subAdminOrgId = rowSet.getString("fid");
                int subActualStaffing = rowSet.getInt("subActualStaffing");
                map.put(subAdminOrgId, subActualStaffing);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    private StringBuffer getSubStaffingSql(Context ctx, String tempTableName, String permItemId) {
        String userId = BriefUtil.getUserId(ctx);
        StringBuffer sql = new StringBuffer("select adminOrg.fid,isnull(actualStaffing.subActualStaffing,0) subActualStaffing").append(" from ").append(tempTableName).append(" adminOrg").append(" left join (").append(" select adcount.fid adcountid,count(emprelation.fpersonid) subActualStaffing from T_ORG_Admin adcount").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" left join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" left join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" left join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid");
        return sql;
    }

    private StringBuffer getSubStaffingFilter(String orgId) {
        StringBuffer sql = new StringBuffer(" where adcount.fparentid = '").append(orgId).append("'").append(" and adcount.fissealup = 0 and child.fissealup = 0").append(" and adcount.fisstartshr = 1 and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1");
        return sql;
    }

    @Override
    protected Map _getActualStaffingByStruConfig(Context ctx, String orgId, int category, String number, String permItemId, String configId) throws BOSException, EASBizException {
        HashMap<String, Integer> actualStaffingMap = new HashMap<String, Integer>();
        StringBuffer actualStaffingSql = this.getActualStaffingSql(ctx, permItemId);
        StringBuffer actualStaffingFilter = this.getActualStaffingFilter(ctx, orgId, permItemId);
        StringBuffer numberFilter = this.getNumberFilter(category, number);
        int actualStaffing = 0;
        String configIdString = null;
        switch (category) {
            case 1: {
                configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_AgeStruConfig") : configId;
                actualStaffingSql.append(" inner join T_HR_PersonOtherInfo personother on personother.fpersonid = emprelation.fpersonid").append(" inner join T_MGR_AgeStruConfigField field on field.fstartAge < personother.fage and field.fendAge >= personother.fage").append(" inner join T_MGR_AgeStruConfig config on field.fparentid = config.fid").append(actualStaffingFilter).append(" and config.fid = '").append(configIdString + "'").append(numberFilter);
                break;
            }
            case 2: {
                configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_WorkTimeStruConfig") : configId;
                String cmpareType = this.getCompareTypeByWorkTime(ctx, number, orgId);
                actualStaffingSql.append(" inner join T_HR_PersonOtherInfo personother on personother.fpersonid = emprelation.fpersonid").append(" inner join T_MGR_WorkTimeStruConfigField field on field.fstartworktime ").append(cmpareType).append(" personother.FSocialServiceYears and field.fendworktime >= personother.FSocialServiceYears").append(" inner join T_MGR_WorkTimeStruConfig config on field.fparentid = config.fid").append(actualStaffingFilter).append(" and config.fid = '").append(configIdString + "'").append(numberFilter);
                break;
            }
            case 7: {
                configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_CompanyYearStruConfig") : configId;
                String compareType = this.getCompareTypeByCompanyYear(ctx, number, orgId);
                actualStaffingSql.append(" inner join T_HR_PersonPosition pp on pp.fpersonid = emprelation.fpersonid").append(" inner join T_MGR_CompanyYearConfigField field on field.fstartCompanyYear ").append(compareType).append(" pp.FJoinCompanyYears and field.fendCompanyYear >= pp.FJoinCompanyYears").append(" inner join T_MGR_CompanyYearStruConfig config on field.fparentid = config.fid").append(actualStaffingFilter).append(" and config.fid = '").append(configIdString + "'").append(numberFilter);
                break;
            }
            case 3: {
                actualStaffingSql.append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(actualStaffingFilter).append(numberFilter);
                break;
            }
            case 4: {
                configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_DiplomaStruConfig") : configId;
                actualStaffingSql.append(" inner join T_HR_PersonDegree degree on degree.fpersonid = emprelation.fpersonid").append(" inner join T_BD_HRDiploma diploma on degree.fdiploma = diploma.fid").append(" inner join T_MGR_DiplomaStruConfigField diplomafield on diplomafield.fstartLevel < diploma.flevelcode and diplomafield.fendLevel >= diploma.flevelcode").append(" inner join T_MGR_DiplomaStruConfig diplomaconfig on diplomafield.fparentid = diplomaconfig.fid").append(actualStaffingFilter).append(" and diplomaconfig.fid = '").append(configIdString + "'").append(" and degree.fishighest = 1").append(numberFilter);
                break;
            }
            case 5: {
                actualStaffingSql.append(" inner join T_HR_EmpPostRank emppostrank on emppostrank.fpersonid = emprelation.fpersonid").append(" inner join T_HR_JobGrade jobgrade on emppostrank.fjobgradeid = jobgrade.fid").append(actualStaffingFilter).append(numberFilter);
                break;
            }
            case 6: {
                actualStaffingSql.append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_ORG_Job jobT on jobT.fid = position.fjobid").append(" inner join T_HR_HRJob hrjob on hrjob.FJobID = jobT.fid").append(" inner join T_HR_HRJobFamily jobfamily on jobfamily.fid = hrjob.FHRJobFamilyID").append(actualStaffingFilter).append(numberFilter);
                break;
            }
            default: {
                actualStaffingSql.append(actualStaffingFilter);
            }
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)actualStaffingSql.toString());
            while (rowSet.next()) {
                actualStaffing = rowSet.getInt("actualStaffing");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        actualStaffingMap.put("actualStaffing", actualStaffing);
        return actualStaffingMap;
    }

    @Override
    protected Map _getDirectStaffingByStruConfig(Context ctx, String orgId, int category, String number, String configId) throws BOSException, EASBizException {
        HashMap<String, Integer> directStaffingMap = new HashMap<String, Integer>();
        StringBuffer directStaffingSql = this.getDirectStaffingSql(ctx);
        StringBuffer directStaffingFilter = this.getDirectStaffingFilter(orgId);
        StringBuffer numberFilter = this.getNumberFilter(category, number);
        int directActualStaffing = 0;
        String configIdString = null;
        switch (category) {
            case 1: {
                configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_AgeStruConfig") : configId;
                directStaffingSql.append(" inner join T_HR_PersonOtherInfo personother on personother.fpersonid = emprelation.fpersonid").append(" inner join T_MGR_AgeStruConfigField field on field.fstartAge < personother.fage and field.fendAge >= personother.fage").append(" inner join T_MGR_AgeStruConfig config on field.fparentid = config.fid").append(directStaffingFilter).append(" and config.fid = '").append(configIdString + "'").append(numberFilter);
                break;
            }
            case 2: {
                configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_WorkTimeStruConfig") : configId;
                String cmpareType = this.getCompareTypeByWorkTime(ctx, number, orgId);
                directStaffingSql.append(" inner join T_HR_PersonOtherInfo personother on personother.fpersonid = emprelation.fpersonid").append(" inner join T_MGR_WorkTimeStruConfigField field on field.fstartworktime ").append(cmpareType).append(" personother.FSocialServiceYears and field.fendworktime >= personother.FSocialServiceYears").append(" inner join T_MGR_WorkTimeStruConfig config on field.fparentid = config.fid").append(directStaffingFilter).append(" and config.fid = '").append(configIdString + "'").append(numberFilter);
                break;
            }
            case 7: {
                configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_CompanyYearStruConfig") : configId;
                String compareType = this.getCompareTypeByCompanyYear(ctx, number, orgId);
                directStaffingSql.append(" inner join T_HR_PersonPosition pp on pp.fpersonid = emprelation.fpersonid").append(" inner join T_MGR_CompanyYearConfigField field on field.fstartCompanyYear ").append(compareType).append(" pp.FJoinCompanyYears and field.fendCompanyYear >= pp.FJoinCompanyYears").append(" inner join T_MGR_CompanyYearStruConfig config on field.fparentid = config.fid").append(directStaffingFilter).append(" and config.fid = '").append(configIdString + "'").append(numberFilter);
                break;
            }
            case 3: {
                directStaffingSql.append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(directStaffingFilter).append(numberFilter);
                break;
            }
            case 4: {
                configIdString = StringUtils.isEmpty((String)configId) ? BriefUtil.getConfigId(ctx, orgId, "T_MGR_DiplomaStruConfig") : configId;
                directStaffingSql.append(" inner join T_HR_PersonDegree degree on degree.fpersonid = emprelation.fpersonid").append(" inner join T_BD_HRDiploma diploma on degree.fdiploma = diploma.fid").append(" inner join T_MGR_DiplomaStruConfigField diplomafield on diplomafield.fstartLevel < diploma.flevelcode and diplomafield.fendLevel >= diploma.flevelcode").append(" inner join T_MGR_DiplomaStruConfig diplomaconfig on diplomafield.fparentid = diplomaconfig.fid").append(directStaffingFilter).append(" and diplomaconfig.fid = '").append(configIdString + "'").append(" and degree.fishighest = 1").append(numberFilter);
                break;
            }
            case 5: {
                directStaffingSql.append(" inner join T_HR_EmpPostRank emppostrank on emppostrank.fpersonid = emprelation.fpersonid").append(" inner join T_HR_JobGrade jobgrade on emppostrank.fjobgradeid = jobgrade.fid").append(directStaffingFilter).append(numberFilter);
                break;
            }
            case 6: {
                directStaffingSql.append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_ORG_Job jobT on jobT.fid = position.fjobid").append(" inner join T_HR_HRJob hrjob on hrjob.FJobID = jobT.fid").append(" inner join T_HR_HRJobFamily jobfamily on jobfamily.fid = hrjob.FHRJobFamilyID").append(directStaffingFilter).append(numberFilter);
                break;
            }
            default: {
                directStaffingSql.append(directStaffingFilter);
            }
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)directStaffingSql.toString());
            while (rowSet.next()) {
                directActualStaffing = rowSet.getInt("actualStaffing");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        directStaffingMap.put("directActualStaffing", directActualStaffing);
        return directStaffingMap;
    }

    @Override
    protected Map _getSubHeadcountByStruConfig(Context ctx, String orgId, int category, String number, String permItemId, String configId) throws BOSException, EASBizException {
        HashMap subEmpStructureMap = new HashMap();
        ArrayList list = new ArrayList();
        String tempTableName = BriefUtil.createTempTable(ctx, orgId, permItemId);
        try {
            int headcount = (Integer)this._getActualStaffingByStruConfig(ctx, orgId, category, number, permItemId, configId).get("actualStaffing");
            int directHeadcount = (Integer)this._getDirectStaffingByStruConfig(ctx, orgId, category, number, configId).get("directActualStaffing");
            String directHeadcountPercent = BriefUtil.rate(directHeadcount, headcount);
            HashMap<String, Object> directHeadcountMap = new HashMap<String, Object>();
            directHeadcountMap.put("orgId", orgId);
            directHeadcountMap.put("orgName", SHRServerResource.getString((String)"com.kingdee.eas.hr.base.ManagerResource", (String)"label_001", (Context)ctx));
            directHeadcountMap.put("includeSub", false);
            directHeadcountMap.put("subHeadcount", directHeadcount);
            directHeadcountMap.put("subHeadcountPercent", directHeadcountPercent);
            list.add(directHeadcountMap);
            Map subActualStaffingMap = this.getSubStaffingByEmpStruConfig(ctx, orgId, category, number, tempTableName, permItemId, configId);
            StringBuffer sql = new StringBuffer("select fid,fname,fisleaf from ").append(tempTableName).append(" order by flongnumber asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String adminOrgId = rowSet.getString("fid");
                String adminOrgName = rowSet.getString("fname");
                boolean isLeaf = rowSet.getBoolean("fisleaf");
                boolean includeSub = !isLeaf;
                int subHeadcount = (Integer)subActualStaffingMap.get(adminOrgId);
                String subHeadcountPercent = BriefUtil.rate(subHeadcount, headcount);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgId", adminOrgId);
                map.put("orgName", adminOrgName);
                map.put("includeSub", includeSub);
                map.put("subHeadcount", subHeadcount);
                map.put("subHeadcountPercent", subHeadcountPercent);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            BriefUtil.relaseTempTable(ctx, tempTableName);
        }
        subEmpStructureMap.put("subEmpStructureList", list);
        return subEmpStructureMap;
    }

    @Override
    protected Map _getEmpDetailByConfig(Context ctx, String orgId, int category, String number, String permItemId, String configId) throws BOSException, EASBizException {
        HashMap personDetailMap = new HashMap();
        ArrayList list = new ArrayList();
        String sql = "";
        switch (category) {
            case 1: {
                sql = this.getPersonDetailByAgeSql(ctx, orgId, number, configId);
                break;
            }
            case 2: {
                sql = this.getPersonDetailByWorkTimeSql(ctx, orgId, number, configId);
                break;
            }
            case 3: {
                sql = this.getPersonDetailByGenderSql(ctx, orgId, number, configId);
                break;
            }
            case 4: {
                sql = this.getPersonDetailByDiplomaSql(ctx, orgId, number, configId);
                break;
            }
            case 5: {
                sql = this.getPersonDetailByJobGradeSql(ctx, orgId, number, configId);
                break;
            }
            case 6: {
                sql = this.getPersonDetailByJobFamilySql(ctx, orgId, number, configId);
                break;
            }
            case 7: {
                sql = this.getPersonDetailByCompanyYearSql(ctx, orgId, number, configId);
                break;
            }
            default: {
                sql = this.getPersonDetailSql(ctx, orgId);
            }
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String personId = rowSet.getString("personId");
                String personName = rowSet.getString("personName");
                String orgName = rowSet.getString("orgName");
                String positionName = rowSet.getString("positionName");
                Blob blob = rowSet.getBlob("fimagedata");
                String personPhoto = BriefUtil.convertBlobToBase64(blob);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("personId", personId);
                map.put("personName", personName);
                map.put("orgName", orgName);
                map.put("positionName", positionName);
                map.put("personPhoto", personPhoto);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (list.size() > 0) {
            personDetailMap.put("personList", list);
        }
        return personDetailMap;
    }
}

