/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.emplightapp.logicservices;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.emplightapp.util.BriefUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommonCodeMethods {
    public static final String initPersonBizDefine = "P/OSDCPfQXqU0TB/LQoA6uZovtk=";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.emplightapp.logicservices.CommonCodeMethods");

    public static void selectDetailColumns(StringBuffer sql, String local) {
        sql.append(" person.fid personId,").append(" person.fname_").append(local).append(" personName,").append(" child.fname_").append(local).append(" orgName,").append(" position.fname_").append(local).append(" positionName,").append(" person.fnumber number,").append(" person.fname_l1 name_l1,").append(" person.fFullnamepingyin fullnamepingyin ");
    }

    public static void childAdminIdSql(StringBuffer sql, String userId, Context ctx, String permItemId) {
        sql.append(" from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid");
    }

    public static void relationHisTableSql(StringBuffer sql, String onStr) {
        sql.append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid");
        if (!StringUtils.isEmpty((String)onStr)) {
            sql.append(onStr);
        }
        sql.append(" inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid").append(" and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid").append(" inner join T_HR_HRBizDefine bizDefine on  emprelation.factionid = bizDefine.fid").append(" left join T_HR_BDEmployeeType empTypeLast  ON laborRelationHis.FLASTLABORRELASTATEID = empTypeLast.fid");
    }

    public static void relationHisTableSql(StringBuffer sql, String onStr, String onStr2) {
        CommonCodeMethods.relationHisTableSql(sql, onStr);
        if (!StringUtils.isEmpty((String)onStr2)) {
            sql.append(onStr2);
        }
    }

    public static void relationCurrentTableSql(StringBuffer sql) {
        sql.append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid ").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid");
    }

    public static void relationCurrentTableSql(StringBuffer sql, String onStr) {
        sql.append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid ").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid");
        if (!StringUtils.isEmpty((String)onStr)) {
            sql.append(onStr);
        }
    }

    public static void currentActualStaffFilter(StringBuffer sql, String includeSubSql, Map<String, Object> filterParamsMap, String local) {
        sql.append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1");
        CommonCodeMethods.dyQuerySql(sql, filterParamsMap, local);
    }

    public static void hisActualStaffFilter(StringBuffer sql, String includeSubSql, Map<String, Object> filterParamsMap, String local) {
        sql.append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.feffdt <= ").append(filterParamsMap.get("endDateTs")).append(" and emprelation.fleffdt >= ").append(filterParamsMap.get("endDateTs")).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1");
        CommonCodeMethods.dyQuerySql(sql, filterParamsMap, local);
    }

    private static void dyQuerySql(StringBuffer sql, Map<String, Object> filterParamsMap, String local) {
        String conditionQuery = (String)filterParamsMap.get("conditionQuery");
        if (!StringUtils.isEmpty((String)conditionQuery)) {
            conditionQuery = conditionQuery.toLowerCase();
            sql.append(" and(").append(" lower(").append("person.fname_").append(local).append(")").append(" like '%").append(conditionQuery).append("%' ").append(" or ").append(" lower(").append("person.fnumber").append(")").append(" like '%").append(conditionQuery).append("%' ").append(" or ").append(" lower(").append("person.fname_l1").append(")").append(" like '%").append(conditionQuery).append("%' ").append(" or ").append(" lower(").append("person.fFullnamepingyin").append(")").append(" like '%").append(conditionQuery).append("%' ").append(" or ").append(" lower(").append("child.fname_").append(local).append(")").append(" like '%").append(conditionQuery).append("%' ").append(" or ").append(" lower(").append("position.fname_").append(local).append(")").append(" like '%").append(conditionQuery).append("%' ").append(" )");
        }
    }

    public static void enrollFilter(StringBuffer sql, String includeSubSql, Map<String, Object> filterParamsMap, String local) {
        sql.append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and (bizDefine.fbizdefinetype = 1 or bizDefine.fbizdefinetype = 16 or bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=')").append(" and laborRelationHis.fenterdate >= ").append(filterParamsMap.get("beginDateStr")).append(" and laborRelationHis.fenterdate <= ").append(filterParamsMap.get("endDateStr")).append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emptype.fisonthestrength = 1");
        CommonCodeMethods.dyQuerySql(sql, filterParamsMap, local);
    }

    public static void resignFilter(StringBuffer sql, String includeSubSql, Map<String, Object> filterParamsMap, String local) {
        sql.append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and ((bizDefine.fbizdefinetype = 4 and empTypeLast.FISONTHESTRENGTH =1)").append(" or (bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and empType.FINSERVICE = 2))").append(" and pphis.fleftdate >= ").append(filterParamsMap.get("beginDateStr")).append(" and pphis.fleftdate <= ").append(filterParamsMap.get("endDateStr")).append(" and emprelation.fisinner = 1").append(" and (emprelation.fisenrolled = 0 or emptype.fisonthestrength = 0) ");
        CommonCodeMethods.dyQuerySql(sql, filterParamsMap, local);
    }

    public static String detailOnTableSql() {
        StringBuffer detailSql = new StringBuffer();
        detailSql.append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid");
        return detailSql.toString();
    }

    public static String includeSubSql(Context ctx, String orgId, String permItemId) throws BOSException {
        String includeSubSql = CommonCodeMethods.isUserOrgIncludeSub(ctx, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        return includeSubSql;
    }

    public static boolean isUserOrgIncludeSub(Context ctx, String orgId, String permItemId) throws BOSException {
        String userId = BriefUtil.getUserId(ctx);
        return BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId);
    }

    public static Map<String, Object> queryPageListData(Context ctx, Integer page, Integer rows, int totalCount, String detailListSql) throws BOSException {
        int length = page * rows > totalCount ? totalCount - (page - 1) * rows : rows;
        PagingHelper pageHelper = new PagingHelper();
        String pagingSql = pageHelper.getPagingSqlNoOptmize(ctx, detailListSql, (page - 1) * rows, length);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("print====queryPageListData====\n" + pagingSql));
        }
        ArrayList list = new ArrayList();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)pagingSql);
            while (rowSet.next()) {
                String personId = rowSet.getString("personId");
                String personName = rowSet.getString("personName");
                String orgName = rowSet.getString("orgName");
                String positionName = rowSet.getString("positionName");
                String number = rowSet.getString("number");
                String name_l1 = rowSet.getString("name_l1");
                String fullnamepingyin = rowSet.getString("fullnamepingyin");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("personId", personId);
                map.put("personName", personName);
                map.put("orgName", orgName);
                map.put("positionName", positionName);
                map.put("number", number);
                map.put("name_l1", name_l1);
                map.put("fullnamepingyin", fullnamepingyin);
                map.put("personPhoto", "");
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        HashMap<String, Object> personMap = new HashMap<String, Object>();
        personMap.put("totalCount", totalCount);
        personMap.put("rows", list);
        return personMap;
    }

    public static Map getSixMonthData(Date startDate, Date endDate) throws BOSException {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        if (startYear == endYear) {
            for (int m = startMonth; m <= endMonth; ++m) {
                map.put(startYear + "-" + m, 0);
            }
        } else {
            int m;
            for (m = startMonth; m <= 12; ++m) {
                map.put(startYear + "-" + m, 0);
            }
            for (m = 1; m <= endMonth; ++m) {
                map.put(endYear + "-" + m, 0);
            }
        }
        return map;
    }

    public static String[] getDateBeginEndDateArr(String datePoint) {
        String[] dateArr = datePoint.split("-");
        String[] dateBeginEndDateArr = new String[2];
        if (dateArr.length == 1 && Integer.valueOf(dateArr[0]) == DateTimeUtils.getYear((Date)new Date())) {
            int year = Integer.valueOf(dateArr[0]);
            dateBeginEndDateArr[0] = "{ts'" + year + "-01-01'}";
            dateBeginEndDateArr[1] = "{ts'" + year + "-12-31'}";
        } else {
            int year = Integer.valueOf(dateArr[0]);
            int month = Integer.valueOf(dateArr[1]);
            int day = BriefUtil.getDay(year, month);
            dateBeginEndDateArr[0] = "{ts'" + year + "-" + month + "-01'}";
            dateBeginEndDateArr[1] = "{ts'" + year + "-" + month + "-" + day + "'}";
        }
        return dateBeginEndDateArr;
    }

    public static void orderByFilter(StringBuffer sql) {
        sql.append(" order by person.fFullnamepingyin asc");
    }
}

