/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.emplightapp.logicservices;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.emplightapp.logicservices.CommonCodeMethods;
import com.kingdee.shr.emplightapp.logicservices.IEmpStrategyService;
import com.kingdee.shr.emplightapp.util.BriefUtil;
import com.kingdee.shr.manager.HRAffairException;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmpStrategyResignPageService
implements IEmpStrategyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.emplightapp.logicservices.EmpStrategyResignPageService");

    @Override
    public Object logicInvoke(Map<String, Object> param) throws BOSException, EASBizException {
        String datePoint = (String)param.get("datePoint");
        Context ctx = (Context)param.get("ctx");
        String orgId = (String)param.get("orgId");
        String permItemId = (String)param.get("permItemId");
        Integer page = (Integer)param.get("page");
        Integer rows = (Integer)param.get("rows");
        String conditionQuery = (String)param.get("conditionQuery");
        if (StringUtils.isEmpty((String)datePoint)) {
            throw new HRAffairException(HRAffairException.DATE_EMPTY_EXCEPTION);
        }
        String includeSubSql = CommonCodeMethods.includeSubSql(ctx, orgId, permItemId);
        String[] dateArr = CommonCodeMethods.getDateBeginEndDateArr(datePoint);
        HashMap<String, Object> filterParamsMap = new HashMap<String, Object>();
        filterParamsMap.put("conditionQuery", conditionQuery);
        filterParamsMap.put("beginDateStr", dateArr[0]);
        filterParamsMap.put("endDateStr", dateArr[1]);
        int totalCount = this.resignTotalCount(ctx, permItemId, includeSubSql, filterParamsMap);
        String detailListSql = this.resignPersonDetailSql(ctx, orgId, permItemId, includeSubSql, filterParamsMap);
        Map<String, Object> personMap = CommonCodeMethods.queryPageListData(ctx, page, rows, totalCount, detailListSql);
        return personMap;
    }

    private int resignTotalCount(Context ctx, String permItemId, String includeSubSql, Map<String, Object> filterParamsMap) throws BOSException {
        int resignCount = 0;
        StringBuffer totalSql = new StringBuffer("select count(emprelation.fpersonid) resignHeadcount");
        this.resignCommonSql(ctx, permItemId, includeSubSql, filterParamsMap, totalSql, CommonCodeMethods.detailOnTableSql());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("print====resignTotalCount====\n" + totalSql));
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)totalSql.toString());
        try {
            while (rowSet.next()) {
                resignCount = rowSet.getInt("resignHeadcount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return resignCount;
    }

    private String resignPersonDetailSql(Context ctx, String orgId, String permItemId, String includeSubSql, Map<String, Object> filterParamsMap) {
        String local = BriefUtil.getLocal(ctx);
        StringBuffer detailSql = new StringBuffer("select ");
        CommonCodeMethods.selectDetailColumns(detailSql, local);
        this.resignCommonSql(ctx, permItemId, includeSubSql, filterParamsMap, detailSql, CommonCodeMethods.detailOnTableSql());
        CommonCodeMethods.orderByFilter(detailSql);
        return detailSql.toString();
    }

    private void resignCommonSql(Context ctx, String permItemId, String includeSubSql, Map<String, Object> filterParamsMap, StringBuffer sql, String detailOnTableSql) {
        String userId = BriefUtil.getUserId(ctx);
        String local = BriefUtil.getLocal(ctx);
        CommonCodeMethods.childAdminIdSql(sql, userId, ctx, permItemId);
        CommonCodeMethods.relationHisTableSql(sql, this.resignCommPartOntableSql(), detailOnTableSql);
        CommonCodeMethods.resignFilter(sql, includeSubSql, filterParamsMap, local);
    }

    private String resignCommPartOntableSql() {
        StringBuffer resignCommPartSql = new StringBuffer();
        resignCommPartSql.append(" inner join t_hr_personpositionhis pphis on emprelation.fpersonid = pphis.fpersonid ").append(" and pphis.FStartDateTime <= emprelation.FEndDateTime and pphis.FEndDateTime >= emprelation.FEndDateTime ");
        return resignCommPartSql.toString();
    }
}

