/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.faqservice.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.faqservice.FaqQuestionAttachmentFactory;
import com.kingdee.shr.faqservice.FaqQuestionAttachmentInfo;
import com.kingdee.shr.faqservice.FaqQuestionCollection;
import com.kingdee.shr.faqservice.FaqQuestionInfo;
import com.kingdee.shr.faqservice.FaqSolutionCollection;
import com.kingdee.shr.faqservice.FaqSolutionFactory;
import com.kingdee.shr.faqservice.FaqSolutionInfo;
import com.kingdee.shr.faqservice.FaqSolutionPermOrgCollection;
import com.kingdee.shr.faqservice.FaqSolutionPermOrgInfo;
import com.kingdee.shr.faqservice.IFaqQuestionAttachment;
import com.kingdee.shr.faqservice.IFaqSolution;
import com.kingdee.shr.faqservice.SSCFaqException;
import com.kingdee.shr.faqservice.app.AbstractFaqQuestionControllerBean;
import com.kingdee.shr.faqservice.cloudhub.AccessTokenHelper;
import com.kingdee.shr.faqservice.cloudhub.Faq;
import com.kingdee.shr.faqservice.cloudhub.entity.Question;
import com.kingdee.shr.faqservice.cloudhub.result.CreateResult;
import com.kingdee.shr.faqservice.cloudhub.result.DeleteResult;
import com.kingdee.shr.faqservice.cloudhub.result.UpdateResult;
import com.kingdee.shr.faqservice.cloudhub.util.RequestUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.util.BeanUtils;
import com.kingdee.shr.shareservice.util.ConvertUtil;
import com.kingdee.shr.shareservice.util.VerifyUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaqQuestionControllerBean
extends AbstractFaqQuestionControllerBean {
    private static final long serialVersionUID = -5560294307614203586L;
    private static final Logger logger = LoggerFactory.getLogger(FaqQuestionControllerBean.class);

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        questionInfo.setTitleBak(VerifyUtils.replacePunctuation((String)questionInfo.getTitle()));
        this._verifyData(ctx, model);
        this._boforeSaveOperation(ctx, model);
        IObjectPK pk = super._save(ctx, model);
        this._afterSaveOperation(ctx, model);
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = this.getFaqQuestionInfo(ctx, pk);
        this._boforeDeleteOperation(ctx, pk, (IObjectValue)questionInfo);
        super._delete(ctx, pk);
        this._afterDeleteOperation(ctx, pk, (IObjectValue)questionInfo);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        HashSet<String> idsSet = new HashSet<String>();
        int length = arrayPK.length;
        for (int i = 0; i < length; ++i) {
            idsSet.add(arrayPK[i].toString());
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("cid"));
        selector.add(new SelectorItemInfo("solution.id"));
        selector.add(new SelectorItemInfo("solution.cid"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idsSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(selector);
        view.setFilter(filter);
        FaqQuestionCollection questionColls = this.getFaqQuestionCollection(ctx, view);
        super._delete(ctx, arrayPK);
        this._afterDeleteOperation(ctx, arrayPK, (IObjectCollection)questionColls);
    }

    protected void _verifyData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._verifyDataOutOfRange(ctx, model);
        this._checkTitleDuplicate(ctx, model);
    }

    protected void _verifyDataOutOfRange(Context ctx, IObjectValue model) throws EASBizException {
        List similarityList;
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        if (VerifyUtils.isOutOfRange((String)questionInfo.getTitle(), (int)60)) {
            String label5 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label5", (Context)ctx);
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label5});
        }
        if (VerifyUtils.isOutOfRange((String)questionInfo.getAnswer(), (int)300)) {
            String label3 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label3", (Context)ctx);
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label3});
        }
        if (!StringUtils.isEmpty((String)questionInfo.getSimilarityQuestions()) && (similarityList = ConvertUtil.stringToList((String)questionInfo.getSimilarityQuestions())) != null && similarityList.size() > 0) {
            int size = similarityList.size();
            for (int i = 0; i < size; ++i) {
                if (!VerifyUtils.isOutOfRange((String)((String)similarityList.get(i)), (int)60)) continue;
                String label4 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label4", (Context)ctx);
                throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label4});
            }
        }
    }

    protected void _checkTitleDuplicate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkTitleDuplicateInSameSolution(ctx, model);
        this._checkSimilaritysSameSolution(ctx, model);
        this._checkTitleDuplicateInSamePermsSolution(ctx, model);
        this._checkTitleSameWithSimilarSameSolution(ctx, model);
    }

    protected void _checkTitleSameWithSimilarSameSolution(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        String titleBak = questionInfo.getTitleBak();
        String solutionId = questionInfo.getSolution().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("similaritysBak", (Object)("%" + titleBak + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)solutionId));
        if (questionInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)questionInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("titleBak"));
        selector.add(new SelectorItemInfo("similaritysBak"));
        selector.add(new SelectorItemInfo("title"));
        selector.add(new SelectorItemInfo("similarityQuestions"));
        view.setSelector(selector);
        FaqQuestionCollection faqColls = this.getFaqQuestionCollection(ctx, view);
        if (faqColls != null && faqColls.size() > 0) {
            for (int dex = 0; dex < faqColls.size(); ++dex) {
                List stringToList = ConvertUtil.stringToList((String)faqColls.get(dex).getSimilarityQuestions());
                for (int i = 0; i < stringToList.size(); ++i) {
                    String replace = VerifyUtils.replacePunctuation((String)((String)stringToList.get(i)));
                    if (!titleBak.equals(replace)) continue;
                    throw new SSCFaqException(SSCFaqException.QUESTION_DUPLICATE);
                }
            }
        }
    }

    protected void _checkSimilaritysSameSolution(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        List stringToList = ConvertUtil.stringToList((String)questionInfo.getSimilarityQuestions());
        ArrayList<String> replaceSimilarity = new ArrayList<String>();
        if (stringToList != null && stringToList.size() > 0) {
            String replace;
            int dex;
            FilterInfo filter = new FilterInfo();
            FilterInfo subFilter = new FilterInfo();
            StringBuffer maskString = new StringBuffer();
            String solutionId = questionInfo.getSolution().getId().toString();
            BOSUuid bosUuid = questionInfo.getId();
            filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)solutionId));
            if (bosUuid != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)bosUuid.toString(), CompareType.NOTEQUALS));
                filter.setMaskString("#0 AND #1");
            }
            for (dex = 0; dex < stringToList.size(); ++dex) {
                replace = VerifyUtils.replacePunctuation((String)((String)stringToList.get(dex)));
                replaceSimilarity.add(replace);
                subFilter.getFilterItems().add(new FilterItemInfo("titleBak", (Object)replace));
                if (dex == 0) {
                    maskString.append("#").append(dex);
                    continue;
                }
                maskString.append("OR #").append(dex);
            }
            subFilter.setMaskString(maskString.toString());
            filter.mergeFilter(subFilter, "AND");
            logger.error("_checkSimilaritysSameSolution view.setFilter(filter) 193 " + filter.toSql());
            if (this.exists(ctx, filter)) {
                String label1 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label1", (Context)ctx);
                throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label1});
            }
            filter = new FilterInfo();
            subFilter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)solutionId));
            if (questionInfo.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)bosUuid.toString().toString(), CompareType.NOTEQUALS));
                filter.setMaskString("#0 AND #1");
            }
            for (dex = 0; dex < replaceSimilarity.size(); ++dex) {
                replace = (String)replaceSimilarity.get(dex);
                subFilter.getFilterItems().add(new FilterItemInfo("similaritysBak", (Object)("%" + replace + "%"), CompareType.LIKE));
            }
            subFilter.setMaskString(maskString.toString());
            filter.mergeFilter(subFilter, "AND");
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            logger.error("_checkSimilaritysSameSolution view.setFilter(filter) 212 " + filter.toSql());
            FaqQuestionCollection dbCollection = this.getFaqQuestionCollection(ctx, view);
            if (dbCollection.size() > 0) {
                List dbSimList = null;
                for (int dex2 = 0; dex2 < dbCollection.size(); ++dex2) {
                    FaqQuestionInfo dbInfo = dbCollection.get(dex2);
                    dbSimList = ConvertUtil.stringToList((String)dbInfo.getSimilaritysBak());
                    if (dbSimList == null || dbSimList.size() <= 0) continue;
                    for (int i = 0; i < replaceSimilarity.size(); ++i) {
                        String replace2 = (String)replaceSimilarity.get(i);
                        if (!dbSimList.contains(replace2)) continue;
                        String label10 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label10", (Context)ctx);
                        throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label10});
                    }
                }
            }
            questionInfo.setSimilaritysBak(ConvertUtil.listToString(replaceSimilarity));
        } else {
            questionInfo.setSimilaritysBak("");
        }
    }

    protected void _checkTitleDuplicateInSamePermsSolution(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        String titleBak = questionInfo.getTitleBak();
        FaqSolutionInfo solution = questionInfo.getSolution();
        Set<String> sameSolutionSet = this.getSamePermsSolutionInfo(ctx, solution);
        logger.error("_checkTitleDuplicateInSamePermsSolution sameSolutionSet : " + sameSolutionSet.toString());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("titleBak", (Object)titleBak));
        filter.getFilterItems().add(new FilterItemInfo("solution.id", sameSolutionSet, CompareType.INCLUDE));
        if (questionInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)questionInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("solution.id"));
        coll.add(new SelectorItemInfo("solution.name"));
        coll.add(new SelectorItemInfo("title"));
        coll.add(new SelectorItemInfo("id"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(coll);
        logger.error("_checkTitleDuplicateInSamePermsSolution filter view : " + view.toString());
        FaqQuestionCollection faqQuestionCollection = this.getFaqQuestionCollection(ctx, view);
        if (faqQuestionCollection != null && faqQuestionCollection.size() > 0) {
            String label12 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label12", (Context)ctx, (Object[])new Object[]{faqQuestionCollection.get(0).getSolution().getName()});
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label12});
        }
        this._checkTitleWithOtherSimlAskInSamePermsSolution(ctx, model, sameSolutionSet);
    }

    protected void _checkTitleWithOtherSimlAskInSamePermsSolution(Context ctx, IObjectValue model, Set<String> sameSolutionSet) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        String titleBak = questionInfo.getTitleBak();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("similaritysBak", (Object)("%" + titleBak + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("solution.id", sameSolutionSet, CompareType.INCLUDE));
        if (questionInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)questionInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("solution.id"));
        coll.add(new SelectorItemInfo("solution.name"));
        coll.add(new SelectorItemInfo("title"));
        coll.add(new SelectorItemInfo("id"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(coll);
        FaqQuestionCollection dbCollection = this.getFaqQuestionCollection(ctx, view);
        if (dbCollection.size() > 0) {
            List dbSimList = null;
            for (int dex = 0; dex < dbCollection.size(); ++dex) {
                FaqQuestionInfo dbInfo = dbCollection.get(dex);
                dbSimList = ConvertUtil.stringToList((String)dbInfo.getSimilaritysBak());
                if (dbSimList == null || dbSimList.size() <= 0 || !dbSimList.contains(titleBak)) continue;
                String label13 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label13", (Context)ctx, (Object[])new Object[]{dbInfo.getSolution().getName()});
                throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label13});
            }
        }
    }

    protected void _checkTitleDuplicateInSameSolution(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        String titleBak = questionInfo.getTitleBak();
        String solutionId = questionInfo.getSolution().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("titleBak", (Object)titleBak));
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)solutionId));
        if (questionInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)questionInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            String label15 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label15", (Context)ctx);
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label15});
        }
    }

    protected void _boforeSaveOperation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _afterSaveOperation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        this.saveAttachment(ctx, model);
        this.updateFaqSolutionLastUpdateTime(ctx, questionInfo.getSolution());
        this._saveFromCloudHub(ctx, model);
    }

    protected void _boforeDeleteOperation(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _afterDeleteOperation(Context ctx, IObjectPK[] pk, IObjectCollection modelColl) throws BOSException, EASBizException {
        FaqQuestionCollection questionColls = (FaqQuestionCollection)modelColl;
        int size = questionColls.size();
        String[] ids = new String[size];
        for (int dex = 0; dex < size; ++dex) {
            ids[dex] = questionColls.get(dex).getId().toString();
        }
        this.deleteAttachment(ctx, ids);
        this.deleteFaqQuestionLikeInfo(ctx, ids);
        this.updateFaqSolutionLastUpdateTime(ctx, questionColls.get(0).getSolution());
        this._deleteFromCloudHub(ctx, modelColl);
    }

    protected void deleteFaqQuestionLikeInfo(Context ctx, String[] ids) throws EASBizException, BOSException {
        HashSet<String> idsSet = new HashSet<String>(Arrays.asList(ids));
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_SHR_FaqQuestionlike WHERE FQuestionID IN (").append(FaqQuestionControllerBean.hashSet2String(idsSet)).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void _afterDeleteOperation(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        this.deleteFaqQuestionLikeInfo(ctx, new String[]{pk.toString()});
        this.deleteAttachment(ctx, new String[]{pk.toString()});
        this.updateFaqSolutionLastUpdateTime(ctx, questionInfo.getSolution());
        this._deleteFromCloudHub(ctx, model);
    }

    protected void saveAttachment(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        String boID = questionInfo.getId().toString();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String cUipk = questionInfo.getString("cuipk");
        if (!StringUtils.isEmpty((String)cUipk)) {
            cUipk = cUipk.split("\\$")[0];
            SHRAttachmentExtFactory.getLocalInstance((Context)ctx).updateAffterSaveForm(boID, userId + "#" + cUipk);
        }
        this.saveAttachmentToFaqAttach(ctx, model);
    }

    protected void saveAttachmentToFaqAttach(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        IFaqQuestionAttachment iFaqQuestionAttachment = FaqQuestionAttachmentFactory.getLocalInstance(ctx);
        iFaqQuestionAttachment.delete("where question.id = '" + questionInfo.getId().toString() + "'");
        if (questionInfo.get("attachmentsJson") == null) {
            return;
        }
        JSONArray attachmentsJson = (JSONArray)questionInfo.get("attachmentsJson");
        if (attachmentsJson != null && attachmentsJson.size() > 0) {
            CoreBaseCollection faqcol = new CoreBaseCollection();
            for (int dex = 0; dex < attachmentsJson.size(); ++dex) {
                FaqQuestionAttachmentInfo attqueInfo = new FaqQuestionAttachmentInfo();
                JSONObject attachItem = attachmentsJson.getJSONObject(dex);
                String attachmentId = attachItem.getString("fileId");
                String attachmentName = attachItem.getString("title");
                AttachmentInfo attachment = new AttachmentInfo();
                attachment.setId(BOSUuid.read((String)attachmentId));
                attqueInfo.setAttachmentName(attachmentName);
                attqueInfo.setAttachmentId(attachment);
                attqueInfo.setQuestion(questionInfo);
                faqcol.add((CoreBaseInfo)attqueInfo);
            }
            if (faqcol.size() > 0) {
                iFaqQuestionAttachment.save(faqcol);
            }
        }
    }

    private void deleteAttachment(Context ctx, String[] boIds) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        HashSet<String> boIdSet = new HashSet<String>(Arrays.asList(boIds));
        filter.getFilterItems().add(new FilterItemInfo("boID", boIdSet, CompareType.INCLUDE));
        SHRAttachmentExtFactory.getLocalInstance((Context)ctx).delete(filter);
        for (String boId : boIds) {
            BoAttchAssoFactory.getLocalInstance((Context)ctx).deleteAllAssociationsByBoID(boId);
        }
    }

    protected void _saveFromCloudHub(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo solutionInfo = (FaqQuestionInfo)model;
        if (StringUtils.isEmpty((String)solutionInfo.getCid())) {
            this._createFromCloudHub(ctx, model);
        } else {
            this._updateFromCloudHub(ctx, model);
        }
    }

    private void _createFromCloudHub(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ArrayList titleList = new ArrayList();
        HashMap<String, String> title = new HashMap<String, String>();
        title.put("title", questionInfo.getTitle());
        titleList.add(title);
        List stringToList = ConvertUtil.stringToList((String)questionInfo.getSimilarityQuestions());
        for (int dex = 0; dex < stringToList.size(); ++dex) {
            title = new HashMap();
            title.put("title", (String)stringToList.get(dex));
            titleList.add(title);
        }
        dataMap.put("questions", titleList);
        FaqSolutionInfo soluInfo = this.getSolutionInfo(ctx, questionInfo.getSolution());
        dataMap.put("domainId", soluInfo.getCid());
        HashMap<String, String> keyword = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)questionInfo.getKeyword())) {
            keyword.put("keyword", questionInfo.getKeyword());
        }
        dataMap.put("keyword", keyword);
        HashMap<String, String> answer = new HashMap<String, String>();
        answer.put("content", questionInfo.getAnswer());
        dataMap.put("answer", answer);
        if (questionInfo.get("attachmentsJson") == null) {
            dataMap.put("attachments", new ArrayList());
        } else {
            dataMap.put("attachments", questionInfo.get("attachmentsJson"));
        }
        HashMap<String, Object> faqData = new HashMap<String, Object>();
        faqData.put("token", AccessTokenHelper.getToken(ctx));
        faqData.put("questionGroup", dataMap);
        Question question = new Question();
        CreateResult result = (CreateResult)RequestUtils.operation(ctx, Faq.question_create, faqData, question);
        if (!result.success()) {
            String label17 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label17", (Context)ctx);
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label17});
        }
        question = (Question)result.getDetailData();
        String cid = question.getId();
        questionInfo.setCid(cid);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("cid"));
        this.updatePartial(ctx, questionInfo, selector);
    }

    private void _updateFromCloudHub(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("id", questionInfo.getCid());
        ArrayList titleList = new ArrayList();
        HashMap<String, String> title = new HashMap<String, String>();
        title.put("title", questionInfo.getTitle());
        titleList.add(title);
        List stringToList = ConvertUtil.stringToList((String)questionInfo.getSimilarityQuestions());
        for (int dex = 0; dex < stringToList.size(); ++dex) {
            title = new HashMap();
            title.put("title", (String)stringToList.get(dex));
            titleList.add(title);
        }
        dataMap.put("questions", titleList);
        FaqSolutionInfo soluInfo = this.getSolutionInfo(ctx, questionInfo.getSolution());
        dataMap.put("domainId", soluInfo.getCid());
        HashMap<String, String> keyword = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)questionInfo.getKeyword())) {
            keyword.put("keyword", questionInfo.getKeyword());
        }
        dataMap.put("keyword", keyword);
        HashMap<String, String> answer = new HashMap<String, String>();
        answer.put("content", questionInfo.getAnswer());
        dataMap.put("answer", answer);
        dataMap.put("attachments", questionInfo.get("attachmentsJson"));
        dataMap.put("token", AccessTokenHelper.getToken(ctx));
        Question question = new Question();
        UpdateResult result = (UpdateResult)RequestUtils.operation(ctx, Faq.question_update, dataMap, question);
        if (!result.success()) {
            question = (Question)result.getDetailData();
            String label19 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label19", (Context)ctx);
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label19});
        }
    }

    protected void _deleteFromCloudHub(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqQuestionInfo questionInfo = (FaqQuestionInfo)model;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("id", questionInfo.getCid());
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(questionInfo.getCid());
        dataMap.put("groupIds", idList);
        dataMap.put("token", AccessTokenHelper.getToken(ctx));
        DeleteResult result = (DeleteResult)RequestUtils.operation(ctx, Faq.question_deletes, dataMap, null);
        if (!result.success()) {
            String label9 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label9", (Context)ctx);
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label9});
        }
    }

    protected void _deleteFromCloudHub(Context ctx, IObjectCollection modelColl) throws BOSException, EASBizException {
        FaqQuestionCollection questionColls = (FaqQuestionCollection)modelColl;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ArrayList<String> idList = new ArrayList<String>();
        int size = questionColls.size();
        for (int dex = 0; dex < size; ++dex) {
            idList.add(questionColls.get(dex).getCid());
        }
        dataMap.put("groupIds", idList);
        dataMap.put("token", AccessTokenHelper.getToken(ctx));
        DeleteResult result = (DeleteResult)RequestUtils.operation(ctx, Faq.question_deletes, dataMap, null);
        if (!result.success()) {
            String label11 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label11", (Context)ctx);
            String format = MessageFormat.format(label11, result.getCode(), result.getMsg());
            String label9 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label9", (Context)ctx);
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label9});
        }
    }

    private FaqSolutionInfo getSolutionInfo(Context ctx, FaqSolutionInfo info) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)info.getCid())) {
            info = FaqSolutionFactory.getLocalInstance(ctx).getFaqSolutionInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        }
        return info;
    }

    private Set<String> getSamePermsSolutionInfo(Context ctx, FaqSolutionInfo solutionInfo) throws BOSException, EASBizException {
        IFaqSolution localInstance = FaqSolutionFactory.getLocalInstance(ctx);
        solutionInfo = localInstance.getFaqSolutionInfo((IObjectPK)new ObjectUuidPK(solutionInfo.getId()), FaqQuestionControllerBean.getSolutionInfoSelector());
        FaqSolutionPermOrgCollection selfPermColls = solutionInfo.getPermissionOrgans();
        logger.error("getSamePermsSolutionInfo selfPermColls : " + selfPermColls.toString());
        int selgPermSize = selfPermColls.size();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(FaqQuestionControllerBean.getSolutionInfoSelector());
        FaqSolutionCollection coll = localInstance.getFaqSolutionCollection(view);
        HashMap<String, FaqSolutionInfo> soluMap = new HashMap<String, FaqSolutionInfo>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            FaqSolutionInfo tempSolutionInfo;
            if (soluMap.containsKey(coll.get(i).getId().toString()) || (tempSolutionInfo = coll.get(i)).getId().toString().equals(solutionInfo.getId().toString())) continue;
            FaqSolutionPermOrgCollection tempPermColls = tempSolutionInfo.getPermissionOrgans();
            boolean isBreak = false;
            int permSize = tempPermColls.size();
            block1: for (int j = 0; j < permSize && !isBreak; ++j) {
                FaqSolutionPermOrgInfo tempPermInfo = tempPermColls.get(j);
                for (int k = 0; k < selgPermSize; ++k) {
                    FaqSolutionPermOrgInfo selfPermInfo = selfPermColls.get(k);
                    if (selfPermInfo.getOrgId().getId().toString().equals(tempPermInfo.getOrgId().getId().toString())) {
                        soluMap.put(tempSolutionInfo.getId().toString(), tempSolutionInfo);
                        isBreak = true;
                        continue block1;
                    }
                    if (selfPermInfo.isIsIncludeSub() && tempPermInfo.getOrgId().getLongNumber().startsWith(selfPermInfo.getOrgId().getLongNumber())) {
                        soluMap.put(tempSolutionInfo.getId().toString(), tempSolutionInfo);
                        isBreak = true;
                        continue block1;
                    }
                    if (!tempPermInfo.isIsIncludeSub() || !selfPermInfo.getOrgId().getLongNumber().startsWith(tempPermInfo.getOrgId().getLongNumber())) continue;
                    soluMap.put(tempSolutionInfo.getId().toString(), tempSolutionInfo);
                    isBreak = true;
                    continue block1;
                }
            }
        }
        return soluMap.keySet();
    }

    protected static SelectorItemCollection getSolutionInfoSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("cid"));
        selector.add(new SelectorItemInfo("orgId.id"));
        selector.add(new SelectorItemInfo("orgId.name"));
        selector.add(new SelectorItemInfo("permissionOrgans.isIncludeSub"));
        selector.add(new SelectorItemInfo("permissionOrgans.orgId.id"));
        selector.add(new SelectorItemInfo("permissionOrgans.orgId.longNumber"));
        return selector;
    }

    private void updateFaqSolutionLastUpdateTime(Context ctx, FaqSolutionInfo solution) throws EASBizException, BOSException {
        solution.setLastUpdateTime(BeanUtils.getTime());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("lastUpdateTime"));
        FaqSolutionFactory.getLocalInstance(ctx).updatePartial(solution, selector);
    }

    public static String hashSet2String(Set<String> sets) {
        if (null == sets) {
            throw new IllegalArgumentException("this argument sets is required; it must not be null");
        }
        StringBuffer result = new StringBuffer();
        if (sets.size() <= 0) {
            result.append("''");
            return result.toString();
        }
        int i = 0;
        for (String str : sets) {
            if (i > 0) {
                result.append(",");
            }
            result.append("'").append(str).append("'");
            ++i;
        }
        return result.toString();
    }
}

