/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.faqservice.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.faqservice.FaqQuestionCollection;
import com.kingdee.shr.faqservice.FaqQuestionFactory;
import com.kingdee.shr.faqservice.FaqQuestionInfo;
import com.kingdee.shr.faqservice.IFaqQuestion;
import com.kingdee.shr.faqservice.app.AbstractFaqQuestionFacadeControllerBean;
import com.kingdee.shr.faqservice.cloudhub.AccessTokenHelper;
import com.kingdee.shr.faqservice.cloudhub.Faq;
import com.kingdee.shr.faqservice.cloudhub.result.DetailResult;
import com.kingdee.shr.faqservice.cloudhub.util.RequestUtils;
import com.kingdee.shr.shareservice.util.ConvertUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaqQuestionFacadeControllerBean
extends AbstractFaqQuestionFacadeControllerBean {
    private static final long serialVersionUID = 7825602355455135559L;
    private static final Logger logger = LoggerFactory.getLogger(FaqQuestionFacadeControllerBean.class);

    @Override
    protected void _batchImportQuestionInfo(Context ctx, IObjectCollection addColls, IObjectCollection updateColls) throws BOSException, EASBizException {
        this.batchAddQuestionInfo(ctx, addColls);
        this.batchUpdateQuestionInfo(ctx, updateColls);
    }

    private void batchUpdateQuestionInfo(Context ctx, IObjectCollection updateColls) throws BOSException, EASBizException {
        if (updateColls != null && updateColls.size() > 0) {
            FaqQuestionCollection colls = (FaqQuestionCollection)updateColls;
            ArrayList dataMapList = new ArrayList();
            IFaqQuestion iFaqQuestion = FaqQuestionFactory.getLocalInstance(ctx);
            HashMap<String, Object> hubMap = null;
            String solutionId = "";
            HashMap<String, FaqQuestionInfo> questionInfoMap = new HashMap<String, FaqQuestionInfo>();
            int size = colls.size();
            for (int dex = 0; dex < size; ++dex) {
                FaqQuestionInfo questionInfo = colls.get(dex);
                if (dex == 0) {
                    solutionId = questionInfo.getSolution().getCid();
                }
                if (StringUtils.isEmpty((String)questionInfo.getCid())) continue;
                hubMap = new HashMap<String, Object>();
                String infoId = questionInfo.getId().toString();
                hubMap.put("mark_id", infoId);
                hubMap.put("id", questionInfo.getCid());
                ArrayList titleList = new ArrayList();
                HashMap<String, String> title = new HashMap<String, String>();
                title.put("title", questionInfo.getTitle());
                titleList.add(title);
                List stringToList = ConvertUtil.stringToList((String)questionInfo.getSimilarityQuestions());
                for (int k = 0; k < stringToList.size(); ++k) {
                    title = new HashMap();
                    title.put("title", (String)stringToList.get(k));
                    titleList.add(title);
                }
                hubMap.put("questions", titleList);
                hubMap.put("domainId", questionInfo.getSolution().getCid());
                HashMap<String, String> keyword = new HashMap<String, String>();
                if (!StringUtils.isEmpty((String)questionInfo.getKeyword())) {
                    keyword.put("keyword", questionInfo.getKeyword());
                }
                hubMap.put("keyword", keyword);
                HashMap answer = new HashMap();
                answer.put("content", questionInfo.getAnswer());
                hubMap.put("answer", answer);
                hubMap.put("attachments", new ArrayList());
                questionInfoMap.put(infoId, questionInfo);
                dataMapList.add(hubMap);
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("domainId", solutionId);
            dataMap.put("questiongroups", dataMapList);
            dataMap.put("token", AccessTokenHelper.getToken(ctx));
            DetailResult result = (DetailResult)RequestUtils.operation(ctx, Faq.question_import, dataMap, null);
            if (result.success()) {
                CoreBaseCollection updateDataColls = new CoreBaseCollection();
                String data = result.getData();
                JSONObject resultObj = JSONObject.parseObject((String)data);
                JSONObject wrongLine = resultObj.getJSONObject("wrongLine");
                JSONArray questionGroups = resultObj.getJSONArray("questionGroups");
                if (wrongLine.size() > 0) {
                    // empty if block
                }
                Set keySet = wrongLine.keySet();
                for (String wrongKey : keySet) {
                    FaqQuestionInfo info = (FaqQuestionInfo)questionInfoMap.get(wrongKey);
                    String errorMsg = wrongLine.getString(wrongKey);
                    info.setBoolean("IMPORTRESULT", false);
                    info.setString("IMPORTERRORMSG", errorMsg);
                }
                int size2 = questionGroups.size();
                for (int dex = 0; dex < size2; ++dex) {
                    JSONObject jSONObject = questionGroups.getJSONObject(dex);
                    String mark_id = jSONObject.getString("mark_id");
                    FaqQuestionInfo info = (FaqQuestionInfo)questionInfoMap.get(mark_id);
                    info.setBoolean("IMPORTRESULT", true);
                    updateDataColls.add((CoreBaseInfo)info);
                }
                if (updateDataColls.size() > 0) {
                    iFaqQuestion.update(updateDataColls);
                }
            } else {
                throw new BOSException("FaqQuestionFacadeControllerBean batchUpdateQuestionInfo error : " + result.getCode() + " -- " + result.getMsg());
            }
        }
    }

    private void batchAddQuestionInfo(Context ctx, IObjectCollection addColls) throws BOSException, EASBizException {
        if (addColls != null && addColls.size() > 0) {
            FaqQuestionCollection colls = (FaqQuestionCollection)addColls;
            ArrayList dataMapList = new ArrayList();
            IFaqQuestion iFaqQuestion = FaqQuestionFactory.getLocalInstance(ctx);
            HashMap<String, Object> hubMap = null;
            String solutionId = "";
            HashMap<String, FaqQuestionInfo> questionInfoMap = new HashMap<String, FaqQuestionInfo>();
            int size = colls.size();
            for (int dex = 0; dex < size; ++dex) {
                FaqQuestionInfo questionInfo = colls.get(dex);
                if (dex == 0) {
                    solutionId = questionInfo.getSolution().getCid();
                }
                BOSUuid create = BOSUuid.create((BOSObjectType)questionInfo.getBOSType());
                questionInfo.setId(create);
                hubMap = new HashMap<String, Object>();
                hubMap.put("mark_id", create.toString());
                ArrayList titleList = new ArrayList();
                HashMap<String, String> title = new HashMap<String, String>();
                title.put("title", questionInfo.getTitle());
                titleList.add(title);
                List stringToList = ConvertUtil.stringToList((String)questionInfo.getSimilarityQuestions());
                for (int k = 0; k < stringToList.size(); ++k) {
                    title = new HashMap();
                    title.put("title", (String)stringToList.get(k));
                    titleList.add(title);
                }
                hubMap.put("questions", titleList);
                hubMap.put("domainId", questionInfo.getSolution().getCid());
                HashMap keyword = new HashMap();
                if (!StringUtils.isEmpty((String)questionInfo.getKeyword())) {
                    keyword.put("keyword", questionInfo.getKeyword());
                }
                hubMap.put("keyword", keyword);
                HashMap<String, String> answer = new HashMap<String, String>();
                answer.put("content", questionInfo.getAnswer());
                hubMap.put("answer", answer);
                hubMap.put("attachments", new ArrayList());
                questionInfoMap.put(create.toString(), questionInfo);
                dataMapList.add(hubMap);
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("domainId", solutionId);
            dataMap.put("questiongroups", dataMapList);
            dataMap.put("token", AccessTokenHelper.getToken(ctx));
            DetailResult result = (DetailResult)RequestUtils.operation(ctx, Faq.question_import, dataMap, null);
            if (result.success()) {
                String data = result.getData();
                JSONObject resultObj = JSONObject.parseObject((String)data);
                JSONObject wrongLine = resultObj.getJSONObject("wrongLine");
                JSONArray questionGroups = resultObj.getJSONArray("questionGroups");
                if (wrongLine.size() > 0) {
                    // empty if block
                }
                Set keySet = wrongLine.keySet();
                for (String wrongKey : keySet) {
                    FaqQuestionInfo info = (FaqQuestionInfo)questionInfoMap.get(wrongKey);
                    String errorMsg = wrongLine.getString(wrongKey);
                    info.setBoolean("IMPORTRESULT", false);
                    info.setString("IMPORTERRORMSG", errorMsg);
                    String string = wrongKey + " : " + info.getTitle() + " : " + info.getAnswer();
                }
                CoreBaseCollection c = new CoreBaseCollection();
                int size2 = questionGroups.size();
                for (int dex = 0; dex < size2; ++dex) {
                    JSONObject jSONObject = questionGroups.getJSONObject(dex);
                    String mark_id = jSONObject.getString("mark_id");
                    FaqQuestionInfo info = (FaqQuestionInfo)questionInfoMap.get(mark_id);
                    info.setCid(jSONObject.getString("id"));
                    info.setBoolean("IMPORTRESULT", true);
                    c.add((CoreBaseInfo)info);
                }
                if (c.size() > 0) {
                    iFaqQuestion.addnew(c);
                }
            } else {
                throw new BOSException("FaqQuestionFacadeControllerBean batchAddQuestionInfo error : " + result.getCode() + " -- " + result.getMsg());
            }
        }
    }
}

