/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.faqservice.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.faqservice.FaqQuestionLikeCollection;
import com.kingdee.shr.faqservice.FaqQuestionLikeFactory;
import com.kingdee.shr.faqservice.FaqQuestionLikeInfo;
import com.kingdee.shr.faqservice.IFaqQuestionLike;
import com.kingdee.shr.faqservice.app.AbstractFaqQuestionLikeFacadeControllerBean;
import com.kingdee.shr.faqservice.cloudhub.Faq;
import com.kingdee.shr.faqservice.cloudhub.result.UpdateResult;
import com.kingdee.shr.faqservice.cloudhub.util.CloudHubHttp;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaqQuestionLikeFacadeControllerBean
extends AbstractFaqQuestionLikeFacadeControllerBean {
    private static final long serialVersionUID = -1814669729050110488L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.shareservice.app.FaqQuestionLikeFacadeControllerBean");
    private static final int MAX_ROW = 5000;

    @Override
    protected void _syncToCloudHubFaq(Context ctx) throws BOSException, EASBizException {
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("askId"));
            view.getSelector().add(new SelectorItemInfo("qId"));
            view.getSelector().add(new SelectorItemInfo("formUser.id"));
            view.getSelector().add(new SelectorItemInfo("hasSync"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("hasSync", (Object)new Integer(0), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("hasSync", null, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isAnswer", (Object)new Integer(0), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isAnswer", null, CompareType.EQUALS));
            filterInfo.setMaskString("(#0 OR #1) AND (#2 OR #3)");
            view.setFilter(filterInfo);
            IFaqQuestionLike iFaqQuestionLike = FaqQuestionLikeFactory.getLocalInstance(ctx);
            FaqQuestionLikeCollection colls = iFaqQuestionLike.getFaqQuestionLikeCollection(view);
            if (colls.size() > 0) {
                int rowTotal = colls.size();
                if (rowTotal > 5000) {
                    rowTotal = 5000;
                }
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
                CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                HashMap<String, Object> dataMap = null;
                for (int index = 0; index < rowTotal; ++index) {
                    dataMap = new HashMap<String, Object>();
                    FaqQuestionLikeInfo faqQuestionLikeInfo = colls.get(index);
                    dataMap.put("questionId", faqQuestionLikeInfo.getQId());
                    dataMap.put("askId", faqQuestionLikeInfo.getAskId());
                    dataMap.put("oid", faqQuestionLikeInfo.getFormUser().getId().toString());
                    List<String> orgList = new ArrayList<String>();
                    String orgs = faqQuestionLikeInfo.getPersonAdminOrg();
                    if (orgs.contains(",")) {
                        orgList = Arrays.asList(orgs.split(","));
                    } else {
                        orgList.add(orgs);
                    }
                    dataMap.put("orgList", orgList);
                    faqQuestionLikeInfo.setHasSync(true);
                    coreBaseCollection.add((CoreBaseInfo)faqQuestionLikeInfo);
                    dataList.add(dataMap);
                }
                this.sendDataHttpToCloudHub(ctx, dataList);
                iFaqQuestionLike.updateBatchData(coreBaseCollection);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void sendDataHttpToCloudHub(Context ctx, List<Map<String, Object>> dataList) throws BOSException, EASBizException {
        String result = CloudHubHttp.post(ctx, Faq.question_like_sync, dataList);
        UpdateResult updateResult = (UpdateResult)JSONObject.parseObject((String)result, UpdateResult.class);
        if (!updateResult.success()) {
            String label14 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label14", (Context)ctx);
            throw new BOSException(label14);
        }
    }
}

