/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.faqservice.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.faqservice.FaqReplyCollection;
import com.kingdee.shr.faqservice.FaqReplyInfo;
import com.kingdee.shr.faqservice.FaqReplyType;
import com.kingdee.shr.faqservice.SSCFaqException;
import com.kingdee.shr.faqservice.app.AbstractFaqReplyControllerBean;
import com.kingdee.shr.ml.util.SHRServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaqReplyControllerBean
extends AbstractFaqReplyControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(FaqReplyControllerBean.class);

    @Override
    protected boolean _startup(Context ctx, IObjectPK pk, boolean startup) throws BOSException, EASBizException {
        FaqReplyInfo model = new FaqReplyInfo();
        model.setId(BOSUuid.read((String)pk.toString()));
        model.setStatus(startup ? BaseItemStateEnum.ENABLE : BaseItemStateEnum.DISABLE);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("status"));
        this.updatePartial(ctx, model, selector);
        this.updateOtherStatusToDisable(ctx, (IObjectValue)model);
        return false;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.beforesave(ctx, model);
        IObjectPK _save = super._save(ctx, model);
        this.aftersave(ctx, model);
        return _save;
    }

    protected void beforesave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verifyNameDuplicate(ctx, model);
    }

    protected void verifyNameDuplicate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqReplyInfo info = (FaqReplyInfo)model;
        String name = info.getName();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            String label16 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label16", (Context)ctx, (Object[])new Object[]{name});
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label16});
        }
    }

    protected void aftersave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.updateOtherStatusToDisable(ctx, model);
    }

    protected void updateOtherStatusToDisable(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqReplyInfo info = (FaqReplyInfo)model;
        if (BaseItemStateEnum.ENABLE.equals((Object)info.getStatus())) {
            BOSUuid savePk = info.getId();
            info = this.getFaqReplyInfo(ctx, (IObjectPK)new ObjectUuidPK(savePk));
            FaqReplyType replyType = info.getType();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)savePk.toString(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)replyType.getValue()));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)BaseItemStateEnum.ENABLE));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            SelectorItemInfo status = new SelectorItemInfo("status");
            selector.add(status);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            view.setSelector(selector);
            FaqReplyCollection faqReplyCollection = this.getFaqReplyCollection(ctx, view);
            if (faqReplyCollection.size() > 0) {
                selector.clear();
                selector.add(status);
                for (int dex = 0; dex < faqReplyCollection.size(); ++dex) {
                    FaqReplyInfo faqReplyInfo = faqReplyCollection.get(dex);
                    faqReplyInfo.setStatus(BaseItemStateEnum.DISABLE);
                    this._updatePartial(ctx, (IObjectValue)faqReplyInfo, selector);
                }
            }
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqReplyInfo info = (FaqReplyInfo)model;
        String number = info.getNumber();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)number, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (super._exists(ctx, filter)) {
            String label41 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label41", (Context)ctx, (Object[])new Object[]{number});
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label41});
        }
    }
}

