/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.faqservice.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.elecontract.util.CloudHubPropertiesUtilsV2;
import com.kingdee.shr.faqservice.FaqSolutionInfo;
import com.kingdee.shr.faqservice.FaqSolutionPermOrgCollection;
import com.kingdee.shr.faqservice.FaqSolutionPermOrgFactory;
import com.kingdee.shr.faqservice.FaqSolutionPermOrgInfo;
import com.kingdee.shr.faqservice.FaqSolutionStateEnum;
import com.kingdee.shr.faqservice.IFaqSolutionPermOrg;
import com.kingdee.shr.faqservice.SSCFaqException;
import com.kingdee.shr.faqservice.app.AbstractFaqSolutionControllerBean;
import com.kingdee.shr.faqservice.cloudhub.AccessTokenHelper;
import com.kingdee.shr.faqservice.cloudhub.Faq;
import com.kingdee.shr.faqservice.cloudhub.entity.Solution;
import com.kingdee.shr.faqservice.cloudhub.result.CreateResult;
import com.kingdee.shr.faqservice.cloudhub.result.DeleteResult;
import com.kingdee.shr.faqservice.cloudhub.result.UpdateResult;
import com.kingdee.shr.faqservice.cloudhub.util.RequestUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.util.BeanUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaqSolutionControllerBean
extends AbstractFaqSolutionControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(FaqSolutionControllerBean.class);
    public static String skillNumber = "";

    @Override
    protected void _startup(Context ctx, IObjectValue model, boolean startup) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = (FaqSolutionInfo)model;
        if (startup) {
            solutionInfo.setStartup(FaqSolutionStateEnum.ENABLE);
        } else {
            solutionInfo.setStartup(FaqSolutionStateEnum.DISABLE);
        }
        this._boforeStartUpOperation(ctx, model);
        this._startup(ctx, (IObjectValue)solutionInfo);
        this._afterStartUpOperation(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._verifyData(ctx, model);
        this._boforeSaveOperation(ctx, model);
        IObjectPK pk = super._save(ctx, model);
        this._afterSaveOperation(ctx, model);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = (FaqSolutionInfo)model;
        UserInfo userInfo = BeanUtils.getUserInfo((Context)ctx);
        Timestamp createtime = BeanUtils.getTime();
        solutionInfo.setLastUpdateUser(userInfo);
        solutionInfo.setLastUpdateTime(createtime);
        SelectorItemCollection selector = this.getSelctorCollection();
        super.updatePartial(ctx, solutionInfo, selector);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = this.getFaqSolutionInfo(ctx, pk);
        this._boforeDeleteOperation(ctx, pk, (IObjectValue)solutionInfo);
        super._delete(ctx, pk);
        this._afterDeleteOperation(ctx, pk, (IObjectValue)solutionInfo);
    }

    protected void _startup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = (FaqSolutionInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("startup"));
        this.updatePartial(ctx, solutionInfo, selector);
    }

    protected void _verifyData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _boforeStartUpOperation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _afterStartUpOperation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._startUpFromCloudHub(ctx, model);
    }

    protected void _boforeSaveOperation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDuplicate(ctx, model);
        this._checkNameDuplicate(ctx, model);
    }

    protected void _checkNameDuplicate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = (FaqSolutionInfo)model;
        String name = solutionInfo.getName();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        if (solutionInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)solutionInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            String label18 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label42", (Context)ctx, (Object[])new Object[]{name});
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label18});
        }
    }

    protected void _checkNumberDuplicate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = (FaqSolutionInfo)model;
        String number = solutionInfo.getNumber();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        if (solutionInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)solutionInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            String label18 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label18", (Context)ctx, (Object[])new Object[]{number});
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label18});
        }
    }

    protected void _afterSaveOperation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.savePermOrgsInfo(ctx, model);
        this._saveFromCloudHub(ctx, model);
    }

    private void savePermOrgsInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = (FaqSolutionInfo)model;
        IFaqSolutionPermOrg iFaqSolutionPermOrg = FaqSolutionPermOrgFactory.getLocalInstance(ctx);
        iFaqSolutionPermOrg.delete("where solution.id = '" + solutionInfo.getId().toString() + "'");
        FaqSolutionPermOrgCollection permOrgColl = solutionInfo.getPermissionOrgans();
        CoreBaseCollection infoColls = new CoreBaseCollection();
        for (int i = 0; i < permOrgColl.size(); ++i) {
            FaqSolutionPermOrgInfo faqSolutionPermOrgInfo = permOrgColl.get(i);
            if (StringUtils.isEmpty((String)faqSolutionPermOrgInfo.getOrgName())) {
                faqSolutionPermOrgInfo.setOrgName(faqSolutionPermOrgInfo.getString("orgid.name"));
            }
            faqSolutionPermOrgInfo.setOrgId(null);
            if (faqSolutionPermOrgInfo.getOrgId() == null && !StringUtils.isEmpty((String)faqSolutionPermOrgInfo.getString("orgid.id"))) {
                AdminOrgUnitInfo admin = new AdminOrgUnitInfo();
                String orgId = faqSolutionPermOrgInfo.getString("orgid.id");
                admin.setId(BOSUuid.read((String)orgId));
                faqSolutionPermOrgInfo.setOrgId(admin);
            }
            faqSolutionPermOrgInfo.setId(null);
            if (faqSolutionPermOrgInfo.get("solution") == null || faqSolutionPermOrgInfo.getSolution() == null) {
                faqSolutionPermOrgInfo.setSolution(solutionInfo);
            }
            infoColls.add((CoreBaseInfo)permOrgColl.get(i));
        }
        if (infoColls.size() > 0) {
            Result result = iFaqSolutionPermOrg.save(infoColls);
        }
    }

    protected void _boforeDeleteOperation(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkSolution(ctx, pk, model);
        this._deleteFaqQuestionInfo(ctx, pk, model);
    }

    protected void _checkSolution(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = (FaqSolutionInfo)model;
        if (solutionInfo.get("startup") == null) {
            solutionInfo = this.getFaqSolutionInfo(ctx, pk);
        }
        if (solutionInfo.getStartup() == FaqSolutionStateEnum.ENABLE) {
            String label20 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label20", (Context)ctx, (Object[])new Object[]{solutionInfo.getName()});
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label20});
        }
    }

    protected void _afterDeleteOperation(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._deleteFromCloudHub(ctx, model);
    }

    protected void _saveFromCloudHub(final Context ctx, final IObjectValue model) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = (FaqSolutionInfo)model;
        if (StringUtils.isEmpty((String)solutionInfo.getCid())) {
            this._createFromCloudHub(ctx, model);
            if (!solutionInfo.containsKey("_form_init_solution_")) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(3000L);
                            FaqSolutionControllerBean.this._updateFromCloudHub(ctx, model);
                        }
                        catch (EASBizException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        catch (BOSException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }).start();
            }
        } else {
            this._updateFromCloudHub(ctx, model);
        }
    }

    private List<Map<String, Object>> getPermOrgsInfo(Context ctx, FaqSolutionPermOrgCollection permOrgColl) throws BOSException {
        ArrayList<Map<String, Object>> permList = new ArrayList<Map<String, Object>>();
        try {
            HashMap<String, String> data = null;
            if (permOrgColl.size() > 0) {
                for (int dex = 0; dex < permOrgColl.size(); ++dex) {
                    FaqSolutionPermOrgInfo perm = permOrgColl.get(dex);
                    String number = perm.getString("orgId.number");
                    String longNumber = perm.getString("orgId.longNumber");
                    String name = perm.getString("orgId.name");
                    if (StringUtils.isEmpty((String)number)) {
                        String[] split = longNumber.split("!");
                        number = split.length > 0 ? split[split.length - 1] : longNumber;
                    }
                    data = new HashMap<String, String>();
                    data.put("orgId", number);
                    data.put("orgName", name);
                    if (perm.get("isIncludeSub") != null && perm.isIsIncludeSub()) {
                        data.put("rangeType", RangeType.DEFAULT.getValue());
                    } else {
                        data.put("rangeType", RangeType.EXCEPT.getValue());
                    }
                    permList.add(data);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return permList;
    }

    private List<Map<String, Object>> getPermOrgsInfo(Context ctx, String perms) throws BOSException {
        ArrayList<Map<String, Object>> permList = new ArrayList<Map<String, Object>>();
        try {
            JSONArray jsArr = JSONArray.parseArray((String)perms);
            HashMap<String, String> data = null;
            if (jsArr.size() > 0) {
                for (Object obj : jsArr) {
                    JSONObject jObj = new JSONObject();
                    jObj = obj instanceof JSONObject ? (JSONObject)obj : JSONObject.parseObject((String)obj.toString());
                    String number = jObj.getString("number");
                    String longNumber = jObj.getString("longNumber");
                    String name = jObj.getString("name");
                    if (StringUtils.isEmpty((String)number)) {
                        String[] split = longNumber.split("!");
                        number = split.length > 0 ? split[split.length - 1] : longNumber;
                    }
                    data = new HashMap<String, String>();
                    data.put("orgId", number);
                    data.put("orgName", name);
                    if (jObj.get((Object)"isIncludeSub") != null && jObj.getBoolean("isIncludeSub").booleanValue()) {
                        data.put("rangeType", RangeType.DEFAULT.getValue());
                    } else {
                        data.put("rangeType", RangeType.EXCEPT.getValue());
                    }
                    permList.add(data);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return permList;
    }

    protected void _deleteFaqQuestionInfo(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("DELETE FROM T_SHR_FaqQuestionlike WHERE FQuestionID IN ( SELECT FID FROM T_SHR_FAQquestion where FSOLUTIONID = '").append(pk.toString()).append("')");
        DbUtil.execute((Context)ctx, (String)ksql.toString());
        ksql = new StringBuffer();
        ksql.append("DELETE FROM T_SHR_FAQquestion WHERE FSOLUTIONID = '").append(pk.toString()).append("'");
        DbUtil.execute((Context)ctx, (String)ksql.toString());
    }

    private void _createFromCloudHub(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = (FaqSolutionInfo)model;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("token", AccessTokenHelper.getToken(ctx));
        dataMap.put("solutionName", solutionInfo.getName());
        dataMap.put("skillNumber", FaqSolutionControllerBean.getFaqSkillNumber(ctx));
        dataMap.put("themeId", "");
        dataMap.put("desc", solutionInfo.getDescription());
        dataMap.put("orgId", solutionInfo.getOrgId().getId().toString());
        dataMap.put("orgName", solutionInfo.getOrgName());
        dataMap.put("permissionOrgans", this.getPermOrgsInfo(ctx, solutionInfo.getPermissionOrgans()));
        Solution solution = new Solution();
        CreateResult result = (CreateResult)RequestUtils.operation(ctx, Faq.solution_create, dataMap, solution);
        if (!result.success()) {
            String label7 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label7", (Context)ctx);
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label7});
        }
        solution = (Solution)result.getDetailData();
        String cid = solution.getId();
        solutionInfo.setCid(cid);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("cid"));
        this.updatePartial(ctx, solutionInfo, selector);
    }

    private void _updateFromCloudHub(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = (FaqSolutionInfo)model;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("solutionName", solutionInfo.getName());
        dataMap.put("skillNumber", FaqSolutionControllerBean.getFaqSkillNumber(ctx));
        dataMap.put("desc", solutionInfo.getDescription());
        dataMap.put("id", solutionInfo.getCid());
        dataMap.put("permissionOrgans", this.getPermOrgsInfo(ctx, solutionInfo.getPermissionOrgans()));
        dataMap.put("token", AccessTokenHelper.getToken(ctx));
        Solution solution = new Solution();
        UpdateResult result = (UpdateResult)RequestUtils.operation(ctx, Faq.solution_update, dataMap, solution);
        if (!result.success()) {
            String label8 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label8", (Context)ctx);
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label8});
        }
    }

    protected void _deleteFromCloudHub(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = (FaqSolutionInfo)model;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("id", solutionInfo.getCid());
        dataMap.put("token", AccessTokenHelper.getToken(ctx));
        DeleteResult result = (DeleteResult)RequestUtils.operation(ctx, Faq.solution_delete, dataMap, null);
        if (!result.success()) {
            String label6 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label6", (Context)ctx);
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label6});
        }
    }

    protected void _startUpFromCloudHub(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaqSolutionInfo solutionInfo = (FaqSolutionInfo)model;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("id", solutionInfo.getCid());
        dataMap.put("enable", solutionInfo.getStartup().equals((Object)FaqSolutionStateEnum.ENABLE) ? 1 : 0);
        dataMap.put("token", AccessTokenHelper.getToken(ctx));
        UpdateResult result = (UpdateResult)RequestUtils.operation(ctx, Faq.solution_startup, dataMap, null);
        if (!result.success()) {
            String label37 = SHRServerResource.getString((String)"com.kingdee.shr.faqservice.FaqServiceServerResource", (String)"label37", (Context)ctx);
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{label37});
        }
    }

    protected SelectorItemCollection getSelctorCollection() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("orgName"));
        selector.add(new SelectorItemInfo("orgId"));
        selector.add(new SelectorItemInfo("lastUpdateUser"));
        selector.add(new SelectorItemInfo("lastUpdateTime"));
        return selector;
    }

    private static String getFaqSkillNumber(Context ctx) throws EASBizException {
        if (StringUtils.isEmpty((String)skillNumber) && StringUtils.isEmpty((String)(skillNumber = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"FAQ.AI.SKILL.NUMBER")))) {
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{"Please contact the administrator, please configure the sky AI platform skill menu number first"});
        }
        return skillNumber;
    }

    private static enum RangeType {
        DEFAULT("DEFAULT"),
        EXCEPT("EXCEPT");

        private String value;

        private RangeType(String value) {
            this.value = value;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

