/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.faqservice.cloudhub;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.faqservice.cloudhub.AccessToken;
import com.kingdee.shr.faqservice.cloudhub.UserAccessToken;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AccessTokenHelper {
    public static final String ACCESSTOKEN_PARAM = "accessToken";
    private Map<String, AccessToken> accessToken_helper = new ConcurrentHashMap<String, AccessToken>();
    private Map<String, UserAccessToken> userAccessToken_helper = new ConcurrentHashMap<String, UserAccessToken>();
    public static final String UTF8 = "UTF-8";
    public static final long TIME_OUT_PERIOD = 3L;
    public static final String DEFAULT_BASEURL_TEST = "https://ai.kingdee.com/ai20test";
    public static final String DEFAULT_BASEURL = "https://ai.kdcloud.com/ai20";
    public static final String GET_ACCESSTOKEN_URL = "/oauth/auth";
    public static final String GET_SKILL_ACCESSTOKEN_URL = "/oauth/authSkill";
    public static final String GET_SYS_ACCESSTOKEN_URL = "/gateway/oauth2/getSysAccessToken";
    public static final String REFRESH_SYS_ACCESSTOKEN_URL = "/gateway/oauth2/tokenRefresh";
    public static final String CLOUDHUB_BASE_URL = "cloudhub.base.url";
    public static final String CLOUDHUB_SYS_BASE_URL = "cloudhub.sys.base.url";
    public static final String FAQ_AI_BASE_URL_PRO = "FAQ.AI.BASE.URL";
    public static final String FAQ_AI_APPID_PRO = "FAQ.AI.APPID";
    public static final String FAQ_AI_APPID_KEY_PRO = "FAQ.AI.APPID.KEY";
    public static final String FAQ_AI_SKILL_NUMBER_PRO = "FAQ.AI.SKILL.NUMBER";
    public static final String FAQ_AI_SKILL_KEY_PRO = "FAQ.AI.SKILL.KEY";
    public static final String EID_PRO = "cloudhub.faq.eid";

    private AccessTokenHelper() {
    }

    public static final AccessTokenHelper getInstance() throws BOSException, EASBizException {
        return SingletonHolder.INSTANCE;
    }

    public void cleanAccessToken(Context ctx) {
        this.accessToken_helper.remove(ctx.getAIS());
        this.userAccessToken_helper.remove(ctx.getAIS());
    }

    public AccessToken getAccessToken(Context ctx) throws EASBizException, BOSException {
        if (this.accessToken_helper.containsKey(ctx.getAIS()) && this.accessToken_helper.get(ctx.getAIS()) != null) {
            AccessToken converter = this.accessToken_helper.get(ctx.getAIS());
            converter.check();
            return converter;
        }
        AccessToken converter = new AccessToken(ctx);
        converter.init();
        this.accessToken_helper.put(ctx.getAIS(), converter);
        return converter;
    }

    public UserAccessToken getUserAccessToken(Context ctx) throws EASBizException, BOSException {
        if (this.userAccessToken_helper.containsKey(ctx.getAIS()) && this.userAccessToken_helper.get(ctx.getAIS()) != null) {
            UserAccessToken converter = this.userAccessToken_helper.get(ctx.getAIS());
            converter.check();
            return converter;
        }
        UserAccessToken converter = new UserAccessToken(ctx);
        converter.init();
        this.userAccessToken_helper.put(ctx.getAIS(), converter);
        return converter;
    }

    public static String getToken(Context ctx) throws EASBizException, BOSException {
        return AccessTokenHelper.getInstance().getAccessToken(ctx).getToken();
    }

    public static String getUserToken(Context ctx) throws EASBizException, BOSException {
        return AccessTokenHelper.getInstance().getUserAccessToken(ctx).getToken();
    }

    private static class SingletonHolder {
        private static final AccessTokenHelper INSTANCE = new AccessTokenHelper();

        private SingletonHolder() {
        }
    }
}

