/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.faqservice.vo;

import com.kingdee.shr.faqservice.vo.FaqReportParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class FaqReport
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5396815511414739364L;
    public static final String Content_EL = "content";
    public static final String Param_EL = "param";
    public static final String Order_EL = "order";
    private Element element;
    private String content = "";
    private List<FaqReportParam> param;
    private List<String> order;

    public FaqReport(Element element) {
        this.element = element;
        this.param = new ArrayList<FaqReportParam>();
        this.order = new ArrayList<String>();
        this.init();
    }

    private void init() {
        this.initContent();
        this.initParam();
        this.initOrder();
    }

    private void initContent() {
        this.content = this.element.element(Content_EL).getText();
    }

    private void initParam() {
        Element el = this.element.element(Param_EL);
        if (el != null && el.hasContent()) {
            List elements = el.elements("attribute");
            FaqReportParam attr = null;
            for (Object e : elements) {
                Iterator iterator = ((Element)e).attributeIterator();
                attr = new FaqReportParam();
                while (iterator.hasNext()) {
                    Attribute next = (Attribute)iterator.next();
                    if ("key".equals(next.getName())) {
                        attr.setKey(next.getValue());
                        continue;
                    }
                    if ("value".equals(next.getName())) {
                        attr.setValue(next.getValue());
                        continue;
                    }
                    if ("defaultValue".equals(next.getName())) {
                        attr.setDefaultValue(next.getValue());
                        continue;
                    }
                    if ("defaultIndex".equals(next.getName())) {
                        attr.setDefaultIndex(Integer.parseInt(next.getValue()));
                        continue;
                    }
                    attr.addOtherParam(next.getName(), next.getValue());
                }
                this.param.add(attr);
            }
        }
    }

    private void initOrder() {
        Element el = this.element.element(Order_EL);
        if (el != null && el.hasContent()) {
            List elements = el.elements("attribute");
            for (Object e : elements) {
                Attribute key = ((Element)e).attribute("key");
                this.order.add(key.getValue());
            }
        }
    }

    public final Element getElement() {
        return this.element;
    }

    public final String getContent() {
        return this.content;
    }

    public final List<FaqReportParam> getParam() {
        return this.param;
    }

    public final List<String> getOrder() {
        return this.order;
    }
}

