/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.formulaplatform.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.formulaplatform.FormulaException;
import com.kingdee.shr.formulaplatform.FormulaItemCollection;
import com.kingdee.shr.formulaplatform.FormulaItemFactory;
import com.kingdee.shr.formulaplatform.FormulaItemInfo;
import com.kingdee.shr.formulaplatform.baseconfig.FormulaCacheService;
import com.kingdee.shr.formulaplatform.formulaexecutor.DefaultFormulaExecutor;
import com.kingdee.shr.formulaplatform.formulaexecutor.IFormulaExecutor;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class FormulaUtil {
    public static void canDelete(Context ctx, IObjectPK pk) throws CanNotDeleteException {
        BOSObjectType bosType = BOSUuid.read((String)pk.toString()).getType();
        EntityObjectInfo modelEntity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        CoreBaseInfo model = null;
        try {
            ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)modelEntity.getFullName()));
            model = iCoreBase.getValue(pk);
        }
        catch (BOSException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
        catch (EASBizException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
        if (null == model) {
            throw new CanNotDeleteException((Throwable)new EASBizException(EASBizException.CHECKEXIST));
        }
        if (model.getBoolean("isSysPreset")) {
            throw new CanNotDeleteException((Throwable)new BaseItemException(BaseItemException.DEFAULT_NOT_DELETE, new Object[]{model.get("number")}));
        }
        if (1 == model.getInt("state")) {
            throw new CanNotDeleteException((Throwable)new BaseItemException(BaseItemException.ONLY_UNENABLE_CAN_DELETE));
        }
    }

    public static boolean hasEditPermissionAction(Context ctx, FormulaItemInfo formulaInfo, String permItemId) throws BOSException, SQLException {
        Set hrOrgSet;
        String hrOrgId = formulaInfo.getHrOrgUnit() != null ? formulaInfo.getHrOrgUnit().getString("id") : null;
        String formulaItemId = formulaInfo.getString("id");
        if (StringUtils.isBlank((CharSequence)formulaItemId)) {
            return true;
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getString("id");
        if (StringUtils.isNotBlank((CharSequence)hrOrgId) && (hrOrgSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)userId, (String)permItemId)).contains(hrOrgId)) {
            return true;
        }
        String hrOrgSql = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)permItemId);
        StringBuffer checkSql = new StringBuffer();
        checkSql.append(" SELECT 1 FROM T_SHR_FormulaItem ");
        checkSql.append(" WHERE fid=? and fhrorgunitid IN (").append(hrOrgSql).append(")");
        checkSql.append(" union all");
        checkSql.append(" SELECT 1 FROM T_SHR_FormulaItem baseItem");
        checkSql.append(" INNER JOIN T_HR_ControlPolicy cp ON baseItem.FShrBasicItemID = cp.FShrBasicItemID and baseItem.fid=?");
        checkSql.append(" where baseItem.FUsePolicy = 100 AND cp.FMaintainPolicy = 200 ");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString(), (Object[])new Object[]{formulaItemId, formulaItemId});
        return iRowSet.next();
    }

    public static FormulaItemInfo gerRefFormulaItem(FormulaItemInfo formulaItemInfo) throws FormulaException {
        int maxRefDeep = 100;
        CoreBaseCollection colls = new CoreBaseCollection();
        colls.add((CoreBaseInfo)formulaItemInfo);
        while (formulaItemInfo != null && formulaItemInfo.getRefItem() != null && --maxRefDeep >= 0) {
            if (StringUtils.isBlank((CharSequence)formulaItemInfo.getRefItem().getString("id"))) {
                return formulaItemInfo;
            }
            formulaItemInfo = FormulaCacheService.getInstance(null).getFormulaItemInfo(formulaItemInfo.getRefItem().getId());
            if (!colls.contains((CoreBaseInfo)formulaItemInfo)) continue;
            throw new FormulaException(FormulaException.CIRCLE_REF);
        }
        return formulaItemInfo;
    }

    public static Class<IFormulaExecutor> checkFormula(Context ctx, FormulaItemInfo formulaInfo, DefaultFormulaExecutor executor) throws FormulaException {
        FormulaUtil.gerRefFormulaItem(formulaInfo);
        if (executor == null) {
            executor = new DefaultFormulaExecutor();
        }
        executor.getFormulaCtx().setSimulate(true);
        String newId = "simulate_" + formulaInfo.getString("id");
        formulaInfo.put("id", newId);
        Class<IFormulaExecutor> cls = executor.analyzeFormula(ctx, formulaInfo, true);
        if (cls == null) {
            throw new FormulaException(FormulaException.FORMULA_ERROR);
        }
        return cls;
    }

    public static boolean checkFormulaSortsn(Context ctx, Iterator<?> formulaItemInfoIterator) throws FormulaException {
        FormulaItemCollection colls;
        boolean result = true;
        try {
            colls = FormulaItemFactory.getLocalInstance(ctx).getFormulaItemCollection("select id,name,number,sortsn where formula=''");
        }
        catch (BOSException e) {
            throw new FormulaException(FormulaException.CUSTOM, e, new Object[]{e.getMessage()});
        }
        FormulaItemCollection needCheckColls = new FormulaItemCollection();
        while (formulaItemInfoIterator.hasNext()) {
            Object item = formulaItemInfoIterator.next();
            if (!(item instanceof FormulaItemInfo)) continue;
            colls.add((FormulaItemInfo)item);
            needCheckColls.add((FormulaItemInfo)item);
        }
        if (formulaItemInfoIterator == null || !formulaItemInfoIterator.hasNext()) {
            return result;
        }
        return result;
    }

    public static boolean isDomainConfigStyle(String config) {
        return config != null && config.trim().startsWith("[") && config.trim().endsWith("]");
    }

    public static boolean isNumberSqlType(int SqlType) {
        return SqlType == -5 || SqlType == 3 || SqlType == 4 || SqlType == 2 || SqlType == 16 || SqlType == -6 || SqlType == 5 || SqlType == 6 || SqlType == 8;
    }

    public static boolean isDateSqlType(int SqlType) {
        return SqlType == 91 || SqlType == 92 || SqlType == 93;
    }
}

