/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.formulaplatform.baseconfig;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.framework.cache.service.CacheRouterManager;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.framework.cache.service.ICacheRouter;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.timezone.Date;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.formulaplatform.FormulaFuncFactory;
import com.kingdee.shr.formulaplatform.FormulaFuncInfo;
import com.kingdee.shr.formulaplatform.FormulaItemCollection;
import com.kingdee.shr.formulaplatform.FormulaItemFactory;
import com.kingdee.shr.formulaplatform.FormulaItemInfo;
import com.kingdee.shr.formulaplatform.FormulaTplCollection;
import com.kingdee.shr.formulaplatform.FormulaTplFactory;
import com.kingdee.shr.formulaplatform.FormulaTplInfo;
import com.kingdee.shr.formulaplatform.IFormulaFunc;
import com.kingdee.shr.formulaplatform.IFormulaItem;
import com.kingdee.shr.formulaplatform.IFormulaTpl;
import com.kingdee.shr.formulaplatform.app.FormulaUtil;
import com.kingdee.shr.formulaplatform.formulaexecutor.DefaultFormulaExecutor;
import com.kingdee.shr.formulaplatform.formulaexecutor.FormulaCacheLevel;
import com.kingdee.shr.formulaplatform.formulaexecutor.FormulaExecutorUtile;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FormulaCacheService {
    private static Logger logger = Logger.getLogger(FormulaCacheService.class);
    public static final String CACHE_TYPE = "shr.formulaPlateformCache";
    public static final int QUERY_LENGTH = 499;
    private DefaultFormulaExecutor formulaExecutor;

    private FormulaCacheService(DefaultFormulaExecutor formulaExecutor) {
        this.formulaExecutor = formulaExecutor == null ? new DefaultFormulaExecutor() : formulaExecutor;
    }

    public static FormulaCacheService getInstance(DefaultFormulaExecutor formulaExecutor) {
        return new FormulaCacheService(formulaExecutor);
    }

    public FormulaTplInfo getFormulaTplInfo(Object id) {
        Context ctx;
        if (id == null || StringUtils.isBlank((String)id.toString())) {
            return null;
        }
        FormulaTplInfo formulaTplInfo = (FormulaTplInfo)CacheService.getInstance().get(CACHE_TYPE, this.getFormulaTplCacheKey(id));
        if (formulaTplInfo != null) {
            return formulaTplInfo;
        }
        try {
            ctx = this.getContext(null);
            String oql = "select *,items.*,scheme.* where id = '" + id + "'";
            IFormulaTpl iFormulaTpl = FormulaTplFactory.getLocalInstance(ctx);
            formulaTplInfo = iFormulaTpl.getFormulaTplInfo(oql);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (formulaTplInfo != null) {
            ctx = this.getContext(null);
            FormulaTplCollection colls = new FormulaTplCollection();
            colls.add(formulaTplInfo);
            FormulaExecutorUtile.cacheDefaultVal(ctx, colls);
            this.putFormulaTplInfo(formulaTplInfo);
        }
        return formulaTplInfo;
    }

    public void putFormulaTplInfo(FormulaTplInfo formulaTplInfo) {
        CacheService.getInstance().put(CACHE_TYPE, this.getFormulaTplCacheKey(formulaTplInfo), (Object)formulaTplInfo);
    }

    public FormulaItemInfo getFormulaItemInfo(Object id) {
        int i;
        if (id == null || StringUtils.isBlank((String)id.toString())) {
            return null;
        }
        FormulaItemInfo formulaItemInfo = (FormulaItemInfo)CacheService.getInstance().get(CACHE_TYPE, FormulaCacheService.getFormulaItemCacheKey(id));
        if (formulaItemInfo != null) {
            return formulaItemInfo;
        }
        FormulaItemCollection coll = null;
        Context ctx = this.getContext(null);
        try {
            String oql = MessageFormat.format("where id=''{0}''", id);
            IFormulaItem iFormulaItem = FormulaItemFactory.getLocalInstance(ctx);
            if (!iFormulaItem.exists(oql)) {
                return null;
            }
            formulaItemInfo = iFormulaItem.getFormulaItemInfo(oql);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            evi.setFilter(filterInfo);
            filterInfo.getFilterItems().add(new FilterItemInfo("formula", (Object)formulaItemInfo.getFormula(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("formulaTpl", (Object)formulaItemInfo.getFormulaTpl().getString("id"), CompareType.EQUALS));
            filterInfo.setMaskString("#0 or #1");
            coll = iFormulaItem.getFormulaItemCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        int n = i = coll == null ? 0 : coll.size();
        while (--i >= 0) {
            FormulaCacheService.putFormulaItemInfo(coll.get(i));
        }
        return formulaItemInfo;
    }

    public FormulaFuncInfo getFormulaFuncInfo(Object id) {
        if (id == null || StringUtils.isBlank((String)id.toString())) {
            return null;
        }
        FormulaFuncInfo formulaFuncInfo = (FormulaFuncInfo)CacheService.getInstance().get(CACHE_TYPE, this.getFormulaFuncCacheKey(id));
        if (formulaFuncInfo != null) {
            return formulaFuncInfo;
        }
        Context ctx = this.getContext(null);
        try {
            String oql = MessageFormat.format("where id=''{0}''", id);
            IFormulaFunc iFormulaFunc = FormulaFuncFactory.getLocalInstance(ctx);
            if (!iFormulaFunc.exists(oql)) {
                return null;
            }
            formulaFuncInfo = iFormulaFunc.getFormulaFuncInfo(oql);
            this.putFormulaFuncInfo(formulaFuncInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return formulaFuncInfo;
    }

    public FormulaFuncInfo putFormulaFuncInfo(FormulaFuncInfo formulaFuncInfo) {
        CacheService.getInstance().put(CACHE_TYPE, this.getFormulaTplCacheKey(formulaFuncInfo), (Object)formulaFuncInfo);
        return formulaFuncInfo;
    }

    public static FormulaItemInfo putFormulaItemInfo(FormulaItemInfo formulaItemInfo) {
        CacheService.getInstance().put(CACHE_TYPE, FormulaCacheService.getFormulaItemCacheKey(formulaItemInfo), (Object)formulaItemInfo);
        return formulaItemInfo;
    }

    private String getFormulaFuncCacheKey(Object formulaFunc) {
        if (formulaFunc instanceof FormulaFuncInfo) {
            formulaFunc = ((FormulaFuncInfo)formulaFunc).getString("id");
        }
        return MessageFormat.format("FM_func_{0}", formulaFunc);
    }

    private static String getFormulaItemCacheKey(Object formulaItem) {
        if (formulaItem instanceof FormulaItemInfo) {
            formulaItem = ((FormulaItemInfo)formulaItem).getString("id");
        }
        return MessageFormat.format("FM_item_{0}", formulaItem);
    }

    private String getFormulaTplCacheKey(Object formulaTpl) {
        if (formulaTpl instanceof FormulaTplInfo) {
            formulaTpl = ((FormulaTplInfo)formulaTpl).getString("id");
        }
        return MessageFormat.format("FM_tpl_{0}", formulaTpl);
    }

    private String getCacheKey(FormulaCacheLevel cacheLevel) {
        return (String)this.formulaExecutor.getFormulaCtx().getExecutorConfig().get(MessageFormat.format("CACHE_LEVEL_{0}", cacheLevel.getValue()));
    }

    public Context getContext(Context ctx) {
        return ctx == null ? ConfigMDUtil.getContext() : ctx;
    }

    public void setCacheKey(Context ctx, FormulaCacheLevel cacheLevel) {
        String cacheKey;
        ctx = this.getContext(ctx);
        String userNum = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String string = userNum = userInfo == null ? null : userInfo.getNumber();
        if (StringUtils.isBlank((String)userNum)) {
            userNum = "administrator";
        }
        if ((cacheKey = this.getCacheKey(cacheLevel)) != null) {
            this.removeCache(ctx, cacheLevel);
        } else {
            this.formulaExecutor.getFormulaCtx().getExecutorConfig().put(MessageFormat.format("CACHE_LEVEL_{0}", cacheLevel.getValue()), MessageFormat.format("FM{0}_{1}_{2}_{3}", userNum, Integer.toHexString(this.formulaExecutor.hashCode()), this.formulaExecutor.getClass().getName(), cacheLevel.getValue()));
        }
    }

    public void removeCache(Context ctx, FormulaCacheLevel cacheLevel) {
        String CACHE_TYPE = CACHE_TYPE;
        ICacheRouter cacheRouter = CacheRouterManager.getInstance().getCustomRouter(CACHE_TYPE);
        ctx = this.getContext(ctx);
        String preCacheType = MessageFormat.format("{0}#{1}", ctx.getAIS(), CACHE_TYPE);
        String cacheKey = this.getCacheKey(cacheLevel);
        if (cacheLevel == FormulaCacheLevel.GLOBAL) {
            cacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(95) + 1);
        }
        List cacheKeys = cacheRouter.searchKeys(preCacheType, cacheKey);
        int fieldStartInd = preCacheType.length() + 1;
        try {
            CacheService cacheService = CacheService.getInstance();
            for (Object key : cacheKeys) {
                cacheService.remove(CACHE_TYPE, key.toString().substring(fieldStartInd));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void removeAllCache() {
        CacheService.getInstance().removeAll(CACHE_TYPE);
    }

    public void removeCache(String key) {
        CacheService.getInstance().remove(CACHE_TYPE, key);
    }

    public void removeFormulaTplCache(Object id) {
        this.removeCache(this.getFormulaTplCacheKey(id));
    }

    public void removeFormulaItemCache(Object id) {
        this.removeCache(FormulaCacheService.getFormulaItemCacheKey(id));
    }

    public void removeFormulaFuncCache(Object id) {
        this.removeCache(this.getFormulaFuncCacheKey(id));
    }

    public String formatFormulaKey(FormulaCacheLevel cacheLevel, String key) {
        String prefix = this.getCacheKey(cacheLevel);
        if (!key.startsWith(prefix)) {
            key = MessageFormat.format("{0}_{1}", prefix, key);
        }
        return key;
    }

    public String generateFunctionKey(Object[] params, String functionName) {
        return MessageFormat.format("{0}_{1}", functionName, StringUtils.join((Object[])params, (String)"_"));
    }

    public void setValueToCache(FormulaCacheLevel cacheLevel, String key, Object obj) {
        long begin = System.currentTimeMillis();
        CacheService.getInstance().put(CACHE_TYPE, this.formatFormulaKey(cacheLevel, key), obj);
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("setValueToCache key:{0},value:{1},cost:{2} ms", key, obj, end - begin));
        }
    }

    public void setValueToCache(Object obj) {
        Iterator<Object> iterator = obj instanceof IObjectCollection ? ((IObjectCollection)obj).iterator() : (obj instanceof Collection ? ((Collection)obj).iterator() : Collections.singletonList(obj).iterator());
        Object ele = iterator.next();
        while (iterator.hasNext()) {
            ele = iterator.next();
            if (ele instanceof CoreBaseInfo) {
                this.setValueToCache(FormulaCacheLevel.GLOBAL, FormulaCacheService.getCacheIDKey(ele), ele);
                this.setValueToCache(FormulaCacheLevel.GLOBAL, FormulaCacheService.getCacheNumberKey(ele, null), ele);
                continue;
            }
            throw new IllegalArgumentException(String.valueOf(obj));
        }
    }

    public static String getCacheIDKey(Object obj) {
        return FormulaCacheService.getCacheKey(obj, "id", null);
    }

    public static String getCacheNumberKey(Object obj, String number) {
        return FormulaCacheService.getCacheKey(obj, "number", number);
    }

    public static String getCacheKey(Object mainKey, String key, Object valueKey) {
        if (valueKey == null && mainKey instanceof CoreBaseInfo) {
            valueKey = ((CoreBaseInfo)mainKey).get(key);
        }
        mainKey = FormulaCacheService.convertToBosType(mainKey);
        return MessageFormat.format("{0}_{1}_{2}", mainKey, key, valueKey);
    }

    private static Object convertToBosType(Object obj) {
        if (obj instanceof Class) {
            try {
                obj = ((Class)obj).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (BOSUuid.isValid((String)String.valueOf(obj), (boolean)true)) {
            obj = BOSUuid.read((String)String.valueOf(obj)).getType();
        }
        if (obj instanceof CoreBaseInfo) {
            obj = ((CoreBaseInfo)obj).getBOSType();
        }
        return obj;
    }

    public Object getValueFromCacheNumber(Object obj, String number) {
        return this.getValueFromCache(FormulaCacheLevel.GLOBAL, FormulaCacheService.getCacheNumberKey(obj, number));
    }

    public Object getValueFromCacheID(Object valueKey) {
        return this.getValueFromCache(FormulaCacheLevel.GLOBAL, FormulaCacheService.getCacheIDKey(valueKey));
    }

    public Object getValueFromCache(FormulaCacheLevel cacheLevel, Object mainKey, String key, Object valueKey) {
        return this.getValueFromCache(cacheLevel, FormulaCacheService.getCacheKey(mainKey, key, valueKey));
    }

    public Object getValueFromCache(FormulaCacheLevel cacheLevel, String key) {
        return CacheService.getInstance().get(CACHE_TYPE, this.formatFormulaKey(cacheLevel, key));
    }

    public Object getAndInit(FormulaCacheLevel cacheLevel, String key) {
        Object res = this.getValueFromCache(cacheLevel, key);
        if (res == null) {
            this.initCacheCollection(key);
        }
        return this.getValueFromCache(FormulaCacheLevel.GLOBAL, key);
    }

    public Object getAndInitByNumber(Object obj, String number) {
        Object res = this.getValueFromCacheNumber(obj, number);
        if (res == null) {
            this.initCacheCollection(obj);
        }
        return this.getValueFromCacheNumber(obj, number);
    }

    public void initCacheCollection(Object key) {
        Object bosType = FormulaCacheService.convertToBosType(key);
        if (bosType instanceof BOSObjectType) {
            Context ctx = ConfigMDUtil.getContext();
            IMetaDataLoader iLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            BusinessObjectInfo bizObj = iLoader.getBusinessObject((BOSObjectType)bosType);
            MetaDataPK pk = MetaDataPK.create((String)bizObj.getFullName());
            try {
                ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)pk);
                EntityViewInfo evi = new EntityViewInfo();
                evi.getSorter().add(new SorterItemInfo("id"));
                int i = 0;
                while (true) {
                    List pageData = iCoreBase.getPagingList(evi, i * 499, 499);
                    this.setValueToCache(pageData);
                    if (pageData.size() >= 499) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static LinkedHashMap<String, Integer> getColumnType(IRowSet iRowSet) throws SQLException {
        ResultSetMetaData allColumn = iRowSet.getMetaData();
        int columnCount = allColumn.getColumnCount();
        LinkedHashMap<String, Integer> columns = new LinkedHashMap<String, Integer>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            String label = StringUtils.isNotEmpty((String)allColumn.getColumnLabel(i)) ? allColumn.getColumnLabel(i) : allColumn.getColumnName(i);
            columns.put(label, allColumn.getColumnType(1));
        }
        return columns;
    }

    private static Object formatDbData(int sqlType, Object value) {
        if (value == null) {
            return FormulaUtil.isNumberSqlType(sqlType) ? Integer.valueOf(0) : "";
        }
        return FormulaUtil.isDateSqlType(sqlType) ? Date.getTime((Object)value) : value;
    }

    public static Map<String, Object> populateToMap(IRowSet iRowSet) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        try {
            ResultSetMetaData allColumn = iRowSet.getMetaData();
            LinkedHashMap<String, Integer> columnType = FormulaCacheService.getColumnType(iRowSet);
            int columnCount = allColumn.getColumnCount();
            if (columnCount == 2) {
                int sqlType = (Integer)columnType.values().toArray()[1];
                while (iRowSet.next()) {
                    res.put(iRowSet.getString(1), FormulaCacheService.formatDbData(sqlType, iRowSet.getObject(2)));
                }
                return res;
            }
            while (iRowSet.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                res.put(iRowSet.getString(1), row);
                for (String column : columnType.keySet()) {
                    row.put(column, FormulaCacheService.formatDbData(columnType.get(column), iRowSet.getObject(column)));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return res;
    }

    public Map<String, Object> initTwoFieldData(Context ctx, String sql, Object[] params, FormulaCacheLevel cacheLevel, String cacheKey) {
        String newCacheKey = this.generateFunctionKey(params, cacheKey);
        Object cacheValue = this.getValueFromCache(cacheLevel, newCacheKey);
        if (cacheValue != null) {
            return (Map)cacheValue;
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        PagingHelper pagingHelper = new PagingHelper();
        try {
            int i = 0;
            while (true) {
                String pageSql = pagingHelper.getPagingSqlNoOptmize(ctx, sql, i * 499, 499);
                Map<String, Object> rowData = FormulaCacheService.populateToMap(DbUtil.executeQuery((Context)ctx, (String)pageSql, (Object[])params));
                res.putAll(rowData);
                if (rowData.size() < 499) break;
                ++i;
            }
            if (StringUtils.isNotBlank((String)cacheKey)) {
                this.setValueToCache(cacheLevel, newCacheKey, res);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return res;
    }
}

