/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.formulaplatform.compile;

import com.kingdee.shr.formulaplatform.compile.DynamicClassUtile;
import com.kingdee.shr.formulaplatform.compile.DynamicElement;
import com.kingdee.shr.formulaplatform.compile.DynamicField;
import com.kingdee.shr.formulaplatform.compile.DynamicMethod;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class DynamicClass
extends DynamicElement {
    private String packageName;
    private String superClass;
    private Set<String> importPackages = new TreeSet<String>();
    private Set<String> superInterFaces = new TreeSet<String>();
    private Map<String, DynamicField> fields = new TreeMap<String, DynamicField>();
    private Map<String, DynamicMethod> methods = new TreeMap<String, DynamicMethod>();

    public DynamicClass() {
        this.setType("class");
    }

    public boolean removeImportPackage(String packageName) {
        return this.importPackages.remove(packageName);
    }

    public boolean removeSuperInterFaces(String interfaceName) {
        return this.superInterFaces.remove(interfaceName);
    }

    public DynamicField removeField(String fieldName) {
        return this.fields.remove(fieldName);
    }

    public DynamicField removeField(DynamicField field) {
        for (String fieldName : this.fields.keySet()) {
            if (!DynamicClassUtile.equals(field, this.fields.get(fieldName))) continue;
            return this.removeField(fieldName);
        }
        return null;
    }

    public DynamicMethod removeMethod(String method) {
        return this.methods.remove(method);
    }

    public DynamicMethod removeMethod(DynamicField method) {
        for (String methodName : this.methods.keySet()) {
            if (!DynamicClassUtile.equals(method, this.methods.get(methodName))) continue;
            return this.removeMethod(methodName);
        }
        return null;
    }

    public void addImportPackage(String packageName) {
        if (StringUtils.isNotBlank((String)packageName)) {
            this.importPackages.add(packageName.trim());
        }
    }

    public void addInterface(String superInterface) {
        if (StringUtils.isNotBlank((String)superInterface)) {
            this.superInterFaces.add(superInterface.trim());
        }
    }

    public DynamicField addField(DynamicField field) {
        if (field != null) {
            this.fields.put(field.getName(), field);
        }
        return field;
    }

    public DynamicField addField(String fieldName, String ... modifiers) {
        if (StringUtils.isBlank((String)fieldName)) {
            return null;
        }
        DynamicField field = new DynamicField();
        field.setName(fieldName);
        if (modifiers == null) {
            for (String modifier : modifiers) {
                field.addModifier(modifier);
            }
        }
        return this.addField(field);
    }

    public DynamicMethod addMethod(DynamicMethod method) {
        if (method != null) {
            this.methods.put(method.getName(), method);
        }
        return method;
    }

    public DynamicMethod addMethod(String methodName, String ... modifiers) {
        if (StringUtils.isBlank((String)methodName)) {
            return null;
        }
        DynamicMethod method = new DynamicMethod();
        method.setName(methodName);
        if (modifiers == null) {
            for (String modifier : modifiers) {
                method.addModifier(modifier);
            }
        }
        return this.addMethod(method);
    }

    public DynamicMethod addMethod(String fullMethodString) {
        return this.addMethod(new DynamicMethod(fullMethodString));
    }

    public String getPackageName() {
        return this.packageName;
    }

    public DynamicClass setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public DynamicClass setSuperClass(String superClass) {
        this.superClass = superClass;
        return this;
    }

    public Set<String> getImportPackages() {
        return this.importPackages;
    }

    public Set<String> getSuperInterFaces() {
        return this.superInterFaces;
    }

    public Map<String, DynamicField> getFields() {
        return this.fields;
    }

    public Map<String, DynamicMethod> getMethods() {
        return this.methods;
    }

    @Override
    public String getContent() {
        StringBuffer content = new StringBuffer();
        if (StringUtils.isNotBlank((String)this.packageName)) {
            content.append("\r\npackage ").append(this.packageName).append(";");
        }
        content.append("\r\n");
        for (String packageName : this.getImportPackages()) {
            content.append("import ").append(packageName).append(";\r\n");
        }
        content.append("\r\n ").append(super.getContent());
        if (StringUtils.isNotBlank((String)this.getSuperClass())) {
            content.append(" extends ").append(this.getSuperClass());
        }
        for (String face : this.getSuperInterFaces()) {
            content.append(" implements ").append(face).append(",");
        }
        if (content.charAt(content.length() - 1) == ',') {
            content.setCharAt(content.length() - 1, '{');
        } else {
            content.append('{');
        }
        for (DynamicMethod method : this.methods.values()) {
            content.append("\r\n").append(method.getContent());
        }
        content.append("\r\n}");
        return content.toString();
    }
}

