/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.formulaplatform.compile.formulaexpr;

import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.shr.formulaplatform.FormulaException;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.ExprType;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.FormulaExpr;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.OperatorExpr;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.operator.OperatorBracket;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.operator.OperatorMathCal;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class FormulaExprProcessor {
    public void test() throws FormulaException {
        OperatorMathCal.add(1, 2);
        OperatorMathCal.add(1, 2);
        OperatorMathCal.add(1, 2);
        OperatorMathCal.add(1.2, (Object)2);
        OperatorMathCal.add((Object)1, 2.3);
        OperatorMathCal.add(1.5, 2.3);
        this.processFormulaExpr("FormulaExecutorUtile.setFieldVal(model,\"BigDecimal\",\"remainLimit\",(formulaFunc:getFormulaFun)(\"h/meZhEIyUurMBI8MBETOkYX1kk=\")(FormulaExecutorUtile.getModelFieldVal(model,\"BigDecimal\",\"realLimit\")+ \"\" )-(formulaFunc:getFormulaFun)(\"h/meZhEIyUurMBI8MBETOkYX1kk=\")((scheme:getFieldVal)(dataSource,\"BigDecimal\",\"hLimit.usedLimit\")+ \"\")-(formulaFunc:getFormulaFun)(\"h/meZhEIyUurMBI8MBETOkYX1kk=\")((scheme:getFieldVal)(dataSource,\"BigDecimal\",\"hLimit.freezeLimit\")+ \"\" ));\nif((scheme:getFieldVal)(dataSource,\"Boolean\",\"HPoli.isOver\")==1){\nFormulaExecutorUtile.setFieldVal(model,\"BigDecimal\",\"remainLimit\",(formulaFunc:getFormulaFun)(\"h/meZhEIyUurMBI8MBETOkYX1kk=\")(FormulaExecutorUtile.getModelFieldVal(model,\"BigDecimal\",\"remainLimit\")+ \"\")-(formulaFunc:getFormulaFun)(\"8r0AAAAyeeBGF9ZJ\")(  ));\n}");
        this.processFormulaExpr("char sign = expr.charAt(operatorInd); \r\nif(sign == ' ' || sign == ';' || sign == '=' || OperatorExpr.operatorExprContainer.containsKey(sign)){\r\nreturn true;\r\n}\r\nint c = 56 *23;\r\nif(expr.length() > operatorInd && OperatorExpr.operatorExprContainer.containsKey(expr.substring(operatorInd, operatorInd + 2))){\r\nreturn true;\r\n}\r\nreturn false;\r\n");
    }

    public String processFormulaExpr(String formulaExpr) throws FormulaException {
        System.out.println(formulaExpr);
        List<FormulaExpr> exprs = this.buildExprList(formulaExpr);
        StringBuffer res = this.processOperand(exprs);
        System.out.println(res);
        return res.toString();
    }

    public List<FormulaExpr> buildExprList(String formulaExpr) throws FormulaException {
        String expr = formulaExpr.trim();
        List<FormulaExpr> processedExprs = new ArrayList<FormulaExpr>();
        ArrayList<OperatorBracket> operatorBrackets = new ArrayList<OperatorBracket>();
        ArrayList<Integer> genericityIndex = new ArrayList<Integer>();
        boolean genericityCnt = false;
        int lastOperatorInd = -1;
        int len = expr.length();
        for (int i = 1; i < len; ++i) {
            if (!this.validateSplitSign(expr, i, lastOperatorInd)) continue;
            char cur = expr.charAt(i);
            String curExpr = expr.substring(lastOperatorInd + 1, i);
            this.addExprToProcessedExprs(processedExprs, operatorBrackets, new FormulaExpr(curExpr));
            if (cur == ' ') {
                lastOperatorInd = i;
                this.addExprToProcessedExprs(processedExprs, operatorBrackets, new FormulaExpr(" "));
                continue;
            }
            OperatorExpr operator = i + 1 == len ? null : OperatorExpr.getOperatorExpr(expr.substring(i, i + 2));
            operator = operator == null ? OperatorExpr.getOperatorExpr(String.valueOf(cur)) : operator;
            operator = operator == null ? new OperatorExpr(String.valueOf(cur)) : operator;
            lastOperatorInd = i = i + operator.getExpr().length() - 1;
            int genericitySize = genericityIndex.size();
            if (cur == '<') {
                genericityIndex.add(processedExprs.size());
            } else if (cur == '>' && genericitySize > 0) {
                if (genericitySize == 1) {
                    StringBuffer genericityExpr = new StringBuffer();
                    int j = (Integer)genericityIndex.remove(0) - 1;
                    while (j < processedExprs.size()) {
                        genericityExpr.append(processedExprs.remove(j).getExpr());
                    }
                    processedExprs.add(new FormulaExpr(genericityExpr.append(cur).toString()));
                    genericityIndex.clear();
                    continue;
                }
                genericityIndex.remove(genericitySize - 1);
            } else if (cur != ' ' && cur != ',') {
                genericityIndex.clear();
            }
            if (cur == ')' || cur == '}') {
                if (operatorBrackets.size() == 0) {
                    throw new FormulaException(FormulaException.LACK_BRACKET_L);
                }
                char lastBracket = ((OperatorBracket)operatorBrackets.remove(operatorBrackets.size() - 1)).setComplete(true).getExpr().charAt(0);
                if ((lastBracket != '(' || cur != '}') && (lastBracket != '{' || cur != ')')) continue;
                throw new FormulaException(FormulaException.NOMATCH_BRACKET);
            }
            this.addExprToProcessedExprs(processedExprs, operatorBrackets, operator);
            if (cur != '(' && cur != '{') continue;
            operatorBrackets.add((OperatorBracket)operator);
        }
        if (operatorBrackets.size() > 0) {
            throw new FormulaException(FormulaException.LACK_BRACKET_R);
        }
        this.removeBlankExpr(processedExprs);
        this.processBracket(processedExprs);
        processedExprs = this.processOrder(processedExprs, Arrays.asList((Object[])new String[]{"*", "/", "%"}));
        processedExprs = this.processOrder(processedExprs, Arrays.asList((Object[])new String[]{"+", "-"}));
        return processedExprs;
    }

    private void removeBlankExpr(List<FormulaExpr> processedExprs) {
        FormulaExpr formulaExpr;
        ListIterator<FormulaExpr> it = processedExprs.listIterator();
        while (it.hasNext()) {
            formulaExpr = it.next();
            if (!formulaExpr.getExpr().equals("")) continue;
            it.remove();
        }
        for (int i = 1; i < processedExprs.size() - 1; ++i) {
            formulaExpr = processedExprs.get(i);
            if (StringUtils.isNotBlank((String)formulaExpr.getExpr()) || processedExprs.get(i - 1).getExprType() != ExprType.Operator && processedExprs.get(i + 1).getExprType() != ExprType.Operator) continue;
            processedExprs.remove(i);
            --i;
        }
    }

    private void processBracket(List<FormulaExpr> processedExprs) {
        for (int i = 1; i < processedExprs.size() - 1; ++i) {
            FormulaExpr formulaExpr = processedExprs.get(i);
            if (formulaExpr.getSubExprs() != null) {
                this.processBracket(formulaExpr.getSubExprs());
            }
            FormulaExpr preFormulaExpr = processedExprs.get(i - 1);
            if (!formulaExpr.getExpr().equals("(") || preFormulaExpr.getExprType() == ExprType.Operator) continue;
            formulaExpr.setExpr(processedExprs.remove(i - 1).getExpr() + formulaExpr.getExpr());
            --i;
        }
    }

    private void addExprToProcessedExprs(List<FormulaExpr> processedExprs, List<OperatorBracket> operatorBrackets, FormulaExpr formulaExpr) {
        if (operatorBrackets.size() > 0) {
            operatorBrackets.get(operatorBrackets.size() - 1).getSubExprs().add(formulaExpr);
        } else {
            processedExprs.add(formulaExpr);
        }
    }

    private boolean validateSplitSign(String expr, int operatorInd, int lastOperatorInd) {
        lastOperatorInd = Math.max(0, lastOperatorInd);
        if (!this.isExprSplitSign(expr, operatorInd)) {
            return false;
        }
        if (expr.substring(lastOperatorInd + 1, operatorInd).equals("'")) {
            return false;
        }
        int quotationCnt = 0;
        for (int i = lastOperatorInd + 1; i < operatorInd; ++i) {
            char cur = expr.charAt(i);
            if (cur != '\"' || expr.charAt(i - 1) == '\\') continue;
            ++quotationCnt;
        }
        if (quotationCnt % 2 != 0) {
            return false;
        }
        Pattern genericityPattern = Pattern.compile("<[<>\\w\\d]+(,[<>\\w\\d]+)*>");
        return quotationCnt % 2 == 0;
    }

    private boolean isExprSplitSign(String expr, int operatorInd) {
        char sign = expr.charAt(operatorInd);
        if (sign == ' ' || OperatorExpr.operatorExprContainer.containsKey(String.valueOf(sign))) {
            return true;
        }
        return expr.length() > operatorInd && OperatorExpr.operatorExprContainer.containsKey(expr.substring(operatorInd, operatorInd + 2));
    }

    public List<FormulaExpr> processOrder(List<FormulaExpr> needProcessExprs, List<String> operators) {
        ArrayList<FormulaExpr> processedExprs = new ArrayList<FormulaExpr>();
        FormulaExpr lastExpr = null;
        for (int i = 0; i < needProcessExprs.size(); ++i) {
            FormulaExpr curExpr = needProcessExprs.get(i);
            if (curExpr.getSubExprs() != null) {
                curExpr.setSubExprs(this.processOrder(curExpr.getSubExprs(), operators));
            }
            if (curExpr.getExprType() != ExprType.Operator || !operators.contains(curExpr.getExpr())) {
                processedExprs.add(curExpr);
                continue;
            }
            OperatorBracket newExpr = (OperatorBracket)OperatorExpr.getOperatorExpr("(");
            while (processedExprs.size() > 0) {
                lastExpr = (FormulaExpr)processedExprs.remove(processedExprs.size() - 1);
                if (!StringUtils.isNotBlank((String)lastExpr.getExpr())) continue;
                newExpr.getSubExprs().add(0, lastExpr);
                break;
            }
            newExpr.getSubExprs().add(curExpr);
            while (i + 1 < needProcessExprs.size()) {
                lastExpr = needProcessExprs.get(i + 1);
                if (StringUtils.isNotBlank((String)lastExpr.getExpr())) {
                    newExpr.getSubExprs().add(lastExpr);
                    break;
                }
                ++i;
            }
            ++i;
            processedExprs.add(newExpr);
        }
        return processedExprs;
    }

    public StringBuffer processOperand(List<FormulaExpr> needProcessExprs) {
        ArrayList<FormulaExpr> processedExprs = new ArrayList<FormulaExpr>(needProcessExprs);
        ListIterator<FormulaExpr> processedExprsIt = processedExprs.listIterator();
        while (processedExprsIt.hasNext()) {
            ((FormulaExpr)processedExprsIt.next()).processOperand(needProcessExprs, processedExprsIt);
        }
        StringBuffer sb = new StringBuffer();
        processedExprsIt = processedExprs.listIterator();
        while (processedExprsIt.hasNext()) {
            sb.append(processedExprsIt.next());
        }
        return sb;
    }
}

