/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.formulaplatform.compile.formulaexpr.operator;

import com.kingdee.shr.formulaplatform.compile.formulaexpr.ExprType;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.FormulaExpr;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.OperatorExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class OperatorBracket
extends OperatorExpr {
    private boolean isComplete;

    public OperatorBracket(String expr, String operatorName) {
        this.setSubExprs(new ArrayList<FormulaExpr>());
        this.isComplete = false;
        this.setExpr(expr);
        this.setOperatorName(operatorName);
    }

    public OperatorBracket() {
        this.setSubExprs(new ArrayList<FormulaExpr>());
        this.isComplete = false;
    }

    public static void initOperator() {
        OperatorBracket.addOperatorExpr("(", OperatorBracket.class, "leftBracket");
        OperatorBracket.addOperatorExpr(")", OperatorBracket.class, "rightBracket");
        OperatorBracket.addOperatorExpr("{", OperatorBracket.class, "leftBracket");
        OperatorBracket.addOperatorExpr("}", OperatorBracket.class, "rightBracket");
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public OperatorBracket setComplete(boolean isComplete) {
        this.isComplete = isComplete;
        return this;
    }

    @Override
    public void processOperand(List<FormulaExpr> processedExprs, ListIterator<FormulaExpr> processedExprsIt) {
        super.processOperand(processedExprs, processedExprsIt);
        processedExprsIt.previous();
        if (processedExprsIt.hasPrevious()) {
            FormulaExpr previousExpr = processedExprsIt.previous();
            if (previousExpr.getExprType() != ExprType.Operator) {
                this.setExpr(previousExpr.getExpr() + this.getExpr());
                processedExprsIt.remove();
            }
            processedExprsIt.next();
        }
        processedExprsIt.next();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(this.getExpr().equals("(") ? (char)')' : '}');
        return sb.toString();
    }
}

