/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cloud_inte.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.cloud_inte.HRCloudInteLogCollection;
import com.kingdee.shr.cloud_inte.HRCloudInteLogFactory;
import com.kingdee.shr.cloud_inte.HRCloudInteLogInfo;
import com.kingdee.shr.cloud_inte.InteCloudException;
import com.kingdee.shr.cloud_inte.InteDataType;
import com.kingdee.shr.cloud_inte.app.AbstractHRCloudInteLogControllerBean;
import com.kingdee.shr.osf.service.ServiceLocator;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class HRCloudInteLogControllerBean
extends AbstractHRCloudInteLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.cloud_inte.app.HRCloudInteLogControllerBean");

    @Override
    protected String _syncAgain(Context ctx, String ids) throws BOSException, EASBizException {
        String[] inteLogIdArray = ids.split(",");
        String idsql = "'" + ids.replace(",", "','") + "'";
        String sql = "select id,billType,number where id in ( " + idsql + " )";
        HRCloudInteLogCollection logCol = HRCloudInteLogFactory.getLocalInstance(ctx).getHRCloudInteLogCollection(sql);
        HashSet<String> orgIdSet = new HashSet<String>();
        HashSet<String> posIdSet = new HashSet<String>();
        HashSet<String> personIdSet = new HashSet<String>();
        Object objType = null;
        Object objId = null;
        Object bosType = null;
        String listObj = null;
        for (int i = 0; i < logCol.size(); ++i) {
            listObj = inteLogIdArray[i];
            HRCloudInteLogInfo LogInfo = logCol.get(i);
            String number = LogInfo.getNumber();
            sql = "select fid where number ='" + LogInfo.getNumber() + "'";
            if (LogInfo.getBillType() == InteDataType.cmpItem || LogInfo.getBillType() == InteDataType.cmpScheme) {
                throw new InteCloudException(InteCloudException.NOT_SUPPORT_CMP_SYNC);
            }
            if (LogInfo.getBillType() == InteDataType.adminOrg) {
                AdminOrgUnitInfo adminInfo = HRCloudInteLogControllerBean.getOrgInfoByNumber(ctx, number);
                orgIdSet.add(adminInfo.getId().toString());
                continue;
            }
            if (LogInfo.getBillType() == InteDataType.position) {
                PositionInfo posInfo = HRCloudInteLogControllerBean.getPosInfoByNumber(ctx, number);
                posIdSet.add(posInfo.getId().toString());
                continue;
            }
            if (LogInfo.getBillType() != InteDataType.employee) continue;
            PersonInfo personInfo = HRCloudInteLogControllerBean.getPersonInfoByNumber(ctx, number);
            personIdSet.add(personInfo.getId().toString());
        }
        HashMap<String, Object> idMap = new HashMap<String, Object>();
        if (orgIdSet.size() > 0) {
            idMap.put("orgUnit", orgIdSet);
        }
        if (posIdSet.size() > 0) {
            idMap.put("position", posIdSet);
        }
        if (personIdSet.size() > 0) {
            idMap.put("person", personIdSet);
        }
        String syncTimeMillis = String.valueOf(System.currentTimeMillis());
        idMap.put("syncTimeMillis", syncTimeMillis);
        IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "adviseOutSystemService");
        imsf.process(ctx, idMap);
        return syncTimeMillis;
    }

    @Override
    protected String _deleteLog(Context ctx, String ids) throws BOSException, EASBizException {
        String[] inteLogIdArray = ids.split(",");
        String idsql = "'" + ids.replace(",", "','") + "'";
        String sql = "select isDelete where id in ( " + idsql + " )";
        CoreBaseCollection logInfoColl = new CoreBaseCollection();
        HRCloudInteLogCollection logCol = HRCloudInteLogFactory.getLocalInstance(ctx).getHRCloudInteLogCollection(sql);
        for (int i = 0; i < logCol.size(); ++i) {
            HRCloudInteLogInfo info = logCol.get(i);
            info.setIsDelete(true);
            logInfoColl.add((CoreBaseInfo)info);
        }
        HRCloudInteLogFactory.getLocalInstance(ctx).save(logInfoColl);
        return null;
    }

    private static AdminOrgUnitInfo getOrgInfoByNumber(Context ctx, String number) throws BOSException, EASBizException {
        String sql = "select id,name,number  where number ='" + number + "'";
        AdminOrgUnitCollection Coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(sql);
        AdminOrgUnitInfo info = null;
        if (Coll.size() <= 0) {
            throw new InteCloudException(InteCloudException.NUMBER_NOT_EXIST);
        }
        info = Coll.get(0);
        return info;
    }

    private static PositionInfo getPosInfoByNumber(Context ctx, String number) throws BOSException, EASBizException {
        String sql = "select id,name,number  where number ='" + number + "'";
        PositionCollection Coll = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(sql);
        PositionInfo info = Coll.get(0);
        if (Coll.size() <= 0) {
            throw new InteCloudException(InteCloudException.NUMBER_NOT_EXIST);
        }
        info = Coll.get(0);
        return info;
    }

    private static PersonInfo getPersonInfoByNumber(Context ctx, String number) throws BOSException, EASBizException {
        String sql = "select id,name,number  where number ='" + number + "'";
        PersonCollection Coll = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(sql);
        PersonInfo info = Coll.get(0);
        if (Coll.size() <= 0) {
            throw new InteCloudException(InteCloudException.NUMBER_NOT_EXIST);
        }
        info = Coll.get(0);
        return info;
    }
}

