/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cloud_inte.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.cloud_inte.HRCloudUltimateInteLogCollection;
import com.kingdee.shr.cloud_inte.HRCloudUltimateInteLogFactory;
import com.kingdee.shr.cloud_inte.HRCloudUltimateInteLogInfo;
import com.kingdee.shr.cloud_inte.InteCloudException;
import com.kingdee.shr.cloud_inte.InteDataType;
import com.kingdee.shr.cloud_inte.OperationType;
import com.kingdee.shr.cloud_inte.app.AbstractHRCloudUltimateInteLogControllerBean;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class HRCloudUltimateInteLogControllerBean
extends AbstractHRCloudUltimateInteLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.cloud_inte.app.HRCloudUltimateInteLogControllerBean");

    @Override
    protected String _syncAgain(Context ctx, String ids) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)ids)) {
            return null;
        }
        String[] inteLogIdArray = ids.split(",");
        String idsql = "'" + ids.replace(",", "','") + "'";
        String sql = "select id,billType,number,hrId,operationType where id in ( " + idsql + " )";
        HRCloudUltimateInteLogCollection logCol = HRCloudUltimateInteLogFactory.getLocalInstance(ctx).getHRCloudUltimateInteLogCollection(sql);
        HashSet<String> orgIdSet = new HashSet<String>();
        HashSet<String> personIdSet = new HashSet<String>();
        for (int i = 0; i < logCol.size(); ++i) {
            HRCloudUltimateInteLogInfo LogInfo = logCol.get(i);
            String idSet = LogInfo.getHrID();
            if (LogInfo.getBillType() == InteDataType.cmpItem || LogInfo.getBillType() == InteDataType.cmpScheme) {
                throw new InteCloudException(InteCloudException.NOT_SUPPORT_CMP_SYNC);
            }
            if (LogInfo.getBillType() == InteDataType.adminOrg) {
                String adminId = idSet;
                if (OperationType.delete.equals((Object)LogInfo.getOperationType())) {
                    adminId = adminId + "@delete";
                }
                orgIdSet.add(adminId);
                continue;
            }
            if (LogInfo.getBillType() != InteDataType.employee) continue;
            String personId = idSet;
            if (OperationType.delete.equals((Object)LogInfo.getOperationType())) {
                personId = personId + "@delete";
            }
            personIdSet.add(personId);
        }
        HashMap<String, Object> idMap = new HashMap<String, Object>();
        if (orgIdSet.size() > 0) {
            idMap.put("orgUnit", orgIdSet);
        }
        if (personIdSet.size() > 0) {
            idMap.put("person", personIdSet);
        }
        String syncTimeMillis = String.valueOf(System.currentTimeMillis());
        idMap.put("syncTimeMillis", syncTimeMillis);
        IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "adviseOutUltimateSystemService");
        imsf.process(ctx, idMap);
        return syncTimeMillis;
    }

    private static AdminOrgUnitInfo getOrgInfoByNumber(Context ctx, String number) throws BOSException, EASBizException {
        String sql = "select id,name,number  where number ='" + number + "'";
        AdminOrgUnitCollection Coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(sql);
        AdminOrgUnitInfo info = null;
        if (Coll.size() <= 0) {
            throw new InteCloudException(InteCloudException.NUMBER_NOT_EXIST);
        }
        info = Coll.get(0);
        return info;
    }

    private static PersonInfo getPersonInfoByNumber(Context ctx, String number) throws BOSException, EASBizException {
        String sql = "select id,name,number  where number ='" + number + "'";
        PersonCollection Coll = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(sql);
        PersonInfo info = Coll.get(0);
        if (Coll.size() <= 0) {
            throw new InteCloudException(InteCloudException.NUMBER_NOT_EXIST);
        }
        info = Coll.get(0);
        return info;
    }

    @Override
    protected String _deleteLog(Context ctx, String ids) throws BOSException, EASBizException {
        String[] inteLogIdArray = ids.split(",");
        String idsql = "'" + ids.replace(",", "','") + "'";
        String sql = "select isDelete where id in ( " + idsql + " )";
        CoreBaseCollection logInfoColl = new CoreBaseCollection();
        HRCloudUltimateInteLogCollection logCol = HRCloudUltimateInteLogFactory.getLocalInstance(ctx).getHRCloudUltimateInteLogCollection(sql);
        for (int i = 0; i < logCol.size(); ++i) {
            HRCloudUltimateInteLogInfo info = logCol.get(i);
            info.setIsDelete(true);
            logInfoColl.add((CoreBaseInfo)info);
        }
        this.save(ctx, logInfoColl);
        return null;
    }
}

