/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cloud_inte.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.rabbitmq.guava.Lists;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.cloud_inte.MonitorSyncCompLogFactory;
import com.kingdee.shr.cloud_inte.MonitorSyncCompLogInfo;
import com.kingdee.shr.cloud_inte.MonitorSyncEntityCollection;
import com.kingdee.shr.cloud_inte.MonitorSyncEntityFactory;
import com.kingdee.shr.cloud_inte.MonitorSyncEntityInfo;
import com.kingdee.shr.cloud_inte.app.AbstractMonitorSyncCompensationFacadeControllerBean;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorSyncCompensationFacadeControllerBean
extends AbstractMonitorSyncCompensationFacadeControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(MonitorSyncCompensationFacadeControllerBean.class);

    @Override
    protected void _sendNoticeToOSF(Context ctx) throws BOSException, EASBizException {
        MonitorSyncCompensationFacadeControllerBean.dealwithMonitorSyncLog(ctx);
        String oql = "select entityName,adjustSyncTime,sortCode where isStart = 1 order by sortCode";
        MonitorSyncEntityCollection coll = MonitorSyncEntityFactory.getLocalInstance(ctx).getMonitorSyncEntityCollection(oql);
        for (int i = 0; i < coll.size(); ++i) {
            MonitorSyncEntityInfo info = coll.get(i);
            String entityName = info.getEntityName();
            int adjustSyncTime = info.getAdjustSyncTime();
            EntityObjectInfo entityInfo = MetaDataUtil.getEntityObjectByEntityName((Context)ctx, (String)entityName);
            if (entityInfo == null || entityInfo.getTable() == null) continue;
            List<String> registerOSFName = this.getOsfRegisterService(ctx, entityName);
            String tableName = entityInfo.getTable().getName();
            IRowSet syncData = this.getSyncDataArea(ctx, tableName, adjustSyncTime);
            if (syncData == null || registerOSFName.size() == 0) continue;
            try {
                while (syncData.next()) {
                    String dataId = syncData.getString("fid");
                    Map<String, Object> syncDataParam = this.getSyncDataToParam(ctx, dataId, entityName);
                    IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
                    for (String osfServiceName : registerOSFName) {
                        try {
                            long begin = System.currentTimeMillis();
                            osfServiceFacade.processService(osfServiceName, syncDataParam);
                            long end = System.currentTimeMillis();
                            if (logger.isDebugEnabled()) {
                                logger.debug(MessageFormat.format("MonitorSyncCompensationFacadeControllerBean sendNotice call osf:{0},cost:{1} ms {2} s", osfServiceName, end - begin, (double)(end - begin) / 1000.0));
                            }
                            MonitorSyncCompLogInfo logInfo = new MonitorSyncCompLogInfo();
                            logInfo.setSyncOSFName(osfServiceName);
                            logInfo.setSyncDataId(dataId);
                            MonitorSyncCompLogFactory.getLocalInstance(ctx).addnew(logInfo);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error("OSF(" + osfServiceName + ") is disable!", (Throwable)e);
                            MonitorSyncCompLogInfo logInfo = new MonitorSyncCompLogInfo();
                            logInfo.setSyncOSFName(osfServiceName);
                            logInfo.setSyncDataId(dataId);
                            String message = e.getMessage();
                            if (!StringUtils.isEmpty((String)message) && message.length() > 1000) {
                                message = message.substring(0, 1000);
                            }
                            logInfo.setMsg(message);
                            MonitorSyncCompLogFactory.getLocalInstance(ctx).addnew(logInfo);
                        }
                    }
                }
                continue;
            }
            catch (SQLException e) {
                logger.error("get sync data error for SQLException.");
                e.printStackTrace();
            }
        }
    }

    public static void dealwithMonitorSyncLog(Context ctx) throws BOSException {
        Date currentTime = new Date();
        Calendar cl = Calendar.getInstance();
        cl.setTime(currentTime);
        cl.add(2, -1);
        Date pastTime = cl.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String pastTimeLocal = sdf.format(pastTime);
        String logSql = "delete from T_HR_MonitorSyncCompLog where FLastUpdateTime < " + MonitorSyncCompensationFacadeControllerBean.getEndDateTs(pastTimeLocal);
        String logUltimateSql = "delete from T_HR_UltimateListenerLog where FCreateTime < " + MonitorSyncCompensationFacadeControllerBean.getEndDateTs(pastTimeLocal);
        DbUtil.execute((Context)ctx, (String)logSql);
        DbUtil.execute((Context)ctx, (String)logUltimateSql);
    }

    protected Map<String, Object> getSyncDataToParam(Context ctx, String dataId, String entityName) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String data = dataId + "@update";
        HashSet<String> dataList = new HashSet<String>();
        dataList.add(data);
        param.put("orgUnit", new HashSet());
        param.put("position", new HashSet());
        param.put("person", new HashSet());
        String bostype = BOSUuid.read((String)dataId).getType().toString();
        if ("80EF7DED".equals(bostype)) {
            param.put("person", dataList);
        } else if ("74AE612E".equals(bostype)) {
            param.put("position", dataList);
        } else if ("CCE7AED4".equals(bostype)) {
            param.put("orgUnit", dataList);
        } else {
            String entityKey = entityName.substring(entityName.lastIndexOf(".") + 1).toLowerCase();
            param.put(entityKey, dataList);
        }
        return param;
    }

    protected List<String> getOsfRegisterService(Context ctx, String entityName) throws BOSException {
        String osfSql = "select syncOSFName where isStart = 1 and entityName = '" + entityName + "' order by sortCode";
        MonitorSyncEntityCollection coll = MonitorSyncEntityFactory.getLocalInstance(ctx).getMonitorSyncEntityCollection(osfSql);
        HashSet<String> osfSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            osfSet.add(coll.get(i).getSyncOSFName());
        }
        ArrayList osfList = Lists.newArrayList(osfSet);
        return osfList;
    }

    protected IRowSet getSyncDataArea(Context ctx, String tableName, int adjustSyncTime) {
        Date currentTime = new Date();
        Calendar cl = Calendar.getInstance();
        cl.setTime(currentTime);
        cl.add(12, -adjustSyncTime);
        Date pastTime = cl.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currentTimeLocal = sdf.format(currentTime);
        String pastTimeLocal = sdf.format(pastTime);
        String syncDataAreaSql = "select fid from " + tableName + " where FLastUpdateTime >= " + MonitorSyncCompensationFacadeControllerBean.getEndDateTs(pastTimeLocal) + " and FLastUpdateTime <= " + MonitorSyncCompensationFacadeControllerBean.getEndDateTs(currentTimeLocal);
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)syncDataAreaSql);
        }
        catch (BOSException e) {
            logger.error("get sync data error for BOSException.");
            e.printStackTrace();
        }
        return rs;
    }

    public static String getEndDateTs(String pastTimeLocal) {
        return "{ts '" + pastTimeLocal + "'}";
    }
}

