/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.integraterec.intergrate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.integraterec.InitialSyncBaseRecFactory;
import com.kingdee.shr.integraterec.InitialSyncBaseRecInfo;
import com.kingdee.shr.integraterec.IntegrateAccountCollection;
import com.kingdee.shr.integraterec.IntegrateAccountFactory;
import com.kingdee.shr.integraterec.IntegrateDataMappingRecCollection;
import com.kingdee.shr.integraterec.IntegrateDataMappingRecFactory;
import com.kingdee.shr.integraterec.IntegrateDataMappingRecInfo;
import com.kingdee.shr.integraterec.IntegrateRecException;
import com.kingdee.shr.integraterec.app.InitialSyncType;
import com.kingdee.shr.integraterec.intergrate.AbstractInitialSyncThirdService;
import com.kingdee.shr.integraterec.utils.SyncThirdDataByCloudOSFUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultInitialSyncThirdServiceImpl
extends AbstractInitialSyncThirdService {
    public static Logger logger = Logger.getLogger(DefaultInitialSyncThirdServiceImpl.class);
    private static final String RESULT_SEPRATOR = "\uff1b";

    @Override
    public boolean initialSyncExecute(Context ctx, InitialSyncBaseRecInfo initialBaseInfo) throws EASBizException, BOSException {
        this.beforeSyncThird(ctx, initialBaseInfo);
        String triggerKey = initialBaseInfo.getInteKeyForInitial();
        String billId = null;
        SyncThirdDataByCloudOSFUtil syncUtil = new SyncThirdDataByCloudOSFUtil();
        Map<String, Object> result = syncUtil.syncThirdDataByCloudOSF(ctx, billId, triggerKey, initialBaseInfo, null);
        billId = "null";
        this.parseRecCloudOSfData(ctx, billId, initialBaseInfo, result, InitialSyncType.INITIALDATA);
        this.afterSyncThird(ctx, initialBaseInfo);
        return true;
    }

    @Override
    public boolean getThirdSystemData(Context ctx, InitialSyncBaseRecInfo initialBaseInfo) throws EASBizException, BOSException {
        this.beforeSyncThird(ctx, initialBaseInfo);
        String triggerKey = initialBaseInfo.getInteKeyForGetHis();
        String billId = null;
        SyncThirdDataByCloudOSFUtil syncUtil = new SyncThirdDataByCloudOSFUtil();
        Map<String, Object> result = syncUtil.syncThirdDataByCloudOSF(ctx, billId, triggerKey, initialBaseInfo, null);
        billId = "null";
        this.parseRecCloudOSfData(ctx, billId, initialBaseInfo, result, InitialSyncType.GETHIS);
        this.afterSyncThird(ctx, initialBaseInfo);
        return true;
    }

    @Override
    public boolean syncThirdDataMapping(Context ctx, InitialSyncBaseRecInfo initialBaseInfo) throws EASBizException, BOSException {
        this.beforeSyncThird(ctx, initialBaseInfo);
        String triggerKey = initialBaseInfo.getInteKeyForPushHis();
        String taskId = initialBaseInfo.getId().toString();
        String billId = null;
        SyncThirdDataByCloudOSFUtil syncUtil = new SyncThirdDataByCloudOSFUtil();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("initialSyncBaseRec", "'" + taskId + "'");
        Map<String, Object> result = syncUtil.syncThirdDataByCloudOSF(ctx, billId, triggerKey, initialBaseInfo, param);
        billId = "null";
        this.parseRecCloudOSfData(ctx, billId, initialBaseInfo, result, InitialSyncType.PUSHHIS);
        this.afterSyncThird(ctx, initialBaseInfo);
        return true;
    }

    @Override
    public void beforeSyncThird(Context ctx, InitialSyncBaseRecInfo initialBaseInfo) throws EASBizException, BOSException {
        int integrateType = initialBaseInfo.getIntegrateType().getValue();
        IntegrateAccountCollection collection = IntegrateAccountFactory.getLocalInstance(ctx).getIntegrateAccountCollection("where integrateStatus = 1 and integrateType = " + integrateType);
        if (collection.size() <= 0) {
            throw new IntegrateRecException(IntegrateRecException.INTEGRATE_ACCOUNT_FAIL);
        }
    }

    @Override
    public void afterSyncThird(Context ctx, InitialSyncBaseRecInfo initialBaseInfo) throws EASBizException, BOSException {
    }

    @Override
    public void paseIntegrateRes(Context ctx, String billId, InitialSyncBaseRecInfo initialBaseInfo, JSONObject jo, InitialSyncType syncType) throws EASBizException, BOSException {
        boolean success = jo.getBoolean("success");
        String code = jo.getString("code");
        String errorMessage = jo.getString("errorMessage");
        if (!success) {
            throw new IntegrateRecException(IntegrateRecException.INTEGRATE_THIRD_FAIL_DETAIL, new Object[]{code, errorMessage});
        }
        if (InitialSyncType.INITIALDATA.equals((Object)syncType)) {
            this.saveAdminInitialSyncResult(ctx, jo, initialBaseInfo);
        } else if (InitialSyncType.GETHIS.equals((Object)syncType)) {
            this.saveAdminOrgForThird(ctx, jo, initialBaseInfo);
        } else if (InitialSyncType.PUSHHIS.equals((Object)syncType)) {
            // empty if block
        }
    }

    public void saveAdminOrgForThird(Context ctx, JSONObject jo, InitialSyncBaseRecInfo initialBaseInfo) throws BOSException {
        JSONArray adminArry = jo.getJSONArray("departments");
        CoreBaseCollection dataMappingColl = new CoreBaseCollection();
        for (int i = 0; i < adminArry.size(); ++i) {
            JSONObject tempJo = (JSONObject)adminArry.get(i);
            String departmentId = tempJo.getString("departmentId");
            String departmentCode = tempJo.getString("departmentCode");
            String departmentName = tempJo.getString("name");
            String parentCode = tempJo.getString("parentCode");
            int deleteByApi = tempJo.getIntValue("deleteByApi");
            int type = tempJo.getIntValue("type");
            if (deleteByApi == 1) continue;
            IntegrateDataMappingRecInfo dataMappingInfo = new IntegrateDataMappingRecInfo();
            dataMappingInfo.setThirdMappingId(departmentId);
            dataMappingInfo.setThirdMappingName(departmentName);
            dataMappingInfo.setShrDataParentId(parentCode);
            dataMappingInfo.setShrDataId(departmentCode);
            dataMappingInfo.setThirdIsDelete(deleteByApi);
            dataMappingInfo.setThirdDataType(type);
            dataMappingInfo.setInitialSyncBaseRec(initialBaseInfo);
            dataMappingInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            dataMappingInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            dataMappingInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            dataMappingInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            dataMappingInfo.setShrDataName(null);
            dataMappingInfo.setShrDataNumber(null);
            String oql = "select id,creator,createTime,shrDataId,shrDataName,shrDataNumber where thirdMappingId = '" + departmentId + "'";
            IntegrateDataMappingRecCollection coll = IntegrateDataMappingRecFactory.getLocalInstance(ctx).getIntegrateDataMappingRecCollection(oql);
            if (coll != null && coll.size() > 0) {
                IntegrateDataMappingRecInfo oldInfo = coll.get(0);
                dataMappingInfo.setId(oldInfo.getId());
                dataMappingInfo.setCreator(oldInfo.getCreator());
                dataMappingInfo.setCreateTime(oldInfo.getCreateTime());
                if (departmentCode != null && departmentCode.equals(oldInfo.getShrDataId())) {
                    dataMappingInfo.setShrDataName(oldInfo.getShrDataName());
                    dataMappingInfo.setShrDataNumber(oldInfo.getShrDataNumber());
                }
            } else {
                boolean isUuid = BOSUuid.isValid((String)departmentCode, (boolean)true);
                if (isUuid) {
                    ICoreBase corebase = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)departmentCode).getType());
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    viewInfo.setSelector(sic);
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)departmentCode, CompareType.EQUALS));
                    viewInfo.setFilter(filterInfo);
                    CoreBaseCollection collShr = corebase.getCollection(viewInfo);
                    if (collShr != null && collShr.size() > 0) {
                        CoreBaseInfo baseInfo = collShr.get(0);
                        String realNumber = baseInfo.get("number") != null ? (String)baseInfo.get("number") : "";
                        String realName = baseInfo.get("name") != null ? (String)baseInfo.get("name") : "";
                        dataMappingInfo.setShrDataNumber(realNumber);
                        dataMappingInfo.setShrDataName(realName);
                    }
                }
            }
            dataMappingColl.add((CoreBaseInfo)dataMappingInfo);
        }
        try {
            IntegrateDataMappingRecFactory.getLocalInstance(ctx).saveBatchData(dataMappingColl);
        }
        catch (EASBizException e) {
            logger.error((Object)"SyncThirdDataByCloudOSFUtil.saveAdminOrgForThird-save fail");
            e.printStackTrace();
        }
        catch (BOSException e) {
            logger.error((Object)"SyncThirdDataByCloudOSFUtil.saveAdminOrgForThird-save fail");
            e.printStackTrace();
        }
    }

    public void saveAdminInitialSyncResult(Context ctx, JSONObject jo, InitialSyncBaseRecInfo initialBaseInfo) throws BOSException, EASBizException {
        JSONObject dataJson = jo.getJSONObject("data");
        String resultStr = "";
        StringBuilder result = new StringBuilder("");
        int addNum = dataJson.getIntValue("add");
        if (addNum == 0) {
            addNum = dataJson.getIntValue("new");
        }
        int updateNum = dataJson.getIntValue("update");
        int deleteNum = dataJson.getIntValue("delete");
        String addStr = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"INITIAL_RESULT_ADD", (Context)ctx);
        String updateStr = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"INITIAL_RESULT_UPDATE", (Context)ctx);
        String deleteStr = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"INITIAL_RESULT_DEL", (Context)ctx);
        result.append(addStr + addNum + RESULT_SEPRATOR).append(updateStr + updateNum + RESULT_SEPRATOR).append(deleteStr + deleteNum + RESULT_SEPRATOR);
        resultStr = result.toString();
        initialBaseInfo.setLastSyncResult(resultStr);
        initialBaseInfo.setLastSyncTime(new Timestamp(System.currentTimeMillis()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("lastSyncTime"));
        sic.add(new SelectorItemInfo("lastSyncResult"));
        if (!initialBaseInfo.isInitSuccess()) {
            initialBaseInfo.setInitSuccess(true);
            sic.add(new SelectorItemInfo("initSuccess"));
        }
        initialBaseInfo.setInitSuccess(true);
        InitialSyncBaseRecFactory.getLocalInstance(ctx).updatePartial(initialBaseInfo, sic);
    }
}

